/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.messaging.InsertMessage;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.MetaData;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.TableHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertHandler
extends AbstractMessageHandler {
    private static final Logger LOG = LoggerFactory.getLogger(InsertHandler.class);

    @Override
    public List<Task<? extends Serializable>> handle(MessageHandler.Context withinContext) throws SemanticException {
        try {
            FileSystem fs = FileSystem.get((URI)new Path(withinContext.location).toUri(), (Configuration)withinContext.hiveConf);
            MetaData metaData = EximUtil.readMetaData(fs, new Path(withinContext.location, "_metadata"));
            ReplicationSpec replicationSpec = metaData.getReplicationSpec();
            if (replicationSpec.isNoop()) {
                return Collections.emptyList();
            }
        }
        catch (Exception e) {
            LOG.error("failed to load insert event", (Throwable)e);
            throw new SemanticException(e);
        }
        InsertMessage insertMessage = this.deserializer.getInsertMessage(withinContext.dmd.getPayload());
        String actualDbName = withinContext.isDbNameEmpty() ? insertMessage.getDB() : withinContext.dbName;
        MessageHandler.Context currentContext = new MessageHandler.Context(withinContext, actualDbName, withinContext.getDumpDirectory(), withinContext.getMetricCollector());
        TableHandler tableHandler = new TableHandler();
        List<Task<? extends Serializable>> tasks = tableHandler.handle(currentContext);
        this.readEntitySet.addAll(tableHandler.readEntities());
        this.writeEntitySet.addAll(tableHandler.writeEntities());
        this.getUpdatedMetadata().copyUpdatedMetadata(tableHandler.getUpdatedMetadata());
        return tasks;
    }
}

