/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.metric;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.ReplicationMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricCollector {
    private static final Logger LOG = LoggerFactory.getLogger(MetricCollector.class);
    private final Map<Long, ReplicationMetric> metricMap = new HashMap<Long, ReplicationMetric>();
    private long maxSize = 0L;
    private boolean isInited = false;
    private static volatile MetricCollector instance;

    private MetricCollector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MetricCollector getInstance() {
        if (instance != null) return instance;
        Class<MetricCollector> clazz = MetricCollector.class;
        synchronized (MetricCollector.class) {
            if (instance != null) return instance;
            instance = new MetricCollector();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized MetricCollector init(HiveConf conf) {
        if (!this.isInited) {
            this.maxSize = this.getMaxSize(conf);
            this.isInited = true;
        }
        return instance;
    }

    long getMaxSize(HiveConf conf) {
        return MetastoreConf.getLongVar(conf, MetastoreConf.ConfVars.REPL_METRICS_CACHE_MAXSIZE);
    }

    public synchronized void addMetric(ReplicationMetric replicationMetric) throws SemanticException {
        if ((long)this.metricMap.size() >= this.maxSize) {
            throw new SemanticException("Metrics are not getting collected. ");
        }
        if ((double)this.metricMap.size() > 0.8 * (double)this.maxSize) {
            LOG.warn("Metrics cache is more than 80 % full. Will start dropping metrics once full. ");
        }
        this.metricMap.put(replicationMetric.getScheduledExecutionId(), replicationMetric);
    }

    public synchronized LinkedList<ReplicationMetric> getMetrics() {
        LinkedList<ReplicationMetric> metricList = new LinkedList<ReplicationMetric>();
        for (ReplicationMetric metric : this.metricMap.values()) {
            metricList.add(new ReplicationMetric(metric));
        }
        this.metricMap.clear();
        return metricList;
    }

    synchronized void deinit() {
        if (this.isInited) {
            this.isInited = false;
            this.metricMap.clear();
            MetricCollector.resetInstance();
        }
    }

    private static void resetInstance() {
        instance = null;
    }
}

