/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;

public enum HiveOperation {
    EXPLAIN("EXPLAIN", 896, null, null),
    LOAD("LOAD", 955, null, new Privilege[]{Privilege.ALTER_DATA}),
    EXPORT("EXPORT", 899, new Privilege[]{Privilege.SELECT}, null),
    IMPORT("IMPORT", 924, null, new Privilege[]{Privilege.ALTER_METADATA, Privilege.ALTER_DATA}),
    REPLDUMP("REPLDUMP", 1033, new Privilege[]{Privilege.ALL}, null),
    REPLLOAD("REPLLOAD", 1034, null, new Privilege[]{Privilege.ALL}),
    REPLSTATUS("REPLSTATUS", 1035, new Privilege[]{Privilege.SELECT}, null),
    CREATEDATABASE("CREATEDATABASE", 837, null, new Privilege[]{Privilege.CREATE}),
    DROPDATABASE("DROPDATABASE", 878, null, new Privilege[]{Privilege.DROP}),
    SWITCHDATABASE("SWITCHDATABASE", 1103, null, null, true, false),
    LOCKDB("LOCKDATABASE", 956, new Privilege[]{Privilege.LOCK}, null),
    UNLOCKDB("UNLOCKDATABASE", 1159, new Privilege[]{Privilege.LOCK}, null),
    DROPTABLE("DROPTABLE", 882, null, new Privilege[]{Privilege.DROP}),
    DESCTABLE("DESCTABLE", 871, null, null),
    DESCFUNCTION("DESCFUNCTION", 870, null, null),
    MSCK("MSCK", 962, null, null),
    ALTERTABLE_ADDCOLS("ALTERTABLE_ADDCOLS", 768, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_REPLACECOLS("ALTERTABLE_REPLACECOLS", 789, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_RENAMECOL("ALTERTABLE_RENAMECOL", 787, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_RENAMEPART("ALTERTABLE_RENAMEPART", 788, new Privilege[]{Privilege.DROP}, new Privilege[]{Privilege.CREATE}),
    ALTERTABLE_UPDATEPARTSTATS("ALTERTABLE_UPDATEPARTSTATS", new int[]{766, 765}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_UPDATETABLESTATS("ALTERTABLE_UPDATETABLESTATS", new int[]{798, 796}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_RENAME("ALTERTABLE_RENAME", 786, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_DROPPARTS("ALTERTABLE_DROPPARTS", new int[]{777, 801}, new Privilege[]{Privilege.DROP}, null),
    ALTERTABLE_ADDPARTS("ALTERTABLE_ADDPARTS", new int[]{770, 800}, null, new Privilege[]{Privilege.CREATE}),
    ALTERTABLE_TOUCH("ALTERTABLE_TOUCH", 794, null, null),
    ALTERTABLE_ARCHIVE("ALTERTABLE_ARCHIVE", 771, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERTABLE_UNARCHIVE("ALTERTABLE_UNARCHIVE", 795, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERTABLE_PROPERTIES("ALTERTABLE_PROPERTIES", new int[]{785, 778}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_OWNER("ALTERTABLE_OWNER", 783, null, null),
    ALTERTABLE_SERIALIZER("ALTERTABLE_SERIALIZER", 791, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_SERIALIZER("ALTERPARTITION_SERIALIZER", 764, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_SERDEPROPERTIES("ALTERTABLE_SERDEPROPERTIES", 790, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_SERDEPROPERTIES("ALTERPARTITION_SERDEPROPERTIES", 763, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_CLUSTER_SORT("ALTERTABLE_CLUSTER_SORT", 774, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ANALYZE_TABLE("ANALYZE_TABLE", 821, null, null),
    CACHE_METADATA("CACHE_METADATA", 827, new Privilege[]{Privilege.SELECT}, null),
    ALTERTABLE_BUCKETNUM("ALTERTABLE_BUCKETNUM", 772, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_BUCKETNUM("ALTERPARTITION_BUCKETNUM", 759, new Privilege[]{Privilege.ALTER_METADATA}, null),
    SHOWDATABASES("SHOWDATABASES", 1066, new Privilege[]{Privilege.SHOW_DATABASE}, null, true, false),
    SHOWTABLES("SHOWTABLES", 1072, null, null, true, false),
    SHOWCOLUMNS("SHOWCOLUMNS", 1064, null, null, true, false),
    SHOW_TABLESTATUS("SHOW_TABLESTATUS", 1083, null, null, true, false),
    SHOW_TBLPROPERTIES("SHOW_TBLPROPERTIES", 1084, null, null, true, false),
    SHOW_CREATEDATABASE("SHOW_CREATEDATABASE", 1075, new Privilege[]{Privilege.SELECT}, null),
    SHOW_CREATETABLE("SHOW_CREATETABLE", 1076, new Privilege[]{Privilege.SELECT}, null),
    SHOWFUNCTIONS("SHOWFUNCTIONS", 1068, null, null, true, false),
    SHOWPARTITIONS("SHOWPARTITIONS", 1071, null, null),
    SHOWLOCKS("SHOWLOCKS", new int[]{1069, 1067}, null, null, true, false),
    SHOWCONF("SHOWCONF", 1065, null, null),
    SHOWVIEWS("SHOWVIEWS", 1073, null, null, true, false),
    SHOWMATERIALIZEDVIEWS("SHOWMATERIALIZEDVIEWS", 1070, null, null, true, false),
    CREATEFUNCTION("CREATEFUNCTION", 838, null, null),
    DROPFUNCTION("DROPFUNCTION", 879, null, null),
    RELOADFUNCTION("RELOADFUNCTION", 1026, null, null),
    CREATEMACRO("CREATEMACRO", 839, null, null),
    DROPMACRO("DROPMACRO", 880, null, null),
    CREATEVIEW("CREATEVIEW", 842, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.CREATE}),
    CREATE_MATERIALIZED_VIEW("CREATE_MATERIALIZED_VIEW", 844, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.CREATE}),
    DROPVIEW("DROPVIEW", 883, null, new Privilege[]{Privilege.DROP}),
    DROP_MATERIALIZED_VIEW("DROP_MATERIALIZED_VIEW", 885, null, new Privilege[]{Privilege.DROP}),
    ALTER_MATERIALIZED_VIEW_REWRITE("ALTER_MATERIALIZED_VIEW_REWRITE", 808, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERVIEW_PROPERTIES("ALTERVIEW_PROPERTIES", new int[]{803, 802}, null, null),
    LOCKTABLE("LOCKTABLE", 957, new Privilege[]{Privilege.LOCK}, null),
    UNLOCKTABLE("UNLOCKTABLE", 1160, new Privilege[]{Privilege.LOCK}, null),
    CREATEROLE("CREATEROLE", 840, null, null),
    DROPROLE("DROPROLE", 881, null, null),
    GRANT_PRIVILEGE("GRANT_PRIVILEGE", 912, null, null),
    REVOKE_PRIVILEGE("REVOKE_PRIVILEGE", 1042, null, null),
    SHOW_GRANT("SHOW_GRANT", 1078, null, null, true, false),
    GRANT_ROLE("GRANT_ROLE", 914, null, null),
    REVOKE_ROLE("REVOKE_ROLE", 1043, null, null),
    SHOW_ROLES("SHOW_ROLES", new int[]{1079, 1077, 1063}, null, null, true, false),
    SHOW_ROLE_PRINCIPALS("SHOW_ROLE_PRINCIPALS", 1081, null, null, true, false),
    SHOW_ROLE_GRANT("SHOW_ROLE_GRANT", 1080, null, null, true, false),
    ALTERTABLE_FILEFORMAT("ALTERTABLE_FILEFORMAT", 780, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_FILEFORMAT("ALTERPARTITION_FILEFORMAT", 760, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_LOCATION("ALTERTABLE_LOCATION", 781, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERPARTITION_LOCATION("ALTERPARTITION_LOCATION", 761, new Privilege[]{Privilege.ALTER_DATA}, null),
    CREATETABLE("CREATETABLE", 841, null, new Privilege[]{Privilege.CREATE}),
    TRUNCATETABLE("TRUNCATETABLE", 1150, null, new Privilege[]{Privilege.DROP}),
    CREATETABLE_AS_SELECT("CREATETABLE_AS_SELECT", null, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.CREATE}),
    QUERY("QUERY", 1021, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA, Privilege.CREATE}, true, false),
    ALTERDATABASE("ALTERDATABASE", 758, null, null),
    ALTERDATABASE_OWNER("ALTERDATABASE_OWNER", 757, null, null),
    ALTERDATABASE_LOCATION("ALTERDATABASE_LOCATION", new int[]{755, 756}, new Privilege[]{Privilege.ALTER_DATA}, null),
    DESCDATABASE("DESCDATABASE", 869, null, null),
    ALTERTABLE_MERGEFILES("ALTER_TABLE_MERGE", 782, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    ALTERPARTITION_MERGEFILES("ALTER_PARTITION_MERGE", 762, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    ALTERTABLE_SKEWED("ALTERTABLE_SKEWED", 792, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTBLPART_SKEWED_LOCATION("ALTERTBLPART_SKEWED_LOCATION", 793, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERTABLE_PARTCOLTYPE("ALTERTABLE_PARTCOLTYPE", 784, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    ALTERTABLE_EXCHANGEPARTITION("ALTERTABLE_EXCHANGEPARTITION", 779, new Privilege[]{Privilege.SELECT, Privilege.DELETE}, new Privilege[]{Privilege.INSERT}),
    ALTERTABLE_DROPCONSTRAINT("ALTERTABLE_DROPCONSTRAINT", 776, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_ADDCONSTRAINT("ALTERTABLE_ADDCONSTRAINT", 769, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_UPDATECOLUMNS("ALTERTABLE_UPDATECOLUMNS", 797, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERVIEW_RENAME("ALTERVIEW_RENAME", 804, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERVIEW_AS("ALTERVIEW_AS", 799, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_COMPACT("ALTERTABLE_COMPACT", 775, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    SHOW_COMPACTIONS("SHOW COMPACTIONS", 1074, null, null, true, false),
    SHOW_TRANSACTIONS("SHOW TRANSACTIONS", 1085, null, null, true, false),
    START_TRANSACTION("START TRANSACTION", 1091, null, null, false, false),
    COMMIT("COMMIT", 835, null, null, true, true),
    ROLLBACK("ROLLBACK", 1048, null, null, true, true),
    SET_AUTOCOMMIT("SET AUTOCOMMIT", 1061, null, null, true, false),
    ABORT_TRANSACTIONS("ABORT TRANSACTIONS", 748, null, null, false, false),
    KILL_QUERY("KILL QUERY", 945, null, null),
    CREATE_RESOURCEPLAN("CREATE RESOURCEPLAN", 846, null, null, false, false),
    SHOW_RESOURCEPLAN("SHOW RESOURCEPLAN", 1082, null, null, false, false),
    ALTER_RESOURCEPLAN("ALTER RESOURCEPLAN", new int[]{818, 814, 816, 817, 813, 812, 815}, null, null, false, false),
    DROP_RESOURCEPLAN("DROP RESOURCEPLAN", 887, null, null, false, false),
    CREATE_TRIGGER("CREATE TRIGGER", 848, null, null, false, false),
    ALTER_TRIGGER("ALTER TRIGGER", 820, null, null, false, false),
    DROP_TRIGGER("DROP TRIGGER", 889, null, null, false, false),
    CREATE_POOL("CREATE POOL", 845, null, null, false, false),
    ALTER_POOL("ALTER POOL", new int[]{809, 810, 811}, null, null, false, false),
    DROP_POOL("DROP POOL", 886, null, null, false, false),
    CREATE_MAPPING("CREATE MAPPING", 843, null, null, false, false),
    ALTER_MAPPING("ALTER MAPPING", 805, null, null, false, false),
    DROP_MAPPING("DROP MAPPING", 884, null, null, false, false),
    CREATE_SCHEDULED_QUERY("CREATE SCHEDULED QUERY", 847, null, null),
    ALTER_SCHEDULED_QUERY("ALTER SCHEDULED QUERY", 819, null, null),
    DROP_SCHEDULED_QUERY("DROP SCHEDULED QUERY", 888, null, null);

    private final String operationName;
    private final int[] tokens;
    private final Privilege[] inputRequiredPrivileges;
    private final Privilege[] outputRequiredPrivileges;
    private final boolean allowedInTransaction;
    private final boolean requiresOpenTransaction;
    private static final Map<Integer, HiveOperation> TOKEN_TO_OPERATION;

    private HiveOperation(String operationName, int token, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges) {
        this(operationName, new int[]{token}, inputRequiredPrivileges, outputRequiredPrivileges, false, false);
    }

    private HiveOperation(String operationName, int[] tokens, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges) {
        this(operationName, tokens, inputRequiredPrivileges, outputRequiredPrivileges, false, false);
    }

    private HiveOperation(String operationName, int token, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges, boolean allowedInTransaction, boolean requiresOpenTransaction) {
        this(operationName, new int[]{token}, inputRequiredPrivileges, outputRequiredPrivileges, allowedInTransaction, requiresOpenTransaction);
    }

    private HiveOperation(String operationName, int[] tokens, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges, boolean allowedInTransaction, boolean requiresOpenTransaction) {
        this.operationName = operationName;
        this.tokens = tokens;
        this.inputRequiredPrivileges = inputRequiredPrivileges;
        this.outputRequiredPrivileges = outputRequiredPrivileges;
        this.requiresOpenTransaction = requiresOpenTransaction;
        this.allowedInTransaction = allowedInTransaction || requiresOpenTransaction;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public Privilege[] getInputRequiredPrivileges() {
        return this.inputRequiredPrivileges;
    }

    public Privilege[] getOutputRequiredPrivileges() {
        return this.outputRequiredPrivileges;
    }

    public boolean isAllowedInTransaction() {
        return this.allowedInTransaction;
    }

    public boolean isRequiresOpenTransaction() {
        return this.requiresOpenTransaction;
    }

    public static HiveOperation operationForToken(int token) {
        return TOKEN_TO_OPERATION.get(token);
    }

    static {
        TOKEN_TO_OPERATION = new HashMap<Integer, HiveOperation>();
        for (HiveOperation hiveOperation : HiveOperation.values()) {
            if (hiveOperation.tokens == null) continue;
            for (int token : hiveOperation.tokens) {
                TOKEN_TO_OPERATION.put(token, hiveOperation);
            }
        }
    }
}

