/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.LoadMultiFilesDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;

@Explain(displayName="Move Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class MoveWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private LoadTableDesc loadTableWork;
    private LoadFileDesc loadFileWork;
    private LoadMultiFilesDesc loadMultiFilesWork;
    private boolean checkFileFormat;
    private boolean srcLocal;
    private boolean needCleanTarget;
    private boolean isReplication;
    private String dumpDirectory;
    private transient ReplicationMetricCollector metricCollector;
    protected Set<ReadEntity> inputs;
    protected Set<WriteEntity> outputs;
    protected List<Partition> movedParts;
    private boolean isInReplicationScope = false;

    public MoveWork() {
    }

    private MoveWork(Set<ReadEntity> inputs, Set<WriteEntity> outputs) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.needCleanTarget = true;
    }

    public MoveWork(Set<ReadEntity> inputs, Set<WriteEntity> outputs, LoadTableDesc loadTableWork, LoadFileDesc loadFileWork, boolean checkFileFormat, boolean srcLocal) {
        this(inputs, outputs);
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace("Creating MoveWork " + System.identityHashCode(this) + " with " + loadTableWork + "; " + loadFileWork);
        }
        this.loadTableWork = loadTableWork;
        this.loadFileWork = loadFileWork;
        this.checkFileFormat = checkFileFormat;
        this.srcLocal = srcLocal;
    }

    public MoveWork(Set<ReadEntity> inputs, Set<WriteEntity> outputs, LoadTableDesc loadTableWork, LoadFileDesc loadFileWork, boolean checkFileFormat) {
        this(inputs, outputs, loadTableWork, loadFileWork, checkFileFormat, false);
    }

    public MoveWork(Set<ReadEntity> inputs, Set<WriteEntity> outputs, LoadTableDesc loadTableWork, LoadFileDesc loadFileWork, boolean checkFileFormat, String dumpRoot, ReplicationMetricCollector metricCollector, boolean isReplication) {
        this(inputs, outputs, loadTableWork, loadFileWork, checkFileFormat, false);
        this.dumpDirectory = dumpRoot;
        this.metricCollector = metricCollector;
        this.isReplication = isReplication;
    }

    public MoveWork(MoveWork o) {
        this.loadTableWork = o.getLoadTableWork();
        this.loadFileWork = o.getLoadFileWork();
        this.loadMultiFilesWork = o.getLoadMultiFilesWork();
        this.checkFileFormat = o.getCheckFileFormat();
        this.srcLocal = o.isSrcLocal();
        this.inputs = o.getInputs();
        this.outputs = o.getOutputs();
        this.needCleanTarget = o.needCleanTarget;
    }

    @Explain(displayName="tables", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public LoadTableDesc getLoadTableWork() {
        return this.loadTableWork;
    }

    public void setLoadTableWork(LoadTableDesc loadTableWork) {
        this.loadTableWork = loadTableWork;
    }

    @Explain(displayName="files")
    public LoadFileDesc getLoadFileWork() {
        return this.loadFileWork;
    }

    @Explain(displayName="files")
    public LoadMultiFilesDesc getLoadMultiFilesWork() {
        return this.loadMultiFilesWork;
    }

    public void setMultiFilesDesc(LoadMultiFilesDesc lmfd) {
        this.loadMultiFilesWork = lmfd;
    }

    public void setLoadFileWork(LoadFileDesc loadFileWork) {
        this.loadFileWork = loadFileWork;
    }

    public boolean getCheckFileFormat() {
        return this.checkFileFormat;
    }

    public void setCheckFileFormat(boolean checkFileFormat) {
        this.checkFileFormat = checkFileFormat;
    }

    public Set<ReadEntity> getInputs() {
        return this.inputs;
    }

    public Set<WriteEntity> getOutputs() {
        return this.outputs;
    }

    public void setInputs(Set<ReadEntity> inputs) {
        this.inputs = inputs;
    }

    public void setOutputs(Set<WriteEntity> outputs) {
        this.outputs = outputs;
    }

    public boolean isSrcLocal() {
        return this.srcLocal;
    }

    public void setSrcLocal(boolean srcLocal) {
        this.srcLocal = srcLocal;
    }

    public boolean isNeedCleanTarget() {
        return this.needCleanTarget;
    }

    public void setNeedCleanTarget(boolean needCleanTarget) {
        this.needCleanTarget = needCleanTarget;
    }

    public void setIsInReplicationScope(boolean isInReplicationScope) {
        this.isInReplicationScope = isInReplicationScope;
    }

    public ReplicationMetricCollector getMetricCollector() {
        return this.metricCollector;
    }

    public String getDumpDirectory() {
        return this.dumpDirectory;
    }

    public boolean isReplication() {
        return this.isReplication;
    }

    public boolean getIsInReplicationScope() {
        return this.isInReplicationScope;
    }
}

