/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.hive.metastore.api.Table;

public class HiveCustomStorageHandlerUtils {
    public static String getTablePropsForCustomStorageHandler(Map<String, String> tableProperties) {
        StringBuilder properties = new StringBuilder();
        for (Map.Entry<String, String> serdeMap : tableProperties.entrySet()) {
            if (serdeMap.getKey().equalsIgnoreCase("serialization.format") || serdeMap.getKey().equalsIgnoreCase("COLUMN_STATS_ACCURATE")) continue;
            properties.append(serdeMap.getValue().replaceAll("\\s", "").replaceAll("\"", ""));
            properties.append("/");
        }
        return properties.toString();
    }

    public static Map<String, String> getTableProperties(Table table) {
        HashMap<String, String> tblProps = new HashMap<String, String>(table.getParameters());
        Optional.ofNullable(table.getSd().getSerdeInfo().getParameters()).ifPresent(tblProps::putAll);
        return tblProps;
    }
}

