/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;

@InterfaceStability.Evolving
@InterfaceAudience.LimitedPrivate(value={"Apache Argus (incubating)"})
public class HivePrivilegeObjectUtils {
    public static List<HivePrivilegeObject> getHivePrivDbObjects(List<String> dbList) {
        ArrayList<HivePrivilegeObject> objs = new ArrayList<HivePrivilegeObject>();
        for (String dbname : dbList) {
            objs.add(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.DATABASE, dbname, dbname));
        }
        return objs;
    }

    public static class TablePrivilegeLookup
    extends TableLookup<HivePrivilegeObject> {
        public TablePrivilegeLookup(List<HivePrivilegeObject> tables) {
            super(tables);
        }

        @Override
        protected String getDbName(HivePrivilegeObject o) {
            return o.getDbname();
        }

        @Override
        protected String getTableName(HivePrivilegeObject o) {
            return o.getObjectName();
        }
    }

    public static abstract class TableLookup<T> {
        private final T[] index;

        protected abstract String getDbName(T var1);

        protected abstract String getTableName(T var1);

        private int compareNames(T table, T arg) {
            String argTableName;
            int cmp = this.getDbName(table).compareTo(this.getDbName(arg));
            if (cmp == 0 && (argTableName = this.getTableName(arg)) != null) {
                cmp = this.getTableName(table).compareTo(argTableName);
            }
            return cmp;
        }

        private int compareNames(T table, String dbName, String tableName) {
            int cmp = this.getDbName(table).compareTo(dbName);
            if (cmp == 0 && tableName != null) {
                cmp = this.getTableName(table).compareTo(tableName);
            }
            return cmp;
        }

        protected TableLookup(List<T> tables) {
            if (tables != null) {
                this.index = tables.toArray(new Object[0]);
                Arrays.sort(this.index, this::compareNames);
            } else {
                this.index = new Object[0];
            }
        }

        public final T lookup(String dbName, String tableName) {
            int low = 0;
            int high = this.index.length - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                T item = this.index[mid];
                int cmp = this.compareNames(item, dbName, tableName);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return item;
            }
            return null;
        }

        public final boolean contains(T tt) {
            return this.lookup(this.getDbName(tt), this.getTableName(tt)) != null;
        }
    }
}

