/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.events.PreAlterTableEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.ql.metadata.HiveStorageAuthorizationHandler;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.security.authorization.HiveCustomStorageHandlerUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthorizableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthzInfo;
import org.apache.hadoop.util.ReflectionUtils;

public class AlterTableEvent
extends HiveMetaStoreAuthorizableEvent {
    private static final Log LOG = LogFactory.getLog(AlterTableEvent.class);
    private String COMMAND_STR = "alter table";

    public AlterTableEvent(PreEventContext preEventContext) {
        super(preEventContext);
    }

    @Override
    public HiveMetaStoreAuthzInfo getAuthzContext() {
        HiveMetaStoreAuthzInfo ret = new HiveMetaStoreAuthzInfo(this.preEventContext, this.getOperationType(), this.getInputHObjs(), this.getOutputHObjs(), this.COMMAND_STR);
        return ret;
    }

    private HiveOperationType getOperationType() {
        PreAlterTableEvent event = (PreAlterTableEvent)this.preEventContext;
        Table table = event.getNewTable();
        Table oldTable = event.getOldTable();
        String newUri = table != null ? this.getSdLocation(table.getSd()) : "";
        String oldUri = oldTable != null ? this.getSdLocation(oldTable.getSd()) : "";
        return StringUtils.equals(oldUri, newUri) ? HiveOperationType.ALTERTABLE_ADDCOLS : HiveOperationType.ALTERTABLE_LOCATION;
    }

    private List<HivePrivilegeObject> getInputHObjs() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> AlterTableEvent.getInputHObjs()");
        }
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        PreAlterTableEvent event = (PreAlterTableEvent)this.preEventContext;
        Table oldTable = event.getOldTable();
        ret.add(this.getHivePrivilegeObject(oldTable));
        this.COMMAND_STR = this.buildCommandString(this.COMMAND_STR, oldTable);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== AlterTableEvent.getInputHObjs(): ret=" + ret));
        }
        return ret;
    }

    private List<HivePrivilegeObject> getOutputHObjs() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> AlterTableEvent.getOutputHObjs()");
        }
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        PreAlterTableEvent event = (PreAlterTableEvent)this.preEventContext;
        Table newTable = event.getNewTable();
        ret.add(this.getHivePrivilegeObject(newTable));
        Table oldTable = event.getOldTable();
        String oldUri = oldTable != null ? this.getSdLocation(oldTable.getSd()) : "";
        String newUri = this.getSdLocation(newTable.getSd());
        if (!StringUtils.equals(oldUri, newUri)) {
            ret.add(this.getHivePrivilegeObjectDfsUri(newUri));
        }
        if (newTable.getParameters().containsKey("storage_handler")) {
            String storageUri = "";
            Object defaultStorageHandler = null;
            HiveStorageHandler hiveStorageHandler = null;
            Configuration conf = new Configuration();
            HashMap<String, String> tableProperties = new HashMap<String, String>();
            tableProperties.putAll(newTable.getSd().getSerdeInfo().getParameters());
            tableProperties.putAll(newTable.getParameters());
            try {
                hiveStorageHandler = (HiveStorageHandler)ReflectionUtils.newInstance((Class)conf.getClassByName(newTable.getParameters().get("storage_handler")), (Configuration)event.getHandler().getConf());
                Method methodIsImplemented = hiveStorageHandler.getClass().getMethod("getURIForAuth", Map.class);
                if (hiveStorageHandler instanceof HiveStorageAuthorizationHandler) {
                    HiveStorageAuthorizationHandler authorizationHandler = (HiveStorageAuthorizationHandler)ReflectionUtils.newInstance((Class)conf.getClassByName(newTable.getParameters().get("storage_handler")), (Configuration)event.getHandler().getConf());
                    storageUri = authorizationHandler.getURIForAuth(tableProperties).toString();
                } else {
                    storageUri = hiveStorageHandler.getClass().getSimpleName().toLowerCase() + "://" + HiveCustomStorageHandlerUtils.getTablePropsForCustomStorageHandler(tableProperties);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)("Exception occured while getting the URI from storage handler: " + ex.getMessage()), (Throwable)ex);
            }
            ret.add(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.STORAGEHANDLER_URI, null, storageUri, null, null, HivePrivilegeObject.HivePrivObjectActionType.OTHER, null, newTable.getParameters().get("storage_handler"), newTable.getOwner(), newTable.getOwnerType()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== AlterTableEvent.getOutputHObjs(): ret=" + ret));
        }
        return ret;
    }

    private String buildCommandString(String cmdStr, Table tbl) {
        String ret = cmdStr;
        if (tbl != null) {
            String tblName = tbl.getTableName();
            ret = ret + (StringUtils.isNotEmpty(tblName) ? " " + tblName : "");
        }
        return ret;
    }
}

