/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreThread;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.RawStoreProxy;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.ql.DriverUtils;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsUpdaterThread
extends Thread
implements MetaStoreThread {
    public static final String SKIP_STATS_AUTOUPDATE_PROPERTY = "skip.stats.autoupdate";
    public static final String WORKER_NAME_PREFIX = "Stats updater worker ";
    private static final Logger LOG = LoggerFactory.getLogger(StatsUpdaterThread.class);
    protected Configuration conf;
    protected int threadId;
    protected AtomicBoolean stop;
    protected AtomicBoolean looped;
    private RawStore rs;
    private TxnStore txnHandler;
    private ConcurrentHashMap<TableName, Boolean> tablesInProgress = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Boolean> partsInProgress = new ConcurrentHashMap();
    private AtomicInteger itemsInProgress = new AtomicInteger(0);
    private boolean isExistingOnly;
    private boolean areTxnStatsEnabled;
    private long noUpdatesWaitMs;
    private int batchSize;
    private BlockingQueue<AnalyzeWork> workQueue;
    private Thread[] workers;

    public void setConf(Configuration conf) {
        MetastoreConf.StatsUpdateMode mode = MetastoreConf.StatsUpdateMode.valueOf(MetastoreConf.getVar(conf, MetastoreConf.ConfVars.STATS_AUTO_UPDATE).toUpperCase());
        switch (mode) {
            case ALL: {
                this.isExistingOnly = false;
                break;
            }
            case EXISTING: {
                this.isExistingOnly = true;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected mode " + (Object)((Object)mode)));
            }
        }
        this.noUpdatesWaitMs = MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.STATS_AUTO_UPDATE_NOOP_WAIT, TimeUnit.MILLISECONDS);
        this.areTxnStatsEnabled = MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.HIVE_TXN_STATS_ENABLED);
        this.batchSize = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX);
        int workerCount = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.STATS_AUTO_UPDATE_WORKER_COUNT);
        if (workerCount <= 0) {
            workerCount = 1;
        }
        this.workers = new Thread[workerCount];
        this.workQueue = new ArrayBlockingQueue<AnalyzeWork>(workerCount * 3);
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setThreadId(int threadId) {
        this.threadId = threadId;
    }

    @Override
    public void init(AtomicBoolean stop) throws MetaException {
        this.stop = stop;
        this.setPriority(1);
        this.setDaemon(true);
        String user = "anonymous";
        try {
            user = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (IOException e) {
            LOG.warn("Cannot determine the current user; executing as anonymous", (Throwable)e);
        }
        this.txnHandler = TxnUtils.getTxnStore(this.conf);
        this.rs = RawStoreProxy.getProxy(this.conf, this.conf, MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.RAW_STORE_IMPL), this.threadId);
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i] = new Thread(new WorkerRunnable(this.conf, user));
            this.workers[i].setDaemon(true);
            this.workers[i].setName(WORKER_NAME_PREFIX + i);
        }
    }

    @Override
    public void run() {
        LOG.info("Stats updater thread started");
        this.startWorkers();
        while (!this.stop.get()) {
            boolean hadUpdates = this.runOneIteration();
            try {
                Thread.sleep(hadUpdates ? 0L : this.noUpdatesWaitMs);
            }
            catch (InterruptedException e) {
                LOG.info("Stats updater thread was interrupted and will now exit");
                this.stopWorkers();
                return;
            }
        }
        LOG.info("Stats updater thread was stopped and will now exit");
    }

    @VisibleForTesting
    void startWorkers() {
        for (int i = 0; i < this.workers.length; ++i) {
            LOG.info("Stats updater worker thread " + this.workers[i].getName() + " started");
            this.workers[i].start();
        }
    }

    @VisibleForTesting
    public boolean runOneIteration() {
        List<TableName> fullTableNames;
        try {
            fullTableNames = this.getTablesToCheck();
        }
        catch (Throwable t) {
            LOG.error("Stats updater thread cannot retrieve tables and will now exit", t);
            this.stopWorkers();
            throw new RuntimeException(t);
        }
        LOG.debug("Processing {}", fullTableNames);
        boolean hadUpdates = false;
        for (TableName fullTableName : fullTableNames) {
            try {
                List<AnalyzeWork> commands = this.processOneTable(fullTableName);
                boolean bl = hadUpdates = hadUpdates || commands != null;
                if (commands == null) continue;
                for (AnalyzeWork req : commands) {
                    this.markAnalyzeInProgress(req);
                    this.workQueue.put(req);
                }
            }
            catch (Exception e) {
                LOG.error("Failed to process " + fullTableName + "; skipping for now", (Throwable)e);
            }
        }
        return hadUpdates;
    }

    private void stopWorkers() {
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i].interrupt();
        }
    }

    private List<AnalyzeWork> processOneTable(TableName fullTableName) throws MetaException, NoSuchTxnException, NoSuchObjectException {
        if (this.isAnalyzeTableInProgress(fullTableName)) {
            return null;
        }
        String cat = fullTableName.getCat();
        String db = fullTableName.getDb();
        String tbl = fullTableName.getTable();
        Table table = this.rs.getTable(cat, db, tbl);
        LOG.debug("Processing table {}", (Object)table);
        String skipParam = table.getParameters().get(SKIP_STATS_AUTOUPDATE_PROPERTY);
        if ("true".equalsIgnoreCase(skipParam)) {
            return null;
        }
        if (ReplUtils.isTargetOfReplication(this.rs.getDatabase(cat, db))) {
            LOG.debug("Skipping table {} since it is being replicated into", (Object)table);
            return null;
        }
        String writeIdString = null;
        boolean isTxn = AcidUtils.isTransactionalTable(table);
        if (isTxn) {
            if (!this.areTxnStatsEnabled) {
                return null;
            }
            ValidReaderWriteIdList writeIds = this.getWriteIds(fullTableName);
            if (writeIds == null) {
                LOG.error("Cannot get writeIds for transactional table " + fullTableName + "; skipping");
                return null;
            }
            writeIdString = writeIds.writeToString();
        }
        ArrayList<String> allCols = new ArrayList<String>(table.getSd().getColsSize());
        for (FieldSchema fs : table.getSd().getCols()) {
            allCols.add(fs.getName());
        }
        Collections.sort(allCols);
        if (table.getPartitionKeysSize() == 0) {
            Map<String, String> params = table.getParameters();
            List<String> colsToUpdate = null;
            long writeId = isTxn ? table.getWriteId() : -1L;
            colsToUpdate = this.isExistingOnly ? this.getExistingNonPartTableStatsToUpdate(fullTableName, cat, db, tbl, params, writeId, allCols, writeIdString) : this.getAnyStatsToUpdate(db, tbl, allCols, params, writeId, writeIdString);
            LOG.debug("Columns to update are {}; existing only: {}, out of: {} based on {}", new Object[]{colsToUpdate, this.isExistingOnly, allCols, params});
            if (colsToUpdate == null || colsToUpdate.isEmpty()) {
                return null;
            }
            return Lists.newArrayList(new AnalyzeWork(fullTableName, null, null, allCols.size() == colsToUpdate.size() ? null : colsToUpdate));
        }
        HashMap<String, List<String>> partsToAnalyze = new HashMap<String, List<String>>();
        List<String> colsForAllParts = this.findPartitionsToAnalyze(fullTableName, cat, db, tbl, allCols, partsToAnalyze, writeIdString);
        LOG.debug("Columns to update are {} for all partitions; {} individual partitions. Existing only: {}, out of: {}", new Object[]{colsForAllParts, partsToAnalyze.size(), this.isExistingOnly, allCols});
        if (colsForAllParts == null && partsToAnalyze.isEmpty()) {
            return null;
        }
        if (colsForAllParts != null) {
            return Lists.newArrayList(new AnalyzeWork(fullTableName, null, this.buildPartColStr(table), colsForAllParts));
        }
        ArrayList<AnalyzeWork> result = new ArrayList<AnalyzeWork>(partsToAnalyze.size());
        for (Map.Entry e : partsToAnalyze.entrySet()) {
            LOG.debug("Adding analyze work for {}", e.getKey());
            result.add(new AnalyzeWork(fullTableName, (String)e.getKey(), null, (List)e.getValue()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> findPartitionsToAnalyze(TableName fullTableName, String cat, String db, String tbl, List<String> allCols, Map<String, List<String>> partsToAnalyze, String writeIdString) throws MetaException, NoSuchObjectException {
        List<String> partNames = null;
        Map<String, List<String>> colsPerPartition = null;
        boolean isAllParts = true;
        if (this.isExistingOnly) {
            this.rs.openTransaction();
            boolean isOk = false;
            try {
                colsPerPartition = this.rs.getPartitionColsWithStats(cat, db, tbl);
                partNames = Lists.newArrayList(colsPerPartition.keySet());
                int partitionCount = this.rs.getNumPartitionsByFilter(cat, db, tbl, "");
                isAllParts = partitionCount == partNames.size();
                isOk = true;
            }
            finally {
                if (isOk) {
                    this.rs.commitTransaction();
                } else {
                    this.rs.rollbackTransaction();
                }
            }
        } else {
            partNames = this.rs.listPartitionNames(cat, db, tbl, (short)-1);
            isAllParts = true;
        }
        Table t = this.rs.getTable(cat, db, tbl);
        List<Partition> currentBatch = null;
        int nextBatchStart = 0;
        int nextIxInBatch = -1;
        int currentBatchStart = 0;
        List<String> colsToUpdateForAll = null;
        while (true) {
            if (currentBatch == null || nextIxInBatch == currentBatch.size()) {
                if (nextBatchStart >= partNames.size()) break;
                int nextBatchEnd = Math.min(partNames.size(), nextBatchStart + this.batchSize);
                List<String> currentNames = partNames.subList(nextBatchStart, nextBatchEnd);
                currentBatchStart = nextBatchStart;
                nextBatchStart = nextBatchEnd;
                try {
                    currentBatch = this.rs.getPartitionsByNames(cat, db, tbl, currentNames);
                }
                catch (NoSuchObjectException e) {
                    LOG.error("Failed to get partitions for " + fullTableName + ", skipping some partitions", (Throwable)e);
                    currentBatch = null;
                    continue;
                }
                nextIxInBatch = 0;
            }
            int currentIxInBatch = nextIxInBatch++;
            Partition part = (Partition)currentBatch.get(currentIxInBatch);
            String partName = Warehouse.makePartName(t.getPartitionKeys(), part.getValues());
            LOG.debug("Processing partition ({} in batch), {}", (Object)currentIxInBatch, (Object)partName);
            Map<String, String> params = part.getParameters();
            String skipParam = params.get(SKIP_STATS_AUTOUPDATE_PROPERTY);
            if (this.isAnalyzePartInProgress(fullTableName, partName) || "true".equalsIgnoreCase(skipParam)) {
                if (isAllParts) {
                    this.addPreviousPartitions(t, partNames, currentBatchStart, currentBatch, currentIxInBatch, colsToUpdateForAll, partsToAnalyze);
                }
                isAllParts = false;
                continue;
            }
            List<String> colsToMaybeUpdate = allCols;
            if (this.isExistingOnly) {
                colsToMaybeUpdate = colsPerPartition.get(partName);
                Collections.sort(colsToMaybeUpdate);
            }
            List<String> colsToUpdate = this.getAnyStatsToUpdate(db, tbl, colsToMaybeUpdate, params, writeIdString == null ? -1L : part.getWriteId(), writeIdString);
            LOG.debug("Updating {} based on {} and {}", new Object[]{colsToUpdate, colsToMaybeUpdate, params});
            if (colsToUpdate == null || colsToUpdate.isEmpty()) {
                if (isAllParts) {
                    this.addPreviousPartitions(t, partNames, currentBatchStart, currentBatch, currentIxInBatch, colsToUpdateForAll, partsToAnalyze);
                }
                isAllParts = false;
                continue;
            }
            if (isAllParts) {
                List<String> newCols = this.verifySameColumnsForAllParts(colsToUpdateForAll, colsToUpdate);
                if (newCols == null) {
                    isAllParts = false;
                    this.addPreviousPartitions(t, partNames, currentBatchStart, currentBatch, currentIxInBatch, colsToUpdateForAll, partsToAnalyze);
                } else if (colsToUpdateForAll == null) {
                    colsToUpdateForAll = newCols;
                }
            }
            if (isAllParts) continue;
            LOG.trace("Adding {}, {}", (Object)partName, colsToUpdate);
            partsToAnalyze.put(partName, colsToUpdate);
        }
        return isAllParts ? colsToUpdateForAll : null;
    }

    private List<String> verifySameColumnsForAllParts(List<String> colsToUpdateForAll, List<String> colsToUpdate) {
        if (colsToUpdateForAll == null) {
            return colsToUpdate;
        }
        if (colsToUpdate.size() != colsToUpdateForAll.size()) {
            return null;
        }
        for (int i = 0; i < colsToUpdateForAll.size(); ++i) {
            if (colsToUpdate.get(i).equals(colsToUpdateForAll.get(i))) continue;
            return null;
        }
        return colsToUpdateForAll;
    }

    private void addPreviousPartitions(Table t, List<String> allPartNames, int currentBatchStart, List<Partition> currentBatch, int currentIxInBatch, List<String> cols, Map<String, List<String>> partsToAnalyze) throws MetaException {
        int i;
        for (i = 0; i < currentBatchStart; ++i) {
            LOG.trace("Adding previous {}, {}", (Object)allPartNames.get(i), cols);
            partsToAnalyze.put(allPartNames.get(i), cols);
        }
        for (i = 0; i < currentIxInBatch; ++i) {
            String name = Warehouse.makePartName(t.getPartitionKeys(), currentBatch.get(i).getValues());
            LOG.trace("Adding previous {}, {}", (Object)name, cols);
            partsToAnalyze.put(name, cols);
        }
    }

    private String buildPartColStr(Table table) {
        String partColStr = "";
        for (int i = 0; i < table.getPartitionKeysSize(); ++i) {
            if (i != 0) {
                partColStr = partColStr + ",";
            }
            partColStr = partColStr + table.getPartitionKeys().get(i).getName();
        }
        return partColStr;
    }

    private List<String> getExistingNonPartTableStatsToUpdate(TableName fullTableName, String cat, String db, String tbl, Map<String, String> params, long statsWriteId, List<String> allCols, String writeIdString) throws MetaException {
        ColumnStatistics existingStats = null;
        try {
            existingStats = this.rs.getTableColumnStatistics(cat, db, tbl, allCols, "hive");
        }
        catch (NoSuchObjectException e) {
            LOG.error("Cannot retrieve existing stats, skipping " + fullTableName, (Throwable)e);
            return null;
        }
        boolean isTxnValid = writeIdString == null || ObjectStore.isCurrentStatsValidForTheQuery(params, statsWriteId, writeIdString, false);
        return this.getExistingStatsToUpdate(existingStats, params, isTxnValid);
    }

    private List<String> getExistingStatsToUpdate(ColumnStatistics existingStats, Map<String, String> params, boolean isTxnValid) {
        boolean hasAnyAccurate = isTxnValid && StatsSetupConst.areBasicStatsUptoDate(params);
        ArrayList<String> colsToUpdate = new ArrayList<String>();
        for (ColumnStatisticsObj obj : existingStats.getStatsObj()) {
            String col = obj.getColName();
            if (hasAnyAccurate && StatsSetupConst.areColumnStatsUptoDate(params, col)) continue;
            colsToUpdate.add(col);
        }
        return colsToUpdate;
    }

    private List<String> getAnyStatsToUpdate(String db, String tbl, List<String> allCols, Map<String, String> params, long statsWriteId, String writeIdString) throws MetaException {
        if (!StatsSetupConst.areBasicStatsUptoDate(params)) {
            return allCols;
        }
        if (writeIdString != null && !ObjectStore.isCurrentStatsValidForTheQuery(params, statsWriteId, writeIdString, false)) {
            return allCols;
        }
        ArrayList<String> colsToUpdate = new ArrayList<String>();
        for (String col : allCols) {
            if (StatsSetupConst.areColumnStatsUptoDate(params, col)) continue;
            colsToUpdate.add(col);
        }
        return colsToUpdate;
    }

    private List<TableName> getTablesToCheck() throws MetaException, NoSuchObjectException {
        if (this.isExistingOnly) {
            try {
                return this.rs.getTableNamesWithStats();
            }
            catch (Exception ex) {
                LOG.error("Error from getTablesWithStats, getting all the tables", (Throwable)ex);
            }
        }
        return this.rs.getAllTableNamesForStats();
    }

    private ValidReaderWriteIdList getWriteIds(TableName fullTableName) throws NoSuchTxnException, MetaException {
        GetValidWriteIdsRequest req = new GetValidWriteIdsRequest(Lists.newArrayList(fullTableName.getDbTable()));
        return TxnUtils.createValidReaderWriteIdList(this.txnHandler.getValidWriteIds(req).getTblValidWriteIds().get(0));
    }

    private void markAnalyzeInProgress(AnalyzeWork req) {
        if (req.partName == null) {
            Boolean old = this.tablesInProgress.putIfAbsent(req.tableName, true);
            if (old != null) {
                throw new AssertionError((Object)("The table was added to progress twice: " + req.tableName));
            }
        } else {
            String partName = req.makeFullPartName();
            Boolean old = this.partsInProgress.putIfAbsent(partName, true);
            if (old != null) {
                throw new AssertionError((Object)("The partition was added to progress twice: " + partName));
            }
        }
        this.itemsInProgress.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markAnalyzeDone(AnalyzeWork req) {
        int remaining;
        if (req.partName == null) {
            Boolean old = this.tablesInProgress.remove(req.tableName);
            if (old == null) {
                throw new AssertionError((Object)("The table was not in progress: " + req.tableName));
            }
        } else {
            String partName = req.makeFullPartName();
            Boolean old = this.partsInProgress.remove(partName);
            if (old == null) {
                throw new AssertionError((Object)("Partition was not in progress: " + partName));
            }
        }
        if ((remaining = this.itemsInProgress.decrementAndGet()) == 0) {
            AtomicInteger atomicInteger = this.itemsInProgress;
            synchronized (atomicInteger) {
                this.itemsInProgress.notifyAll();
            }
        }
    }

    private boolean isAnalyzeTableInProgress(TableName fullTableName) {
        return this.tablesInProgress.containsKey(fullTableName);
    }

    private boolean isAnalyzePartInProgress(TableName tableName, String partName) {
        return this.partsInProgress.containsKey(StatsUpdaterThread.makeFullPartName(tableName, partName));
    }

    private static String makeFullPartName(TableName tableName, String partName) {
        return tableName + "/" + partName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public boolean runOneWorkerIteration(SessionState ss, String user, HiveConf conf, boolean doWait) throws InterruptedException {
        AnalyzeWork req;
        if (doWait) {
            req = this.workQueue.take();
        } else {
            req = (AnalyzeWork)this.workQueue.poll();
            if (req == null) {
                return false;
            }
        }
        String cmd = null;
        try {
            cmd = req.buildCommand();
            LOG.debug("Running {} based on {}", (Object)cmd, (Object)req);
            if (doWait) {
                SessionState.start(ss);
            }
            DriverUtils.runOnDriver(conf, user, ss, cmd);
        }
        catch (Exception e) {
            LOG.error("Analyze command failed: " + cmd, (Throwable)e);
            try {
                ss.close();
            }
            catch (IOException e1) {
                LOG.warn("Failed to close a bad session", (Throwable)e1);
            }
            finally {
                SessionState.detachSession();
            }
        }
        finally {
            this.markAnalyzeDone(req);
        }
        return true;
    }

    private static void closeSession(SessionState ss) {
        try {
            ss.close();
        }
        catch (IOException e1) {
            LOG.error("Failed to close the session", (Throwable)e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void waitForQueuedCommands() throws InterruptedException {
        while (this.itemsInProgress.get() > 0) {
            AtomicInteger atomicInteger = this.itemsInProgress;
            synchronized (atomicInteger) {
                this.itemsInProgress.wait(100L);
            }
        }
    }

    @VisibleForTesting
    public int getQueueLength() {
        return this.workQueue.size();
    }

    public class WorkerRunnable
    implements Runnable {
        private final HiveConf conf;
        private final String user;

        public WorkerRunnable(Configuration conf, String user) {
            this.conf = new HiveConf(conf, HiveConf.class);
            this.user = user;
        }

        @Override
        public void run() {
            while (true) {
                SessionState ss = DriverUtils.setUpSessionState(this.conf, this.user, false);
                try {
                    StatsUpdaterThread.this.runOneWorkerIteration(ss, this.user, this.conf, true);
                }
                catch (InterruptedException e) {
                    StatsUpdaterThread.closeSession(ss);
                    LOG.info("Worker thread was interrupted and will now exit");
                    return;
                }
                try {
                    while (StatsUpdaterThread.this.runOneWorkerIteration(ss, this.user, this.conf, false)) {
                    }
                }
                catch (InterruptedException e) {
                    StatsUpdaterThread.closeSession(ss);
                    LOG.info("Worker thread was interrupted unexpectedly and will now exit");
                    return;
                }
                StatsUpdaterThread.closeSession(ss);
                SessionState.detachSession();
            }
        }
    }

    private static final class AnalyzeWork {
        TableName tableName;
        String partName;
        String allParts;
        List<String> cols;

        public AnalyzeWork(TableName tableName, String partName, String allParts, List<String> cols) {
            this.tableName = tableName;
            this.partName = partName;
            this.allParts = allParts;
            this.cols = cols;
        }

        public String makeFullPartName() {
            return StatsUpdaterThread.makeFullPartName(this.tableName, this.partName);
        }

        public String buildCommand() {
            String cmd = "analyze table " + this.tableName.getDb() + "." + this.tableName.getTable();
            assert (this.partName == null || this.allParts == null);
            if (this.partName != null) {
                cmd = cmd + " partition(" + this.partName + ")";
            }
            if (this.allParts != null) {
                cmd = cmd + " partition(" + this.allParts + ")";
            }
            cmd = cmd + " compute statistics for columns";
            if (this.cols != null) {
                cmd = cmd + " " + String.join((CharSequence)",", this.cols);
            }
            return cmd;
        }

        public String toString() {
            return "AnalyzeWork [tableName=" + this.tableName + ", partName=" + this.partName + ", allParts=" + this.allParts + ", cols=" + this.cols + "]";
        }
    }
}

