/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import org.apache.hadoop.hive.common.StringableMap;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;

public class CompactorUtil {
    public static final String COMPACTOR = "compactor";
    private static final List<String> QUEUE_PROPERTIES = Arrays.asList("compactor." + HiveConf.ConfVars.COMPACTOR_JOB_QUEUE.varname, "compactor.mapreduce.job.queuename", "compactor.mapred.job.queue.name");

    public static ThreadFactory createThreadFactory(String threadNameFormat) {
        return new ThreadFactoryBuilder().setPriority(Thread.currentThread().getPriority()).setDaemon(Thread.currentThread().isDaemon()).setNameFormat(threadNameFormat).build();
    }

    public static ExecutorService createExecutorWithThreadFactory(int threadCount, String threadNameFormat) {
        return Executors.newFixedThreadPool(threadCount, CompactorUtil.createThreadFactory(threadNameFormat));
    }

    static String getCompactorJobQueueName(HiveConf conf, CompactionInfo ci, Table table) {
        ArrayList<Function<String, String>> propertyGetters = new ArrayList<Function<String, String>>(2);
        if (ci.properties != null) {
            StringableMap ciProperties = new StringableMap(ci.properties);
            propertyGetters.add(ciProperties::get);
        }
        if (table.getParameters() != null) {
            propertyGetters.add(table.getParameters()::get);
        }
        for (Function function : propertyGetters) {
            for (String p : QUEUE_PROPERTIES) {
                String queueName = (String)function.apply(p);
                if (queueName == null || queueName.isEmpty()) continue;
                return queueName;
            }
        }
        return conf.getVar(HiveConf.ConfVars.COMPACTOR_JOB_QUEUE);
    }

    public static interface ThrowingRunnable<E extends Exception> {
        public void run() throws E;

        public static Runnable unchecked(ThrowingRunnable<?> r) {
            return () -> {
                try {
                    r.run();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
        }
    }
}

