/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilder;
import org.apache.hadoop.hive.ql.txn.compactor.QueryCompactor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MmMinorQueryCompactor
extends QueryCompactor {
    private static final Logger LOG = LoggerFactory.getLogger((String)MmMinorQueryCompactor.class.getName());

    MmMinorQueryCompactor() {
    }

    @Override
    void runCompaction(HiveConf hiveConf, Table table, Partition partition, StorageDescriptor storageDescriptor, ValidWriteIdList writeIds, CompactionInfo compactionInfo, AcidUtils.Directory dir) throws IOException {
        LOG.debug("Going to delete directories for aborted transactions for MM table " + table.getDbName() + "." + table.getTableName());
        QueryCompactor.Util.removeFilesForMmTable(hiveConf, dir);
        HiveConf driverConf = this.setUpDriverSession(hiveConf);
        String tmpPrefix = table.getDbName() + ".tmp_minor_compactor_" + table.getTableName() + "_";
        String tmpTableName = tmpPrefix + System.currentTimeMillis();
        String resultTmpTableName = tmpTableName + "_result";
        Path resultDeltaDir = QueryCompactor.Util.getCompactionResultDir(storageDescriptor, writeIds, driverConf, false, false, false, dir);
        List<String> createTableQueries = this.getCreateQueries(tmpTableName, table, storageDescriptor, dir, writeIds, resultDeltaDir);
        List<String> compactionQueries = this.getCompactionQueries(tmpTableName, resultTmpTableName, table);
        List<String> dropQueries = this.getDropQueries(tmpTableName);
        this.runCompactionQueries(driverConf, tmpTableName, storageDescriptor, writeIds, compactionInfo, Lists.newArrayList(resultDeltaDir), createTableQueries, compactionQueries, dropQueries);
    }

    @Override
    protected void commitCompaction(String dest, String tmpTableName, HiveConf conf, ValidWriteIdList actualWriteIds, long compactorTxnId) throws IOException, HiveException {
        QueryCompactor.Util.cleanupEmptyDir(conf, tmpTableName);
    }

    private List<String> getCreateQueries(String tmpTableBase, Table t, StorageDescriptor sd, AcidUtils.Directory dir, ValidWriteIdList writeIds, Path resultDeltaDir) {
        ArrayList<String> queries = Lists.newArrayList(this.getCreateQuery(tmpTableBase, t, sd, null, true), this.getCreateQuery(tmpTableBase + "_result", t, sd, resultDeltaDir.toString(), false));
        String alterQuery = this.buildAlterTableQuery(tmpTableBase, dir, writeIds);
        if (!alterQuery.isEmpty()) {
            queries.add(alterQuery);
        }
        return queries;
    }

    private String getCreateQuery(String newTableName, Table t, StorageDescriptor sd, String location, boolean isPartitioned) {
        return new CompactionQueryBuilder(CompactionQueryBuilder.CompactionType.MINOR_INSERT_ONLY, CompactionQueryBuilder.Operation.CREATE, newTableName).setSourceTab(t).setStorageDescriptor(sd).setLocation(location).setPartitioned(isPartitioned).build();
    }

    private String buildAlterTableQuery(String tableName, AcidUtils.Directory dir, ValidWriteIdList validWriteIdList) {
        return new CompactionQueryBuilder(CompactionQueryBuilder.CompactionType.MINOR_INSERT_ONLY, CompactionQueryBuilder.Operation.ALTER, tableName).setDir(dir).setValidWriteIdList(validWriteIdList).build();
    }

    private List<String> getCompactionQueries(String sourceTmpTableName, String resultTmpTableName, Table sourceTable) {
        return Lists.newArrayList(new CompactionQueryBuilder(CompactionQueryBuilder.CompactionType.MINOR_INSERT_ONLY, CompactionQueryBuilder.Operation.INSERT, resultTmpTableName).setSourceTabForInsert(sourceTmpTableName).setSourceTab(sourceTable).build());
    }

    private List<String> getDropQueries(String tmpTableBase) {
        return Lists.newArrayList(this.getDropQuery(tmpTableBase), this.getDropQuery(tmpTableBase + "_result"));
    }

    private String getDropQuery(String tableToDrop) {
        return new CompactionQueryBuilder(CompactionQueryBuilder.CompactionType.MINOR_INSERT_ONLY, CompactionQueryBuilder.Operation.DROP, tableToDrop).build();
    }

    private HiveConf setUpDriverSession(HiveConf hiveConf) {
        HiveConf driverConf = new HiveConf(hiveConf);
        driverConf.set(HiveConf.ConfVars.HIVE_QUOTEDID_SUPPORT.varname, "column");
        driverConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_FETCH_COLUMN_STATS, false);
        driverConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_ESTIMATE_STATS, false);
        return driverConf;
    }
}

