/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hive.metastore.HiveMetaStoreUtils;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorThread;
import org.apache.thrift.TException;

public class RemoteCompactorThread
extends CompactorThread {
    protected IMetaStoreClient msc;

    @Override
    public void init(AtomicBoolean stop) throws Exception {
        super.init(stop);
        this.msc = HiveMetaStoreUtils.getHiveMetastoreClient(this.conf);
    }

    @Override
    Table resolveTable(CompactionInfo ci) throws MetaException {
        try {
            return this.msc.getTable(MetaStoreUtils.getDefaultCatalog(this.conf), ci.dbname, ci.tableName);
        }
        catch (TException e) {
            LOG.error("Unable to find table " + ci.getFullTableName(), (Throwable)e);
            throw new MetaException(e.toString());
        }
    }

    @Override
    boolean replIsCompactionDisabledForDatabase(String dbName) throws TException {
        try {
            Database database = this.msc.getDatabase(MetaStoreUtils.getDefaultCatalog(this.conf), dbName);
            return ReplUtils.isFirstIncPending(database.getParameters());
        }
        catch (NoSuchObjectException e) {
            LOG.info("Unable to find database " + dbName);
            return true;
        }
    }

    @Override
    List<Partition> getPartitionsByNames(CompactionInfo ci) throws MetaException {
        try {
            return this.msc.getPartitionsByNames(MetaStoreUtils.getDefaultCatalog(this.conf), ci.dbname, ci.tableName, Collections.singletonList(ci.partName));
        }
        catch (TException e) {
            LOG.error("Unable to get partitions by name for CompactionInfo=" + ci);
            throw new MetaException(e.toString());
        }
    }
}

