/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateTimestamp;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDateObjectInspector;
import org.apache.hive.common.util.DateParser;

@Description(name="to_date", value="_FUNC_(expr) - Extracts the date part of the date or datetime expression expr", extended="Example:\n   > SELECT _FUNC_('2009-07-30 04:17:52') FROM src LIMIT 1;\n  '2009-07-30'")
@VectorizedExpressions(value={VectorUDFDateString.class, VectorUDFDateTimestamp.class})
public class GenericUDFDate
extends GenericUDF {
    private transient PrimitiveObjectInspectorConverter.TimestampConverter timestampConverter;
    private transient ObjectInspectorConverters.Converter textConverter;
    private transient ObjectInspectorConverters.Converter dateWritableConverter;
    private transient PrimitiveObjectInspector.PrimitiveCategory inputType;
    private transient PrimitiveObjectInspector argumentOI;
    private final transient DateWritableV2 output = new DateWritableV2();
    private final transient Date date = new Date();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentLengthException("to_date() requires 1 argument, got " + arguments.length);
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException("to_date() only accepts STRING/TIMESTAMP/DATEWRITABLE types, got " + arguments[0].getTypeName());
        }
        this.argumentOI = (PrimitiveObjectInspector)arguments[0];
        this.inputType = this.argumentOI.getPrimitiveCategory();
        WritableDateObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        switch (this.inputType) {
            case VOID: {
                break;
            }
            case CHAR: 
            case VARCHAR: 
            case STRING: {
                this.inputType = PrimitiveObjectInspector.PrimitiveCategory.STRING;
                this.textConverter = ObjectInspectorConverters.getConverter((ObjectInspector)this.argumentOI, (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
                break;
            }
            case TIMESTAMP: {
                this.timestampConverter = new PrimitiveObjectInspectorConverter.TimestampConverter(this.argumentOI, PrimitiveObjectInspectorFactory.writableTimestampObjectInspector);
                break;
            }
            case TIMESTAMPLOCALTZ: 
            case DATE: {
                this.dateWritableConverter = ObjectInspectorConverters.getConverter((ObjectInspector)this.argumentOI, (ObjectInspector)PrimitiveObjectInspectorFactory.writableDateObjectInspector);
                break;
            }
            default: {
                throw new UDFArgumentException("TO_DATE() only takes STRING/TIMESTAMP/DATEWRITABLE types, got " + (Object)((Object)this.inputType));
            }
        }
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (arguments[0].get() == null) {
            return null;
        }
        switch (this.inputType) {
            case VOID: {
                throw new UDFArgumentException("TO_DATE() received non-null object of VOID type");
            }
            case STRING: {
                String dateString = this.textConverter.convert(arguments[0].get()).toString();
                if (DateParser.parseDate(dateString, this.date)) {
                    this.output.set(this.date);
                    break;
                }
                return null;
            }
            case TIMESTAMP: {
                Timestamp ts = ((TimestampWritableV2)this.timestampConverter.convert(arguments[0].get())).getTimestamp();
                this.output.set(DateWritableV2.millisToDays(ts.toEpochMilli()));
                break;
            }
            case TIMESTAMPLOCALTZ: 
            case DATE: {
                DateWritableV2 dw = (DateWritableV2)this.dateWritableConverter.convert(arguments[0].get());
                this.output.set(dw);
                break;
            }
            default: {
                throw new UDFArgumentException("TO_DATE() only takes STRING/TIMESTAMP/DATEWRITABLE types, got " + (Object)((Object)this.inputType));
            }
        }
        return this.output;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("to_date", children);
    }
}

