/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateAddColCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateAddColScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateAddScalarCol;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDateObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.hive.common.util.DateParser;

@Description(name="date_add", value="_FUNC_(start_date, num_days) - Returns the date that is num_days after start_date.", extended="start_date is a string in the format 'yyyy-MM-dd HH:mm:ss' or 'yyyy-MM-dd'. num_days is a number. The time part of start_date is ignored.\nExample:\n   > SELECT _FUNC_('2009-07-30', 1) FROM src LIMIT 1;\n  '2009-07-31'")
@VectorizedExpressions(value={VectorUDFDateAddColScalar.class, VectorUDFDateAddScalarCol.class, VectorUDFDateAddColCol.class})
public class GenericUDFDateAdd
extends GenericUDF {
    private final transient Date dateVal = new Date();
    private transient ObjectInspectorConverters.Converter dateConverter;
    private transient ObjectInspectorConverters.Converter daysConverter;
    private transient PrimitiveObjectInspector.PrimitiveCategory inputType1;
    private transient PrimitiveObjectInspector.PrimitiveCategory inputType2;
    private final DateWritableV2 output = new DateWritableV2();
    protected int signModifier = 1;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("date_add() requires 2 argument, got " + arguments.length);
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + arguments[0].getTypeName() + " is passed. as first arguments");
        }
        if (arguments[1].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(1, "Only primitive type arguments are accepted but " + arguments[1].getTypeName() + " is passed. as second arguments");
        }
        this.inputType1 = ((PrimitiveObjectInspector)arguments[0]).getPrimitiveCategory();
        WritableDateObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        switch (this.inputType1) {
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                this.inputType1 = PrimitiveObjectInspector.PrimitiveCategory.STRING;
                this.dateConverter = ObjectInspectorConverters.getConverter((ObjectInspector)((PrimitiveObjectInspector)arguments[0]), (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
                break;
            }
            case TIMESTAMP: {
                this.dateConverter = new PrimitiveObjectInspectorConverter.TimestampConverter((PrimitiveObjectInspector)arguments[0], PrimitiveObjectInspectorFactory.writableTimestampObjectInspector);
                break;
            }
            case DATE: {
                this.dateConverter = ObjectInspectorConverters.getConverter((ObjectInspector)((PrimitiveObjectInspector)arguments[0]), (ObjectInspector)PrimitiveObjectInspectorFactory.writableDateObjectInspector);
                break;
            }
            default: {
                throw new UDFArgumentException(" DATE_ADD() only takes STRING/TIMESTAMP/DATEWRITABLE types as first argument, got " + (Object)((Object)this.inputType1));
            }
        }
        this.inputType2 = ((PrimitiveObjectInspector)arguments[1]).getPrimitiveCategory();
        switch (this.inputType2) {
            case BYTE: {
                this.daysConverter = ObjectInspectorConverters.getConverter((ObjectInspector)((PrimitiveObjectInspector)arguments[1]), (ObjectInspector)PrimitiveObjectInspectorFactory.writableByteObjectInspector);
                break;
            }
            case SHORT: {
                this.daysConverter = ObjectInspectorConverters.getConverter((ObjectInspector)((PrimitiveObjectInspector)arguments[1]), (ObjectInspector)PrimitiveObjectInspectorFactory.writableShortObjectInspector);
                break;
            }
            case INT: {
                this.daysConverter = ObjectInspectorConverters.getConverter((ObjectInspector)((PrimitiveObjectInspector)arguments[1]), (ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector);
                break;
            }
            default: {
                throw new UDFArgumentException(" DATE_ADD() only takes TINYINT/SMALLINT/INT types as second argument, got " + (Object)((Object)this.inputType2));
            }
        }
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        int toBeAdded;
        if (arguments[0].get() == null) {
            return null;
        }
        Object daysWritableObject = this.daysConverter.convert(arguments[1].get());
        if (daysWritableObject == null) {
            return null;
        }
        if (daysWritableObject instanceof ByteWritable) {
            toBeAdded = ((ByteWritable)((Object)daysWritableObject)).get();
        } else if (daysWritableObject instanceof ShortWritable) {
            toBeAdded = ((ShortWritable)daysWritableObject).get();
        } else if (daysWritableObject instanceof IntWritable) {
            toBeAdded = ((IntWritable)daysWritableObject).get();
        } else {
            return null;
        }
        switch (this.inputType1) {
            case STRING: {
                String dateString = this.dateConverter.convert(arguments[0].get()).toString();
                if (DateParser.parseDate(dateString, this.dateVal)) {
                    this.output.set(this.dateVal);
                    break;
                }
                return null;
            }
            case TIMESTAMP: {
                Timestamp ts = ((TimestampWritableV2)this.dateConverter.convert(arguments[0].get())).getTimestamp();
                this.output.set(DateWritableV2.millisToDays(ts.toEpochMilli()));
                break;
            }
            case DATE: {
                DateWritableV2 dw = (DateWritableV2)this.dateConverter.convert(arguments[0].get());
                this.output.set(dw.getDays());
                break;
            }
            default: {
                throw new UDFArgumentException("DATE_ADD() only takes STRING/TIMESTAMP/DATEWRITABLE types, got " + (Object)((Object)this.inputType1));
            }
        }
        int newDays = this.output.getDays() + this.signModifier * toBeAdded;
        this.output.set(newDays);
        return this.output;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("date_add", children);
    }
}

