/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.UnixTimeFormatter;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.Text;

@Description(name="from_unixtime", value="_FUNC_(unix_time, format) - returns unix_time in the specified format", extended="Example:\n  > SELECT _FUNC_(0, 'yyyy-MM-dd HH:mm:ss') FROM src LIMIT 1;\n  '1970-01-01 00:00:00'")
public class GenericUDFFromUnixTime
extends GenericUDF {
    private transient IntObjectInspector inputIntOI;
    private transient LongObjectInspector inputLongOI;
    private final transient Text result = new Text();
    private transient UnixTimeFormatter formatter;
    private transient ObjectInspectorConverters.Converter[] converters = new ObjectInspectorConverters.Converter[2];
    private transient PrimitiveObjectInspector.PrimitiveCategory[] inputTypes = new PrimitiveObjectInspector.PrimitiveCategory[2];

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.checkArgsSize(arguments, 1, 2);
        for (int i = 0; i < arguments.length; ++i) {
            this.checkArgPrimitive(arguments, i);
        }
        PrimitiveObjectInspector arg0OI = (PrimitiveObjectInspector)arguments[0];
        switch (arg0OI.getPrimitiveCategory()) {
            case INT: {
                this.inputIntOI = (IntObjectInspector)arguments[0];
                break;
            }
            case LONG: {
                this.inputLongOI = (LongObjectInspector)arguments[0];
                break;
            }
            default: {
                throw new UDFArgumentException("The function from_unixtime takes only int/long types for first argument. Got Type:" + arg0OI.getPrimitiveCategory().name());
            }
        }
        if (arguments.length == 2) {
            this.checkArgGroups(arguments, 1, this.inputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP);
            this.obtainStringConverter(arguments, 1, this.inputTypes, this.converters);
        }
        if (this.formatter == null) {
            this.formatter = UnixTimeFormatter.ofConfiguration(SessionState.get() == null ? new HiveConf() : SessionState.getSessionConf());
        }
        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
    }

    @Override
    public void configure(MapredContext context) {
        if (context != null) {
            this.formatter = UnixTimeFormatter.ofConfiguration((Configuration)context.getJobConf());
        }
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        long unixTime;
        if (arguments[0].get() == null) {
            return null;
        }
        long l = unixTime = this.inputIntOI != null ? (long)this.inputIntOI.get(arguments[0].get()) : this.inputLongOI.get(arguments[0].get());
        if (arguments.length == 2) {
            String format = this.getStringValue(arguments, 1, this.converters);
            if (format == null) {
                return null;
            }
            this.result.set(this.formatter.format(unixTime, format));
        } else {
            this.result.set(this.formatter.format(unixTime));
        }
        return this.result;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("from_unixtime", children, ", ");
    }
}

