/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressionsSupportDecimal64;
import org.apache.hadoop.hive.ql.exec.vector.expressions.LongColDivideLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.LongColDivideLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.LongScalarDivideLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.Decimal64ColDivideDecimal64Column;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.Decimal64ColDivideDecimal64Scalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalColDivideDecimalColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalColDivideDecimalScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalScalarDivideDecimalColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleColDivideDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleColDivideDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleColDivideLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleColDivideLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleScalarDivideDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleScalarDivideLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColDivideDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColDivideDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongScalarDivideDoubleColumn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseNumeric;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

@Description(name="/", value="a _FUNC_ b - Divide a by b", extended="Example:\n  > SELECT 3 _FUNC_ 2 FROM src LIMIT 1;\n  1.5")
@VectorizedExpressions(value={LongColDivideLongColumn.class, LongColDivideDoubleColumn.class, DoubleColDivideLongColumn.class, DoubleColDivideDoubleColumn.class, LongColDivideLongScalar.class, LongColDivideDoubleScalar.class, DoubleColDivideLongScalar.class, DoubleColDivideDoubleScalar.class, LongScalarDivideLongColumn.class, LongScalarDivideDoubleColumn.class, DoubleScalarDivideLongColumn.class, DoubleScalarDivideDoubleColumn.class, DecimalColDivideDecimalColumn.class, DecimalColDivideDecimalScalar.class, DecimalScalarDivideDecimalColumn.class, Decimal64ColDivideDecimal64Scalar.class, Decimal64ColDivideDecimal64Column.class})
@VectorizedExpressionsSupportDecimal64
public class GenericUDFOPDivide
extends GenericUDFBaseNumeric {
    public GenericUDFOPDivide() {
        this.opDisplayName = "/";
    }

    @Override
    protected PrimitiveTypeInfo deriveResultExactTypeInfo() {
        if (this.ansiSqlArithmetic) {
            return this.deriveResultExactTypeInfoAnsiSql();
        }
        return this.deriveResultExactTypeInfoBackwardsCompat();
    }

    protected PrimitiveTypeInfo deriveResultExactTypeInfoAnsiSql() {
        return this.deriveResultDecimalTypeInfo();
    }

    protected PrimitiveTypeInfo deriveResultExactTypeInfoBackwardsCompat() {
        if (this.leftOI.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.DECIMAL && this.rightOI.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.DECIMAL) {
            return TypeInfoFactory.doubleTypeInfo;
        }
        return this.deriveResultDecimalTypeInfo();
    }

    @Override
    protected PrimitiveTypeInfo deriveResultApproxTypeInfo() {
        return TypeInfoFactory.doubleTypeInfo;
    }

    @Override
    protected DoubleWritable evaluate(DoubleWritable left, DoubleWritable right) {
        if (right.get() == 0.0) {
            return null;
        }
        this.doubleWritable.set(left.get() / right.get());
        return this.doubleWritable;
    }

    @Override
    protected HiveDecimalWritable evaluate(HiveDecimal left, HiveDecimal right) {
        if (right.compareTo(HiveDecimal.ZERO) == 0) {
            return null;
        }
        HiveDecimal dec = left.divide(right);
        if (dec == null) {
            return null;
        }
        this.decimalWritable.set(dec);
        return this.decimalWritable;
    }

    @Override
    protected DecimalTypeInfo deriveResultDecimalTypeInfo(int prec1, int scale1, int prec2, int scale2) {
        int intDig = prec1 - scale1 + scale2;
        int scale = Math.max(6, scale1 + prec2 + 1);
        int prec = intDig + scale;
        return this.adjustPrecScale(prec, scale);
    }
}

