/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.tez.TezContext;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantIntObjectInspector;
import org.apache.hadoop.io.LongWritable;

@UDFType(deterministic=false)
public class GenericUDFSurrogateKey
extends GenericUDF {
    private static final int DEFAULT_WRITE_ID_BITS = 24;
    private static final int DEFAULT_TASK_ID_BITS = 16;
    private static final int DEFAULT_ROW_ID_BITS = 24;
    private int writeIdBits;
    private int taskIdBits;
    private int rowIdBits;
    private long maxWriteId;
    private long maxTaskId;
    private long maxRowId;
    private long writeId = -1L;
    private long taskId = -1L;
    private long rowId = 0L;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length == 0) {
            this.writeIdBits = 24;
            this.taskIdBits = 16;
            this.rowIdBits = 24;
        } else if (arguments.length == 2) {
            for (int i = 0; i < 2; ++i) {
                if (arguments[i].getCategory() == ObjectInspector.Category.PRIMITIVE) continue;
                throw new UDFArgumentTypeException(0, "SURROGATE_KEY input only takes primitive types, got " + arguments[i].getTypeName());
            }
            this.writeIdBits = ((WritableConstantIntObjectInspector)arguments[0]).getWritableConstantValue().get();
            this.taskIdBits = ((WritableConstantIntObjectInspector)arguments[1]).getWritableConstantValue().get();
            this.rowIdBits = 64 - (this.writeIdBits + this.taskIdBits);
            if (this.writeIdBits < 1 || this.writeIdBits > 62) {
                throw new UDFArgumentException("Write ID bits must be between 1 and 62 (value: " + this.writeIdBits + ")");
            }
            if (this.taskIdBits < 1 || this.taskIdBits > 62) {
                throw new UDFArgumentException("Task ID bits must be between 1 and 62 (value: " + this.taskIdBits + ")");
            }
            if (this.writeIdBits + this.taskIdBits > 63) {
                throw new UDFArgumentException("Write ID bits + Task ID bits must be less than 63 (value: " + (this.writeIdBits + this.taskIdBits) + ")");
            }
        } else {
            throw new UDFArgumentLengthException("The function SURROGATE_KEY takes 0 or 2 integer arguments (write id bits, taks id bits), but found " + arguments.length);
        }
        this.maxWriteId = (1L << this.writeIdBits) - 1L;
        this.maxTaskId = (1L << this.taskIdBits) - 1L;
        this.maxRowId = (1L << this.rowIdBits) - 1L;
        return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
    }

    @Override
    public void configure(MapredContext context) {
        if (!(context instanceof TezContext)) {
            throw new IllegalStateException("surrogate_key function is only supported if the execution engine is Tez");
        }
        this.taskId = ((TezContext)context).getTezProcessorContext().getTaskIndex();
        if (this.taskId > this.maxTaskId) {
            throw new IllegalStateException(String.format("Task ID is out of range (%d bits) in surrogate_key", this.taskIdBits));
        }
    }

    public void setWriteId(long writeId) {
        this.writeId = writeId;
        if (writeId > this.maxWriteId) {
            throw new IllegalStateException(String.format("Write ID is out of range (%d bits) in surrogate_key", this.writeIdBits));
        }
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (this.writeId == -1L) {
            throw new HiveException("Could not obtain Write ID for the surrogate_key function");
        }
        if (this.rowId > this.maxRowId) {
            throw new HiveException(String.format("Row ID is out of range (%d bits) in surrogate_key", this.rowIdBits));
        }
        long uniqueId = (this.writeId << this.taskIdBits + this.rowIdBits) + (this.taskId << this.rowIdBits) + this.rowId;
        ++this.rowId;
        return new LongWritable(uniqueId);
    }

    @Override
    public String getDisplayString(String[] children) {
        return "SURROGATE_KEY()";
    }
}

