/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="string", value="CAST(<value> as STRING) - Converts the argument to a string value.", extended="Example:\n   > SELECT CAST(1234 AS string) FROM src LIMIT 1;\n  '1234'")
public class GenericUDFToString
extends GenericUDF {
    private static final Logger LOG = LoggerFactory.getLogger((String)GenericUDFToString.class.getName());
    private transient PrimitiveObjectInspector argumentOI;
    private transient PrimitiveObjectInspectorConverter.TextConverter converter;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentException("STRING cast requires a value argument");
        }
        try {
            this.argumentOI = (PrimitiveObjectInspector)arguments[0];
        }
        catch (ClassCastException e) {
            throw new UDFArgumentException("The function STRING takes only primitive types");
        }
        this.converter = new PrimitiveObjectInspectorConverter.TextConverter(this.argumentOI);
        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object o0 = arguments[0].get();
        if (o0 == null) {
            return null;
        }
        return this.converter.convert(o0);
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 1);
        StringBuilder sb = new StringBuilder();
        sb.append("CAST( ");
        sb.append(children[0]);
        sb.append(" AS STRING)");
        return sb.toString();
    }
}

