/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Objects;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.ql.udf.generic.UnixTimeFormatterCache;

final class UnixTimeDateTimeFormatter
extends UnixTimeFormatterCache<DateTimeFormatter> {
    UnixTimeDateTimeFormatter(ZoneId zoneId) {
        super(zoneId, s -> new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern((String)s).toFormatter().withZone(zoneId));
    }

    @Override
    public long parse(String text) throws RuntimeException {
        Objects.requireNonNull(text);
        Timestamp timestamp = Timestamp.valueOf(text);
        TimestampTZ timestampTZ = TimestampTZUtil.convert(timestamp, this.zoneId);
        return timestampTZ.getEpochSecond();
    }

    @Override
    public long parse(String text, String pattern) {
        Timestamp timestamp;
        Objects.requireNonNull(text);
        Objects.requireNonNull(pattern);
        DateTimeFormatter formatter = (DateTimeFormatter)this.getFormatter(pattern);
        try {
            ZonedDateTime zonedDateTime = ZonedDateTime.parse(text, formatter).withZoneSameInstant(this.zoneId);
            timestamp = new Timestamp(zonedDateTime.toLocalDateTime());
        }
        catch (DateTimeException e1) {
            LocalDate localDate = LocalDate.parse(text, formatter);
            timestamp = new Timestamp(localDate.atStartOfDay());
        }
        TimestampTZ timestampTZ = TimestampTZUtil.convert(timestamp, this.zoneId);
        return timestampTZ.getEpochSecond();
    }

    @Override
    public String format(long epochSeconds) {
        return this.format(epochSeconds, "uuuu-MM-dd HH:mm:ss");
    }

    @Override
    public String format(long epochSeconds, String pattern) {
        DateTimeFormatter formatter = (DateTimeFormatter)this.getFormatter(pattern);
        Instant instant = Instant.ofEpochSecond(epochSeconds);
        ZonedDateTime zonedDT = ZonedDateTime.ofInstant(instant, this.zoneId);
        return zonedDT.format(formatter);
    }
}

