/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.time.ZoneId;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.udf.generic.UnixTimeDateTimeFormatter;
import org.apache.hadoop.hive.ql.udf.generic.UnixTimeSimpleDateFormatter;

public interface UnixTimeFormatter {
    public static UnixTimeFormatter ofConfiguration(Configuration conf) {
        ZoneId zoneId = TimestampTZUtil.parseTimeZone(HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_LOCAL_TIME_ZONE));
        Type type = Type.valueOf(HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_DATETIME_FORMATTER).toUpperCase());
        return type.newFormatter(zoneId);
    }

    public long parse(String var1) throws RuntimeException;

    public long parse(String var1, String var2) throws RuntimeException;

    public String format(long var1);

    public String format(long var1, String var3);

    public static enum Type {
        SIMPLE{

            @Override
            UnixTimeFormatter newFormatter(ZoneId zone) {
                return new UnixTimeSimpleDateFormatter(zone);
            }
        }
        ,
        DATETIME{

            @Override
            UnixTimeFormatter newFormatter(ZoneId zone) {
                return new UnixTimeDateTimeFormatter(zone);
            }
        };


        abstract UnixTimeFormatter newFormatter(ZoneId var1);
    }
}

