/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.hadoop.hive.ql.udf.generic.UnixTimeFormatterCache;

final class UnixTimeSimpleDateFormatter
extends UnixTimeFormatterCache<SimpleDateFormat> {
    private static final String DEFAULT = "yyyy-MM-dd HH:mm:ss";

    UnixTimeSimpleDateFormatter(ZoneId zoneId) {
        super(zoneId, s -> {
            SimpleDateFormat f = new SimpleDateFormat((String)s);
            f.setTimeZone(TimeZone.getTimeZone(zoneId));
            return f;
        });
    }

    @Override
    public long parse(String value) throws RuntimeException {
        return this.parse(value, DEFAULT);
    }

    @Override
    public long parse(String text, String pattern) {
        Objects.requireNonNull(text);
        Objects.requireNonNull(pattern);
        SimpleDateFormat formatter = (SimpleDateFormat)this.getFormatter(pattern);
        ParsePosition pos = new ParsePosition(0);
        Date d = formatter.parse(text, pos);
        if (d == null) {
            throw new DateTimeParseException(text + " cannot be parsed to date. Error at index " + pos.getErrorIndex(), text, pos.getErrorIndex());
        }
        return d.getTime() / 1000L;
    }

    @Override
    public String format(long epochSeconds) {
        return this.format(epochSeconds, DEFAULT);
    }

    @Override
    public String format(long epochSeconds, String pattern) {
        SimpleDateFormat formatter = (SimpleDateFormat)this.getFormatter(pattern);
        Date date = new Date(epochSeconds * 1000L);
        return formatter.format(date);
    }
}

