/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.OrderExpressionDef;
import org.apache.hadoop.hive.ql.udf.ptf.SingleValueBoundaryScanner;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

class DateValueBoundaryScanner
extends SingleValueBoundaryScanner {
    public DateValueBoundaryScanner(BoundaryDef start, BoundaryDef end, OrderExpressionDef expressionDef, boolean nullsLast) {
        super(start, end, expressionDef, nullsLast);
    }

    @Override
    public boolean isDistanceGreater(Object v1, Object v2, int amt) {
        Date l1 = PrimitiveObjectInspectorUtils.getDate(v1, (PrimitiveObjectInspector)this.expressionDef.getOI());
        Date l2 = PrimitiveObjectInspectorUtils.getDate(v2, (PrimitiveObjectInspector)this.expressionDef.getOI());
        if (l1 != null && l2 != null) {
            return (double)(l1.toEpochMilli() - l2.toEpochMilli()) / 1000.0 > (double)((long)amt * 24L * 3600L);
        }
        return l1 != l2;
    }

    @Override
    public boolean isEqual(Object v1, Object v2) {
        Date l1 = PrimitiveObjectInspectorUtils.getDate(v1, (PrimitiveObjectInspector)this.expressionDef.getOI());
        Date l2 = PrimitiveObjectInspectorUtils.getDate(v2, (PrimitiveObjectInspector)this.expressionDef.getOI());
        return l1 == null && l2 == null || l1 != null && l1.equals(l2);
    }
}

