/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

public enum NullOrdering {
    NULLS_FIRST(1, 971, ObjectInspectorUtils.NullValueOption.MINVALUE, 'a'),
    NULLS_LAST(0, 972, ObjectInspectorUtils.NullValueOption.MAXVALUE, 'z');

    private final int code;
    private final int token;
    private final ObjectInspectorUtils.NullValueOption nullValueOption;
    private final char sign;

    private NullOrdering(int code, int token, ObjectInspectorUtils.NullValueOption nullValueOption, char sign) {
        this.code = code;
        this.token = token;
        this.nullValueOption = nullValueOption;
        this.sign = sign;
    }

    public static NullOrdering fromToken(int token) {
        for (NullOrdering nullOrdering : NullOrdering.values()) {
            if (nullOrdering.token != token) continue;
            return nullOrdering;
        }
        throw new EnumConstantNotPresentException(NullOrdering.class, "No enum constant present with token " + token);
    }

    public static NullOrdering fromCode(int code) {
        for (NullOrdering nullOrdering : NullOrdering.values()) {
            if (nullOrdering.code != code) continue;
            return nullOrdering;
        }
        throw new EnumConstantNotPresentException(NullOrdering.class, "No enum constant present with code " + code);
    }

    public static NullOrdering fromSign(char sign) {
        for (NullOrdering nullOrdering : NullOrdering.values()) {
            if (nullOrdering.sign != sign) continue;
            return nullOrdering;
        }
        throw new EnumConstantNotPresentException(NullOrdering.class, "No enum constant present with sign " + sign);
    }

    public static NullOrdering defaultNullOrder(Configuration hiveConf) {
        return HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVE_DEFAULT_NULLS_LAST) ? NULLS_LAST : NULLS_FIRST;
    }

    public int getCode() {
        return this.code;
    }

    public int getToken() {
        return this.token;
    }

    public ObjectInspectorUtils.NullValueOption getNullValueOption() {
        return this.nullValueOption;
    }

    public char getSign() {
        return this.sign;
    }
}

