/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.typeinfo;

import java.io.Serializable;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class PrimitiveTypeInfo
extends TypeInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String typeName;
    protected transient PrimitiveObjectInspectorUtils.PrimitiveTypeEntry typeEntry;

    public PrimitiveTypeInfo() {
    }

    PrimitiveTypeInfo(String typeName) {
        this.typeName = typeName;
        this.typeEntry = PrimitiveObjectInspectorUtils.getTypeEntryFromTypeName(typeName);
    }

    @Override
    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.PRIMITIVE;
    }

    public PrimitiveObjectInspector.PrimitiveCategory getPrimitiveCategory() {
        return this.getPrimitiveTypeEntry().primitiveCategory;
    }

    public Class<?> getPrimitiveWritableClass() {
        return this.getPrimitiveTypeEntry().primitiveWritableClass;
    }

    public Class<?> getPrimitiveJavaClass() {
        return this.getPrimitiveTypeEntry().primitiveJavaClass;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
        this.typeEntry = null;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    public PrimitiveObjectInspectorUtils.PrimitiveTypeEntry getPrimitiveTypeEntry() {
        if (this.typeEntry == null) {
            this.typeEntry = PrimitiveObjectInspectorUtils.getTypeEntryFromTypeName(this.typeName);
        }
        return this.typeEntry;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        PrimitiveTypeInfo pti = (PrimitiveTypeInfo)other;
        return this.typeName.equals(pti.typeName);
    }

    @Override
    public int hashCode() {
        return this.typeName.hashCode();
    }

    @Override
    public String toString() {
        return this.typeName;
    }
}

