/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hive.hbase.DefaultHBaseKeyFactory;
import org.apache.hadoop.hive.hbase.HBaseCompositeKey;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeHBaseKeyFactory<T extends HBaseCompositeKey>
extends DefaultHBaseKeyFactory {
    public static final Logger LOG = LoggerFactory.getLogger(CompositeHBaseKeyFactory.class);
    private final Class<T> keyClass;
    private final Constructor constructor;
    private Configuration conf;

    public CompositeHBaseKeyFactory(Class<T> keyClass) throws Exception {
        this.keyClass = keyClass;
        this.constructor = keyClass.getDeclaredConstructor(LazySimpleStructObjectInspector.class, Properties.class, Configuration.class);
    }

    @Override
    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) throws IOException {
        super.configureJobConf(tableDesc, jobConf);
        TableMapReduceUtil.addDependencyJars((Configuration)jobConf, (Class[])new Class[]{this.keyClass});
    }

    public T createKey(ObjectInspector inspector) throws SerDeException {
        try {
            return (T)((Object)((HBaseCompositeKey)((Object)this.constructor.newInstance(inspector, this.properties, this.hbaseParams.getBaseConfiguration()))));
        }
        catch (Exception e) {
            throw new SerDeException((Throwable)e);
        }
    }
}

