/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.mapreduce.TableInputFormatBase;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.token.TokenUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.hbase.ColumnMappings;
import org.apache.hadoop.hive.hbase.HBaseKeyFactory;
import org.apache.hadoop.hive.hbase.HBaseMetaHook;
import org.apache.hadoop.hive.hbase.HBaseSerDe;
import org.apache.hadoop.hive.hbase.HBaseTableSnapshotInputFormatUtil;
import org.apache.hadoop.hive.hbase.HiveHBaseInputFormatUtil;
import org.apache.hadoop.hive.hbase.HiveHBaseTableInputFormat;
import org.apache.hadoop.hive.hbase.HiveHBaseTableOutputFormat;
import org.apache.hadoop.hive.hbase.HiveHBaseTableSnapshotInputFormat;
import org.apache.hadoop.hive.hbase.HiveHFileOutputFormat;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.index.IndexPredicateAnalyzer;
import org.apache.hadoop.hive.ql.index.IndexSearchCondition;
import org.apache.hadoop.hive.ql.metadata.DefaultStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseStorageHandler
extends DefaultStorageHandler
implements HiveStoragePredicateHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseStorageHandler.class);
    private static final String HBASE_SNAPSHOT_NAME_KEY = "hbase.TableSnapshotInputFormat.snapshot.name";
    private static final String HBASE_SNAPSHOT_TABLE_DIR_KEY = "hbase.TableSnapshotInputFormat.table.dir";
    private static final String HBASE_SNAPSHOT_RESTORE_DIR_KEY = "hbase.TableSnapshotInputFormat.restore.dir";
    private static final String[] HBASE_CACHE_KEYS = new String[]{"hbase.offheapcache.percentage", "hbase.bucketcache.size", "hbase.bucketcache.ioengine", "hfile.block.cache.size"};
    public static final String DEFAULT_PREFIX = "default.";
    private static final String HBASE_PREFIX = "hbase:";
    private static final String HBASE_HOST_NAME = "hbase.zookeeper.quorum";
    private static final String HBASE_CLIENT_PORT = "hbase.zookeeper.property.clientPort";
    private boolean configureInputJobProps = true;
    private Configuration jobConf;
    private Configuration hbaseConf;
    private static Class counterClass = null;

    public Configuration getConf() {
        return this.hbaseConf;
    }

    public Configuration getJobConf() {
        return this.jobConf;
    }

    public void setConf(Configuration conf) {
        this.jobConf = conf;
        this.hbaseConf = HBaseConfiguration.create((Configuration)conf);
    }

    public Class<? extends InputFormat> getInputFormatClass() {
        if (HiveConf.getVar((Configuration)this.jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_HBASE_SNAPSHOT_NAME) != null) {
            LOG.debug("Using TableSnapshotInputFormat");
            return HiveHBaseTableSnapshotInputFormat.class;
        }
        LOG.debug("Using HiveHBaseTableInputFormat");
        return HiveHBaseTableInputFormat.class;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        if (HBaseStorageHandler.isHBaseGenerateHFiles(this.jobConf)) {
            return HiveHFileOutputFormat.class;
        }
        return HiveHBaseTableOutputFormat.class;
    }

    public Class<? extends AbstractSerDe> getSerDeClass() {
        return HBaseSerDe.class;
    }

    public HiveMetaHook getMetaHook() {
        return new HBaseMetaHook(this.hbaseConf);
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.configureInputJobProps = true;
        this.configureTableJobProperties(tableDesc, jobProperties);
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.configureInputJobProps = false;
        this.configureTableJobProperties(tableDesc, jobProperties);
    }

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        String tableName;
        String scanBatch;
        Properties tableProperties = tableDesc.getProperties();
        jobProperties.put("hbase.columns.mapping", tableProperties.getProperty("hbase.columns.mapping"));
        jobProperties.put("hbase.columns.mapping.regex.matching", tableProperties.getProperty("hbase.columns.mapping.regex.matching", "true"));
        jobProperties.put("hbase.columns.mapping.prefix.hide", tableProperties.getProperty("hbase.columns.mapping.prefix.hide", "false"));
        jobProperties.put("hbase.table.default.storage.type", tableProperties.getProperty("hbase.table.default.storage.type", "string"));
        jobProperties.put("hbase.scan.cacheblock", tableProperties.getProperty("hbase.scan.cacheblock", "false"));
        String scanCache = tableProperties.getProperty("hbase.scan.cache");
        if (scanCache != null) {
            jobProperties.put("hbase.scan.cache", scanCache);
        }
        if ((scanBatch = tableProperties.getProperty("hbase.scan.batch")) != null) {
            jobProperties.put("hbase.scan.batch", scanBatch);
        }
        if ((tableName = tableProperties.getProperty("hbase.table.name")) == null) {
            tableName = tableProperties.getProperty("name");
            if ((tableName = tableName.toLowerCase()).startsWith(DEFAULT_PREFIX)) {
                tableName = tableName.substring(DEFAULT_PREFIX.length());
            }
        }
        jobProperties.put("hbase.table.name", tableName);
        Configuration jobConf = this.getJobConf();
        this.addHBaseResources(jobConf, jobProperties);
        if (this.configureInputJobProps) {
            LOG.info("Configuring input job properties");
            String snapshotName = HiveConf.getVar((Configuration)jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_HBASE_SNAPSHOT_NAME);
            if (snapshotName != null) {
                HBaseTableSnapshotInputFormatUtil.assertSupportsTableSnapshots();
                try {
                    String restoreDir = HiveConf.getVar((Configuration)jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_HBASE_SNAPSHOT_RESTORE_DIR);
                    if (restoreDir == null) {
                        throw new IllegalArgumentException("Cannot process HBase snapshot without specifying " + HiveConf.ConfVars.HIVE_HBASE_SNAPSHOT_RESTORE_DIR);
                    }
                    HBaseTableSnapshotInputFormatUtil.configureJob(this.hbaseConf, snapshotName, new Path(restoreDir));
                    jobProperties.put(HBASE_SNAPSHOT_NAME_KEY, this.hbaseConf.get(HBASE_SNAPSHOT_NAME_KEY));
                    if (this.hbaseConf.get(HBASE_SNAPSHOT_TABLE_DIR_KEY, null) != null) {
                        jobProperties.put(HBASE_SNAPSHOT_TABLE_DIR_KEY, this.hbaseConf.get(HBASE_SNAPSHOT_TABLE_DIR_KEY));
                    } else {
                        jobProperties.put(HBASE_SNAPSHOT_RESTORE_DIR_KEY, this.hbaseConf.get(HBASE_SNAPSHOT_RESTORE_DIR_KEY));
                    }
                    TableMapReduceUtil.resetCacheConfig((Configuration)this.hbaseConf);
                    for (String cacheKey : HBASE_CACHE_KEYS) {
                        String value = this.hbaseConf.get(cacheKey);
                        if (value != null) {
                            jobProperties.put(cacheKey, value);
                            continue;
                        }
                        jobProperties.remove(cacheKey);
                    }
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            for (String k : jobProperties.keySet()) {
                jobConf.set(k, jobProperties.get(k));
            }
            try {
                this.addHBaseDelegationToken(jobConf);
            }
            catch (IOException | MetaException e) {
                throw new IllegalStateException("Error while configuring input job properties", e);
            }
        }
        LOG.info("Configuring output job properties");
        if (HBaseStorageHandler.isHBaseGenerateHFiles(jobConf)) {
            String path = HiveHFileOutputFormat.getFamilyPath(jobConf, tableProperties);
            if (path == null || path.isEmpty()) {
                throw new RuntimeException("Please set hfile.family.path to target location for HFiles");
            }
            jobProperties.put("mapred.output.dir", path);
        } else {
            jobProperties.put("hbase.mapred.outputtable", tableName);
        }
    }

    public URI getURIForAuth(Map<String, String> tableProperties) throws URISyntaxException {
        this.hbaseConf = this.getConf();
        String hbase_host = tableProperties.getOrDefault(HBASE_HOST_NAME, this.hbaseConf.get(HBASE_HOST_NAME));
        String hbase_port = tableProperties.getOrDefault(HBASE_CLIENT_PORT, this.hbaseConf.get(HBASE_CLIENT_PORT));
        String table_name = HBaseStorageHandler.encodeString(tableProperties.getOrDefault("hbase.table.name", null));
        String column_family = HBaseStorageHandler.encodeString(tableProperties.getOrDefault("hbase.columns.mapping", null));
        String URIString = "hbase://" + hbase_host + ":" + hbase_port + "/" + table_name;
        if (column_family != null) {
            URIString = URIString + "/" + column_family;
        }
        return new URI(URIString);
    }

    private static String encodeString(String rawString) {
        return rawString != null ? rawString.replace("#", "%23") : null;
    }

    public static boolean isHBaseGenerateHFiles(Configuration conf) {
        return HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_HBASE_GENERATE_HFILES);
    }

    private void addHBaseResources(Configuration jobConf, Map<String, String> newJobProperties) {
        Configuration conf = new Configuration(false);
        HBaseConfiguration.addHbaseResources((Configuration)conf);
        for (Map.Entry entry : conf) {
            if (jobConf.get((String)entry.getKey()) != null) continue;
            newJobProperties.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void addHBaseDelegationToken(Configuration conf) throws IOException, MetaException {
        if (User.isHBaseSecurityEnabled((Configuration)conf)) {
            try (Connection connection = ConnectionFactory.createConnection((Configuration)this.hbaseConf);){
                User curUser = User.getCurrent();
                Job job = new Job(conf);
                TokenUtil.addTokenForJob((Connection)connection, (User)curUser, (Job)job);
            }
        }
    }

    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
        LOG.debug("Configuring JobConf for table {}.{}", (Object)tableDesc.getDbName(), (Object)tableDesc.getTableName());
        try {
            HBaseConfiguration.addHbaseResources((Configuration)jobConf);
            HBaseSerDe.configureJobConf(tableDesc, jobConf);
            if (counterClass != null) {
                TableMapReduceUtil.addDependencyJars((Configuration)jobConf, (Class[])new Class[]{HBaseStorageHandler.class, TableInputFormatBase.class, counterClass});
            } else {
                TableMapReduceUtil.addDependencyJars((Configuration)jobConf, (Class[])new Class[]{HBaseStorageHandler.class, TableInputFormatBase.class});
            }
            if (HiveConf.getVar((Configuration)jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_HBASE_SNAPSHOT_NAME) != null) {
                TableMapReduceUtil.addDependencyJars((Configuration)jobConf, (Class[])new Class[]{MetricRegistry.class});
            }
            LinkedHashSet merged = new LinkedHashSet(jobConf.getStringCollection("tmpjars"));
            Job copy = new Job((Configuration)jobConf);
            TableMapReduceUtil.addDependencyJars((Job)copy);
            merged.addAll(copy.getConfiguration().getStringCollection("tmpjars"));
            jobConf.set("tmpjars", StringUtils.arrayToString((String[])merged.toArray(new String[0])));
            JobConf hbaseJobConf = new JobConf(this.getConf());
            org.apache.hadoop.hbase.mapred.TableMapReduceUtil.initCredentials((JobConf)hbaseJobConf);
            ShimLoader.getHadoopShims().mergeCredentials(jobConf, hbaseJobConf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public HiveStoragePredicateHandler.DecomposedPredicate decomposePredicate(JobConf jobConf, Deserializer deserializer, ExprNodeDesc predicate) {
        HBaseKeyFactory keyFactory = ((HBaseSerDe)deserializer).getKeyFactory();
        return keyFactory.decomposePredicate(jobConf, deserializer, predicate);
    }

    public static HiveStoragePredicateHandler.DecomposedPredicate decomposePredicate(JobConf jobConf, HBaseSerDe hBaseSerDe, ExprNodeDesc predicate) {
        ColumnMappings.ColumnMapping keyMapping = hBaseSerDe.getHBaseSerdeParam().getKeyColumnMapping();
        ColumnMappings.ColumnMapping tsMapping = hBaseSerDe.getHBaseSerdeParam().getTimestampColumnMapping();
        IndexPredicateAnalyzer analyzer = HiveHBaseTableInputFormat.newIndexPredicateAnalyzer(keyMapping.columnName, keyMapping.isComparable(), tsMapping == null ? null : tsMapping.columnName);
        ArrayList<IndexSearchCondition> conditions = new ArrayList<IndexSearchCondition>();
        ExprNodeGenericFuncDesc pushedPredicate = null;
        ExprNodeGenericFuncDesc residualPredicate = (ExprNodeGenericFuncDesc)analyzer.analyzePredicate(predicate, conditions);
        for (List<IndexSearchCondition> searchConditions : HiveHBaseInputFormatUtil.decompose(conditions).values()) {
            int scSize = searchConditions.size();
            if (scSize < 1 || 2 < scSize) {
                residualPredicate = HBaseStorageHandler.extractResidualCondition(analyzer, searchConditions, residualPredicate);
                continue;
            }
            if (scSize == 2 && (searchConditions.get(0).getComparisonOp().equals(GenericUDFOPEqual.class.getName()) || searchConditions.get(1).getComparisonOp().equals(GenericUDFOPEqual.class.getName()))) {
                residualPredicate = HBaseStorageHandler.extractResidualCondition(analyzer, searchConditions, residualPredicate);
                continue;
            }
            boolean sameType = HBaseStorageHandler.sameTypeIndexSearchConditions(searchConditions);
            if (!sameType) {
                residualPredicate = HBaseStorageHandler.extractResidualCondition(analyzer, searchConditions, residualPredicate);
                continue;
            }
            TypeInfo typeInfo = searchConditions.get(0).getColumnDesc().getTypeInfo();
            if (typeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE && PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory()) == PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP) {
                if (scSize == 2) {
                    boolean lowerBound = false;
                    boolean upperBound = false;
                    if (searchConditions.get(0).getComparisonOp().equals(GenericUDFOPEqualOrLessThan.class.getName()) || searchConditions.get(0).getComparisonOp().equals(GenericUDFOPLessThan.class.getName())) {
                        lowerBound = true;
                    } else {
                        upperBound = true;
                    }
                    if (searchConditions.get(1).getComparisonOp().equals(GenericUDFOPEqualOrGreaterThan.class.getName()) || searchConditions.get(1).getComparisonOp().equals(GenericUDFOPGreaterThan.class.getName())) {
                        upperBound = true;
                    } else {
                        lowerBound = true;
                    }
                    if (!upperBound || !lowerBound) {
                        residualPredicate = HBaseStorageHandler.extractResidualCondition(analyzer, searchConditions, residualPredicate);
                        continue;
                    }
                } else if (!searchConditions.get(0).getComparisonOp().equals(GenericUDFOPEqual.class.getName())) {
                    residualPredicate = HBaseStorageHandler.extractResidualCondition(analyzer, searchConditions, residualPredicate);
                    continue;
                }
            }
            pushedPredicate = HBaseStorageHandler.extractStorageHandlerCondition(analyzer, searchConditions, pushedPredicate);
        }
        HiveStoragePredicateHandler.DecomposedPredicate decomposedPredicate = new HiveStoragePredicateHandler.DecomposedPredicate();
        decomposedPredicate.pushedPredicate = pushedPredicate;
        decomposedPredicate.residualPredicate = residualPredicate;
        return decomposedPredicate;
    }

    private static ExprNodeGenericFuncDesc extractStorageHandlerCondition(IndexPredicateAnalyzer analyzer, List<IndexSearchCondition> searchConditions, ExprNodeGenericFuncDesc inputExpr) {
        if (inputExpr == null) {
            return analyzer.translateSearchConditions(searchConditions);
        }
        ArrayList<ExprNodeGenericFuncDesc> children = new ArrayList<ExprNodeGenericFuncDesc>();
        children.add(analyzer.translateSearchConditions(searchConditions));
        children.add(inputExpr);
        return new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getGenericUDFForAnd(), children);
    }

    private static ExprNodeGenericFuncDesc extractResidualCondition(IndexPredicateAnalyzer analyzer, List<IndexSearchCondition> searchConditions, ExprNodeGenericFuncDesc inputExpr) {
        if (inputExpr == null) {
            return analyzer.translateOriginalConditions(searchConditions);
        }
        ArrayList<ExprNodeGenericFuncDesc> children = new ArrayList<ExprNodeGenericFuncDesc>();
        children.add(analyzer.translateOriginalConditions(searchConditions));
        children.add(inputExpr);
        return new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getGenericUDFForAnd(), children);
    }

    private static boolean sameTypeIndexSearchConditions(List<IndexSearchCondition> searchConditions) {
        for (IndexSearchCondition isc : searchConditions) {
            if (isc.getColumnDesc().getTypeInfo().equals((Object)isc.getConstantDesc().getTypeInfo())) continue;
            return false;
        }
        return true;
    }

    static {
        try {
            counterClass = Class.forName("org.cliffc.high_scale_lib.Counter");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

