/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hive.jdbc.JdbcUriParseException;
import org.apache.hive.jdbc.ZooKeeperHiveClientException;
import org.apache.hive.jdbc.ZooKeeperHiveClientHelper;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.rpc.thrift.TStatus;
import org.apache.hive.service.rpc.thrift.TStatusCode;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    static final Logger LOG = LoggerFactory.getLogger((String)Utils.class.getName());
    public static final String URL_PREFIX = "jdbc:hive2://";
    static final String DEFAULT_PORT = "10000";
    static final String dummyAuthorityString = "dummyhost:00000";
    static final String DEFAULT_DATABASE = "default";
    private static final String URI_JDBC_PREFIX = "jdbc:";
    private static final String URI_HIVE_PREFIX = "hive2:";
    static final String HIVE_SERVER2_RETRY_KEY = "hive.server2.retryserver";
    static final String HIVE_SERVER2_RETRY_TRUE = "true";
    static final String HIVE_SERVER2_RETRY_FALSE = "false";

    static void verifySuccessWithInfo(TStatus status) throws SQLException {
        Utils.verifySuccess(status, true);
    }

    static void verifySuccess(TStatus status) throws SQLException {
        Utils.verifySuccess(status, false);
    }

    static void verifySuccess(TStatus status, boolean withInfo) throws SQLException {
        if (status.getStatusCode() == TStatusCode.SUCCESS_STATUS || withInfo && status.getStatusCode() == TStatusCode.SUCCESS_WITH_INFO_STATUS) {
            return;
        }
        throw new HiveSQLException(status);
    }

    public static JdbcConnectionParams parseURL(String uri) throws JdbcUriParseException, SQLException, ZooKeeperHiveClientException {
        return Utils.parseURL(uri, new Properties());
    }

    public static JdbcConnectionParams parseURL(String uri, Properties info) throws JdbcUriParseException, SQLException, ZooKeeperHiveClientException {
        JdbcConnectionParams connParams = Utils.extractURLComponents(uri, info);
        if (ZooKeeperHiveClientHelper.isZkDynamicDiscoveryMode(connParams.getSessionVars())) {
            Utils.configureConnParamsFromZooKeeper(connParams);
        }
        Utils.handleAllDeprecations(connParams);
        return connParams;
    }

    public static JdbcConnectionParams extractURLComponents(String uri, Properties info) throws JdbcUriParseException {
        String varStr;
        String confStr;
        JdbcConnectionParams connParams = new JdbcConnectionParams();
        if (!uri.startsWith(URL_PREFIX)) {
            throw new JdbcUriParseException("Bad URL format: Missing prefix jdbc:hive2://");
        }
        if (uri.equalsIgnoreCase(URL_PREFIX)) {
            connParams.setEmbeddedMode(true);
            return connParams;
        }
        String authorityFromClientJdbcURL = Utils.getAuthorityFromJdbcURL(uri);
        if (authorityFromClientJdbcURL == null || authorityFromClientJdbcURL.isEmpty()) {
            connParams.setEmbeddedMode(true);
        } else {
            connParams.setSuppliedURLAuthority(authorityFromClientJdbcURL);
            uri = uri.replace(authorityFromClientJdbcURL, dummyAuthorityString);
        }
        URI jdbcURI = URI.create(uri.substring(URI_JDBC_PREFIX.length()));
        Pattern pattern = Pattern.compile("([^;]*)=([^;]*)[;]?");
        String sessVars = jdbcURI.getPath();
        if (sessVars != null && !sessVars.isEmpty()) {
            String dbName = "";
            if (!(sessVars = sessVars.substring(1)).contains(";")) {
                dbName = sessVars;
            } else {
                dbName = sessVars.substring(0, sessVars.indexOf(59));
                if ((sessVars = sessVars.substring(sessVars.indexOf(59) + 1)) != null) {
                    Matcher sessMatcher = pattern.matcher(sessVars);
                    while (sessMatcher.find()) {
                        if (connParams.getSessionVars().put(sessMatcher.group(1), sessMatcher.group(2)) == null) continue;
                        throw new JdbcUriParseException("Bad URL format: Multiple values for property " + sessMatcher.group(1));
                    }
                }
            }
            if (!dbName.isEmpty()) {
                connParams.setDbName(dbName);
            }
        }
        if ((confStr = jdbcURI.getQuery()) != null) {
            Matcher confMatcher = pattern.matcher(confStr);
            while (confMatcher.find()) {
                connParams.getHiveConfs().put(confMatcher.group(1), confMatcher.group(2));
            }
        }
        if ((varStr = jdbcURI.getFragment()) != null) {
            Matcher varMatcher = pattern.matcher(varStr);
            while (varMatcher.find()) {
                connParams.getHiveVars().put(varMatcher.group(1), varMatcher.group(2));
            }
        }
        for (Map.Entry entry : info.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            String key = (String)entry.getKey();
            if (key.startsWith("hivevar:")) {
                connParams.getHiveVars().put(key.substring("hivevar:".length()), info.getProperty(key));
                continue;
            }
            if (!key.startsWith("hiveconf:")) continue;
            connParams.getHiveConfs().put(key.substring("hiveconf:".length()), info.getProperty(key));
        }
        if (!connParams.getSessionVars().containsKey("user")) {
            if (info.containsKey("user")) {
                connParams.getSessionVars().put("user", info.getProperty("user"));
            }
            if (info.containsKey("password")) {
                connParams.getSessionVars().put("password", info.getProperty("password"));
            }
        }
        if (!connParams.getSessionVars().containsKey("password")) {
            if (info.containsKey("user")) {
                connParams.getSessionVars().put("user", info.getProperty("user"));
            }
            if (info.containsKey("password")) {
                connParams.getSessionVars().put("password", info.getProperty("password"));
            }
        }
        if (info.containsKey("auth")) {
            connParams.getSessionVars().put("auth", info.getProperty("auth"));
        }
        if (connParams.isEmbeddedMode()) {
            connParams.setHost(jdbcURI.getHost());
            connParams.setPort(jdbcURI.getPort());
        } else {
            String authorityStr = connParams.getSuppliedURLAuthority();
            if (ZooKeeperHiveClientHelper.isZkDynamicDiscoveryMode(connParams.getSessionVars())) {
                uri = uri.replace(dummyAuthorityString, authorityStr);
                connParams.setZooKeeperEnsemble(authorityStr);
                ZooKeeperHiveClientHelper.setZkSSLParams(connParams);
            } else {
                URI uRI = URI.create("hive2://" + authorityStr);
                if (uRI.getAuthority() != null) {
                    String host = uRI.getHost();
                    int port = uRI.getPort();
                    if (host == null) {
                        throw new JdbcUriParseException("Bad URL format. Hostname not found  in authority part of the url: " + uRI.getAuthority() + ". Are you missing a '/' after the hostname ?");
                    }
                    if (port <= 0) {
                        port = Integer.parseInt(DEFAULT_PORT);
                    }
                    connParams.setHost(uRI.getHost());
                    connParams.setPort(uRI.getPort());
                }
                authorityStr = connParams.getHost() + ":" + connParams.getPort();
                LOG.debug("Resolved authority: " + authorityStr);
                uri = uri.replace(dummyAuthorityString, authorityStr);
            }
        }
        connParams.setJdbcUriString(uri);
        return connParams;
    }

    static void configureConnParamsFromZooKeeper(JdbcConnectionParams connParams) throws ZooKeeperHiveClientException, JdbcUriParseException {
        ZooKeeperHiveClientHelper.configureConnParams(connParams);
        String authorityStr = connParams.getHost() + ":" + connParams.getPort();
        LOG.debug("Resolved authority: " + authorityStr);
        String jdbcUriString = connParams.getJdbcUriString();
        connParams.setJdbcUriString(jdbcUriString.replace(Utils.getAuthorityFromJdbcURL(jdbcUriString), authorityStr));
    }

    private static void handleAllDeprecations(JdbcConnectionParams connParams) {
        String usageUrlBase = "jdbc:hive2://<host>:<port>/dbName;";
        String newUsage = usageUrlBase + "saslQop" + "=<qop_value>";
        Utils.handleParamDeprecation(connParams.getSessionVars(), connParams.getSessionVars(), "sasl.qop", "saslQop", newUsage);
        newUsage = usageUrlBase + "transportMode" + "=<transport_mode_value>";
        Utils.handleParamDeprecation(connParams.getHiveConfs(), connParams.getSessionVars(), "hive.server2.transport.mode", "transportMode", newUsage);
        newUsage = usageUrlBase + "httpPath" + "=<http_path_value>";
        Utils.handleParamDeprecation(connParams.getHiveConfs(), connParams.getSessionVars(), "hive.server2.thrift.http.path", "httpPath", newUsage);
    }

    private static void handleParamDeprecation(Map<String, String> fromMap, Map<String, String> toMap, String deprecatedName, String newName, String newUsage) {
        if (fromMap.containsKey(deprecatedName)) {
            LOG.warn("***** JDBC param deprecation *****");
            LOG.warn("The use of " + deprecatedName + " is deprecated.");
            LOG.warn("Please use " + newName + " like so: " + newUsage);
            String paramValue = fromMap.remove(deprecatedName);
            toMap.put(newName, paramValue);
        }
    }

    private static String getAuthorityFromJdbcURL(String uri) throws JdbcUriParseException {
        String toIndexChar;
        int fromIndex = URL_PREFIX.length();
        int toIndex = -1;
        ArrayList<String> toIndexChars = new ArrayList<String>(Arrays.asList("/", "?", "#"));
        Iterator<String> iterator = toIndexChars.iterator();
        while (iterator.hasNext() && (toIndex = uri.indexOf(toIndexChar = iterator.next(), fromIndex)) <= 0) {
        }
        String authorities = toIndex < 0 ? uri.substring(fromIndex) : uri.substring(fromIndex, toIndex);
        return authorities;
    }

    static boolean updateConnParamsFromZooKeeper(JdbcConnectionParams connParams) {
        connParams.getRejectedHostZnodePaths().add(connParams.getCurrentHostZnodePath());
        String oldServerHost = connParams.getHost();
        int oldServerPort = connParams.getPort();
        try {
            ZooKeeperHiveClientHelper.configureConnParams(connParams);
            connParams.setJdbcUriString(connParams.getJdbcUriString().replace(oldServerHost + ":" + oldServerPort, connParams.getHost() + ":" + connParams.getPort()));
            LOG.info("Selected HiveServer2 instance with uri: " + connParams.getJdbcUriString());
        }
        catch (ZooKeeperHiveClientException e) {
            LOG.error(e.getMessage());
            return false;
        }
        return true;
    }

    static int getVersionPart(String fullVersion, int position) {
        int version = -1;
        try {
            String[] tokens = fullVersion.split("[\\.-]");
            if (tokens != null && tokens.length > 1 && tokens[position] != null) {
                version = Integer.parseInt(tokens[position]);
            }
        }
        catch (Exception e) {
            version = -1;
        }
        return version;
    }

    static boolean needToSendCredentials(CookieStore cookieStore, String cookieName, boolean isSSL) {
        if (cookieName == null || cookieStore == null) {
            return true;
        }
        List cookies = cookieStore.getCookies();
        for (Cookie c : cookies) {
            if (c.isSecure() && !isSSL || !c.getName().equals(cookieName)) continue;
            return false;
        }
        return true;
    }

    public static String parsePropertyFromUrl(String url, String key) {
        String[] tokens;
        for (String token : tokens = url.split(";")) {
            if (!token.trim().startsWith(key.trim() + "=")) continue;
            return token.trim().substring((key.trim() + "=").length());
        }
        return null;
    }

    public static String getCanonicalHostName(String hostName) {
        try {
            return InetAddress.getByName(hostName).getCanonicalHostName();
        }
        catch (UnknownHostException exception) {
            LOG.warn("Could not retrieve canonical hostname for " + hostName, (Throwable)exception);
            return hostName;
        }
    }

    public static class JdbcConnectionParams {
        static final String RETRIES = "retries";
        public static final String RETRY_INTERVAL = "retryInterval";
        public static final String AUTH_TYPE = "auth";
        public static final String AUTH_QOP_DEPRECATED = "sasl.qop";
        public static final String AUTH_QOP = "saslQop";
        public static final String AUTH_SIMPLE = "noSasl";
        public static final String AUTH_TOKEN = "delegationToken";
        public static final String AUTH_USER = "user";
        public static final String AUTH_PRINCIPAL = "principal";
        public static final String AUTH_PASSWD = "password";
        public static final String AUTH_KERBEROS_AUTH_TYPE = "kerberosAuthType";
        public static final String AUTH_KERBEROS_AUTH_TYPE_FROM_SUBJECT = "fromSubject";
        public static final String AUTH_SSO_BROWSER_MODE = "browser";
        public static final String AUTH_SSO_TOKEN_MODE = "token";
        public static final String AUTH_BROWSER_RESPONSE_PORT = "browserResponsePort";
        public static final String AUTH_BROWSER_RESPONSE_TIMEOUT_SECS = "browserResponseTimeout";
        public static final String AUTH_BROWSER_DISABLE_SSL_VALIDATION = "browserDisableSslCheck";
        public static final String ANONYMOUS_USER = "anonymous";
        public static final String ANONYMOUS_PASSWD = "anonymous";
        public static final String USE_SSL = "ssl";
        public static final String SSL_TRUST_STORE = "sslTrustStore";
        public static final String SSL_TRUST_STORE_PASSWORD = "trustStorePassword";
        static final String TRANSPORT_MODE_DEPRECATED = "hive.server2.transport.mode";
        public static final String TRANSPORT_MODE = "transportMode";
        static final String HTTP_PATH_DEPRECATED = "hive.server2.thrift.http.path";
        public static final String HTTP_PATH = "httpPath";
        public static final String SERVICE_DISCOVERY_MODE = "serviceDiscoveryMode";
        public static final String PROPERTY_DRIVER = "driver";
        public static final String PROPERTY_URL = "url";
        static final String SERVICE_DISCOVERY_MODE_NONE = "none";
        public static final String SERVICE_DISCOVERY_MODE_ZOOKEEPER = "zooKeeper";
        public static final String SERVICE_DISCOVERY_MODE_ZOOKEEPER_HA = "zooKeeperHA";
        public static final String ZOOKEEPER_NAMESPACE = "zooKeeperNamespace";
        public static final String ZOOKEEPER_SSL_ENABLE = "zooKeeperSSLEnable";
        public static final String ZOOKEEPER_KEYSTORE_LOCATION = "zooKeeperKeystoreLocation";
        public static final String ZOOKEEPER_KEYSTORE_PASSWORD = "zooKeeperKeystorePassword";
        public static final String ZOOKEEPER_TRUSTSTORE_LOCATION = "zooKeeperTruststoreLocation";
        public static final String ZOOKEEPER_TRUSTSTORE_PASSWORD = "zooKeeperTruststorePassword";
        static final String ZOOKEEPER_DEFAULT_NAMESPACE = "hiveserver2";
        static final String ZOOKEEPER_ACTIVE_PASSIVE_HA_DEFAULT_NAMESPACE = "hs2ActivePassiveHA";
        static final String COOKIE_AUTH = "cookieAuth";
        static final String COOKIE_AUTH_FALSE = "false";
        static final String COOKIE_NAME = "cookieName";
        static final String DEFAULT_COOKIE_NAMES_HS2 = "hive.server2.auth";
        static final String HTTP_HEADER_PREFIX = "http.header.";
        static final String FETCH_SIZE = "fetchSize";
        static final String INIT_FILE = "initFile";
        static final String WM_POOL = "wmPool";
        static final String HTTP_COOKIE_PREFIX = "http.cookie.";
        static final String CREATE_TABLE_AS_EXTERNAL = "hiveCreateAsExternalLegacy";
        public static final String SOCKET_TIMEOUT = "socketTimeout";
        static final String[] APPLICATION = new String[]{"applicationName", "ApplicationName"};
        static final String USE_TWO_WAY_SSL = "twoWay";
        static final String TRUE = "true";
        static final String SSL_KEY_STORE = "sslKeyStore";
        static final String SSL_KEY_STORE_PASSWORD = "keyStorePassword";
        static final String SSL_KEY_STORE_TYPE = "JKS";
        static final String SUNX509_ALGORITHM_STRING = "SunX509";
        static final String SUNJSSE_ALGORITHM_STRING = "SunJSSE";
        static final String SSL_TRUST_STORE_TYPE = "JKS";
        private static final String HIVE_VAR_PREFIX = "hivevar:";
        private static final String HIVE_CONF_PREFIX = "hiveconf:";
        private String host = null;
        private int port = 0;
        private String jdbcUriString;
        private String dbName = "default";
        private Map<String, String> hiveConfs = new LinkedHashMap<String, String>();
        private Map<String, String> hiveVars = new LinkedHashMap<String, String>();
        private Map<String, String> sessionVars = new LinkedHashMap<String, String>();
        private boolean isEmbeddedMode = false;
        private String suppliedURLAuthority;
        private String zooKeeperEnsemble = null;
        private boolean zooKeeperSslEnabled = false;
        private String zookeeperKeyStoreLocation = "";
        private String zookeeperKeyStorePassword = "";
        private String zookeeperTrustStoreLocation = "";
        private String zookeeperTrustStorePassword = "";
        private String currentHostZnodePath;
        private final List<String> rejectedHostZnodePaths = new ArrayList<String>();

        public JdbcConnectionParams() {
        }

        public JdbcConnectionParams(JdbcConnectionParams params) {
            this.host = params.host;
            this.port = params.port;
            this.jdbcUriString = params.jdbcUriString;
            this.dbName = params.dbName;
            this.hiveConfs.putAll(params.hiveConfs);
            this.hiveVars.putAll(params.hiveVars);
            this.sessionVars.putAll(params.sessionVars);
            this.isEmbeddedMode = params.isEmbeddedMode;
            this.suppliedURLAuthority = params.suppliedURLAuthority;
            this.zooKeeperEnsemble = params.zooKeeperEnsemble;
            this.zooKeeperSslEnabled = params.zooKeeperSslEnabled;
            this.zookeeperKeyStoreLocation = params.zookeeperKeyStoreLocation;
            this.zookeeperKeyStorePassword = params.zookeeperKeyStorePassword;
            this.zookeeperTrustStoreLocation = params.zookeeperTrustStoreLocation;
            this.zookeeperTrustStorePassword = params.zookeeperTrustStorePassword;
            this.currentHostZnodePath = params.currentHostZnodePath;
            this.rejectedHostZnodePaths.addAll(this.rejectedHostZnodePaths);
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getJdbcUriString() {
            return this.jdbcUriString;
        }

        public String getDbName() {
            return this.dbName;
        }

        public Map<String, String> getHiveConfs() {
            return this.hiveConfs;
        }

        public Map<String, String> getHiveVars() {
            return this.hiveVars;
        }

        public boolean isEmbeddedMode() {
            return this.isEmbeddedMode;
        }

        public Map<String, String> getSessionVars() {
            return this.sessionVars;
        }

        public String getSuppliedURLAuthority() {
            return this.suppliedURLAuthority;
        }

        public String getZooKeeperEnsemble() {
            return this.zooKeeperEnsemble;
        }

        public boolean isZooKeeperSslEnabled() {
            return this.zooKeeperSslEnabled;
        }

        public String getZookeeperKeyStoreLocation() {
            return this.zookeeperKeyStoreLocation;
        }

        public String getZookeeperKeyStorePassword() {
            return this.zookeeperKeyStorePassword;
        }

        public String getZookeeperTrustStoreLocation() {
            return this.zookeeperTrustStoreLocation;
        }

        public String getZookeeperTrustStorePassword() {
            return this.zookeeperTrustStorePassword;
        }

        public List<String> getRejectedHostZnodePaths() {
            return this.rejectedHostZnodePaths;
        }

        public String getCurrentHostZnodePath() {
            return this.currentHostZnodePath;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public void setJdbcUriString(String jdbcUriString) {
            this.jdbcUriString = jdbcUriString;
        }

        public void setDbName(String dbName) {
            this.dbName = dbName;
        }

        public void setHiveConfs(Map<String, String> hiveConfs) {
            this.hiveConfs = hiveConfs;
        }

        public void setHiveVars(Map<String, String> hiveVars) {
            this.hiveVars = hiveVars;
        }

        public void setEmbeddedMode(boolean embeddedMode) {
            this.isEmbeddedMode = embeddedMode;
        }

        public void setSessionVars(Map<String, String> sessionVars) {
            this.sessionVars = sessionVars;
        }

        public void setSuppliedURLAuthority(String suppliedURLAuthority) {
            this.suppliedURLAuthority = suppliedURLAuthority;
        }

        public void setZooKeeperEnsemble(String zooKeeperEnsemble) {
            this.zooKeeperEnsemble = zooKeeperEnsemble;
        }

        public void setZooKeeperSslEnabled(boolean zooKeeperSslEnabled) {
            this.zooKeeperSslEnabled = zooKeeperSslEnabled;
        }

        public void setZookeeperKeyStoreLocation(String zookeeperKeyStoreLocation) {
            this.zookeeperKeyStoreLocation = zookeeperKeyStoreLocation;
        }

        public void setZookeeperKeyStorePassword(String zookeeperKeyStorePassword) {
            this.zookeeperKeyStorePassword = zookeeperKeyStorePassword;
        }

        public void setZookeeperTrustStoreLocation(String zookeeperTrustStoreLocation) {
            this.zookeeperTrustStoreLocation = zookeeperTrustStoreLocation;
        }

        public void setZookeeperTrustStorePassword(String zookeeperTrustStorePassword) {
            this.zookeeperTrustStorePassword = zookeeperTrustStorePassword;
        }

        public void setCurrentHostZnodePath(String currentHostZnodePath) {
            this.currentHostZnodePath = currentHostZnodePath;
        }
    }
}

