/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc.saml;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.hive.jdbc.HttpRequestInterceptorBase;
import org.apache.hive.jdbc.saml.IJdbcBrowserClient;
import org.apache.http.HttpRequest;
import org.apache.http.client.CookieStore;
import org.apache.http.protocol.HttpContext;

public class HttpSamlAuthRequestInterceptor
extends HttpRequestInterceptorBase {
    private final IJdbcBrowserClient browserClient;
    private static final String BEARER = "Bearer ";

    public HttpSamlAuthRequestInterceptor(IJdbcBrowserClient browserClient, CookieStore cookieStore, String cn, boolean isSSL, Map<String, String> additionalHeaders, Map<String, String> customCookies) {
        super(cookieStore, cn, isSSL, additionalHeaders, customCookies);
        this.browserClient = (IJdbcBrowserClient)Preconditions.checkNotNull((Object)browserClient);
    }

    @Override
    protected void addHttpAuthHeader(HttpRequest httpRequest, HttpContext httpContext) throws Exception {
        String port = String.valueOf(this.browserClient.getPort());
        String token = this.browserClient.getServerResponse() == null ? null : this.browserClient.getServerResponse().getToken();
        String clientIdentifier = this.browserClient.getClientIdentifier();
        if (token != null && !token.isEmpty()) {
            httpRequest.addHeader("Authorization", BEARER + token);
            httpRequest.addHeader("X-Hive-Client-Identifier", clientIdentifier);
            httpRequest.removeHeaders("X-Hive-Token-Response-Port");
        } else {
            httpRequest.addHeader("X-Hive-Token-Response-Port", port);
        }
    }
}

