/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc.saml;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import java.io.Closeable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public interface IJdbcBrowserClient
extends Closeable {
    public void doBrowserSSO() throws HiveJdbcBrowserException;

    public void init(JdbcBrowserClientContext var1);

    public Integer getPort();

    public HiveJdbcBrowserServerResponse getServerResponse();

    public String getClientIdentifier();

    @Immutable
    public static class HiveJdbcBrowserServerResponse {
        private final String msg;
        private final boolean status;
        private final String token;

        public HiveJdbcBrowserServerResponse(String postResponse) {
            Map<String, String> params = this.parseUrlEncodedFormData(postResponse);
            this.status = Boolean.parseBoolean(params.get("status"));
            this.msg = params.getOrDefault("message", "");
            this.token = params.get("token");
        }

        private Map<String, String> parseUrlEncodedFormData(String line) {
            String decoded;
            try {
                decoded = URLDecoder.decode(line, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            HashMap<String, String> ret = new HashMap<String, String>();
            for (String params : decoded.split("&")) {
                if (!params.contains("=")) continue;
                String key = params.substring(0, params.indexOf("="));
                String val = params.substring(params.indexOf("=") + 1);
                ret.put(key, val);
            }
            return ret;
        }

        public String getMsg() {
            return this.msg;
        }

        public boolean isSuccessful() {
            return this.status;
        }

        public String getToken() {
            return this.token;
        }
    }

    public static class HiveJdbcBrowserException
    extends Exception {
        HiveJdbcBrowserException(String msg, Throwable ex) {
            super(msg, ex);
        }

        HiveJdbcBrowserException(String msg) {
            super(msg);
        }

        HiveJdbcBrowserException(Throwable e) {
            super(e);
        }
    }

    public static class JdbcBrowserClientContext {
        private final URI ssoUri;
        private final String clientIdentifier;

        JdbcBrowserClientContext(URI ssoUrl, String clientIdentifier) {
            this.ssoUri = (URI)Preconditions.checkNotNull((Object)ssoUrl);
            this.clientIdentifier = (String)Preconditions.checkNotNull((Object)clientIdentifier);
        }

        public URI getSsoUri() {
            return this.ssoUri;
        }

        public String getClientIdentifier() {
            return this.clientIdentifier;
        }
    }
}

