/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hive.llap.Schema;
import org.apache.hadoop.mapred.InputSplitWithLocationInfo;
import org.apache.hadoop.mapred.SplitLocationInfo;

public class LlapInputSplit
implements InputSplitWithLocationInfo {
    private int splitNum;
    private byte[] planBytes;
    private byte[] fragmentBytes;
    private SplitLocationInfo[] locations;
    private Schema schema;
    private String llapUser;
    private byte[] fragmentBytesSignature;
    private byte[] tokenBytes;

    public LlapInputSplit() {
    }

    public LlapInputSplit(int splitNum, byte[] planBytes, byte[] fragmentBytes, byte[] fragmentBytesSignature, SplitLocationInfo[] locations, Schema schema, String llapUser, byte[] tokenBytes) {
        this.planBytes = planBytes;
        this.fragmentBytes = fragmentBytes;
        this.fragmentBytesSignature = fragmentBytesSignature;
        this.locations = locations;
        this.schema = schema;
        this.splitNum = splitNum;
        this.llapUser = llapUser;
        this.tokenBytes = tokenBytes;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public long getLength() throws IOException {
        return 0L;
    }

    public String[] getLocations() throws IOException {
        String[] locs = new String[this.locations.length];
        for (int i = 0; i < this.locations.length; ++i) {
            locs[i] = this.locations[i].getLocation();
        }
        return locs;
    }

    public int getSplitNum() {
        return this.splitNum;
    }

    public byte[] getPlanBytes() {
        return this.planBytes;
    }

    public byte[] getFragmentBytes() {
        return this.fragmentBytes;
    }

    public byte[] getFragmentBytesSignature() {
        return this.fragmentBytesSignature;
    }

    public byte[] getTokenBytes() {
        return this.tokenBytes;
    }

    public void setPlanBytes(byte[] planBytes) {
        this.planBytes = planBytes;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.splitNum);
        out.writeInt(this.planBytes.length);
        out.write(this.planBytes);
        out.writeInt(this.fragmentBytes.length);
        out.write(this.fragmentBytes);
        if (this.fragmentBytesSignature != null) {
            out.writeInt(this.fragmentBytesSignature.length);
            out.write(this.fragmentBytesSignature);
        } else {
            out.writeInt(0);
        }
        out.writeInt(this.locations.length);
        for (int i = 0; i < this.locations.length; ++i) {
            out.writeUTF(this.locations[i].getLocation());
        }
        this.schema.write(out);
        out.writeUTF(this.llapUser);
        if (this.tokenBytes != null) {
            out.writeInt(this.tokenBytes.length);
            out.write(this.tokenBytes);
        } else {
            out.writeInt(0);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.splitNum = in.readInt();
        int length = in.readInt();
        this.planBytes = new byte[length];
        in.readFully(this.planBytes);
        length = in.readInt();
        this.fragmentBytes = new byte[length];
        in.readFully(this.fragmentBytes);
        length = in.readInt();
        if (length > 0) {
            this.fragmentBytesSignature = new byte[length];
            in.readFully(this.fragmentBytesSignature);
        }
        length = in.readInt();
        this.locations = new SplitLocationInfo[length];
        for (int i = 0; i < length; ++i) {
            this.locations[i] = new SplitLocationInfo(in.readUTF(), false);
        }
        this.schema = new Schema();
        this.schema.readFields(in);
        this.llapUser = in.readUTF();
        length = in.readInt();
        if (length > 0) {
            this.tokenBytes = new byte[length];
            in.readFully(this.tokenBytes);
        }
    }

    public SplitLocationInfo[] getLocationInfo() throws IOException {
        return this.locations;
    }

    public String getLlapUser() {
        return this.llapUser;
    }
}

