/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.registry.impl;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.registry.LlapServiceInstance;
import org.apache.hadoop.hive.llap.registry.LlapServiceInstanceSet;
import org.apache.hadoop.hive.llap.registry.ServiceRegistry;
import org.apache.hadoop.hive.llap.registry.impl.LlapFixedRegistryImpl;
import org.apache.hadoop.hive.llap.registry.impl.LlapZookeeperRegistryImpl;
import org.apache.hadoop.hive.registry.ServiceInstanceStateChangeListener;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapRegistryService
extends AbstractService {
    public static final String LLAP_DAEMON_TASK_SCHEDULER_ENABLED_WAIT_QUEUE_SIZE = "hive.llap.daemon.task.scheduler.enabled.wait.queue.size";
    public static final String LLAP_DAEMON_NUM_ENABLED_EXECUTORS = "hive.llap.daemon.num.enabled.executors";
    private static final Logger LOG = LoggerFactory.getLogger(LlapRegistryService.class);
    private ServiceRegistry<LlapServiceInstance> registry = null;
    private final boolean isDaemon;
    private boolean isDynamic = false;
    private String identity = "(pending)";
    private static final Map<String, LlapRegistryService> yarnRegistries = new HashMap<String, LlapRegistryService>();

    public LlapRegistryService(boolean isDaemon) {
        super("LlapRegistryService");
        this.isDaemon = isDaemon;
    }

    public static synchronized LlapRegistryService getClient(Configuration conf) {
        LlapRegistryService registry;
        String hosts = HiveConf.getTrimmedVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS);
        Preconditions.checkNotNull((Object)hosts, (Object)(HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS.toString() + " must be defined"));
        if (hosts.startsWith("@")) {
            String appName = hosts.substring(1);
            String userName = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ZK_REGISTRY_USER, (String)LlapRegistryService.currentUser());
            String key = appName + "-" + userName;
            registry = yarnRegistries.get(key);
            if (registry == null || !registry.isInState(Service.STATE.STARTED)) {
                registry = new LlapRegistryService(false);
                registry.init(conf);
                registry.start();
                yarnRegistries.put(key, registry);
            }
        } else {
            registry = new LlapRegistryService(false);
            registry.init(conf);
            registry.start();
        }
        LOG.info("Using LLAP registry (client) type: " + (Object)((Object)registry));
        return registry;
    }

    public static String currentUser() {
        try {
            return UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void serviceInit(Configuration conf) {
        String hosts = HiveConf.getTrimmedVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS);
        if (hosts.startsWith("@")) {
            String instanceName = hosts.substring(1);
            boolean computeGroupEnabled = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS_ENABLE_COMPUTE_GROUPS);
            if (computeGroupEnabled) {
                String computeName = System.getenv("COMPUTE_GROUP_NAME");
                if (computeName == null || computeName.isEmpty()) {
                    computeName = "default-compute";
                }
                this.registry = new LlapZookeeperRegistryImpl(instanceName, computeName, conf);
            } else {
                this.registry = new LlapZookeeperRegistryImpl(instanceName, conf);
            }
            this.isDynamic = true;
        } else {
            this.registry = new LlapFixedRegistryImpl(hosts, conf);
            this.isDynamic = false;
        }
        LOG.info("Using LLAP registry type " + this.registry);
    }

    public void serviceStart() throws Exception {
        if (this.registry != null) {
            this.registry.start();
        }
        if (this.isDaemon) {
            this.registerWorker();
        }
    }

    public void serviceStop() throws Exception {
        if (this.isDaemon) {
            this.unregisterWorker();
        }
        if (this.registry != null) {
            this.registry.stop();
        } else {
            LOG.warn("Stopping non-existent registry service");
        }
    }

    private void registerWorker() throws IOException {
        if (this.registry != null) {
            this.identity = this.registry.register();
        }
    }

    private void unregisterWorker() throws IOException {
        if (this.registry != null) {
            this.registry.unregister();
        }
    }

    public void updateRegistration(Iterable<Map.Entry<String, String>> attributes) throws IOException {
        if (this.isDaemon && this.registry != null) {
            this.registry.updateRegistration(attributes);
        }
    }

    public LlapZookeeperRegistryImpl.ConfigChangeLockResult lockForConfigChange(long windowStart, long windowEnd) {
        if (this.registry == null) {
            throw new IllegalStateException("Not allowed to call lockForConfigChange before serviceInit");
        }
        if (this.isDynamic) {
            LlapZookeeperRegistryImpl zkRegisty = (LlapZookeeperRegistryImpl)this.registry;
            return zkRegisty.lockForConfigChange(windowStart, windowEnd);
        }
        throw new UnsupportedOperationException("Acquiring config lock is only allowed for dynamic registries");
    }

    public LlapServiceInstanceSet getInstances() throws IOException {
        return this.getInstances(0L);
    }

    public LlapServiceInstanceSet getInstances(long clusterReadyTimeoutMs) throws IOException {
        return (LlapServiceInstanceSet)this.registry.getInstances("LLAP", clusterReadyTimeoutMs);
    }

    public void registerStateChangeListener(ServiceInstanceStateChangeListener<LlapServiceInstance> listener) throws IOException {
        this.registry.registerStateChangeListener(listener);
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public String getWorkerIdentity() {
        return this.identity;
    }

    public ApplicationId getApplicationId() throws IOException {
        return this.registry.getApplicationId();
    }
}

