/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.tez;

import com.google.protobuf.Message;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.AsyncPbRpcProxy;
import org.apache.hadoop.hive.llap.LlapNodeId;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.impl.LlapProtocolClientImpl;
import org.apache.hadoop.hive.llap.protocol.LlapProtocolBlockingPB;
import org.apache.hadoop.hive.llap.security.LlapTokenIdentifier;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

public class LlapProtocolClientProxy
extends AsyncPbRpcProxy<LlapProtocolBlockingPB, LlapTokenIdentifier> {
    public LlapProtocolClientProxy(int numThreads, Configuration conf, Token<LlapTokenIdentifier> llapToken) {
        super(LlapProtocolClientProxy.class.getSimpleName(), numThreads, conf, llapToken, HiveConf.getTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_TASK_COMMUNICATOR_CONNECTION_TIMEOUT_MS, (TimeUnit)TimeUnit.MILLISECONDS), HiveConf.getTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_TASK_COMMUNICATOR_CONNECTION_SLEEP_BETWEEN_RETRIES_MS, (TimeUnit)TimeUnit.MILLISECONDS), -1, 1);
    }

    public void registerDag(LlapDaemonProtocolProtos.RegisterDagRequestProto request, String host, int port, AsyncPbRpcProxy.ExecuteRequestCallback<LlapDaemonProtocolProtos.RegisterDagResponseProto> callback) {
        LlapNodeId nodeId = LlapNodeId.getInstance((String)host, (int)port);
        this.queueRequest((AsyncPbRpcProxy.CallableRequest)new RegisterDagCallable(nodeId, request, callback));
    }

    public void sendSubmitWork(LlapDaemonProtocolProtos.SubmitWorkRequestProto request, String host, int port, AsyncPbRpcProxy.ExecuteRequestCallback<LlapDaemonProtocolProtos.SubmitWorkResponseProto> callback) {
        LlapNodeId nodeId = LlapNodeId.getInstance((String)host, (int)port);
        this.queueRequest((AsyncPbRpcProxy.CallableRequest)new SubmitWorkCallable(nodeId, request, callback));
    }

    public void sendSourceStateUpdate(LlapDaemonProtocolProtos.SourceStateUpdatedRequestProto request, LlapNodeId nodeId, AsyncPbRpcProxy.ExecuteRequestCallback<LlapDaemonProtocolProtos.SourceStateUpdatedResponseProto> callback) {
        this.queueRequest((AsyncPbRpcProxy.CallableRequest)new SendSourceStateUpdateCallable(nodeId, request, callback));
    }

    public void sendQueryComplete(LlapDaemonProtocolProtos.QueryCompleteRequestProto request, String host, int port, AsyncPbRpcProxy.ExecuteRequestCallback<LlapDaemonProtocolProtos.QueryCompleteResponseProto> callback) {
        LlapNodeId nodeId = LlapNodeId.getInstance((String)host, (int)port);
        this.queueRequest((AsyncPbRpcProxy.CallableRequest)new SendQueryCompleteCallable(nodeId, request, callback));
    }

    public void sendTerminateFragment(LlapDaemonProtocolProtos.TerminateFragmentRequestProto request, String host, int port, AsyncPbRpcProxy.ExecuteRequestCallback<LlapDaemonProtocolProtos.TerminateFragmentResponseProto> callback) {
        LlapNodeId nodeId = LlapNodeId.getInstance((String)host, (int)port);
        this.queueRequest((AsyncPbRpcProxy.CallableRequest)new SendTerminateFragmentCallable(nodeId, request, callback));
    }

    public void sendUpdateFragment(LlapDaemonProtocolProtos.UpdateFragmentRequestProto request, String host, int port, AsyncPbRpcProxy.ExecuteRequestCallback<LlapDaemonProtocolProtos.UpdateFragmentResponseProto> callback) {
        LlapNodeId nodeId = LlapNodeId.getInstance((String)host, (int)port);
        this.queueRequest((AsyncPbRpcProxy.CallableRequest)new SendUpdateFragmentCallable(nodeId, request, callback));
    }

    protected LlapProtocolBlockingPB createProtocolImpl(Configuration config, String hostname, int port, UserGroupInformation ugi, RetryPolicy retryPolicy, SocketFactory socketFactory) {
        return new LlapProtocolClientImpl(config, hostname, port, ugi, retryPolicy, socketFactory);
    }

    protected String getTokenUser(Token<LlapTokenIdentifier> token) {
        if (token == null) {
            return null;
        }
        try {
            return ((LlapTokenIdentifier)token.decodeIdentifier()).getOwner().toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot determine the user from token " + token, e);
        }
    }

    protected void shutdownProtocolImpl(LlapProtocolBlockingPB client) {
    }

    private class SendUpdateFragmentCallable
    extends AsyncPbRpcProxy.NodeCallableRequest<LlapDaemonProtocolProtos.UpdateFragmentRequestProto, LlapDaemonProtocolProtos.UpdateFragmentResponseProto> {
        protected SendUpdateFragmentCallable(LlapNodeId nodeId, LlapDaemonProtocolProtos.UpdateFragmentRequestProto terminateFragmentRequestProto, AsyncPbRpcProxy.ExecuteRequestCallback<LlapDaemonProtocolProtos.UpdateFragmentResponseProto> callback) {
            super(nodeId, (Message)terminateFragmentRequestProto, callback);
        }

        public LlapDaemonProtocolProtos.UpdateFragmentResponseProto call() throws Exception {
            return ((LlapProtocolBlockingPB)LlapProtocolClientProxy.this.getProxy(this.nodeId, null)).updateFragment(null, (LlapDaemonProtocolProtos.UpdateFragmentRequestProto)this.request);
        }
    }

    private class SendTerminateFragmentCallable
    extends AsyncPbRpcProxy.NodeCallableRequest<LlapDaemonProtocolProtos.TerminateFragmentRequestProto, LlapDaemonProtocolProtos.TerminateFragmentResponseProto> {
        protected SendTerminateFragmentCallable(LlapNodeId nodeId, LlapDaemonProtocolProtos.TerminateFragmentRequestProto terminateFragmentRequestProto, AsyncPbRpcProxy.ExecuteRequestCallback<LlapDaemonProtocolProtos.TerminateFragmentResponseProto> callback) {
            super(nodeId, (Message)terminateFragmentRequestProto, callback);
        }

        public LlapDaemonProtocolProtos.TerminateFragmentResponseProto call() throws Exception {
            return ((LlapProtocolBlockingPB)LlapProtocolClientProxy.this.getProxy(this.nodeId, null)).terminateFragment(null, (LlapDaemonProtocolProtos.TerminateFragmentRequestProto)this.request);
        }
    }

    private class SendQueryCompleteCallable
    extends AsyncPbRpcProxy.NodeCallableRequest<LlapDaemonProtocolProtos.QueryCompleteRequestProto, LlapDaemonProtocolProtos.QueryCompleteResponseProto> {
        protected SendQueryCompleteCallable(LlapNodeId nodeId, LlapDaemonProtocolProtos.QueryCompleteRequestProto queryCompleteRequestProto, AsyncPbRpcProxy.ExecuteRequestCallback<LlapDaemonProtocolProtos.QueryCompleteResponseProto> callback) {
            super(nodeId, (Message)queryCompleteRequestProto, callback);
        }

        public LlapDaemonProtocolProtos.QueryCompleteResponseProto call() throws Exception {
            return ((LlapProtocolBlockingPB)LlapProtocolClientProxy.this.getProxy(this.nodeId, null)).queryComplete(null, (LlapDaemonProtocolProtos.QueryCompleteRequestProto)this.request);
        }
    }

    private class SendSourceStateUpdateCallable
    extends AsyncPbRpcProxy.NodeCallableRequest<LlapDaemonProtocolProtos.SourceStateUpdatedRequestProto, LlapDaemonProtocolProtos.SourceStateUpdatedResponseProto> {
        public SendSourceStateUpdateCallable(LlapNodeId nodeId, LlapDaemonProtocolProtos.SourceStateUpdatedRequestProto request, AsyncPbRpcProxy.ExecuteRequestCallback<LlapDaemonProtocolProtos.SourceStateUpdatedResponseProto> callback) {
            super(nodeId, (Message)request, callback);
        }

        public LlapDaemonProtocolProtos.SourceStateUpdatedResponseProto call() throws Exception {
            return ((LlapProtocolBlockingPB)LlapProtocolClientProxy.this.getProxy(this.nodeId, null)).sourceStateUpdated(null, (LlapDaemonProtocolProtos.SourceStateUpdatedRequestProto)this.request);
        }
    }

    private class SubmitWorkCallable
    extends AsyncPbRpcProxy.NodeCallableRequest<LlapDaemonProtocolProtos.SubmitWorkRequestProto, LlapDaemonProtocolProtos.SubmitWorkResponseProto> {
        protected SubmitWorkCallable(LlapNodeId nodeId, LlapDaemonProtocolProtos.SubmitWorkRequestProto submitWorkRequestProto, AsyncPbRpcProxy.ExecuteRequestCallback<LlapDaemonProtocolProtos.SubmitWorkResponseProto> callback) {
            super(nodeId, (Message)submitWorkRequestProto, callback);
        }

        public LlapDaemonProtocolProtos.SubmitWorkResponseProto call() throws Exception {
            return ((LlapProtocolBlockingPB)LlapProtocolClientProxy.this.getProxy(this.nodeId, null)).submitWork(null, (LlapDaemonProtocolProtos.SubmitWorkRequestProto)this.request);
        }
    }

    private class RegisterDagCallable
    extends AsyncPbRpcProxy.NodeCallableRequest<LlapDaemonProtocolProtos.RegisterDagRequestProto, LlapDaemonProtocolProtos.RegisterDagResponseProto> {
        protected RegisterDagCallable(LlapNodeId nodeId, LlapDaemonProtocolProtos.RegisterDagRequestProto registerDagRequestProto, AsyncPbRpcProxy.ExecuteRequestCallback<LlapDaemonProtocolProtos.RegisterDagResponseProto> callback) {
            super(nodeId, (Message)registerDagRequestProto, callback);
        }

        public LlapDaemonProtocolProtos.RegisterDagResponseProto call() throws Exception {
            return ((LlapProtocolBlockingPB)LlapProtocolClientProxy.this.getProxy(this.nodeId, null)).registerDag(null, (LlapDaemonProtocolProtos.RegisterDagRequestProto)this.request);
        }
    }
}

