/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.SynchronizedDescriptiveStatistics;
import org.apache.hadoop.hive.common.JvmMetrics;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCustomMetricsInfo;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonExecutorInfo;
import org.apache.hadoop.hive.llap.metrics.LlapMetricsSystem;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;

@Metrics(about="LlapDaemon Executor Metrics", context="executors")
public class LlapDaemonExecutorMetrics
implements MetricsSource {
    private final String name;
    private final JvmMetrics jvmMetrics;
    private final String sessionId;
    private final MetricsRegistry registry;
    private final int numExecutorsConfigured;
    private final int waitQueueSizeConfigured;
    private final ThreadMXBean threadMXBean;
    private final Map<Integer, MetricsInfo> cpuMetricsInfoMap;
    private final Map<Integer, MetricsInfo> userMetricsInfoMap;
    private long maxTimeLost = Long.MIN_VALUE;
    private long maxTimeToKill = Long.MIN_VALUE;
    private long fallOffMaxSuccessTimeLostLong = 0L;
    private long fallOffMaxFailedTimeLostLong = 0L;
    private long fallOffMaxKilledTimeLostLong = 0L;
    private TimedAverageMetrics executorNumQueuedRequestsAverage;
    private TimedAverageMetrics numExecutorsAvailableAverage;
    private final Map<String, Integer> executorNames;
    private final DescriptiveStatistics queueTime;
    private final DescriptiveStatistics runningTime;
    final MutableGaugeLong[] executorThreadCpuTime;
    final MutableGaugeLong[] executorThreadUserTime;
    @Metric
    MutableCounterLong executorTotalRequestHandled;
    @Metric
    MutableGaugeInt executorNumQueuedRequests;
    @Metric
    MutableGaugeInt executorNumPreemptableRequests;
    @Metric
    MutableGaugeInt numExecutorsAvailable;
    @Metric
    MutableCounterLong totalRejectedRequests;
    @Metric
    MutableCounterLong totalEvictedFromWaitQueue;
    @Metric
    MutableCounterLong executorTotalSuccess;
    @Metric
    MutableCounterLong executorTotalIKilled;
    @Metric
    MutableCounterLong executorTotalExecutionFailed;
    @Metric
    MutableGaugeLong cacheMemoryPerInstance;
    @Metric
    MutableGaugeLong memoryPerInstance;
    @Metric
    MutableGaugeLong jvmMaxMemory;
    @Metric
    MutableGaugeInt waitQueueSize;
    @Metric
    MutableCounterLong totalPreemptionTimeToKill;
    @Metric
    MutableCounterLong totalPreemptionTimeLost;
    @Metric
    MutableGaugeLong maxPreemptionTimeToKill;
    @Metric
    MutableGaugeLong maxPreemptionTimeLost;
    @Metric
    final MutableQuantiles[] percentileTimeToKill;
    @Metric
    final MutableQuantiles[] percentileTimeLost;
    @Metric
    MutableCounterLong fallOffNumCompletedFragments;
    @Metric
    MutableCounterLong fallOffSuccessTimeLost;
    @Metric
    MutableCounterLong fallOffFailedTimeLost;
    @Metric
    MutableCounterLong fallOffKilledTimeLost;
    @Metric
    MutableGaugeLong fallOffMaxSuccessTimeLost;
    @Metric
    MutableGaugeLong fallOffMaxFailedTimeLost;
    @Metric
    MutableGaugeLong fallOffMaxKilledTimeLost;
    @Metric
    MutableGaugeInt numExecutors;

    private LlapDaemonExecutorMetrics(String displayName, JvmMetrics jm, String sessionId, int numExecutorsConfigured, int waitQueueSizeConfigured, int[] intervals, int timedWindowAverageDataPoints, long timedWindowAverageWindowLength, int simpleAverageWindowDataSize) {
        int i;
        this.name = displayName;
        this.jvmMetrics = jm;
        this.sessionId = sessionId;
        this.registry = new MetricsRegistry("LlapDaemonExecutorRegistry");
        this.registry.tag((MetricsInfo)MsInfo.ProcessName, "LlapDaemon").tag((MetricsInfo)MsInfo.SessionId, sessionId);
        this.numExecutorsConfigured = numExecutorsConfigured;
        this.waitQueueSizeConfigured = waitQueueSizeConfigured;
        this.threadMXBean = ManagementFactory.getThreadMXBean();
        this.executorThreadCpuTime = new MutableGaugeLong[numExecutorsConfigured];
        this.executorThreadUserTime = new MutableGaugeLong[numExecutorsConfigured];
        this.cpuMetricsInfoMap = new ConcurrentHashMap<Integer, MetricsInfo>();
        this.userMetricsInfoMap = new ConcurrentHashMap<Integer, MetricsInfo>();
        int len = intervals == null ? 0 : intervals.length;
        this.percentileTimeToKill = new MutableQuantiles[len];
        this.percentileTimeLost = new MutableQuantiles[len];
        for (i = 0; i < len; ++i) {
            int interval = intervals[i];
            this.percentileTimeToKill[i] = this.registry.newQuantiles(LlapDaemonExecutorInfo.ExecutorMaxPreemptionTimeToKill.name() + "_" + interval + "s", LlapDaemonExecutorInfo.ExecutorMaxPreemptionTimeToKill.description(), "ops", "latency", interval);
            this.percentileTimeLost[i] = this.registry.newQuantiles(LlapDaemonExecutorInfo.ExecutorMaxPreemptionTimeLost.name() + "_" + interval + "s", LlapDaemonExecutorInfo.ExecutorMaxPreemptionTimeLost.description(), "ops", "latency", interval);
        }
        this.executorNames = Maps.newHashMap();
        for (i = 0; i < numExecutorsConfigured; ++i) {
            LlapDaemonCustomMetricsInfo mic = new LlapDaemonCustomMetricsInfo(LlapDaemonExecutorInfo.ExecutorThreadCPUTime.name() + "_" + i, LlapDaemonExecutorInfo.ExecutorThreadCPUTime.description());
            LlapDaemonCustomMetricsInfo miu = new LlapDaemonCustomMetricsInfo(LlapDaemonExecutorInfo.ExecutorThreadUserTime.name() + "_" + i, LlapDaemonExecutorInfo.ExecutorThreadUserTime.description());
            this.cpuMetricsInfoMap.put(i, mic);
            this.userMetricsInfoMap.put(i, miu);
            this.executorThreadCpuTime[i] = this.registry.newGauge((MetricsInfo)mic, 0L);
            this.executorThreadUserTime[i] = this.registry.newGauge((MetricsInfo)miu, 0L);
            this.executorNames.put("ContainerExecutor " + i, i);
        }
        if (timedWindowAverageDataPoints > 0) {
            this.executorNumQueuedRequestsAverage = new TimedAverageMetrics(timedWindowAverageDataPoints, timedWindowAverageWindowLength);
            this.numExecutorsAvailableAverage = new TimedAverageMetrics(timedWindowAverageDataPoints, timedWindowAverageWindowLength);
        }
        if (simpleAverageWindowDataSize > 0) {
            this.queueTime = new SynchronizedDescriptiveStatistics(simpleAverageWindowDataSize);
            this.runningTime = new SynchronizedDescriptiveStatistics(simpleAverageWindowDataSize);
        } else {
            this.queueTime = null;
            this.runningTime = null;
        }
    }

    public static LlapDaemonExecutorMetrics create(String displayName, String sessionId, int numExecutorsConfigured, int waitQueueSizeConfigured, int[] intervals, int timedWindowAverageDataPoints, long timedWindowAverageWindowLength, int simpleAverageWindowDataSize) {
        MetricsSystem ms = LlapMetricsSystem.instance();
        JvmMetrics jm = JvmMetrics.create((String)"LlapDaemon", (String)sessionId, (MetricsSystem)ms);
        return (LlapDaemonExecutorMetrics)ms.register(displayName, "LlapDaemon Executor Metrics", (Object)new LlapDaemonExecutorMetrics(displayName, jm, sessionId, numExecutorsConfigured, waitQueueSizeConfigured, intervals, timedWindowAverageDataPoints, timedWindowAverageWindowLength, simpleAverageWindowDataSize));
    }

    public void getMetrics(MetricsCollector collector, boolean b) {
        MetricsRecordBuilder rb = collector.addRecord((MetricsInfo)LlapDaemonExecutorInfo.ExecutorMetrics).setContext("executors").tag((MetricsInfo)MsInfo.ProcessName, "LlapDaemon").tag((MetricsInfo)MsInfo.SessionId, this.sessionId);
        this.getExecutorStats(rb);
    }

    public void incrExecutorTotalRequestsHandled() {
        this.executorTotalRequestHandled.incr();
    }

    public void setExecutorNumQueuedRequests(int value) {
        this.executorNumQueuedRequests.set(value);
        if (this.executorNumQueuedRequestsAverage != null) {
            this.executorNumQueuedRequestsAverage.add(value);
        }
    }

    public void setExecutorNumPreemptableRequests(int value) {
        this.executorNumPreemptableRequests.set(value);
    }

    public void setNumExecutorsAvailable(int value) {
        this.numExecutorsAvailable.set(value);
        if (this.numExecutorsAvailableAverage != null) {
            this.numExecutorsAvailableAverage.add(value);
        }
    }

    public void incrTotalEvictedFromWaitQueue() {
        this.totalEvictedFromWaitQueue.incr();
    }

    public void incrTotalRejectedRequests() {
        this.totalRejectedRequests.incr();
    }

    public void incrExecutorTotalSuccess() {
        this.executorTotalSuccess.incr();
    }

    public void incrExecutorTotalExecutionFailed() {
        this.executorTotalExecutionFailed.incr();
    }

    public void addMetricsPreemptionTimeLost(long value) {
        this.totalPreemptionTimeLost.incr(value);
        if (value > this.maxTimeLost) {
            this.maxTimeLost = value;
            this.maxPreemptionTimeLost.set(this.maxTimeLost);
        }
        for (MutableQuantiles q : this.percentileTimeLost) {
            q.add(value);
        }
    }

    public void addMetricsPreemptionTimeToKill(long value) {
        this.totalPreemptionTimeToKill.incr(value);
        if (value > this.maxTimeToKill) {
            this.maxTimeToKill = value;
            this.maxPreemptionTimeToKill.set(this.maxTimeToKill);
        }
        for (MutableQuantiles q : this.percentileTimeToKill) {
            q.add(value);
        }
    }

    public void addMetricsFallOffSuccessTimeLost(long timeLost) {
        this.fallOffNumCompletedFragments.incr();
        this.fallOffSuccessTimeLost.incr(timeLost);
        if (timeLost > this.fallOffMaxSuccessTimeLostLong) {
            this.fallOffMaxSuccessTimeLostLong = timeLost;
            this.fallOffMaxSuccessTimeLost.set(timeLost);
        }
    }

    public void addMetricsFallOffFailedTimeLost(long timeLost) {
        this.fallOffNumCompletedFragments.incr();
        this.fallOffFailedTimeLost.incr(timeLost);
        if (timeLost > this.fallOffMaxFailedTimeLostLong) {
            this.fallOffMaxFailedTimeLostLong = timeLost;
            this.fallOffMaxFailedTimeLost.set(timeLost);
        }
    }

    public void addMetricsFallOffKilledTimeLost(long timeLost) {
        this.fallOffNumCompletedFragments.incr();
        this.fallOffKilledTimeLost.incr(timeLost);
        if (timeLost > this.fallOffMaxKilledTimeLostLong) {
            this.fallOffMaxKilledTimeLostLong = timeLost;
            this.fallOffMaxKilledTimeLost.set(timeLost);
        }
    }

    public void incrExecutorTotalKilled() {
        this.executorTotalIKilled.incr();
    }

    public void addMetricsQueueTime(long queueTime) {
        if (this.queueTime != null) {
            this.queueTime.addValue((double)queueTime);
        }
    }

    public void addMetricsRunningTime(long runningTime) {
        if (this.runningTime != null) {
            this.runningTime.addValue((double)runningTime);
        }
    }

    public void setCacheMemoryPerInstance(long value) {
        this.cacheMemoryPerInstance.set(value);
    }

    public void setMemoryPerInstance(long value) {
        this.memoryPerInstance.set(value);
    }

    public void setJvmMaxMemory(long value) {
        this.jvmMaxMemory.set(value);
    }

    public void setWaitQueueSize(int size) {
        this.waitQueueSize.set(size);
    }

    public void setNumExecutors(int size) {
        this.numExecutors.set(size);
    }

    private void getExecutorStats(MetricsRecordBuilder rb) {
        this.updateThreadMetrics(rb);
        int totalConfiguredSlots = this.waitQueueSizeConfigured + this.numExecutorsConfigured;
        int totalSlots = this.waitQueueSize.value() + this.numExecutors.value();
        int slotsAvailableInQueue = this.waitQueueSize.value() - this.executorNumQueuedRequests.value();
        int slotsAvailableTotal = slotsAvailableInQueue + this.numExecutorsAvailable.value();
        float slotsAvailablePercent = totalSlots <= 0 ? 0.0f : (float)slotsAvailableTotal / (float)totalSlots;
        rb.addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorTotalRequestsHandled, this.executorTotalRequestHandled.value()).addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorTotalSuccess, this.executorTotalSuccess.value()).addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorTotalFailed, this.executorTotalExecutionFailed.value()).addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorTotalKilled, this.executorTotalIKilled.value()).addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorTotalEvictedFromWaitQueue, this.totalEvictedFromWaitQueue.value()).addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorTotalRejectedRequests, this.totalRejectedRequests.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorNumQueuedRequests, this.executorNumQueuedRequests.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorNumPreemptableRequests, this.executorNumPreemptableRequests.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorMemoryPerInstance, this.memoryPerInstance.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorCacheMemoryPerInstance, this.cacheMemoryPerInstance.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorJvmMaxMemory, this.jvmMaxMemory.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorMaxFreeSlotsConfigured, totalConfiguredSlots).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorMaxFreeSlots, totalSlots).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorNumExecutors, this.numExecutors.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorNumExecutorsConfigured, this.numExecutorsConfigured).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorWaitQueueSizeConfigured, this.waitQueueSizeConfigured).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorWaitQueueSize, this.waitQueueSize.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorNumExecutorsAvailable, this.numExecutorsAvailable.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorAvailableFreeSlots, slotsAvailableTotal).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorAvailableFreeSlotsPercent, slotsAvailablePercent).addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorTotalPreemptionTimeToKill, this.totalPreemptionTimeToKill.value()).addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorTotalPreemptionTimeLost, this.totalPreemptionTimeLost.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorMaxPreemptionTimeToKill, this.maxPreemptionTimeToKill.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorMaxPreemptionTimeLost, this.maxPreemptionTimeLost.value()).addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorFallOffSuccessTimeLost, this.fallOffSuccessTimeLost.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorFallOffSuccessMaxTimeLost, this.fallOffMaxSuccessTimeLost.value()).addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorFallOffFailedTimeLost, this.fallOffFailedTimeLost.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorFallOffFailedMaxTimeLost, this.fallOffMaxFailedTimeLost.value()).addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorFallOffKilledTimeLost, this.fallOffKilledTimeLost.value()).addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorFallOffKilledMaxTimeLost, this.fallOffMaxKilledTimeLost.value()).addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorFallOffNumCompletedFragments, this.fallOffNumCompletedFragments.value());
        if (this.numExecutorsAvailableAverage != null) {
            rb.addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorNumExecutorsAvailableAverage, this.numExecutorsAvailableAverage.value());
        }
        if (this.executorNumQueuedRequestsAverage != null) {
            rb.addGauge((MetricsInfo)LlapDaemonExecutorInfo.ExecutorNumQueuedRequestsAverage, this.executorNumQueuedRequestsAverage.value());
        }
        if (this.queueTime != null) {
            rb.addGauge((MetricsInfo)LlapDaemonExecutorInfo.AverageQueueTime, this.queueTime.getSum() / (double)this.queueTime.getN());
        }
        if (this.runningTime != null) {
            rb.addGauge((MetricsInfo)LlapDaemonExecutorInfo.AverageResponseTime, this.runningTime.getSum() / (double)this.runningTime.getN());
        }
        for (MutableQuantiles q : this.percentileTimeToKill) {
            q.snapshot(rb, true);
        }
        for (MutableQuantiles q : this.percentileTimeLost) {
            q.snapshot(rb, true);
        }
    }

    private void updateThreadMetrics(MetricsRecordBuilder rb) {
        if (this.threadMXBean.isThreadCpuTimeSupported() && this.threadMXBean.isThreadCpuTimeEnabled()) {
            int i;
            long[] ids = this.threadMXBean.getAllThreadIds();
            ThreadInfo[] infos = this.threadMXBean.getThreadInfo(ids);
            for (i = 0; i < ids.length; ++i) {
                ThreadInfo threadInfo = infos[i];
                if (threadInfo == null) continue;
                String threadName = threadInfo.getThreadName();
                long threadId = ids[i];
                Integer id = this.executorNames.get(threadName);
                if (id == null) continue;
                this.executorThreadCpuTime[id].set(this.threadMXBean.getThreadCpuTime(threadId));
                this.executorThreadUserTime[id].set(this.threadMXBean.getThreadUserTime(threadId));
            }
            for (i = 0; i < this.numExecutorsConfigured; ++i) {
                rb.addGauge(this.cpuMetricsInfoMap.get(i), this.executorThreadCpuTime[i].value());
                rb.addGauge(this.userMetricsInfoMap.get(i), this.executorThreadUserTime[i].value());
            }
        }
    }

    public JvmMetrics getJvmMetrics() {
        return this.jvmMetrics;
    }

    public String getName() {
        return this.name;
    }

    public int getNumExecutorsAvailable() {
        return this.numExecutorsAvailable.value();
    }

    public int getWaitQueueSize() {
        return this.waitQueueSize.value();
    }

    private static class Data {
        private long nanoTime;
        private long value;

        Data(long nanoTime, long value) {
            this.nanoTime = nanoTime;
            this.value = value;
        }
    }

    @VisibleForTesting
    static class TimedAverageMetrics {
        private final int windowDataSize;
        private final long windowTimeSize;
        private final Data[] data;
        private int nextPos = 0;

        TimedAverageMetrics(int windowDataSize, long windowTimeSize) {
            this(windowDataSize, windowTimeSize, System.nanoTime() - windowTimeSize - 1L);
        }

        @VisibleForTesting
        TimedAverageMetrics(int windowDataSize, long windowTimeSize, long defaultTime) {
            assert (windowDataSize > 0);
            this.windowDataSize = windowDataSize;
            this.windowTimeSize = windowTimeSize;
            this.data = new Data[windowDataSize];
            Arrays.setAll(this.data, i -> new Data(defaultTime, 0L));
        }

        public synchronized void add(long value) {
            this.add(System.nanoTime(), value);
        }

        public synchronized long value() {
            return this.value(System.nanoTime());
        }

        @VisibleForTesting
        void add(long time, long value) {
            this.data[this.nextPos].nanoTime = time;
            this.data[this.nextPos].value = value;
            ++this.nextPos;
            if (this.nextPos == this.windowDataSize) {
                this.nextPos = 0;
            }
        }

        @VisibleForTesting
        long value(long time) {
            long sum = 0L;
            long lastTime = time;
            long minTime = lastTime - this.windowTimeSize;
            int pos = this.nextPos - 1;
            do {
                if (pos < 0) {
                    pos = this.windowDataSize - 1;
                }
                if (this.data[pos].nanoTime < minTime) {
                    sum += (lastTime - minTime) * this.data[pos].value;
                    break;
                }
                sum += (lastTime - this.data[pos].nanoTime) * this.data[pos].value;
                lastTime = this.data[pos].nanoTime;
            } while (--pos != this.nextPos - 1);
            if (pos == this.nextPos - 1 && this.data[this.nextPos].nanoTime > minTime) {
                sum += (lastTime - minTime) * this.data[this.nextPos].value;
            }
            return Math.round((double)sum / (double)this.windowTimeSize);
        }
    }
}

