/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.metadata;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hive.llap.io.metadata.ConsumerStripeMetadata;
import org.apache.hadoop.hive.ql.io.orc.encoded.OrcBatchKey;
import org.apache.orc.OrcProto;
import org.apache.orc.StripeInformation;
import org.apache.orc.impl.OrcIndex;

public class OrcStripeMetadata
implements ConsumerStripeMetadata {
    private final OrcBatchKey stripeKey;
    private final List<OrcProto.ColumnEncoding> encodings;
    private final List<OrcProto.Stream> streams;
    private final String writerTimezone;
    private final long rowCount;
    private OrcIndex rowIndex;

    public OrcStripeMetadata(OrcBatchKey stripeKey, OrcProto.StripeFooter footer, OrcIndex orcIndex, StripeInformation stripe) throws IOException {
        this.stripeKey = stripeKey;
        this.streams = footer.getStreamsList();
        this.encodings = footer.getColumnsList();
        this.writerTimezone = footer.getWriterTimezone();
        this.rowCount = stripe.getNumberOfRows();
        this.rowIndex = orcIndex;
    }

    @Override
    public int getStripeIx() {
        return this.stripeKey.stripeIx;
    }

    @Override
    public OrcProto.RowIndex[] getRowIndexes() {
        return this.rowIndex.getRowGroupIndex();
    }

    public OrcProto.Stream.Kind[] getBloomFilterKinds() {
        return this.rowIndex.getBloomFilterKinds();
    }

    public OrcProto.BloomFilterIndex[] getBloomFilterIndexes() {
        return this.rowIndex.getBloomFilterIndex();
    }

    @Override
    public List<OrcProto.ColumnEncoding> getEncodings() {
        return this.encodings;
    }

    public List<OrcProto.Stream> getStreams() {
        return this.streams;
    }

    @Override
    public String getWriterTimezone() {
        return this.writerTimezone;
    }

    public OrcBatchKey getKey() {
        return this.stripeKey;
    }

    @Override
    public long getRowCount() {
        return this.rowCount;
    }

    @VisibleForTesting
    public void resetRowIndex() {
        this.rowIndex = null;
    }

    @Override
    public OrcProto.RowIndexEntry getRowIndexEntry(int colIx, int rgIx) {
        if (this.rowIndex == null || this.rowIndex.getRowGroupIndex()[colIx] == null) {
            return null;
        }
        return this.rowIndex.getRowGroupIndex()[colIx].getEntry(rgIx);
    }

    @Override
    public boolean supportsRowIndexes() {
        if (this.rowIndex == null) {
            return false;
        }
        boolean allNulls = true;
        for (OrcProto.RowIndex rowIndex : this.rowIndex.getRowGroupIndex()) {
            if (rowIndex == null) continue;
            allNulls = false;
            break;
        }
        return !allNulls;
    }

    public OrcIndex getIndex() {
        return this.rowIndex;
    }

    public String toString() {
        return "OrcStripeMetadata [stripeKey=" + this.stripeKey + ", rowCount=" + this.rowCount + ", writerTimezone=" + this.writerTimezone + ", encodings=" + this.encodings + ", streams=" + this.streams + ", rowIndex=" + this.rowIndex + "]";
    }
}

