/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cli.status;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Properties;
import jline.TerminalFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.hive.llap.cli.status.ExitCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapStatusServiceCommandLine {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"LlapStatusServiceDriverConsole");
    @VisibleForTesting
    static final long DEFAULT_FIND_YARN_APP_TIMEOUT_MS = 20000L;
    @VisibleForTesting
    static final long DEFAULT_STATUS_REFRESH_INTERVAL_MS = 1000L;
    @VisibleForTesting
    static final long DEFAULT_WATCH_MODE_TIMEOUT_MS = 300000L;
    @VisibleForTesting
    static final float DEFAULT_RUNNING_NODES_THRESHOLD = 1.0f;
    private static final Option NAME;
    private static final Option FIND_APP_TIMEOUT;
    private static final Option OUTPUT_FILE;
    private static final Option WATCH_MODE;
    private static final Option NOT_LAUNCHED;
    private static final Option RUNNING_NODES_THRESHOLD;
    private static final Option REFRESH_INTERVAL;
    private static final Option WATCH_TIMEOUT;
    private static final Option HIVECONF;
    private static final Option HELP;
    private static final Options OPTIONS;
    private String name;
    private long findAppTimeoutMs;
    private String outputFile;
    private boolean watchMode;
    private boolean isLaunched;
    private float runningNodesThreshold;
    private long refreshIntervalMs;
    private long watchTimeoutMs;
    private Properties hiveConf;
    private boolean isHelp;

    public static LlapStatusServiceCommandLine parseArguments(String[] args) {
        LlapStatusServiceCommandLine cl = null;
        try {
            cl = new LlapStatusServiceCommandLine(args);
        }
        catch (Exception e) {
            LOGGER.error("Parsing the command line arguments failed", (Throwable)e);
            LlapStatusServiceCommandLine.printUsage();
            System.exit(ExitCode.INCORRECT_USAGE.getCode());
        }
        if (cl.isHelp()) {
            LlapStatusServiceCommandLine.printUsage();
            System.exit(0);
        }
        return cl;
    }

    LlapStatusServiceCommandLine(String[] args) throws ParseException {
        LOGGER.info("LLAP status invoked with arguments = {}", (Object)Arrays.toString(args));
        this.parseCommandLine(args);
        this.printArguments();
    }

    private void parseCommandLine(String[] args) throws ParseException {
        CommandLine cl = new GnuParser().parse(OPTIONS, args);
        this.name = cl.getOptionValue(NAME.getLongOpt());
        this.findAppTimeoutMs = 20000L;
        if (cl.hasOption(FIND_APP_TIMEOUT.getLongOpt())) {
            this.findAppTimeoutMs = Long.parseLong(cl.getOptionValue(FIND_APP_TIMEOUT.getLongOpt())) * 1000L;
        }
        if (cl.hasOption(OUTPUT_FILE.getLongOpt())) {
            this.outputFile = cl.getOptionValue(OUTPUT_FILE.getLongOpt());
        }
        this.watchMode = cl.hasOption(WATCH_MODE.getLongOpt());
        this.isLaunched = !cl.hasOption(NOT_LAUNCHED.getLongOpt());
        this.runningNodesThreshold = 1.0f;
        if (cl.hasOption(RUNNING_NODES_THRESHOLD.getLongOpt())) {
            this.runningNodesThreshold = Float.parseFloat(cl.getOptionValue(RUNNING_NODES_THRESHOLD.getLongOpt()));
            if (this.runningNodesThreshold < 0.0f || this.runningNodesThreshold > 1.0f) {
                throw new IllegalArgumentException("Running nodes threshold value should be between 0.0 and 1.0 (inclusive)");
            }
        }
        this.refreshIntervalMs = 1000L;
        if (cl.hasOption(REFRESH_INTERVAL.getLongOpt())) {
            long refreshIntervalSec = Long.parseLong(cl.getOptionValue(REFRESH_INTERVAL.getLongOpt()));
            if (refreshIntervalSec <= 0L) {
                throw new IllegalArgumentException("Refresh interval should be >0");
            }
            this.refreshIntervalMs = refreshIntervalSec * 1000L;
        }
        this.watchTimeoutMs = 300000L;
        if (cl.hasOption(WATCH_TIMEOUT.getLongOpt())) {
            long watchTimeoutSec = Long.parseLong(cl.getOptionValue(WATCH_TIMEOUT.getLongOpt()));
            if (watchTimeoutSec <= 0L) {
                throw new IllegalArgumentException("Watch timeout should be >0");
            }
            this.watchTimeoutMs = watchTimeoutSec * 1000L;
        }
        this.hiveConf = new Properties();
        if (cl.hasOption(HIVECONF.getLongOpt())) {
            this.hiveConf = cl.getOptionProperties(HIVECONF.getLongOpt());
        }
        this.isHelp = cl.hasOption(HELP.getOpt());
    }

    private static void printUsage() {
        HelpFormatter hf = new HelpFormatter();
        try {
            int width = hf.getWidth();
            int jlineWidth = TerminalFactory.get().getWidth();
            width = Math.min(160, Math.max(jlineWidth, width));
            hf.setWidth(width);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        hf.printHelp("llapstatus", OPTIONS);
    }

    private void printArguments() {
        LOGGER.info("LLAP status running with the following parsed arguments: \n\tname                 : " + this.name + "\n" + "\tfindAppTimeoutMs     : " + this.findAppTimeoutMs + "\n" + "\toutputFile           : " + this.outputFile + "\n" + "\twatchMode            : " + this.watchMode + "\n" + "\tisLaunched           : " + this.isLaunched + "\n" + "\trunningNodesThreshold: " + this.runningNodesThreshold + "\n" + "\trefreshIntervalMs    : " + this.refreshIntervalMs + "\n" + "\twatchTimeoutMs       : " + this.watchTimeoutMs + "\n" + "\thiveConf             : " + this.hiveConf);
    }

    String getName() {
        return this.name;
    }

    long getFindAppTimeoutMs() {
        return this.findAppTimeoutMs;
    }

    String getOutputFile() {
        return this.outputFile;
    }

    boolean isWatchMode() {
        return this.watchMode;
    }

    boolean isLaunched() {
        return this.isLaunched;
    }

    float getRunningNodesThreshold() {
        return this.runningNodesThreshold;
    }

    long getRefreshIntervalMs() {
        return this.refreshIntervalMs;
    }

    long getWatchTimeoutMs() {
        return this.watchTimeoutMs;
    }

    Properties getHiveConf() {
        return this.hiveConf;
    }

    boolean isHelp() {
        return this.isHelp;
    }

    static {
        OptionBuilder.withLongOpt((String)"name");
        OptionBuilder.withDescription((String)"LLAP cluster name");
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.hasArg();
        NAME = OptionBuilder.create((char)'n');
        OptionBuilder.withLongOpt((String)"findAppTimeout");
        OptionBuilder.withDescription((String)"Amount of time(s) that the tool will sleep to wait for the YARN application to start.negative values=wait forever, 0=Do not wait. default=20s");
        OptionBuilder.withArgName((String)"findAppTimeout");
        OptionBuilder.hasArg();
        FIND_APP_TIMEOUT = OptionBuilder.create((char)'f');
        OptionBuilder.withLongOpt((String)"outputFile");
        OptionBuilder.withDescription((String)"File to which output should be written (Default stdout)");
        OptionBuilder.withArgName((String)"outputFile");
        OptionBuilder.hasArg();
        OUTPUT_FILE = OptionBuilder.create((char)'o');
        OptionBuilder.withLongOpt((String)"watch");
        OptionBuilder.withDescription((String)"Watch mode waits until all LLAP daemons are running or subset of the nodes are running (threshold can be specified via -r option) (Default wait until all nodes are running)");
        OptionBuilder.withArgName((String)"watch");
        WATCH_MODE = OptionBuilder.create((char)'w');
        OptionBuilder.withLongOpt((String)"notLaunched");
        OptionBuilder.withDescription((String)"In watch mode, do not assume that the application was already launched if there's doubt (e.g. if the last application instance has failed).");
        OptionBuilder.withArgName((String)"notLaunched");
        NOT_LAUNCHED = OptionBuilder.create((char)'l');
        OptionBuilder.withLongOpt((String)"runningNodesThreshold");
        OptionBuilder.withDescription((String)"When watch mode is enabled (-w), wait until the specified threshold of nodes are running (Default 1.0 which means 100% nodes are running)");
        OptionBuilder.withArgName((String)"runningNodesThreshold");
        OptionBuilder.hasArg();
        RUNNING_NODES_THRESHOLD = OptionBuilder.create((char)'r');
        OptionBuilder.withLongOpt((String)"refreshInterval");
        OptionBuilder.withDescription((String)"Amount of time in seconds to wait until subsequent status checks in watch mode. Valid only for watch mode. (Default 1s)");
        OptionBuilder.withArgName((String)"refreshInterval");
        OptionBuilder.hasArg();
        REFRESH_INTERVAL = OptionBuilder.create((char)'i');
        OptionBuilder.withLongOpt((String)"watchTimeout");
        OptionBuilder.withDescription((String)"Exit watch mode if the desired state is not attained until the specified timeout. (Default 300s)");
        OptionBuilder.withArgName((String)"watchTimeout");
        OptionBuilder.hasArg();
        WATCH_TIMEOUT = OptionBuilder.create((char)'t');
        OptionBuilder.withLongOpt((String)"hiveconf");
        OptionBuilder.withDescription((String)"Use value for given property. Overridden by explicit parameters");
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.hasArgs((int)2);
        HIVECONF = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"Print help information");
        OptionBuilder.withArgName((String)"help");
        HELP = OptionBuilder.create((char)'h');
        OPTIONS = new Options();
        OPTIONS.addOption(NAME);
        OPTIONS.addOption(FIND_APP_TIMEOUT);
        OPTIONS.addOption(OUTPUT_FILE);
        OPTIONS.addOption(WATCH_MODE);
        OPTIONS.addOption(NOT_LAUNCHED);
        OPTIONS.addOption(RUNNING_NODES_THRESHOLD);
        OPTIONS.addOption(REFRESH_INTERVAL);
        OPTIONS.addOption(WATCH_TIMEOUT);
        OPTIONS.addOption(HIVECONF);
        OPTIONS.addOption(HELP);
    }
}

