/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.log;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.routing.PurgePolicy;
import org.apache.logging.log4j.core.appender.routing.RoutingAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="LlapRoutingAppenderPurgePolicy", category="Core", printObject=true)
public class LlapRoutingAppenderPurgePolicy
implements PurgePolicy {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final ConcurrentMap<String, LlapRoutingAppenderPurgePolicy> INSTANCES = new ConcurrentHashMap<String, LlapRoutingAppenderPurgePolicy>();
    private final Set<String> knownAppenders = Collections.newSetFromMap(new ConcurrentHashMap());
    private final String name;
    private RoutingAppender routingAppender;

    public LlapRoutingAppenderPurgePolicy(String name) {
        LOGGER.trace("Created " + LlapRoutingAppenderPurgePolicy.class.getName() + " with name=" + name);
        this.name = name;
    }

    private LlapRoutingAppenderPurgePolicy() {
        this("_NOOP_");
    }

    public void initialize(RoutingAppender routingAppender) {
        this.routingAppender = routingAppender;
    }

    public void purge() {
    }

    public void update(String key, LogEvent event) {
        Marker marker = event.getMarker();
        if (marker != null && marker.getName() != null && marker.getName().equals("EOF_MARKER")) {
            LOGGER.debug("Received EOF_MARKER for key. Attempting cleanup.");
            this.keyComplete(key);
        } else if (this.knownAppenders.add(key) && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Registered key: [" + key + "] on purgePolicyWithName=" + this.name + ", thisAddress=" + System.identityHashCode(this));
        }
    }

    private void keyComplete(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"Key must be specified");
        boolean removed = this.knownAppenders.remove(key);
        if (removed) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Deleting Appender for key: " + key);
            }
            this.routingAppender.deleteAppender(key);
        } else {
            LOGGER.trace("Ignoring call to remove unknown key: " + key);
        }
    }

    @PluginFactory
    public static PurgePolicy createPurgePolicy(@PluginAttribute(value="name") String name) {
        Preconditions.checkNotNull((Object)name, (Object)("Name must be specified for " + LlapRoutingAppenderPurgePolicy.class.getName()));
        LlapRoutingAppenderPurgePolicy llapRoutingAppenderPurgePolicy = new LlapRoutingAppenderPurgePolicy(name);
        LlapRoutingAppenderPurgePolicy old = INSTANCES.putIfAbsent(name, llapRoutingAppenderPurgePolicy);
        if (old != null) {
            LOGGER.debug("Attempt to create multiple instances of " + LlapRoutingAppenderPurgePolicy.class.getName() + " with the name " + name + ". Using original instance");
            llapRoutingAppenderPurgePolicy = old;
        }
        return llapRoutingAppenderPurgePolicy;
    }
}

