/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import com.google.common.base.Function;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.common.io.CacheTag;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.llap.DebugUtils;
import org.apache.hadoop.hive.llap.cache.BufferUsageManager;
import org.apache.hadoop.hive.llap.cache.EvictionDispatcher;
import org.apache.hadoop.hive.llap.cache.FileCache;
import org.apache.hadoop.hive.llap.cache.FileCacheCleanupThread;
import org.apache.hadoop.hive.llap.cache.LlapAllocatorBuffer;
import org.apache.hadoop.hive.llap.cache.LlapOomDebugDump;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.LowLevelCacheCounters;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheMetrics;
import org.apache.hive.common.util.Ref;
import org.apache.orc.OrcProto;

public class SerDeLowLevelCacheImpl
implements BufferUsageManager,
LlapOomDebugDump {
    private static final int DEFAULT_CLEANUP_INTERVAL = 600;
    private final Allocator allocator;
    private final AtomicInteger newEvictions = new AtomicInteger(0);
    private Thread cleanupThread = null;
    private final ConcurrentHashMap<Object, FileCache<FileData>> cache = new ConcurrentHashMap();
    private final LowLevelCachePolicy cachePolicy;
    private final long cleanupInterval;
    private final LlapDaemonCacheMetrics metrics;

    public static String toString(LlapSerDeDataBuffer[][][] data) {
        if (data == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < data.length; ++i) {
            LlapSerDeDataBuffer[][] colData = data[i];
            if (colData == null) {
                sb.append("null, ");
                continue;
            }
            sb.append("colData [");
            for (int j = 0; j < colData.length; ++j) {
                LlapSerDeDataBuffer[] streamData = colData[j];
                if (streamData == null) {
                    sb.append("null, ");
                    continue;
                }
                sb.append("buffers [");
                for (int k = 0; k < streamData.length; ++k) {
                    sb.append(streamData[k]);
                }
                sb.append("], ");
            }
            sb.append("], ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toString(LlapSerDeDataBuffer[][] data) {
        if (data == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("[");
        for (int j = 0; j < data.length; ++j) {
            LlapSerDeDataBuffer[] streamData = data[j];
            if (streamData == null) {
                sb.append("null, ");
                continue;
            }
            sb.append("[");
            for (int k = 0; k < streamData.length; ++k) {
                sb.append(streamData[k]);
            }
            sb.append("], ");
        }
        sb.append("]");
        return sb.toString();
    }

    public SerDeLowLevelCacheImpl(LlapDaemonCacheMetrics metrics, LowLevelCachePolicy cachePolicy, Allocator allocator) {
        this.cachePolicy = cachePolicy;
        this.allocator = allocator;
        this.cleanupInterval = 600L;
        this.metrics = metrics;
        LlapIoImpl.LOG.info("SerDe low-level level cache; cleanup interval {} sec", (Object)this.cleanupInterval);
    }

    public void startThreads() {
        if (this.cleanupInterval < 0L) {
            return;
        }
        this.cleanupThread = new CleanupThread(this.cache, this.newEvictions, this.cleanupInterval);
        this.cleanupThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileData getFileData(Object fileKey, long start, long end, boolean[] includes, DataCache.DiskRangeListFactory factory, LowLevelCacheCounters qfCounters, DataCache.BooleanRef gotAllData) throws IOException {
        FileCache<FileData> subCache = this.cache.get(fileKey);
        if (subCache == null || !subCache.incRef()) {
            if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
                LlapIoImpl.CACHE_LOGGER.trace("Cannot find cache for " + fileKey + " in " + this.cache);
            }
            this.markAllAsMissed(start, end, qfCounters, gotAllData);
            return null;
        }
        try {
            int endIx;
            int startIx;
            long origEnd;
            long origStart;
            FileData result;
            FileData cached;
            block32: {
                block31: {
                    cached = subCache.getCache();
                    cached.rwLock.readLock().lock();
                    if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
                        LlapIoImpl.CACHE_LOGGER.trace("Cache for " + fileKey + " is " + subCache.getCache());
                    }
                    if (cached.stripes != null) break block31;
                    LlapIoImpl.CACHE_LOGGER.debug("Cannot find any stripes for " + fileKey);
                    this.markAllAsMissed(start, end, qfCounters, gotAllData);
                    FileData fileData = null;
                    cached.rwLock.readLock().unlock();
                    return fileData;
                }
                if (includes.length > cached.colCount) {
                    throw new IOException("Includes " + DebugUtils.toString((boolean[])includes) + " for " + cached.colCount + " columns");
                }
                result = new FileData(cached.fileKey, cached.colCount);
                if (gotAllData != null) {
                    gotAllData.value = true;
                }
                origStart = start;
                origEnd = end;
                startIx = Integer.MIN_VALUE;
                endIx = Integer.MIN_VALUE;
                LlapIoImpl.CACHE_LOGGER.debug("Looking for data between " + start + " and " + end);
                for (int i = 0; i < cached.stripes.size() && endIx == Integer.MIN_VALUE; ++i) {
                    StripeData si = (StripeData)cached.stripes.get(i);
                    if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
                        LlapIoImpl.CACHE_LOGGER.trace("Looking at " + si.toCoordinateString());
                    }
                    if (startIx == i) {
                        start = si.knownTornStart;
                    } else if (startIx == Integer.MIN_VALUE) {
                        if (si.lastEnd <= start) continue;
                        if (start == 0L && si.firstStart == 0L) {
                            startIx = i;
                        } else if (start >= si.firstStart) {
                            startIx = i + 1;
                        } else {
                            startIx = i;
                            start = si.knownTornStart;
                        }
                    }
                    if (startIx == Integer.MIN_VALUE || endIx != Integer.MIN_VALUE) continue;
                    if (si.lastEnd <= end) {
                        if (i + 1 != cached.stripes.size()) continue;
                        endIx = i + 1;
                        end = si.lastEnd;
                        continue;
                    }
                    if (si.lastStart <= end) {
                        endIx = i + 1;
                        end = si.lastEnd;
                        continue;
                    }
                    endIx = i;
                    end = endIx > 0 ? ((StripeData)cached.stripes.get(endIx - 1)).lastEnd : start;
                }
                LlapIoImpl.CACHE_LOGGER.debug("Determined stripe indexes " + startIx + ", " + endIx);
                if (endIx > startIx) break block32;
                if (gotAllData != null) {
                    gotAllData.value = false;
                }
                FileData i = null;
                cached.rwLock.readLock().unlock();
                return i;
            }
            try {
                if (start > origStart || end < origEnd) {
                    if (gotAllData != null) {
                        gotAllData.value = false;
                    }
                    long totalMiss = Math.max(0L, origEnd - end) + Math.max(0L, start - origStart);
                    this.metrics.incrCacheRequestedBytes(totalMiss);
                    if (qfCounters != null) {
                        qfCounters.recordCacheMiss(totalMiss);
                    }
                }
                result.stripes = new ArrayList(endIx - startIx);
                for (int stripeIx = startIx; stripeIx < endIx; ++stripeIx) {
                    this.getCacheDataForOneSlice(stripeIx, cached, result, gotAllData, includes, qfCounters);
                }
                FileData fileData = result;
                cached.rwLock.readLock().unlock();
                return fileData;
            }
            catch (Throwable throwable) {
                cached.rwLock.readLock().unlock();
                throw throwable;
            }
        }
        finally {
            subCache.decRef();
        }
    }

    private void getCacheDataForOneSlice(int stripeIx, FileData cached, FileData result, DataCache.BooleanRef gotAllData, boolean[] includes, LowLevelCacheCounters qfCounters) {
        StripeData cStripe = (StripeData)cached.stripes.get(stripeIx);
        if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
            LlapIoImpl.CACHE_LOGGER.trace("Got stripe in cache " + cStripe);
        }
        StripeData stripe = StripeData.duplicateStructure(cStripe);
        result.stripes.add(stripe);
        boolean isMissed = false;
        for (int colIx = 0; colIx < cached.colCount; ++colIx) {
            if (!includes[colIx]) continue;
            if (cStripe.encodings[colIx] == null || cStripe.data[colIx] == null) {
                if (cStripe.data[colIx] != null) {
                    throw new AssertionError(cStripe);
                }
                isMissed = true;
                if (gotAllData == null) continue;
                gotAllData.value = false;
                continue;
            }
            ((StripeData)stripe).encodings[colIx] = cStripe.encodings[colIx];
            LlapSerDeDataBuffer[][] cColData = cStripe.data[colIx];
            assert (cColData != null);
            block1: for (int streamIx = 0; cColData != null && streamIx < cColData.length; ++streamIx) {
                LlapSerDeDataBuffer[] streamData = cColData[streamIx];
                if (streamData == null) continue;
                for (int i = 0; i < streamData.length; ++i) {
                    if (this.lockBuffer(streamData[i], true)) continue;
                    LlapIoImpl.CACHE_LOGGER.info("Couldn't lock data for stripe at " + stripeIx + ", colIx " + colIx + ", stream type " + streamIx);
                    this.handleRemovedColumnData(cColData);
                    cColData = null;
                    isMissed = true;
                    if (gotAllData == null) continue block1;
                    gotAllData.value = false;
                    continue block1;
                }
            }
            ((StripeData)stripe).data[colIx] = cColData;
            if (cColData != null) continue;
            ((StripeData)stripe).encodings[colIx] = null;
        }
        this.doMetricsStuffForOneSlice(qfCounters, stripe, isMissed);
    }

    private void doMetricsStuffForOneSlice(LowLevelCacheCounters qfCounters, StripeData stripe, boolean isMissed) {
        long bytes = stripe.lastEnd - stripe.knownTornStart;
        this.metrics.incrCacheRequestedBytes(bytes);
        if (!isMissed) {
            this.metrics.incrCacheHitBytes(bytes);
        }
        if (qfCounters != null) {
            if (isMissed) {
                qfCounters.recordCacheMiss(bytes);
            } else {
                qfCounters.recordCacheHit(bytes);
            }
        }
    }

    private void markAllAsMissed(long from, long to, LowLevelCacheCounters qfCounters, DataCache.BooleanRef gotAllData) {
        if (qfCounters != null) {
            this.metrics.incrCacheRequestedBytes(to - from);
            qfCounters.recordCacheMiss(to - from);
        }
        if (gotAllData != null) {
            gotAllData.value = false;
        }
    }

    private boolean lockBuffer(LlapSerDeDataBuffer buffer, boolean doNotifyPolicy) {
        int rc = buffer.incRef();
        if (rc > 0) {
            this.metrics.incrCacheNumLockedBuffers();
        }
        if (doNotifyPolicy && rc == 1) {
            this.cachePolicy.notifyLock(buffer);
        }
        return rc > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFileData(final FileData data, LowLevelCache.Priority priority, LowLevelCacheCounters qfCounters, CacheTag tag) {
        if (data.stripes == null || data.stripes.isEmpty()) {
            LlapIoImpl.LOG.warn("Trying to cache FileData with no data for " + data.fileKey);
            return;
        }
        FileCache<FileData> subCache = null;
        FileData cached = null;
        data.rwLock.writeLock().lock();
        try {
            subCache = FileCache.getOrAddFileSubCache(this.cache, data.fileKey, new Function<Void, FileData>(){

                public FileData apply(Void input) {
                    return data;
                }
            });
            cached = subCache.getCache();
        }
        finally {
            if (data != cached) {
                data.rwLock.writeLock().unlock();
            }
        }
        try {
            if (data != cached) {
                cached.rwLock.writeLock().lock();
            }
            try {
                for (StripeData si : data.stripes) {
                    this.lockAllBuffersForPut(si, priority, tag);
                }
                if (data == cached) {
                    if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
                        LlapIoImpl.CACHE_LOGGER.trace("Cached new data " + data);
                    }
                    return;
                }
                if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
                    LlapIoImpl.CACHE_LOGGER.trace("Merging old " + cached + " and new " + data);
                }
                ArrayList combined = new ArrayList(cached.stripes.size() + data.stripes.size());
                combined.addAll(cached.stripes);
                combined.addAll(data.stripes);
                Collections.sort(combined, new StripeInfoComparator());
                int lastIx = combined.size() - 1;
                for (int ix = 0; ix < lastIx; ++ix) {
                    StripeData cur = (StripeData)combined.get(ix);
                    StripeData next = (StripeData)combined.get(ix + 1);
                    if (cur.lastEnd <= next.firstStart) continue;
                    if (cur.firstStart == next.firstStart && cur.lastEnd == next.lastEnd) {
                        this.mergeStripeInfos(cur, next);
                        combined.remove(ix + 1);
                        --lastIx;
                        continue;
                    }
                    boolean isCurOriginal = cached.stripes.contains(cur);
                    this.handleRemovedStripeInfo((StripeData)combined.remove(isCurOriginal ? ix : ix + 1));
                    --ix;
                    --lastIx;
                }
                cached.stripes = combined;
                if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
                    LlapIoImpl.CACHE_LOGGER.trace("New cache data is " + combined);
                }
            }
            finally {
                cached.rwLock.writeLock().unlock();
            }
        }
        finally {
            subCache.decRef();
        }
    }

    private void lockAllBuffersForPut(StripeData si, LowLevelCache.Priority priority, CacheTag tag) {
        for (int i = 0; i < si.data.length; ++i) {
            LlapSerDeDataBuffer[][] colData = si.data[i];
            if (colData == null) continue;
            for (int j = 0; j < colData.length; ++j) {
                LlapSerDeDataBuffer[] streamData = colData[j];
                if (streamData == null) continue;
                for (int k = 0; k < streamData.length; ++k) {
                    boolean canLock = this.lockBuffer(streamData[k], false);
                    assert (canLock);
                    streamData[k].setTag(tag);
                    this.cachePolicy.cache(streamData[k], priority);
                    streamData[k].isCached = true;
                }
            }
        }
    }

    private void handleRemovedStripeInfo(StripeData removed) {
        for (LlapSerDeDataBuffer[][] colData : removed.data) {
            this.handleRemovedColumnData(colData);
        }
    }

    private void handleRemovedColumnData(LlapSerDeDataBuffer[][] removed) {
    }

    private void mergeStripeInfos(StripeData to, StripeData from) {
        if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
            LlapIoImpl.CACHE_LOGGER.trace("Merging slices data: old " + to + " and new " + from);
        }
        to.knownTornStart = Math.min(to.knownTornStart, from.knownTornStart);
        if (from.encodings.length != to.encodings.length) {
            throw new RuntimeException("Different encodings " + from + "; " + to);
        }
        for (int colIx = 0; colIx < from.encodings.length; ++colIx) {
            if (to.encodings[colIx] == null) {
                ((StripeData)to).encodings[colIx] = from.encodings[colIx];
            } else if (from.encodings[colIx] != null && !to.encodings[colIx].equals((Object)from.encodings[colIx])) {
                throw new RuntimeException("Different encodings at " + colIx + ": " + from + "; " + to);
            }
            LlapSerDeDataBuffer[][] fromColData = from.data[colIx];
            if (fromColData == null) continue;
            if (to.data[colIx] != null) {
                this.handleRemovedColumnData(to.data[colIx]);
            }
            ((StripeData)to).data[colIx] = fromColData;
        }
    }

    @Override
    public void decRefBuffer(MemoryBuffer buffer) {
        this.unlockBuffer((LlapSerDeDataBuffer)buffer, true);
    }

    @Override
    public void decRefBuffers(List<MemoryBuffer> cacheBuffers) {
        for (MemoryBuffer b : cacheBuffers) {
            this.unlockBuffer((LlapSerDeDataBuffer)b, true);
        }
    }

    private void unlockBuffer(LlapSerDeDataBuffer buffer, boolean handleLastDecRef) {
        boolean isLastDecref;
        boolean bl = isLastDecref = buffer.decRef() == 0;
        if (handleLastDecRef && isLastDecref) {
            if (buffer.isCached) {
                this.cachePolicy.notifyUnlock(buffer);
            } else {
                if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
                    LlapIoImpl.CACHE_LOGGER.trace("Deallocating {} that was not cached", (Object)buffer);
                }
                this.allocator.deallocate((MemoryBuffer)buffer);
            }
        }
        this.metrics.decrCacheNumLockedBuffers();
    }

    public final void notifyEvicted(MemoryBuffer buffer) {
        this.newEvictions.incrementAndGet();
    }

    @Override
    public boolean incRefBuffer(MemoryBuffer buffer) {
        return this.lockBuffer((LlapSerDeDataBuffer)buffer, false);
    }

    @Override
    public Allocator getAllocator() {
        return this.allocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String debugDumpForOom() {
        StringBuilder sb = new StringBuilder("File cache state ");
        for (Map.Entry<Object, FileCache<FileData>> e : this.cache.entrySet()) {
            if (!e.getValue().incRef()) continue;
            try {
                sb.append("\n  file " + e.getKey());
                sb.append("\n    [");
                e.getValue().getCache().toString(sb);
                sb.append("]");
            }
            finally {
                e.getValue().decRef();
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void debugDumpShort(StringBuilder sb) {
        sb.append("\nSerDe cache state ");
        int allLocked = 0;
        int allUnlocked = 0;
        int allEvicted = 0;
        int allMoving = 0;
        for (Map.Entry<Object, FileCache<FileData>> e : this.cache.entrySet()) {
            if (!e.getValue().incRef()) continue;
            try {
                FileData fd = e.getValue().getCache();
                int fileLocked = 0;
                int fileUnlocked = 0;
                int fileEvicted = 0;
                int fileMoving = 0;
                for (StripeData stripe : fd.stripes) {
                    if (stripe.data == null) continue;
                    for (int i = 0; i < stripe.data.length; ++i) {
                        LlapSerDeDataBuffer[][] colData = stripe.data[i];
                        if (colData == null) continue;
                        for (int j = 0; j < colData.length; ++j) {
                            LlapSerDeDataBuffer[] streamData = colData[j];
                            if (streamData == null) continue;
                            for (int k = 0; k < streamData.length; ++k) {
                                int newRc = streamData[k].incRef();
                                if (newRc < 0) {
                                    if (newRc == -1) {
                                        ++fileEvicted;
                                        continue;
                                    }
                                    if (newRc != -2) continue;
                                    ++fileMoving;
                                    continue;
                                }
                                try {
                                    if (newRc > 1) {
                                        ++fileLocked;
                                        continue;
                                    }
                                    ++fileUnlocked;
                                    continue;
                                }
                                finally {
                                    streamData[k].decRef();
                                }
                            }
                        }
                    }
                }
                allLocked += fileLocked;
                allUnlocked += fileUnlocked;
                allEvicted += fileEvicted;
                allMoving += fileMoving;
                sb.append("\n  file " + e.getKey() + ": " + fileLocked + " locked, " + fileUnlocked + " unlocked, " + fileEvicted + " evicted, " + fileMoving + " being moved; ");
                sb.append(fd.colCount).append(" columns, ").append(fd.stripes.size()).append(" stripes");
            }
            finally {
                e.getValue().decRef();
            }
        }
        sb.append("\nSerDe cache summary: " + allLocked + " locked, " + allUnlocked + " unlocked, " + allEvicted + " evicted, " + allMoving + " being moved");
    }

    private final class CleanupThread
    extends FileCacheCleanupThread<FileData> {
        public CleanupThread(ConcurrentHashMap<Object, FileCache<FileData>> fileMap, AtomicInteger newEvictions, long cleanupInterval) {
            super("Llap serde low level cache cleanup thread", fileMap, newEvictions, cleanupInterval);
        }

        @Override
        protected int getCacheSize(FileCache<FileData> fc) {
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int cleanUpOneFileCache(FileCache<FileData> fc, int leftToCheck, long endTime, Ref<Boolean> isPastEndTime) throws InterruptedException {
            FileData fd = fc.getCache();
            fd.rwLock.writeLock().lock();
            try {
                for (StripeData sd : fd.stripes) {
                    for (int colIx = 0; colIx < sd.data.length; ++colIx) {
                        LlapSerDeDataBuffer[][] colData = sd.data[colIx];
                        if (colData == null) continue;
                        boolean hasAllData = true;
                        block5: for (int j = 0; j < colData.length && hasAllData; ++j) {
                            LlapSerDeDataBuffer[] streamData = colData[j];
                            if (streamData == null) continue;
                            for (int k = 0; k < streamData.length; ++k) {
                                LlapSerDeDataBuffer buf = streamData[k];
                                boolean bl = hasAllData = hasAllData && SerDeLowLevelCacheImpl.this.lockBuffer(buf, false);
                                if (!hasAllData) continue block5;
                                SerDeLowLevelCacheImpl.this.unlockBuffer(buf, true);
                            }
                        }
                        if (hasAllData) continue;
                        SerDeLowLevelCacheImpl.this.handleRemovedColumnData(colData);
                        ((StripeData)sd).data[colIx] = null;
                    }
                }
            }
            finally {
                fd.rwLock.writeLock().unlock();
            }
            return leftToCheck - 1;
        }
    }

    public static final class StripeData {
        private long knownTornStart;
        private final long firstStart;
        private final long lastStart;
        private final long lastEnd;
        private final long rowCount;
        private final OrcProto.ColumnEncoding[] encodings;
        private LlapSerDeDataBuffer[][][] data;

        public StripeData(long knownTornStart, long firstStart, long lastStart, long lastEnd, long rowCount, OrcProto.ColumnEncoding[] encodings) {
            this.knownTornStart = knownTornStart;
            this.firstStart = firstStart;
            this.lastStart = lastStart;
            this.lastEnd = lastEnd;
            this.encodings = encodings;
            this.rowCount = rowCount;
            this.data = encodings == null ? (LlapSerDeDataBuffer[][][])null : new LlapSerDeDataBuffer[encodings.length][][];
        }

        public String toString() {
            return this.toCoordinateString() + " with encodings [" + Arrays.toString(this.encodings).replace('\n', ' ') + "] and data " + SerDeLowLevelCacheImpl.toString(this.data);
        }

        public long getKnownTornStart() {
            return this.knownTornStart;
        }

        public long getFirstStart() {
            return this.firstStart;
        }

        public long getLastStart() {
            return this.lastStart;
        }

        public long getLastEnd() {
            return this.lastEnd;
        }

        public long getRowCount() {
            return this.rowCount;
        }

        public OrcProto.ColumnEncoding[] getEncodings() {
            return this.encodings;
        }

        public LlapSerDeDataBuffer[][][] getData() {
            return this.data;
        }

        public String toCoordinateString() {
            return "stripe kts " + this.knownTornStart + " from " + this.firstStart + " to [" + this.lastStart + ", " + this.lastEnd + ")";
        }

        public static StripeData duplicateStructure(StripeData s) {
            return new StripeData(s.knownTornStart, s.firstStart, s.lastStart, s.lastEnd, s.rowCount, new OrcProto.ColumnEncoding[s.encodings.length]);
        }

        public void setKnownTornStart(long value) {
            this.knownTornStart = value;
        }
    }

    public static class FileData {
        private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
        private final Object fileKey;
        private final int colCount;
        private ArrayList<StripeData> stripes;

        public FileData(Object fileKey, int colCount) {
            this.fileKey = fileKey;
            this.colCount = colCount;
        }

        public void toString(StringBuilder sb) {
            sb.append("File data for ").append(this.fileKey).append(" with ").append(this.colCount).append(" columns: ").append(this.stripes);
        }

        public int getColCount() {
            return this.colCount;
        }

        public ArrayList<StripeData> getData() {
            return this.stripes;
        }

        public void addStripe(StripeData sd) {
            if (this.stripes == null) {
                this.stripes = new ArrayList();
            }
            this.stripes.add(sd);
        }

        public String toString() {
            return "[fileKey=" + this.fileKey + ", colCount=" + this.colCount + ", stripes=" + this.stripes + "]";
        }
    }

    private static final class StripeInfoComparator
    implements Comparator<StripeData> {
        private StripeInfoComparator() {
        }

        @Override
        public int compare(StripeData o1, StripeData o2) {
            int starts = Long.compare(o1.knownTornStart, o2.knownTornStart);
            if (starts != 0) {
                return starts;
            }
            starts = Long.compare(o1.firstStart, o2.firstStart);
            if (starts != 0) {
                return starts;
            }
            assert (o1.lastStart == o2.lastStart == (o1.lastEnd == o2.lastEnd));
            return Long.compare(o1.lastStart, o2.lastStart);
        }
    }

    public static final class LlapSerDeDataBuffer
    extends LlapAllocatorBuffer {
        public boolean isCached = false;
        private CacheTag tag;

        @Override
        public void notifyEvicted(EvictionDispatcher evictionDispatcher) {
            evictionDispatcher.notifyEvicted(this);
        }

        public void setTag(CacheTag tag) {
            this.tag = tag;
        }

        @Override
        public CacheTag getTag() {
            return this.tag;
        }
    }
}

