/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.api.impl;

import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.common.io.CacheTag;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.io.FileMetadataCache;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cache.BuddyAllocator;
import org.apache.hadoop.hive.llap.cache.BufferUsageManager;
import org.apache.hadoop.hive.llap.cache.CacheContentsTracker;
import org.apache.hadoop.hive.llap.cache.EvictionDispatcher;
import org.apache.hadoop.hive.llap.cache.LlapDataBuffer;
import org.apache.hadoop.hive.llap.cache.LlapOomDebugDump;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.LowLevelCacheImpl;
import org.apache.hadoop.hive.llap.cache.LowLevelCacheMemoryManager;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.cache.LowLevelFifoCachePolicy;
import org.apache.hadoop.hive.llap.cache.LowLevelLrfuCachePolicy;
import org.apache.hadoop.hive.llap.cache.SerDeLowLevelCacheImpl;
import org.apache.hadoop.hive.llap.cache.SimpleAllocator;
import org.apache.hadoop.hive.llap.cache.SimpleBufferManager;
import org.apache.hadoop.hive.llap.daemon.impl.StatsRecordingThreadPool;
import org.apache.hadoop.hive.llap.io.api.LlapIo;
import org.apache.hadoop.hive.llap.io.api.impl.LlapInputFormat;
import org.apache.hadoop.hive.llap.io.decode.ColumnVectorProducer;
import org.apache.hadoop.hive.llap.io.decode.GenericColumnVectorProducer;
import org.apache.hadoop.hive.llap.io.decode.OrcColumnVectorProducer;
import org.apache.hadoop.hive.llap.io.encoded.OrcEncodedDataReader;
import org.apache.hadoop.hive.llap.io.metadata.MetadataCache;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheMetrics;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonIOMetrics;
import org.apache.hadoop.hive.llap.metrics.MetricsUtils;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.LlapCacheOnlyInputFormatInterface;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.encoded.IoTrace;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hive.common.util.FixedSizedObjectPool;
import org.apache.orc.impl.OrcTail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapIoImpl
implements LlapIo<VectorizedRowBatch> {
    public static final Logger LOG = LoggerFactory.getLogger((String)"LlapIoImpl");
    public static final Logger ORC_LOGGER = LoggerFactory.getLogger((String)"LlapIoOrc");
    public static final Logger CACHE_LOGGER = LoggerFactory.getLogger((String)"LlapIoCache");
    public static final Logger LOCKING_LOGGER = LoggerFactory.getLogger((String)"LlapIoLocking");
    private static final String MODE_CACHE = "cache";
    private final ColumnVectorProducer orcCvp;
    private final ColumnVectorProducer genericCvp;
    private final ExecutorService executor;
    private final LlapDaemonCacheMetrics cacheMetrics;
    private final LlapDaemonIOMetrics ioMetrics;
    private ObjectName buddyAllocatorMXBean;
    private final Allocator allocator;
    private final LlapOomDebugDump memoryDump;
    private final FileMetadataCache fileMetadataCache;
    private final LowLevelCache dataCache;
    private final BufferUsageManager bufferManager;
    private final Configuration daemonConf;
    private final LowLevelCacheMemoryManager memoryManager;

    /*
     * WARNING - void declaration
     */
    private LlapIoImpl(Configuration conf) throws IOException {
        void var11_17;
        boolean isEncodeEnabled;
        this.daemonConf = conf;
        String ioMode = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_MEMORY_MODE);
        boolean useLowLevelCache = MODE_CACHE.equalsIgnoreCase(ioMode);
        LOG.info("Initializing LLAP IO in {} mode", (Object)(useLowLevelCache ? MODE_CACHE : "none"));
        String displayName = "LlapDaemonCacheMetrics-" + MetricsUtils.getHostName();
        String sessionId = conf.get("llap.daemon.metrics.sessionid");
        this.cacheMetrics = LlapDaemonCacheMetrics.create(displayName, sessionId);
        displayName = "LlapDaemonIOMetrics-" + MetricsUtils.getHostName();
        Object[] strIntervals = HiveConf.getTrimmedStringsVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_DECODING_METRICS_PERCENTILE_INTERVALS);
        ArrayList<Integer> intervalList = new ArrayList<Integer>();
        if (strIntervals != null) {
            for (String string : strIntervals) {
                try {
                    intervalList.add(Integer.valueOf(string));
                }
                catch (NumberFormatException e) {
                    LOG.warn("Ignoring IO decoding metrics interval {} from {} as it is invalid", (Object)string, (Object)Arrays.toString(strIntervals));
                }
            }
        }
        this.ioMetrics = LlapDaemonIOMetrics.create(displayName, sessionId, Ints.toArray(intervalList));
        LOG.info("Started llap daemon metrics with displayName: {} sessionId: {}", (Object)displayName, (Object)sessionId);
        MetadataCache metadataCache = null;
        SerDeLowLevelCacheImpl serdeCache = null;
        LowLevelCache bufferManagerOrc = null;
        Object var11_14 = null;
        boolean bl = isEncodeEnabled = useLowLevelCache && HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_ENCODE_ENABLED);
        if (useLowLevelCache) {
            boolean useLrfu = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_USE_LRFU);
            long totalMemorySize = HiveConf.getSizeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_MEMORY_MAX_SIZE);
            int minAllocSize = (int)HiveConf.getSizeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ALLOCATOR_MIN_ALLOC);
            LowLevelCachePolicy cp = useLrfu ? new LowLevelLrfuCachePolicy(minAllocSize, totalMemorySize, conf) : new LowLevelFifoCachePolicy();
            boolean trackUsage = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_TRACK_CACHE_USAGE);
            LowLevelCachePolicy cachePolicyWrapper = trackUsage ? new CacheContentsTracker(cp) : cp;
            this.memoryManager = new LowLevelCacheMemoryManager(totalMemorySize, cachePolicyWrapper, this.cacheMetrics);
            this.cacheMetrics.setCacheCapacityTotal(totalMemorySize);
            BuddyAllocator allocator = new BuddyAllocator(conf, this.memoryManager, this.cacheMetrics);
            this.allocator = allocator;
            this.memoryDump = allocator;
            LowLevelCacheImpl cacheImpl = new LowLevelCacheImpl(this.cacheMetrics, cachePolicyWrapper, allocator, true);
            this.dataCache = cacheImpl;
            if (isEncodeEnabled) {
                SerDeLowLevelCacheImpl serdeCacheImpl;
                serdeCache = serdeCacheImpl = new SerDeLowLevelCacheImpl(this.cacheMetrics, cachePolicyWrapper, allocator);
            }
            boolean useGapCache = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_CACHE_ENABLE_ORC_GAP_CACHE);
            metadataCache = new MetadataCache(allocator, this.memoryManager, cachePolicyWrapper, useGapCache, this.cacheMetrics);
            this.fileMetadataCache = metadataCache;
            EvictionDispatcher e = new EvictionDispatcher(this.dataCache, serdeCache, metadataCache, allocator);
            cachePolicyWrapper.setEvictionListener(e);
            cachePolicyWrapper.setParentDebugDumper(e);
            cacheImpl.startThreads();
            bufferManagerOrc = cacheImpl;
            this.bufferManager = bufferManagerOrc;
            SerDeLowLevelCacheImpl serDeLowLevelCacheImpl = serdeCache;
        } else {
            SimpleBufferManager sbm;
            SimpleBufferManager simpleBufferManager;
            this.allocator = new SimpleAllocator(conf);
            this.memoryDump = null;
            this.fileMetadataCache = null;
            bufferManagerOrc = simpleBufferManager = (sbm = new SimpleBufferManager(this.allocator, this.cacheMetrics));
            this.bufferManager = simpleBufferManager;
            this.dataCache = sbm;
            this.memoryManager = null;
        }
        int numThreads = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_THREADPOOL_SIZE);
        this.executor = new StatsRecordingThreadPool(numThreads, numThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("IO-Elevator-Thread-%d").setDaemon(true).build());
        FixedSizedObjectPool tracePool = IoTrace.createTracePool((Configuration)conf);
        this.orcCvp = new OrcColumnVectorProducer(metadataCache, this.dataCache, (BufferUsageManager)((Object)bufferManagerOrc), conf, this.cacheMetrics, this.ioMetrics, (FixedSizedObjectPool<IoTrace>)tracePool);
        this.genericCvp = isEncodeEnabled ? new GenericColumnVectorProducer(serdeCache, (BufferUsageManager)var11_17, conf, this.cacheMetrics, this.ioMetrics, (FixedSizedObjectPool<IoTrace>)tracePool) : null;
        LOG.info("LLAP IO initialized");
        this.registerMXBeans();
    }

    private void registerMXBeans() {
        this.buddyAllocatorMXBean = MBeans.register((String)"LlapDaemon", (String)"BuddyAllocatorInfo", (Object)this.allocator);
    }

    public String getMemoryInfo() {
        if (this.memoryDump == null) {
            return "\nNot using the allocator";
        }
        StringBuilder sb = new StringBuilder();
        this.memoryDump.debugDumpShort(sb);
        return sb.toString();
    }

    public long purge() {
        if (this.memoryManager != null) {
            return this.memoryManager.purge();
        }
        return 0L;
    }

    public InputFormat<NullWritable, VectorizedRowBatch> getInputFormat(InputFormat<?, ?> sourceInputFormat, Deserializer sourceSerDe) {
        ColumnVectorProducer cvp = this.genericCvp;
        if (sourceInputFormat instanceof OrcInputFormat) {
            cvp = this.orcCvp;
        } else if (cvp == null) {
            LOG.warn("LLAP encode is disabled; cannot use for " + sourceInputFormat.getClass());
            return null;
        }
        return new LlapInputFormat(sourceInputFormat, sourceSerDe, cvp, this.executor, this.daemonConf);
    }

    public void close() {
        LOG.info("Closing LlapIoImpl..");
        if (this.buddyAllocatorMXBean != null) {
            MBeans.unregister((ObjectName)this.buddyAllocatorMXBean);
            this.buddyAllocatorMXBean = null;
        }
        this.executor.shutdownNow();
    }

    public void initCacheOnlyInputFormat(InputFormat<?, ?> inputFormat) {
        LlapCacheOnlyInputFormatInterface cacheIf = (LlapCacheOnlyInputFormatInterface)inputFormat;
        cacheIf.injectCaches(this.fileMetadataCache, (DataCache)new GenericDataCache(this.dataCache, this.bufferManager), this.daemonConf);
    }

    public OrcTail getOrcTailFromCache(Path path, Configuration jobConf, CacheTag tag) throws IOException {
        return OrcEncodedDataReader.getOrcTailForPath(path, jobConf, tag, this.daemonConf, (MetadataCache)this.fileMetadataCache);
    }

    private class GenericDataCache
    implements DataCache,
    Allocator.BufferObjectFactory {
        private final LowLevelCache lowLevelCache;
        private final BufferUsageManager bufferManager;

        public GenericDataCache(LowLevelCache lowLevelCache, BufferUsageManager bufferManager) {
            this.lowLevelCache = lowLevelCache;
            this.bufferManager = bufferManager;
        }

        public DiskRangeList getFileData(Object fileKey, DiskRangeList range, long baseOffset, DataCache.DiskRangeListFactory factory, DataCache.BooleanRef gotAllData) {
            return this.lowLevelCache.getFileData(fileKey, range, baseOffset, factory, null, gotAllData);
        }

        public long[] putFileData(Object fileKey, DiskRange[] ranges, MemoryBuffer[] data, long baseOffset) {
            return this.putFileData(fileKey, ranges, data, baseOffset, null);
        }

        public long[] putFileData(Object fileKey, DiskRange[] ranges, MemoryBuffer[] data, long baseOffset, CacheTag tag) {
            return this.lowLevelCache.putFileData(fileKey, ranges, data, baseOffset, LowLevelCache.Priority.NORMAL, null, tag);
        }

        public void releaseBuffer(MemoryBuffer buffer) {
            this.bufferManager.decRefBuffer(buffer);
        }

        public void reuseBuffer(MemoryBuffer buffer) {
            boolean isReused = this.bufferManager.incRefBuffer(buffer);
            assert (isReused);
        }

        public Allocator getAllocator() {
            return this.bufferManager.getAllocator();
        }

        public Allocator.BufferObjectFactory getDataBufferFactory() {
            return this;
        }

        public MemoryBuffer create() {
            return new LlapDataBuffer();
        }
    }
}

