/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import org.apache.hadoop.hive.common.io.CacheTag;
import org.apache.hadoop.hive.llap.cache.EvictionDispatcher;

public abstract class LlapCacheableBuffer {
    protected static final int IN_LIST = -2;
    protected static final int NOT_IN_CACHE = -1;
    public double priority;
    public long lastUpdate = -1L;
    public LlapCacheableBuffer prev = null;
    public LlapCacheableBuffer next = null;
    public int indexInHeap = -1;
    public static final int INVALIDATE_OK = 0;
    public static final int INVALIDATE_FAILED = 1;
    public static final int INVALIDATE_ALREADY_INVALID = 2;

    protected abstract int invalidate();

    public abstract long getMemoryUsage();

    public abstract void notifyEvicted(EvictionDispatcher var1);

    public String toString() {
        return "0x" + Integer.toHexString(System.identityHashCode(this));
    }

    public String toStringForCache() {
        return "[" + Integer.toHexString(this.hashCode()) + " " + String.format("%1$.2f", this.priority) + " " + this.lastUpdate + " " + (this.isLocked() ? "!" : ".") + "]";
    }

    public abstract CacheTag getTag();

    protected abstract boolean isLocked();
}

