/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cli.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cli.service.LlapServiceCommandLine;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AsyncTaskCopyAuxJars
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger((String)AsyncTaskCopyAuxJars.class.getName());
    private static final String[] DEFAULT_AUX_CLASSES = new String[]{"org.apache.hive.hcatalog.data.JsonSerDe", "org.apache.hadoop.hive.druid.DruidStorageHandler", "org.apache.hive.storage.jdbc.JdbcStorageHandler", "org.apache.commons.dbcp.BasicDataSourceFactory", "org.apache.commons.pool.impl.GenericObjectPool", "org.apache.hadoop.hive.kafka.KafkaStorageHandler", "org.apache.hadoop.hive.kudu.KuduStorageHandler"};
    private static final String HBASE_SERDE_CLASS = "org.apache.hadoop.hive.hbase.HBaseSerDe";
    private final LlapServiceCommandLine cl;
    private final HiveConf conf;
    private final FileSystem rawFs;
    private final Path libDir;

    AsyncTaskCopyAuxJars(LlapServiceCommandLine cl, HiveConf conf, FileSystem rawFs, Path libDir) {
        this.cl = cl;
        this.conf = conf;
        this.rawFs = rawFs;
        this.libDir = libDir;
    }

    @Override
    public Void call() throws Exception {
        this.localizeJarForClass(Arrays.asList(DEFAULT_AUX_CLASSES), false);
        this.localizeJarForClass(this.conf.getStringCollection("io.compression.codecs"), false);
        this.localizeJarForClass(this.getDbSpecificJdbcJars(), false);
        if (this.cl.getIsHBase()) {
            try {
                this.localizeJarForClass(Arrays.asList(HBASE_SERDE_CLASS), true);
                Job fakeJob = Job.getInstance((Configuration)new JobConf());
                TableMapReduceUtil.addDependencyJars((Job)fakeJob);
                Collection hbaseJars = fakeJob.getConfiguration().getStringCollection("tmpjars");
                for (String jarPath : hbaseJars) {
                    if (jarPath.isEmpty()) continue;
                    this.rawFs.copyFromLocalFile(new Path(jarPath), this.libDir);
                }
            }
            catch (Throwable t) {
                String err = "Failed to add HBase jars. Use --auxhbase=false to avoid localizing them";
                LOG.error(err);
                System.err.println(err);
                throw new RuntimeException(t);
            }
        }
        HashSet<String> auxJars = new HashSet<String>();
        if (this.cl.getIsHiveAux()) {
            this.addAuxJarsToSet(auxJars, this.conf.getAuxJars(), ",");
            this.addAuxJarsToSet(auxJars, System.getenv("HIVE_AUX_JARS_PATH"), ":");
            LOG.info("Adding the following aux jars from the environment and configs: " + auxJars);
        }
        this.addAuxJarsToSet(auxJars, this.cl.getAuxJars(), ",");
        for (String jarPath : auxJars) {
            this.rawFs.copyFromLocalFile(new Path(jarPath), this.libDir);
        }
        return null;
    }

    private void localizeJarForClass(Collection<String> classNames, boolean doThrow) throws IOException {
        if (CollectionUtils.isEmpty(classNames)) {
            return;
        }
        for (String className : classNames) {
            String jarPath = null;
            boolean hasException = false;
            try {
                Class<?> clazz = Class.forName(className);
                jarPath = Utilities.jarFinderGetJar(clazz);
            }
            catch (Throwable t) {
                if (doThrow) {
                    throw t instanceof IOException ? (IOException)t : new IOException(t);
                }
                hasException = true;
                String err = "Cannot find a jar for [" + className + "] due to an exception (" + t.getMessage() + "); not packaging the jar";
                LOG.error(err);
                System.err.println(err);
            }
            if (jarPath != null) {
                this.rawFs.copyFromLocalFile(new Path(jarPath), this.libDir);
                continue;
            }
            if (hasException) continue;
            String err = "Cannot find a jar for [" + className + "]; not packaging the jar";
            if (doThrow) {
                throw new IOException(err);
            }
            LOG.error(err);
            System.err.println(err);
        }
    }

    private List<String> getDbSpecificJdbcJars() {
        ArrayList<String> jdbcJars = new ArrayList<String>();
        this.addJarForClassToListIfExists("com.mysql.jdbc.Driver", jdbcJars);
        this.addJarForClassToListIfExists("org.postgresql.Driver", jdbcJars);
        this.addJarForClassToListIfExists("oracle.jdbc.OracleDriver", jdbcJars);
        this.addJarForClassToListIfExists("com.microsoft.sqlserver.jdbc.SQLServerDriver", jdbcJars);
        return jdbcJars;
    }

    private void addJarForClassToListIfExists(String cls, List<String> jarList) {
        try {
            Class.forName(cls);
            jarList.add(cls);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addAuxJarsToSet(Set<String> auxJarSet, String auxJars, String delimiter) {
        if (StringUtils.isNotEmpty((CharSequence)auxJars)) {
            String[] jarPaths;
            for (String jarPath : jarPaths = auxJars.split(delimiter)) {
                if (jarPath.isEmpty()) continue;
                auxJarSet.add(jarPath);
            }
        }
    }
}

