/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import javax.jdo.Transaction;
import javax.jdo.datastore.JDOConnection;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.AggregateStatsCache;
import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.IExtrapolatePartStatus;
import org.apache.hadoop.hive.metastore.LinearExtrapolatePartStatus;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.MetastoreDirectSqlUtils;
import org.apache.hadoop.hive.metastore.PartitionProjectionEvaluator;
import org.apache.hadoop.hive.metastore.StatObjectConverter;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.GetPartitionsFilterSpec;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.model.MDatabase;
import org.apache.hadoop.hive.metastore.model.MPartitionColumnPrivilege;
import org.apache.hadoop.hive.metastore.model.MPartitionColumnStatistics;
import org.apache.hadoop.hive.metastore.model.MPartitionPrivilege;
import org.apache.hadoop.hive.metastore.model.MTableColumnStatistics;
import org.apache.hadoop.hive.metastore.parser.ExpressionTree;
import org.apache.hadoop.hive.serde.serdeConstants;
import org.apache.hive.common.util.BloomFilter;
import org.datanucleus.store.rdbms.query.ForwardQueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetaStoreDirectSql {
    private static final int NO_BATCHING = -1;
    private static final int DETECT_BATCHING = 0;
    private static final Logger LOG = LoggerFactory.getLogger(MetaStoreDirectSql.class);
    private final PersistenceManager pm;
    private final DB dbType;
    private final int batchSize;
    private final boolean convertMapNullsToEmptyStrings;
    private final String defaultPartName;
    @TableName
    private String DBS;
    @TableName
    private String TBLS;
    @TableName
    private String PARTITIONS;
    @TableName
    private String DATABASE_PARAMS;
    @TableName
    private String PARTITION_PARAMS;
    @TableName
    private String SORT_COLS;
    @TableName
    private String SD_PARAMS;
    @TableName
    private String SDS;
    @TableName
    private String SERDES;
    @TableName
    private String SKEWED_STRING_LIST_VALUES;
    @TableName
    private String SKEWED_VALUES;
    @TableName
    private String BUCKETING_COLS;
    @TableName
    private String SKEWED_COL_NAMES;
    @TableName
    private String SKEWED_COL_VALUE_LOC_MAP;
    @TableName
    private String COLUMNS_V2;
    @TableName
    private String PARTITION_KEYS;
    @TableName
    private String SERDE_PARAMS;
    @TableName
    private String PART_COL_STATS;
    @TableName
    private String KEY_CONSTRAINTS;
    @TableName
    private String TAB_COL_STATS;
    @TableName
    private String PARTITION_KEY_VALS;
    @TableName
    private String PART_PRIVS;
    @TableName
    private String PART_COL_PRIVS;
    @TableName
    private String SKEWED_STRING_LIST;
    @TableName
    private String CDS;
    private final boolean isCompatibleDatastore;
    private final boolean isAggregateStatsCacheEnabled;
    private final ImmutableMap<String, String> fieldnameToTableName;
    private AggregateStatsCache aggrStatsCache;
    private static final String STATS_COLLIST = "\"COLUMN_NAME\", \"COLUMN_TYPE\", \"LONG_LOW_VALUE\", \"LONG_HIGH_VALUE\", \"DOUBLE_LOW_VALUE\", \"DOUBLE_HIGH_VALUE\", \"BIG_DECIMAL_LOW_VALUE\", \"BIG_DECIMAL_HIGH_VALUE\", \"NUM_NULLS\", \"NUM_DISTINCTS\", \"AVG_COL_LEN\", \"MAX_COL_LEN\", \"NUM_TRUES\", \"NUM_FALSES\", \"LAST_ANALYZED\" ";

    public static <T> String getIdListForIn(List<T> objectIds) throws MetaException {
        return objectIds.stream().map(i -> i.toString()).collect(Collectors.joining(","));
    }

    public MetaStoreDirectSql(PersistenceManager pm, Configuration conf, String schema) {
        this.pm = pm;
        this.dbType = this.determineDbType();
        int batchSize = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_DIRECT_SQL_PARTITION_BATCH_SIZE);
        if (batchSize == 0) {
            batchSize = this.dbType == DB.ORACLE || this.dbType == DB.MSSQL ? 1000 : -1;
        }
        this.batchSize = batchSize;
        ImmutableMap.Builder fieldNameToTableNameBuilder = new ImmutableMap.Builder();
        for (Field f : this.getClass().getDeclaredFields()) {
            if (f.getAnnotation(TableName.class) == null) continue;
            try {
                String value = MetaStoreDirectSql.getFullyQualifiedName(schema, f.getName());
                f.set(this, value);
                fieldNameToTableNameBuilder.put((Object)f.getName(), (Object)value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException("Internal error, cannot set " + f.getName());
            }
        }
        this.convertMapNullsToEmptyStrings = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_ORM_RETRIEVE_MAPNULLS_AS_EMPTY_STRINGS);
        this.defaultPartName = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.DEFAULTPARTITIONNAME);
        String jdoIdFactory = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_IDENTIFIER_FACTORY);
        if (!"datanucleus1".equalsIgnoreCase(jdoIdFactory)) {
            LOG.warn("Underlying metastore does not use 'datanuclues1' for its ORM naming scheme. Disabling directSQL as it uses hand-hardcoded SQL with that assumption.");
            this.isCompatibleDatastore = false;
        } else {
            boolean isInTest = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_IN_TEST);
            boolean bl = this.isCompatibleDatastore = (!isInTest || this.ensureDbInit()) && this.runTestQuery();
            if (this.isCompatibleDatastore) {
                LOG.debug("Using direct SQL, underlying DB is " + (Object)((Object)this.dbType));
            }
        }
        this.isAggregateStatsCacheEnabled = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_AGGREGATE_STATS_CACHE_ENABLED);
        if (this.isAggregateStatsCacheEnabled) {
            this.aggrStatsCache = AggregateStatsCache.getInstance(conf);
        }
        this.fieldnameToTableName = fieldNameToTableNameBuilder.put((Object)"createTime", (Object)(this.PARTITIONS + ".\"CREATE_TIME\"")).put((Object)"lastAccessTime", (Object)(this.PARTITIONS + ".\"LAST_ACCESS_TIME\"")).put((Object)"writeId", (Object)(this.PARTITIONS + ".\"WRITE_ID\"")).put((Object)"sd.location", (Object)(this.SDS + ".\"LOCATION\"")).put((Object)"sd.inputFormat", (Object)(this.SDS + ".\"INPUT_FORMAT\"")).put((Object)"sd.outputFormat", (Object)(this.SDS + ".\"OUTPUT_FORMAT\"")).put((Object)"sd.storedAsSubDirectories", (Object)(this.SDS + ".\"IS_STOREDASSUBDIRECTORIES\"")).put((Object)"sd.compressed", (Object)(this.SDS + ".\"IS_COMPRESSED\"")).put((Object)"sd.numBuckets", (Object)(this.SDS + ".\"NUM_BUCKETS\"")).put((Object)"sd.serdeInfo.name", (Object)(this.SERDES + ".\"NAME\"")).put((Object)"sd.serdeInfo.serializationLib", (Object)(this.SERDES + ".\"SLIB\"")).put((Object)"PART_ID", (Object)(this.PARTITIONS + ".\"PART_ID\"")).put((Object)"SD_ID", (Object)(this.SDS + ".\"SD_ID\"")).put((Object)"SERDE_ID", (Object)(this.SERDES + ".\"SERDE_ID\"")).put((Object)"CD_ID", (Object)(this.SDS + ".\"CD_ID\"")).build();
    }

    private static String getFullyQualifiedName(String schema, String tblName) {
        return (schema == null || schema.isEmpty() ? "" : "\"" + schema + "\".\"") + "\"" + tblName + "\"";
    }

    private DB determineDbType() {
        DB dbType = DB.OTHER;
        String productName = this.getProductName();
        if (productName != null) {
            if ((productName = productName.toLowerCase()).contains("mysql")) {
                dbType = DB.MYSQL;
            } else if (productName.contains("oracle")) {
                dbType = DB.ORACLE;
            } else if (productName.contains("microsoft sql server")) {
                dbType = DB.MSSQL;
            } else if (productName.contains("derby")) {
                dbType = DB.DERBY;
            } else if (productName.contains("postgresql")) {
                dbType = DB.POSTGRES;
            }
        }
        return dbType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProductName() {
        try (JDOConnection jdoConn = this.pm.getDataStoreConnection();){
            String string = ((Connection)jdoConn.getNativeConnection()).getMetaData().getDatabaseProductName();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureDbInit() {
        Transaction tx = this.pm.currentTransaction();
        boolean doCommit = false;
        if (!tx.isActive()) {
            tx.begin();
            doCommit = true;
        }
        Query dbQuery = null;
        Query tblColumnQuery = null;
        Query partColumnQuery = null;
        Query partPrivQuery = null;
        Query partColumnPrivQuery = null;
        try {
            dbQuery = this.pm.newQuery(MDatabase.class, "name == ''");
            dbQuery.execute();
            tblColumnQuery = this.pm.newQuery(MTableColumnStatistics.class, "dbName == ''");
            tblColumnQuery.execute();
            partColumnQuery = this.pm.newQuery(MPartitionColumnStatistics.class, "dbName == ''");
            partColumnQuery.execute();
            partPrivQuery = this.pm.newQuery(MPartitionPrivilege.class, "principalName == ''");
            partPrivQuery.execute();
            partColumnPrivQuery = this.pm.newQuery(MPartitionColumnPrivilege.class, "principalName == ''");
            partColumnPrivQuery.execute();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            doCommit = false;
            LOG.warn("Database initialization failed; direct SQL is disabled", (Throwable)ex);
            tx.rollback();
            boolean bl = false;
            return bl;
        }
        finally {
            if (doCommit) {
                tx.commit();
            }
            if (dbQuery != null) {
                dbQuery.closeAll();
            }
            if (tblColumnQuery != null) {
                tblColumnQuery.closeAll();
            }
            if (partColumnQuery != null) {
                partColumnQuery.closeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runTestQuery() {
        Transaction tx = this.pm.currentTransaction();
        boolean doCommit = false;
        if (!tx.isActive()) {
            tx.begin();
            doCommit = true;
        }
        Query query = null;
        String selfTestQuery = "select \"DB_ID\" from \"DBS\"";
        try {
            this.prepareTxn();
            query = this.pm.newQuery("javax.jdo.query.SQL", (Object)selfTestQuery);
            query.execute();
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            doCommit = false;
            LOG.warn("Self-test query [" + selfTestQuery + "] failed; direct SQL is disabled", t);
            tx.rollback();
            boolean bl = false;
            return bl;
        }
        finally {
            if (doCommit) {
                tx.commit();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    public boolean isCompatibleDatastore() {
        return this.isCompatibleDatastore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeNoResult(String queryText) throws SQLException {
        JDOConnection jdoConn = this.pm.getDataStoreConnection();
        Statement statement = null;
        boolean doTrace = LOG.isDebugEnabled();
        try {
            long start = doTrace ? System.nanoTime() : 0L;
            statement = ((Connection)jdoConn.getNativeConnection()).createStatement();
            statement.execute(queryText);
            MetastoreDirectSqlUtils.timingTrace(doTrace, queryText, start, doTrace ? System.nanoTime() : 0L);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            jdoConn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database getDatabase(String dbName) throws MetaException {
        Query queryDbSelector = null;
        Query queryDbParams = null;
        try {
            List sqlResult;
            dbName = dbName.toLowerCase();
            String queryTextDbSelector = "select \"DB_ID\", \"NAME\", \"DB_LOCATION_URI\", \"DESC\", \"OWNER_NAME\", \"OWNER_TYPE\" , \"CREATE_TIME\"FROM \"DBS\" where \"NAME\" = ? ";
            Object[] params = new Object[]{dbName};
            queryDbSelector = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryTextDbSelector);
            if (LOG.isTraceEnabled()) {
                LOG.trace("getDatabase:query instantiated : " + queryTextDbSelector + " with param [" + params[0] + "]");
            }
            if ((sqlResult = (List)this.executeWithArray(queryDbSelector, params, queryTextDbSelector)) == null || sqlResult.isEmpty()) {
                Database database = null;
                return database;
            }
            assert (sqlResult.size() == 1);
            if (sqlResult.get(0) == null) {
                Database database = null;
                return database;
            }
            Object[] dbline = (Object[])sqlResult.get(0);
            Long dbid = MetastoreDirectSqlUtils.extractSqlLong(dbline[0]);
            String queryTextDbParams = "select \"PARAM_KEY\", \"PARAM_VALUE\"  FROM \"DATABASE_PARAMS\"  WHERE \"DB_ID\" = ?  AND \"PARAM_KEY\" IS NOT NULL";
            params[0] = dbid;
            queryDbParams = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryTextDbParams);
            if (LOG.isTraceEnabled()) {
                LOG.trace("getDatabase:query2 instantiated : " + queryTextDbParams + " with param [" + params[0] + "]");
            }
            HashMap<String, String> dbParams = new HashMap<String, String>();
            List<Object[]> sqlResult2 = MetastoreDirectSqlUtils.ensureList(this.executeWithArray(queryDbParams, params, queryTextDbParams));
            if (!sqlResult2.isEmpty()) {
                for (Object[] line : sqlResult2) {
                    dbParams.put(MetastoreDirectSqlUtils.extractSqlString(line[0]), MetastoreDirectSqlUtils.extractSqlString(line[1]));
                }
            }
            Database db = new Database();
            db.setName(MetastoreDirectSqlUtils.extractSqlString(dbline[1]));
            db.setLocationUri(MetastoreDirectSqlUtils.extractSqlString(dbline[2]));
            db.setDescription(MetastoreDirectSqlUtils.extractSqlString(dbline[3]));
            db.setOwnerName(MetastoreDirectSqlUtils.extractSqlString(dbline[4]));
            String type = MetastoreDirectSqlUtils.extractSqlString(dbline[5]);
            db.setOwnerType(null == type || type.trim().isEmpty() ? null : PrincipalType.valueOf(type));
            db.setCreateTime(MetastoreDirectSqlUtils.extractSqlInt(dbline[6]));
            db.setParameters(MetaStoreUtils.trimMapNulls(dbParams, this.convertMapNullsToEmptyStrings));
            if (LOG.isDebugEnabled()) {
                LOG.debug("getDatabase: directsql returning db " + db.getName() + " locn[" + db.getLocationUri() + "] desc [" + db.getDescription() + "] owner [" + db.getOwnerName() + "] ownertype [" + (Object)((Object)db.getOwnerType()) + "]");
            }
            Database database = db;
            return database;
        }
        finally {
            if (queryDbSelector != null) {
                queryDbSelector.closeAll();
            }
            if (queryDbParams != null) {
                queryDbParams.closeAll();
            }
        }
    }

    public List<Partition> getPartitionsViaSqlFilter(final String dbName, final String tblName, List<String> partNames) throws MetaException {
        if (partNames.isEmpty()) {
            return Collections.emptyList();
        }
        return this.runBatched(partNames, new Batchable<String, Partition>(){

            @Override
            public List<Partition> run(List<String> input) throws MetaException {
                String filter = "\"PARTITIONS\".\"PART_NAME\" in (" + MetaStoreDirectSql.this.makeParams(input.size()) + ")";
                List partitionIds = MetaStoreDirectSql.this.getPartitionIdsViaSqlFilter(dbName, tblName, filter, input, Collections.emptyList(), null);
                if (partitionIds.isEmpty()) {
                    return Collections.emptyList();
                }
                return MetaStoreDirectSql.this.getPartitionsFromPartitionIds(dbName, tblName, null, partitionIds);
            }
        });
    }

    public List<Partition> getPartitionsViaSqlFilter(final SqlFilterForPushdown filter, Integer max) throws MetaException {
        final Boolean isViewTable = MetaStoreDirectSql.isViewTable(filter.table);
        List<Long> partitionIds = this.getPartitionIdsViaSqlFilter(filter.table.getDbName(), filter.table.getTableName(), filter.filter, filter.params, filter.joins, max);
        if (partitionIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.runBatched(partitionIds, new Batchable<Long, Partition>(){

            @Override
            public List<Partition> run(List<Long> input) throws MetaException {
                return MetaStoreDirectSql.this.getPartitionsFromPartitionIds(filter.table.getDbName(), filter.table.getTableName(), isViewTable, input);
            }
        });
    }

    public boolean generateSqlFilterForPushdown(Table table, ExpressionTree tree, SqlFilterForPushdown result) throws MetaException {
        boolean dbHasJoinCastBug = this.dbType == DB.DERBY || this.dbType == DB.ORACLE || this.dbType == DB.POSTGRES;
        result.table = table;
        result.filter = PartitionFilterGenerator.generateSqlFilter(table, tree, result.params, result.joins, dbHasJoinCastBug, this.defaultPartName, this.dbType);
        return result.filter != null;
    }

    public List<Partition> getPartitions(final String dbName, final String tblName, Integer max) throws MetaException {
        List<Long> partitionIds = this.getPartitionIdsViaSqlFilter(dbName, tblName, null, Collections.emptyList(), Collections.emptyList(), max);
        if (partitionIds.isEmpty()) {
            return Collections.emptyList();
        }
        List<Partition> result = this.runBatched(partitionIds, new Batchable<Long, Partition>(){

            @Override
            public List<Partition> run(List<Long> input) throws MetaException {
                return MetaStoreDirectSql.this.getPartitionsFromPartitionIds(dbName, tblName, null, input);
            }
        });
        return result;
    }

    private static Boolean isViewTable(Table t) {
        return t.isSetTableType() ? Boolean.valueOf(t.getTableType().equals(TableType.VIRTUAL_VIEW.toString())) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isViewTable(String dbName, String tblName) throws MetaException {
        Query query = null;
        try {
            String queryText = "select \"TBL_TYPE\" from \"TBLS\" inner join \"DBS\" on \"TBLS\".\"DB_ID\" = \"DBS\".\"DB_ID\"  where \"TBLS\".\"TBL_NAME\" = ? and \"DBS\".\"NAME\" = ?";
            Object[] params = new Object[]{tblName, dbName};
            query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
            query.setUnique(true);
            Object result = this.executeWithArray(query, params, queryText);
            boolean bl = result != null && result.toString().equals(TableType.VIRTUAL_VIEW.toString());
            return bl;
        }
        finally {
            if (query != null) {
                query.closeAll();
            }
        }
    }

    private List<Long> getPartitionIdsViaSqlFilter(String dbName, String tblName, String sqlFilter, List<? extends Object> paramsForFilter, List<String> joinsForFilter, Integer max) throws MetaException {
        boolean doTrace = LOG.isDebugEnabled();
        String dbNameLcase = dbName.toLowerCase();
        String tblNameLcase = tblName.toLowerCase();
        String orderForFilter = max != null ? " order by \"PART_NAME\" asc" : "";
        String queryText = "select \"PARTITIONS\".\"PART_ID\" from \"PARTITIONS\"  inner join \"TBLS\" on \"PARTITIONS\".\"TBL_ID\" = \"TBLS\".\"TBL_ID\"     and \"TBLS\".\"TBL_NAME\" = ?   inner join \"DBS\" on \"TBLS\".\"DB_ID\" = \"DBS\".\"DB_ID\"      and \"DBS\".\"NAME\" = ? " + StringUtils.join(joinsForFilter, (char)' ') + (StringUtils.isBlank((String)sqlFilter) ? "" : " where " + sqlFilter) + orderForFilter;
        Object[] params = new Object[paramsForFilter.size() + 2];
        params[0] = tblNameLcase;
        params[1] = dbNameLcase;
        for (int i = 0; i < paramsForFilter.size(); ++i) {
            params[i + 2] = paramsForFilter.get(i);
        }
        long start = doTrace ? System.nanoTime() : 0L;
        Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        if (max != null) {
            query.setRange(0L, (long)max.shortValue());
        }
        List sqlResult = (List)this.executeWithArray(query, params, queryText);
        long queryTime = doTrace ? System.nanoTime() : 0L;
        MetastoreDirectSqlUtils.timingTrace(doTrace, queryText, start, queryTime);
        if (sqlResult.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Long> result = new ArrayList<Long>(sqlResult.size());
        for (Object fields : sqlResult) {
            result.add(MetastoreDirectSqlUtils.extractSqlLong(fields));
        }
        query.closeAll();
        return result;
    }

    public List<Partition> getPartitionsUsingProjectionAndFilterSpec(Table tbl, List<String> partitionFields, String includeParamKeyPattern, String excludeParamKeyPattern, GetPartitionsFilterSpec filterSpec, SqlFilterForPushdown filter) throws MetaException {
        String tblName = tbl.getTableName();
        String dbName = tbl.getDbName();
        List<Long> partitionIds = null;
        if (filterSpec.isSetFilterMode()) {
            List<String> filters = filterSpec.getFilters();
            if (filters == null || filters.isEmpty()) {
                throw new MetaException("Invalid filter expressions in the filter spec");
            }
            switch (filterSpec.getFilterMode()) {
                case BY_EXPR: {
                    partitionIds = this.getPartitionIdsViaSqlFilter(dbName, tblName, filter.filter, filter.params, filter.joins, null);
                    break;
                }
                case BY_NAMES: {
                    String partNamesFilter = "" + this.PARTITIONS + ".\"PART_NAME\" in (" + this.makeParams(filterSpec.getFilters().size()) + ")";
                    partitionIds = this.getPartitionIdsViaSqlFilter(dbName, tblName, partNamesFilter, filterSpec.getFilters(), Collections.EMPTY_LIST, null);
                    break;
                }
                case BY_VALUES: {
                    String partNameMatcher = MetaStoreUtils.makePartNameMatcher(tbl, filters, "_%");
                    String partNamesLikeFilter = "" + this.PARTITIONS + ".\"PART_NAME\" LIKE (?)";
                    partitionIds = this.getPartitionIdsViaSqlFilter(dbName, tblName, partNamesLikeFilter, Arrays.asList(partNameMatcher), Collections.EMPTY_LIST, null);
                    break;
                }
                default: {
                    throw new MetaException("Unsupported filter mode " + (Object)((Object)filterSpec.getFilterMode()));
                }
            }
        } else {
            partitionIds = this.getPartitionIdsViaSqlFilter(dbName, tblName, null, Collections.EMPTY_LIST, Collections.EMPTY_LIST, null);
        }
        if (partitionIds.isEmpty()) {
            return Collections.emptyList();
        }
        Boolean isView = MetaStoreDirectSql.isViewTable(tbl);
        if (isView == null) {
            isView = this.isViewTable(dbName, tblName);
        }
        final PartitionProjectionEvaluator projectionEvaluator = new PartitionProjectionEvaluator(this.pm, this.fieldnameToTableName, partitionFields, this.convertMapNullsToEmptyStrings, isView, includeParamKeyPattern, excludeParamKeyPattern);
        return this.runBatched(partitionIds, new Batchable<Long, Partition>(){

            @Override
            public List<Partition> run(List<Long> input) throws MetaException {
                return projectionEvaluator.getPartitionsUsingProjectionList(input);
            }
        });
    }

    private List<Partition> getPartitionsFromPartitionIds(String dbName, String tblName, Boolean isView, List<Long> partIdList) throws MetaException {
        boolean doTrace = LOG.isDebugEnabled();
        int idStringWidth = (int)Math.ceil(Math.log10(partIdList.size())) + 1;
        int sbCapacity = partIdList.size() * idStringWidth;
        String partIds = MetaStoreDirectSql.getIdListForIn(partIdList);
        String queryText = "select \"PARTITIONS\".\"PART_ID\", \"SDS\".\"SD_ID\", \"SDS\".\"CD_ID\", \"SERDES\".\"SERDE_ID\", \"PARTITIONS\".\"CREATE_TIME\", \"PARTITIONS\".\"LAST_ACCESS_TIME\", \"SDS\".\"INPUT_FORMAT\", \"SDS\".\"IS_COMPRESSED\", \"SDS\".\"IS_STOREDASSUBDIRECTORIES\", \"SDS\".\"LOCATION\", \"SDS\".\"NUM_BUCKETS\", \"SDS\".\"OUTPUT_FORMAT\", \"SERDES\".\"NAME\", \"SERDES\".\"SLIB\" from \"PARTITIONS\"  left outer join \"SDS\" on \"PARTITIONS\".\"SD_ID\" = \"SDS\".\"SD_ID\"   left outer join \"SERDES\" on \"SDS\".\"SERDE_ID\" = \"SERDES\".\"SERDE_ID\" where \"PART_ID\" in (" + partIds + ") order by \"PART_NAME\" asc";
        long start = doTrace ? System.nanoTime() : 0L;
        Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        List sqlResult = (List)this.executeWithArray(query, null, queryText);
        long queryTime = doTrace ? System.nanoTime() : 0L;
        Deadline.checkTimeout();
        TreeMap<Long, Partition> partitions = new TreeMap<Long, Partition>();
        TreeMap<Long, StorageDescriptor> sds = new TreeMap<Long, StorageDescriptor>();
        TreeMap<Long, SerDeInfo> serdes = new TreeMap<Long, SerDeInfo>();
        TreeMap<Long, List<FieldSchema>> colss = new TreeMap<Long, List<FieldSchema>>();
        ArrayList<Partition> orderedResult = new ArrayList<Partition>(partIdList.size());
        StringBuilder sdSb = new StringBuilder(sbCapacity);
        StringBuilder serdeSb = new StringBuilder(sbCapacity);
        StringBuilder colsSb = new StringBuilder(7);
        tblName = tblName.toLowerCase();
        dbName = dbName.toLowerCase();
        for (Object[] fields : sqlResult) {
            SerDeInfo serde;
            SerDeInfo oldSerde;
            long partitionId = MetastoreDirectSqlUtils.extractSqlLong(fields[0]);
            Long sdId = MetastoreDirectSqlUtils.extractSqlLong(fields[1]);
            Long colId = MetastoreDirectSqlUtils.extractSqlLong(fields[2]);
            Long serdeId = MetastoreDirectSqlUtils.extractSqlLong(fields[3]);
            if (sdId == null || serdeId == null) {
                if (isView == null) {
                    isView = this.isViewTable(dbName, tblName);
                }
                if (sdId != null || colId != null || serdeId != null || !isView.booleanValue()) {
                    throw new MetaException("Unexpected null for one of the IDs, SD " + sdId + ", serde " + serdeId + " for a " + (isView != false ? "" : "non-") + " view");
                }
            }
            Partition part = new Partition();
            orderedResult.add(part);
            part.setParameters(new HashMap<String, String>());
            part.setValues(new ArrayList<String>());
            part.setDbName(dbName);
            part.setTableName(tblName);
            if (fields[4] != null) {
                part.setCreateTime(MetastoreDirectSqlUtils.extractSqlInt(fields[4]));
            }
            if (fields[5] != null) {
                part.setLastAccessTime(MetastoreDirectSqlUtils.extractSqlInt(fields[5]));
            }
            partitions.put(partitionId, part);
            if (sdId == null) continue;
            assert (serdeId != null);
            StorageDescriptor sd = new StorageDescriptor();
            StorageDescriptor oldSd = sds.put(sdId, sd);
            if (oldSd != null) {
                throw new MetaException("Partitions reuse SDs; we don't expect that");
            }
            sd.setSortCols(new ArrayList<Order>());
            sd.setBucketCols(new ArrayList<String>());
            sd.setParameters(new HashMap<String, String>());
            sd.setSkewedInfo(new SkewedInfo(new ArrayList<String>(), new ArrayList<List<String>>(), new HashMap<List<String>, String>()));
            sd.setInputFormat((String)fields[6]);
            Boolean tmpBoolean = MetastoreDirectSqlUtils.extractSqlBoolean(fields[7]);
            if (tmpBoolean != null) {
                sd.setCompressed(tmpBoolean);
            }
            if ((tmpBoolean = MetastoreDirectSqlUtils.extractSqlBoolean(fields[8])) != null) {
                sd.setStoredAsSubDirectories(tmpBoolean);
            }
            sd.setLocation((String)fields[9]);
            if (fields[10] != null) {
                sd.setNumBuckets(MetastoreDirectSqlUtils.extractSqlInt(fields[10]));
            }
            sd.setOutputFormat((String)fields[11]);
            sdSb.append(sdId).append(",");
            part.setSd(sd);
            if (colId != null) {
                List<FieldSchema> cols = colss.get(colId);
                if (cols == null) {
                    cols = new ArrayList<FieldSchema>();
                    colss.put(colId, cols);
                    colsSb.append(colId).append(",");
                }
                sd.setCols(cols);
            }
            if ((oldSerde = serdes.put(serdeId, serde = new SerDeInfo())) != null) {
                throw new MetaException("SDs reuse serdes; we don't expect that");
            }
            serde.setParameters(new HashMap<String, String>());
            serde.setName((String)fields[12]);
            serde.setSerializationLib((String)fields[13]);
            serdeSb.append(serdeId).append(",");
            sd.setSerdeInfo(serde);
            Deadline.checkTimeout();
        }
        query.closeAll();
        MetastoreDirectSqlUtils.timingTrace(doTrace, queryText, start, queryTime);
        MetastoreDirectSqlUtils.setPartitionParameters(this.PARTITION_PARAMS, this.convertMapNullsToEmptyStrings, this.pm, partIds, partitions);
        MetastoreDirectSqlUtils.setPartitionValues(this.PARTITION_KEY_VALS, this.pm, partIds, partitions);
        if (sdSb.length() == 0) {
            assert (serdeSb.length() == 0 && colsSb.length() == 0);
            return orderedResult;
        }
        String sdIds = MetaStoreDirectSql.trimCommaList(sdSb);
        String serdeIds = MetaStoreDirectSql.trimCommaList(serdeSb);
        String colIds = MetaStoreDirectSql.trimCommaList(colsSb);
        MetastoreDirectSqlUtils.setSDParameters(this.SD_PARAMS, this.convertMapNullsToEmptyStrings, this.pm, sds, sdIds);
        MetastoreDirectSqlUtils.setSDSortCols(this.SORT_COLS, this.pm, sds, sdIds);
        MetastoreDirectSqlUtils.setSDBucketCols(this.BUCKETING_COLS, this.pm, sds, sdIds);
        boolean hasSkewedColumns = MetastoreDirectSqlUtils.setSkewedColNames(this.SKEWED_COL_NAMES, this.pm, sds, sdIds);
        if (hasSkewedColumns) {
            MetastoreDirectSqlUtils.setSkewedColValues(this.SKEWED_STRING_LIST_VALUES, this.SKEWED_VALUES, this.pm, sds, sdIds);
            MetastoreDirectSqlUtils.setSkewedColLocationMaps(this.SKEWED_COL_VALUE_LOC_MAP, this.SKEWED_STRING_LIST_VALUES, this.pm, sds, sdIds);
        }
        if (!colss.isEmpty()) {
            MetastoreDirectSqlUtils.setSDCols(this.COLUMNS_V2, this.pm, colss, colIds);
        }
        MetastoreDirectSqlUtils.setSerdeParams(this.SERDE_PARAMS, this.convertMapNullsToEmptyStrings, this.pm, serdes, serdeIds);
        return orderedResult;
    }

    public int getNumPartitionsViaSqlFilter(SqlFilterForPushdown filter) throws MetaException {
        boolean doTrace = LOG.isDebugEnabled();
        String dbName = filter.table.getDbName().toLowerCase();
        String tblName = filter.table.getTableName().toLowerCase();
        String queryText = "select count(\"PARTITIONS\".\"PART_ID\") from \"PARTITIONS\"  inner join \"TBLS\" on \"PARTITIONS\".\"TBL_ID\" = \"TBLS\".\"TBL_ID\"     and \"TBLS\".\"TBL_NAME\" = ?   inner join \"DBS\" on \"TBLS\".\"DB_ID\" = \"DBS\".\"DB_ID\"      and \"DBS\".\"NAME\" = ? " + StringUtils.join((Collection)filter.joins, (char)' ') + (filter.filter == null || filter.filter.trim().isEmpty() ? "" : " where " + filter.filter);
        Object[] params = new Object[filter.params.size() + 2];
        params[0] = tblName;
        params[1] = dbName;
        for (int i = 0; i < filter.params.size(); ++i) {
            params[i + 2] = filter.params.get(i);
        }
        long start = doTrace ? System.nanoTime() : 0L;
        Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        query.setUnique(true);
        int sqlResult = MetastoreDirectSqlUtils.extractSqlInt(query.executeWithArray(params));
        long queryTime = doTrace ? System.nanoTime() : 0L;
        MetastoreDirectSqlUtils.timingTrace(doTrace, queryText, start, queryTime);
        return sqlResult;
    }

    private static String trimCommaList(StringBuilder sb) {
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public ColumnStatistics getTableStats(final String dbName, final String tableName, List<String> colNames) throws MetaException {
        if (colNames.isEmpty()) {
            return null;
        }
        final boolean doTrace = LOG.isDebugEnabled();
        String queryText0 = "select \"COLUMN_NAME\", \"COLUMN_TYPE\", \"LONG_LOW_VALUE\", \"LONG_HIGH_VALUE\", \"DOUBLE_LOW_VALUE\", \"DOUBLE_HIGH_VALUE\", \"BIG_DECIMAL_LOW_VALUE\", \"BIG_DECIMAL_HIGH_VALUE\", \"NUM_NULLS\", \"NUM_DISTINCTS\", \"AVG_COL_LEN\", \"MAX_COL_LEN\", \"NUM_TRUES\", \"NUM_FALSES\", \"LAST_ANALYZED\"  from \"TAB_COL_STATS\"  where \"DB_NAME\" = ? and \"TABLE_NAME\" = ? and \"COLUMN_NAME\" in (";
        Batchable<String, Object[]> b = new Batchable<String, Object[]>(){

            @Override
            public List<Object[]> run(List<String> input) throws MetaException {
                String queryText = "select \"COLUMN_NAME\", \"COLUMN_TYPE\", \"LONG_LOW_VALUE\", \"LONG_HIGH_VALUE\", \"DOUBLE_LOW_VALUE\", \"DOUBLE_HIGH_VALUE\", \"BIG_DECIMAL_LOW_VALUE\", \"BIG_DECIMAL_HIGH_VALUE\", \"NUM_NULLS\", \"NUM_DISTINCTS\", \"AVG_COL_LEN\", \"MAX_COL_LEN\", \"NUM_TRUES\", \"NUM_FALSES\", \"LAST_ANALYZED\"  from \"TAB_COL_STATS\"  where \"DB_NAME\" = ? and \"TABLE_NAME\" = ? and \"COLUMN_NAME\" in (" + MetaStoreDirectSql.this.makeParams(input.size()) + ")";
                Object[] params = new Object[input.size() + 2];
                params[0] = dbName;
                params[1] = tableName;
                for (int i = 0; i < input.size(); ++i) {
                    params[i + 2] = input.get(i);
                }
                long start = doTrace ? System.nanoTime() : 0L;
                Query query = MetaStoreDirectSql.this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
                Object qResult = MetaStoreDirectSql.this.executeWithArray(query, params, queryText);
                MetastoreDirectSqlUtils.timingTrace(doTrace, "select \"COLUMN_NAME\", \"COLUMN_TYPE\", \"LONG_LOW_VALUE\", \"LONG_HIGH_VALUE\", \"DOUBLE_LOW_VALUE\", \"DOUBLE_HIGH_VALUE\", \"BIG_DECIMAL_LOW_VALUE\", \"BIG_DECIMAL_HIGH_VALUE\", \"NUM_NULLS\", \"NUM_DISTINCTS\", \"AVG_COL_LEN\", \"MAX_COL_LEN\", \"NUM_TRUES\", \"NUM_FALSES\", \"LAST_ANALYZED\"  from \"TAB_COL_STATS\"  where \"DB_NAME\" = ? and \"TABLE_NAME\" = ? and \"COLUMN_NAME\" in (...)", start, doTrace ? System.nanoTime() : 0L);
                if (qResult == null) {
                    query.closeAll();
                    return null;
                }
                this.addQueryAfterUse(query);
                return MetastoreDirectSqlUtils.ensureList(qResult);
            }
        };
        List<Object[]> list = this.runBatched(colNames, b);
        if (list.isEmpty()) {
            return null;
        }
        ColumnStatisticsDesc csd = new ColumnStatisticsDesc(true, dbName, tableName);
        ColumnStatistics result = this.makeColumnStats(list, csd, 0);
        b.closeAllQueries();
        return result;
    }

    public AggrStats aggrColStatsForPartitions(String dbName, String tableName, List<String> partNames, List<String> colNames, boolean useDensityFunctionForNDVEstimation) throws MetaException {
        List<ColumnStatisticsObj> colStatsList;
        if (colNames.isEmpty() || partNames.isEmpty()) {
            LOG.debug("Columns is empty or partNames is empty : Short-circuiting stats eval");
            return new AggrStats(new ArrayList<ColumnStatisticsObj>(), 0L);
        }
        long partsFound = this.partsFoundForPartitions(dbName, tableName, partNames, colNames);
        if (this.isAggregateStatsCacheEnabled) {
            int maxPartsPerCacheNode = this.aggrStatsCache.getMaxPartsPerCacheNode();
            float fpp = this.aggrStatsCache.getFalsePositiveProbability();
            int partitionsRequested = partNames.size();
            if (partitionsRequested > maxPartsPerCacheNode) {
                colStatsList = this.columnStatisticsObjForPartitions(dbName, tableName, partNames, colNames, partsFound, useDensityFunctionForNDVEstimation);
            } else {
                colStatsList = new ArrayList<ColumnStatisticsObj>();
                BloomFilter bloomFilter = this.createPartsBloomFilter(maxPartsPerCacheNode, fpp, partNames);
                for (String colName : colNames) {
                    AggregateStatsCache.AggrColStats colStatsAggrCached = this.aggrStatsCache.get(dbName, tableName, colName, partNames);
                    if (colStatsAggrCached != null) {
                        colStatsList.add(colStatsAggrCached.getColStats());
                        continue;
                    }
                    ArrayList<String> colNamesForDB = new ArrayList<String>();
                    colNamesForDB.add(colName);
                    List<ColumnStatisticsObj> colStatsAggrFromDB = this.columnStatisticsObjForPartitions(dbName, tableName, partNames, colNamesForDB, partsFound, useDensityFunctionForNDVEstimation);
                    if (colStatsAggrFromDB.isEmpty()) continue;
                    ColumnStatisticsObj colStatsAggr = colStatsAggrFromDB.get(0);
                    colStatsList.add(colStatsAggr);
                    this.aggrStatsCache.add(dbName, tableName, colName, partsFound, colStatsAggr, bloomFilter);
                }
            }
        } else {
            colStatsList = this.columnStatisticsObjForPartitions(dbName, tableName, partNames, colNames, partsFound, useDensityFunctionForNDVEstimation);
        }
        LOG.info("useDensityFunctionForNDVEstimation = " + useDensityFunctionForNDVEstimation + "\npartsFound = " + partsFound + "\nColumnStatisticsObj = " + Arrays.toString(colStatsList.toArray()));
        return new AggrStats(colStatsList, partsFound);
    }

    private BloomFilter createPartsBloomFilter(int maxPartsPerCacheNode, float fpp, List<String> partNames) {
        BloomFilter bloomFilter = new BloomFilter((long)maxPartsPerCacheNode, (double)fpp);
        for (String partName : partNames) {
            bloomFilter.add(partName.getBytes());
        }
        return bloomFilter;
    }

    private long partsFoundForPartitions(final String dbName, final String tableName, final List<String> partNames, List<String> colNames) throws MetaException {
        assert (!colNames.isEmpty() && !partNames.isEmpty());
        final boolean doTrace = LOG.isDebugEnabled();
        String queryText0 = "select count(\"COLUMN_NAME\") from \"PART_COL_STATS\" where \"DB_NAME\" = ? and \"TABLE_NAME\" = ?  and \"COLUMN_NAME\" in (%1$s) and \"PARTITION_NAME\" in (%2$s) group by \"PARTITION_NAME\"";
        List<Long> allCounts = this.runBatched(colNames, new Batchable<String, Long>(){

            @Override
            public List<Long> run(final List<String> inputColName) throws MetaException {
                return MetaStoreDirectSql.this.runBatched(partNames, new Batchable<String, Long>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public List<Long> run(List<String> inputPartNames) throws MetaException {
                        long partsFound = 0L;
                        String queryText = String.format("select count(\"COLUMN_NAME\") from \"PART_COL_STATS\" where \"DB_NAME\" = ? and \"TABLE_NAME\" = ?  and \"COLUMN_NAME\" in (%1$s) and \"PARTITION_NAME\" in (%2$s) group by \"PARTITION_NAME\"", MetaStoreDirectSql.this.makeParams(inputColName.size()), MetaStoreDirectSql.this.makeParams(inputPartNames.size()));
                        long start = doTrace ? System.nanoTime() : 0L;
                        Query query = MetaStoreDirectSql.this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
                        try {
                            Object qResult = MetaStoreDirectSql.this.executeWithArray(query, MetaStoreDirectSql.this.prepareParams(dbName, tableName, inputPartNames, inputColName), queryText);
                            long end = doTrace ? System.nanoTime() : 0L;
                            MetastoreDirectSqlUtils.timingTrace(doTrace, queryText, start, end);
                            ForwardQueryResult fqr = (ForwardQueryResult)qResult;
                            Iterator iter = fqr.iterator();
                            while (iter.hasNext()) {
                                if (MetastoreDirectSqlUtils.extractSqlLong(iter.next()) != (long)inputColName.size()) continue;
                                ++partsFound;
                            }
                            ArrayList arrayList = Lists.newArrayList((Object[])new Long[]{partsFound});
                            return arrayList;
                        }
                        finally {
                            query.closeAll();
                        }
                    }
                });
            }
        });
        long partsFound = 0L;
        for (Long val : allCounts) {
            partsFound += val.longValue();
        }
        return partsFound;
    }

    private List<ColumnStatisticsObj> columnStatisticsObjForPartitions(final String dbName, final String tableName, final List<String> partNames, List<String> colNames, long partsFound, final boolean useDensityFunctionForNDVEstimation) throws MetaException {
        final boolean areAllPartsFound = partsFound == (long)partNames.size();
        return this.runBatched(colNames, new Batchable<String, ColumnStatisticsObj>(){

            @Override
            public List<ColumnStatisticsObj> run(final List<String> inputColNames) throws MetaException {
                return MetaStoreDirectSql.this.runBatched(partNames, new Batchable<String, ColumnStatisticsObj>(){

                    @Override
                    public List<ColumnStatisticsObj> run(List<String> inputPartNames) throws MetaException {
                        return MetaStoreDirectSql.this.columnStatisticsObjForPartitionsBatch(dbName, tableName, inputPartNames, inputColNames, areAllPartsFound, useDensityFunctionForNDVEstimation);
                    }
                });
            }
        });
    }

    private List<ColumnStatisticsObj> columnStatisticsObjForPartitionsBatch(String dbName, String tableName, List<String> partNames, List<String> colNames, boolean areAllPartsFound, boolean useDensityFunctionForNDVEstimation) throws MetaException {
        String commonPrefix = "select \"COLUMN_NAME\", \"COLUMN_TYPE\", min(\"LONG_LOW_VALUE\"), max(\"LONG_HIGH_VALUE\"), min(\"DOUBLE_LOW_VALUE\"), max(\"DOUBLE_HIGH_VALUE\"), min(cast(\"BIG_DECIMAL_LOW_VALUE\" as decimal)), max(cast(\"BIG_DECIMAL_HIGH_VALUE\" as decimal)), sum(\"NUM_NULLS\"), max(\"NUM_DISTINCTS\"), max(\"AVG_COL_LEN\"), max(\"MAX_COL_LEN\"), sum(\"NUM_TRUES\"), sum(\"NUM_FALSES\"), avg((\"LONG_HIGH_VALUE\"-\"LONG_LOW_VALUE\")/cast(\"NUM_DISTINCTS\" as decimal)),avg((\"DOUBLE_HIGH_VALUE\"-\"DOUBLE_LOW_VALUE\")/\"NUM_DISTINCTS\"),avg((cast(\"BIG_DECIMAL_HIGH_VALUE\" as decimal)-cast(\"BIG_DECIMAL_LOW_VALUE\" as decimal))/\"NUM_DISTINCTS\"),sum(\"NUM_DISTINCTS\") from \"PART_COL_STATS\" where \"DB_NAME\" = ? and \"TABLE_NAME\" = ? ";
        String queryText = null;
        long start = 0L;
        long end = 0L;
        Query query = null;
        boolean doTrace = LOG.isDebugEnabled();
        Object qResult = null;
        ForwardQueryResult fqr = null;
        if (areAllPartsFound) {
            queryText = commonPrefix + " and \"COLUMN_NAME\" in (" + this.makeParams(colNames.size()) + ") and \"PARTITION_NAME\" in (" + this.makeParams(partNames.size()) + ") group by \"COLUMN_NAME\", \"COLUMN_TYPE\"";
            start = doTrace ? System.nanoTime() : 0L;
            query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
            qResult = this.executeWithArray(query, this.prepareParams(dbName, tableName, partNames, colNames), queryText);
            if (qResult == null) {
                query.closeAll();
                return Lists.newArrayList();
            }
            end = doTrace ? System.nanoTime() : 0L;
            MetastoreDirectSqlUtils.timingTrace(doTrace, queryText, start, end);
            List<Object[]> list = MetastoreDirectSqlUtils.ensureList(qResult);
            ArrayList<ColumnStatisticsObj> colStats = new ArrayList<ColumnStatisticsObj>(list.size());
            for (Object[] row : list) {
                colStats.add(this.prepareCSObjWithAdjustedNDV(row, 0, useDensityFunctionForNDVEstimation));
                Deadline.checkTimeout();
            }
            query.closeAll();
            return colStats;
        }
        ArrayList<ColumnStatisticsObj> colStats = new ArrayList<ColumnStatisticsObj>(colNames.size());
        queryText = "select \"COLUMN_NAME\", \"COLUMN_TYPE\", count(\"PARTITION_NAME\")  from \"PART_COL_STATS\" where \"DB_NAME\" = ? and \"TABLE_NAME\" = ?  and \"COLUMN_NAME\" in (" + this.makeParams(colNames.size()) + ") and \"PARTITION_NAME\" in (" + this.makeParams(partNames.size()) + ") group by \"COLUMN_NAME\", \"COLUMN_TYPE\"";
        start = doTrace ? System.nanoTime() : 0L;
        query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        qResult = this.executeWithArray(query, this.prepareParams(dbName, tableName, partNames, colNames), queryText);
        end = doTrace ? System.nanoTime() : 0L;
        MetastoreDirectSqlUtils.timingTrace(doTrace, queryText, start, end);
        if (qResult == null) {
            query.closeAll();
            return Lists.newArrayList();
        }
        ArrayList<String> noExtraColumnNames = new ArrayList<String>();
        HashMap<String, String[]> extraColumnNameTypeParts = new HashMap<String, String[]>();
        List<Object[]> list = MetastoreDirectSqlUtils.ensureList(qResult);
        for (Object[] row : list) {
            String colName = (String)row[0];
            String colType = (String)row[1];
            Long count = MetastoreDirectSqlUtils.extractSqlLong(row[2]);
            if (count == (long)partNames.size() || count < 2L) {
                noExtraColumnNames.add(colName);
            } else {
                extraColumnNameTypeParts.put(colName, new String[]{colType, String.valueOf(count)});
            }
            Deadline.checkTimeout();
        }
        query.closeAll();
        if (noExtraColumnNames.size() != 0) {
            queryText = commonPrefix + " and \"COLUMN_NAME\" in (" + this.makeParams(noExtraColumnNames.size()) + ") and \"PARTITION_NAME\" in (" + this.makeParams(partNames.size()) + ") group by \"COLUMN_NAME\", \"COLUMN_TYPE\"";
            start = doTrace ? System.nanoTime() : 0L;
            query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
            qResult = this.executeWithArray(query, this.prepareParams(dbName, tableName, partNames, noExtraColumnNames), queryText);
            if (qResult == null) {
                query.closeAll();
                return Lists.newArrayList();
            }
            list = MetastoreDirectSqlUtils.ensureList(qResult);
            for (Object[] row : list) {
                colStats.add(this.prepareCSObjWithAdjustedNDV(row, 0, useDensityFunctionForNDVEstimation));
                Deadline.checkTimeout();
            }
            end = doTrace ? System.nanoTime() : 0L;
            MetastoreDirectSqlUtils.timingTrace(doTrace, queryText, start, end);
            query.closeAll();
        }
        if (extraColumnNameTypeParts.size() != 0) {
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            for (int index = 0; index < partNames.size(); ++index) {
                indexMap.put(partNames.get(index), index);
            }
            HashMap sumMap = new HashMap();
            queryText = "select \"COLUMN_NAME\", sum(\"NUM_NULLS\"), sum(\"NUM_TRUES\"), sum(\"NUM_FALSES\"), sum(\"NUM_DISTINCTS\") from \"PART_COL_STATS\" where \"DB_NAME\" = ? and \"TABLE_NAME\" = ?  and \"COLUMN_NAME\" in (" + this.makeParams(extraColumnNameTypeParts.size()) + ") and \"PARTITION_NAME\" in (" + this.makeParams(partNames.size()) + ") group by \"COLUMN_NAME\"";
            start = doTrace ? System.nanoTime() : 0L;
            query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
            ArrayList<String> extraColumnNames = new ArrayList<String>();
            extraColumnNames.addAll(extraColumnNameTypeParts.keySet());
            qResult = this.executeWithArray(query, this.prepareParams(dbName, tableName, partNames, extraColumnNames), queryText);
            if (qResult == null) {
                query.closeAll();
                return Lists.newArrayList();
            }
            list = MetastoreDirectSqlUtils.ensureList(qResult);
            Integer[] sumIndex = new Integer[]{6, 10, 11, 15};
            for (Object[] objectArray : list) {
                HashMap<Integer, Object> indexToObject = new HashMap<Integer, Object>();
                for (int ind = 1; ind < objectArray.length; ++ind) {
                    indexToObject.put(sumIndex[ind - 1], objectArray[ind]);
                }
                sumMap.put((String)objectArray[0], indexToObject);
                Deadline.checkTimeout();
            }
            end = doTrace ? System.nanoTime() : 0L;
            MetastoreDirectSqlUtils.timingTrace(doTrace, queryText, start, end);
            query.closeAll();
            for (Map.Entry entry : extraColumnNameTypeParts.entrySet()) {
                Object[] row = new Object[IExtrapolatePartStatus.colStatNames.length + 2];
                String colName = (String)entry.getKey();
                String colType = ((String[])entry.getValue())[0];
                Long sumVal = Long.parseLong(((String[])entry.getValue())[1]);
                row[0] = colName;
                row[1] = colType;
                LinearExtrapolatePartStatus extrapolateMethod = new LinearExtrapolatePartStatus();
                Integer[] index = null;
                boolean decimal = false;
                if (colType.toLowerCase().startsWith("decimal")) {
                    index = IExtrapolatePartStatus.indexMaps.get("decimal");
                    decimal = true;
                } else {
                    index = IExtrapolatePartStatus.indexMaps.get(colType.toLowerCase());
                }
                if (index == null) {
                    index = IExtrapolatePartStatus.indexMaps.get("default");
                }
                Integer[] integerArray = index;
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int colStatIndex = integerArray[i];
                    String colStatName = IExtrapolatePartStatus.colStatNames[colStatIndex];
                    if (IExtrapolatePartStatus.aggrTypes[colStatIndex] == IExtrapolatePartStatus.AggrType.Sum) {
                        Object o = ((Map)sumMap.get(colName)).get(colStatIndex);
                        if (o == null) {
                            row[2 + colStatIndex] = null;
                            continue;
                        }
                        Long val = MetastoreDirectSqlUtils.extractSqlLong(o);
                        row[2 + colStatIndex] = val / sumVal * (long)partNames.size();
                        continue;
                    }
                    if (IExtrapolatePartStatus.aggrTypes[colStatIndex] == IExtrapolatePartStatus.AggrType.Min || IExtrapolatePartStatus.aggrTypes[colStatIndex] == IExtrapolatePartStatus.AggrType.Max) {
                        queryText = !decimal ? "select \"" + colStatName + "\",\"PARTITION_NAME\" from \"PART_COL_STATS\" where \"DB_NAME\" = ? and \"TABLE_NAME\" = ? and \"COLUMN_NAME\" = ? and \"PARTITION_NAME\" in (" + this.makeParams(partNames.size()) + ") order by \"" + colStatName + "\"" : "select \"" + colStatName + "\",\"PARTITION_NAME\" from \"PART_COL_STATS\" where \"DB_NAME\" = ? and \"TABLE_NAME\" = ? and \"COLUMN_NAME\" = ? and \"PARTITION_NAME\" in (" + this.makeParams(partNames.size()) + ") order by cast(\"" + colStatName + "\" as decimal)";
                        start = doTrace ? System.nanoTime() : 0L;
                        query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
                        qResult = this.executeWithArray(query, this.prepareParams(dbName, tableName, partNames, Arrays.asList(colName)), queryText);
                        if (qResult == null) {
                            query.closeAll();
                            return Lists.newArrayList();
                        }
                        fqr = qResult;
                        Object[] min = (Object[])fqr.get(0);
                        Object[] max = (Object[])fqr.get(fqr.size() - 1);
                        end = doTrace ? System.nanoTime() : 0L;
                        MetastoreDirectSqlUtils.timingTrace(doTrace, queryText, start, end);
                        query.closeAll();
                        if (min[0] == null || max[0] == null) {
                            row[2 + colStatIndex] = null;
                            continue;
                        }
                        row[2 + colStatIndex] = extrapolateMethod.extrapolate(min, max, colStatIndex, indexMap);
                        continue;
                    }
                    queryText = "select avg((\"LONG_HIGH_VALUE\"-\"LONG_LOW_VALUE\")/cast(\"NUM_DISTINCTS\" as decimal)),avg((\"DOUBLE_HIGH_VALUE\"-\"DOUBLE_LOW_VALUE\")/\"NUM_DISTINCTS\"),avg((cast(\"BIG_DECIMAL_HIGH_VALUE\" as decimal)-cast(\"BIG_DECIMAL_LOW_VALUE\" as decimal))/\"NUM_DISTINCTS\") from \"PART_COL_STATS\" where \"DB_NAME\" = ? and \"TABLE_NAME\" = ? and \"COLUMN_NAME\" = ? and \"PARTITION_NAME\" in (" + this.makeParams(partNames.size()) + ") group by \"COLUMN_NAME\"";
                    start = doTrace ? System.nanoTime() : 0L;
                    query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
                    qResult = this.executeWithArray(query, this.prepareParams(dbName, tableName, partNames, Arrays.asList(colName)), queryText);
                    if (qResult == null) {
                        query.closeAll();
                        return Lists.newArrayList();
                    }
                    fqr = qResult;
                    Object[] avg = (Object[])fqr.get(0);
                    row[2 + colStatIndex] = avg[colStatIndex - 12];
                    end = doTrace ? System.nanoTime() : 0L;
                    MetastoreDirectSqlUtils.timingTrace(doTrace, queryText, start, end);
                    query.closeAll();
                }
                colStats.add(this.prepareCSObjWithAdjustedNDV(row, 0, useDensityFunctionForNDVEstimation));
                Deadline.checkTimeout();
            }
        }
        return colStats;
    }

    private ColumnStatisticsObj prepareCSObj(Object[] row, int i) throws MetaException {
        ColumnStatisticsData data = new ColumnStatisticsData();
        ColumnStatisticsObj cso = new ColumnStatisticsObj((String)row[i++], (String)row[i++], data);
        Object llow = row[i++];
        Object lhigh = row[i++];
        Object dlow = row[i++];
        Object dhigh = row[i++];
        Object declow = row[i++];
        Object dechigh = row[i++];
        Object nulls = row[i++];
        Object dist = row[i++];
        Object avglen = row[i++];
        Object maxlen = row[i++];
        Object trues = row[i++];
        Object falses = row[i++];
        StatObjectConverter.fillColumnStatisticsData(cso.getColType(), data, llow, lhigh, dlow, dhigh, declow, dechigh, nulls, dist, avglen, maxlen, trues, falses);
        return cso;
    }

    private ColumnStatisticsObj prepareCSObjWithAdjustedNDV(Object[] row, int i, boolean useDensityFunctionForNDVEstimation) throws MetaException {
        ColumnStatisticsData data = new ColumnStatisticsData();
        ColumnStatisticsObj cso = new ColumnStatisticsObj((String)row[i++], (String)row[i++], data);
        Object llow = row[i++];
        Object lhigh = row[i++];
        Object dlow = row[i++];
        Object dhigh = row[i++];
        Object declow = row[i++];
        Object dechigh = row[i++];
        Object nulls = row[i++];
        Object dist = row[i++];
        Object avglen = row[i++];
        Object maxlen = row[i++];
        Object trues = row[i++];
        Object falses = row[i++];
        Object avgLong = row[i++];
        Object avgDouble = row[i++];
        Object avgDecimal = row[i++];
        Object sumDist = row[i++];
        StatObjectConverter.fillColumnStatisticsData(cso.getColType(), data, llow, lhigh, dlow, dhigh, declow, dechigh, nulls, dist, avglen, maxlen, trues, falses, avgLong, avgDouble, avgDecimal, sumDist, useDensityFunctionForNDVEstimation);
        return cso;
    }

    private Object[] prepareParams(String dbName, String tableName, List<String> partNames, List<String> colNames) throws MetaException {
        Object[] params = new Object[colNames.size() + partNames.size() + 2];
        int paramI = 0;
        params[paramI++] = dbName;
        params[paramI++] = tableName;
        for (String colName : colNames) {
            params[paramI++] = colName;
        }
        for (String partName : partNames) {
            params[paramI++] = partName;
        }
        return params;
    }

    public List<ColumnStatistics> getPartitionStats(final String dbName, final String tableName, final List<String> partNames, List<String> colNames) throws MetaException {
        if (colNames.isEmpty() || partNames.isEmpty()) {
            return Lists.newArrayList();
        }
        final boolean doTrace = LOG.isDebugEnabled();
        String queryText0 = "select \"PARTITION_NAME\", \"COLUMN_NAME\", \"COLUMN_TYPE\", \"LONG_LOW_VALUE\", \"LONG_HIGH_VALUE\", \"DOUBLE_LOW_VALUE\", \"DOUBLE_HIGH_VALUE\", \"BIG_DECIMAL_LOW_VALUE\", \"BIG_DECIMAL_HIGH_VALUE\", \"NUM_NULLS\", \"NUM_DISTINCTS\", \"AVG_COL_LEN\", \"MAX_COL_LEN\", \"NUM_TRUES\", \"NUM_FALSES\", \"LAST_ANALYZED\"  from  \"PART_COL_STATS\" where \"DB_NAME\" = ? and \"TABLE_NAME\" = ? and \"COLUMN_NAME\"  in (%1$s) AND \"PARTITION_NAME\" in (%2$s) order by \"PARTITION_NAME\"";
        Batchable<String, Object[]> b = new Batchable<String, Object[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Object[]> run(final List<String> inputColNames) throws MetaException {
                Batchable<String, Object[]> b2 = new Batchable<String, Object[]>(){

                    @Override
                    public List<Object[]> run(List<String> inputPartNames) throws MetaException {
                        String queryText = String.format("select \"PARTITION_NAME\", \"COLUMN_NAME\", \"COLUMN_TYPE\", \"LONG_LOW_VALUE\", \"LONG_HIGH_VALUE\", \"DOUBLE_LOW_VALUE\", \"DOUBLE_HIGH_VALUE\", \"BIG_DECIMAL_LOW_VALUE\", \"BIG_DECIMAL_HIGH_VALUE\", \"NUM_NULLS\", \"NUM_DISTINCTS\", \"AVG_COL_LEN\", \"MAX_COL_LEN\", \"NUM_TRUES\", \"NUM_FALSES\", \"LAST_ANALYZED\"  from  \"PART_COL_STATS\" where \"DB_NAME\" = ? and \"TABLE_NAME\" = ? and \"COLUMN_NAME\"  in (%1$s) AND \"PARTITION_NAME\" in (%2$s) order by \"PARTITION_NAME\"", MetaStoreDirectSql.this.makeParams(inputColNames.size()), MetaStoreDirectSql.this.makeParams(inputPartNames.size()));
                        long start = doTrace ? System.nanoTime() : 0L;
                        Query query = MetaStoreDirectSql.this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
                        Object qResult = MetaStoreDirectSql.this.executeWithArray(query, MetaStoreDirectSql.this.prepareParams(dbName, tableName, inputPartNames, inputColNames), queryText);
                        MetastoreDirectSqlUtils.timingTrace(doTrace, "select \"PARTITION_NAME\", \"COLUMN_NAME\", \"COLUMN_TYPE\", \"LONG_LOW_VALUE\", \"LONG_HIGH_VALUE\", \"DOUBLE_LOW_VALUE\", \"DOUBLE_HIGH_VALUE\", \"BIG_DECIMAL_LOW_VALUE\", \"BIG_DECIMAL_HIGH_VALUE\", \"NUM_NULLS\", \"NUM_DISTINCTS\", \"AVG_COL_LEN\", \"MAX_COL_LEN\", \"NUM_TRUES\", \"NUM_FALSES\", \"LAST_ANALYZED\"  from  \"PART_COL_STATS\" where \"DB_NAME\" = ? and \"TABLE_NAME\" = ? and \"COLUMN_NAME\"  in (%1$s) AND \"PARTITION_NAME\" in (%2$s) order by \"PARTITION_NAME\"", start, doTrace ? System.nanoTime() : 0L);
                        if (qResult == null) {
                            query.closeAll();
                            return Lists.newArrayList();
                        }
                        this.addQueryAfterUse(query);
                        return MetastoreDirectSqlUtils.ensureList(qResult);
                    }
                };
                try {
                    List list = MetaStoreDirectSql.this.runBatched(partNames, b2);
                    return list;
                }
                finally {
                    this.addQueryAfterUse(b2);
                }
            }
        };
        List<Object[]> list = this.runBatched(colNames, b);
        ArrayList<ColumnStatistics> result = new ArrayList<ColumnStatistics>(Math.min(list.size(), partNames.size()));
        String lastPartName = null;
        int from = 0;
        for (int i = 0; i <= list.size(); ++i) {
            String partName;
            boolean isLast = i == list.size();
            String string = partName = isLast ? null : (String)list.get(i)[0];
            if (!isLast && partName.equals(lastPartName)) continue;
            if (from != i) {
                ColumnStatisticsDesc csd = new ColumnStatisticsDesc(false, dbName, tableName);
                csd.setPartName(lastPartName);
                result.add(this.makeColumnStats(list.subList(from, i), csd, 1));
            }
            lastPartName = partName;
            from = i;
            Deadline.checkTimeout();
        }
        b.closeAllQueries();
        return result;
    }

    private ColumnStatistics makeColumnStats(List<Object[]> list, ColumnStatisticsDesc csd, int offset) throws MetaException {
        ColumnStatistics result = new ColumnStatistics();
        result.setStatsDesc(csd);
        ArrayList<ColumnStatisticsObj> csos = new ArrayList<ColumnStatisticsObj>(list.size());
        for (Object[] row : list) {
            Object laObj = row[offset + 14];
            if (!(laObj == null || csd.isSetLastAnalyzed() && csd.getLastAnalyzed() <= MetastoreDirectSqlUtils.extractSqlLong(laObj))) {
                csd.setLastAnalyzed(MetastoreDirectSqlUtils.extractSqlLong(laObj));
            }
            csos.add(this.prepareCSObj(row, offset));
            Deadline.checkTimeout();
        }
        result.setStatsObj(csos);
        return result;
    }

    private String makeParams(int size) {
        return size == 0 ? "" : StringUtils.repeat((String)",?", (int)size).substring(1);
    }

    private <T> T executeWithArray(Query query, Object[] params, String sql) throws MetaException {
        return MetastoreDirectSqlUtils.executeWithArray(query, params, sql);
    }

    public void prepareTxn() throws MetaException {
        if (this.dbType != DB.MYSQL) {
            return;
        }
        try {
            assert (this.pm.currentTransaction().isActive());
            this.executeNoResult("SET @@session.sql_mode=ANSI_QUOTES");
        }
        catch (SQLException sqlEx) {
            throw new MetaException("Error setting ansi quotes: " + sqlEx.getMessage());
        }
    }

    private <I, R> List<R> runBatched(List<I> input, Batchable<I, R> runnable) throws MetaException {
        if (this.batchSize == -1 || this.batchSize >= input.size()) {
            return runnable.run(input);
        }
        ArrayList<R> result = new ArrayList<R>(input.size());
        int fromIndex = 0;
        int toIndex = 0;
        while (toIndex < input.size()) {
            toIndex = Math.min(fromIndex + this.batchSize, input.size());
            List<I> batchedInput = input.subList(fromIndex, toIndex);
            List<R> batchedOutput = runnable.run(batchedInput);
            if (batchedOutput != null) {
                result.addAll(batchedOutput);
            }
            fromIndex = toIndex;
        }
        return result;
    }

    public List<SQLForeignKey> getForeignKeys(String parent_db_name, String parent_tbl_name, String foreign_db_name, String foreign_tbl_name) throws MetaException {
        Query queryParams;
        List<Object[]> sqlResult;
        ArrayList<SQLForeignKey> ret = new ArrayList<SQLForeignKey>();
        String queryText = "SELECT  \"D2\".\"NAME\", \"T2\".\"TBL_NAME\", \"C2\".\"COLUMN_NAME\",\"DBS\".\"NAME\", \"TBLS\".\"TBL_NAME\", \"COLUMNS_V2\".\"COLUMN_NAME\", \"KEY_CONSTRAINTS\".\"POSITION\", \"KEY_CONSTRAINTS\".\"UPDATE_RULE\", \"KEY_CONSTRAINTS\".\"DELETE_RULE\", \"KEY_CONSTRAINTS\".\"CONSTRAINT_NAME\" , \"KEY_CONSTRAINTS2\".\"CONSTRAINT_NAME\", \"KEY_CONSTRAINTS\".\"ENABLE_VALIDATE_RELY\"  FROM \"TBLS\"  INNER JOIN \"KEY_CONSTRAINTS\" ON \"TBLS\".\"TBL_ID\" = \"KEY_CONSTRAINTS\".\"CHILD_TBL_ID\"  INNER JOIN \"KEY_CONSTRAINTS\" \"KEY_CONSTRAINTS2\" ON \"KEY_CONSTRAINTS2\".\"PARENT_TBL_ID\"  = \"KEY_CONSTRAINTS\".\"PARENT_TBL_ID\"  AND \"KEY_CONSTRAINTS2\".\"PARENT_CD_ID\"  = \"KEY_CONSTRAINTS\".\"PARENT_CD_ID\" AND  \"KEY_CONSTRAINTS2\".\"PARENT_INTEGER_IDX\"  = \"KEY_CONSTRAINTS\".\"PARENT_INTEGER_IDX\"  INNER JOIN \"DBS\" ON \"TBLS\".\"DB_ID\" = \"DBS\".\"DB_ID\"  INNER JOIN \"TBLS\" \"T2\" ON  \"KEY_CONSTRAINTS\".\"PARENT_TBL_ID\" = \"T2\".\"TBL_ID\"  INNER JOIN \"DBS\" \"D2\" ON \"T2\".\"DB_ID\" = \"D2\".\"DB_ID\"  INNER JOIN \"COLUMNS_V2\"  ON \"COLUMNS_V2\".\"CD_ID\" = \"KEY_CONSTRAINTS\".\"CHILD_CD_ID\" AND  \"COLUMNS_V2\".\"INTEGER_IDX\" = \"KEY_CONSTRAINTS\".\"CHILD_INTEGER_IDX\"  INNER JOIN \"COLUMNS_V2\" \"C2\" ON \"C2\".\"CD_ID\" = \"KEY_CONSTRAINTS\".\"PARENT_CD_ID\" AND  \"C2\".\"INTEGER_IDX\" = \"KEY_CONSTRAINTS\".\"PARENT_INTEGER_IDX\"  WHERE \"KEY_CONSTRAINTS\".\"CONSTRAINT_TYPE\" = 1 AND \"KEY_CONSTRAINTS2\".\"CONSTRAINT_TYPE\" = 0 AND" + (foreign_db_name == null ? "" : " \"DBS\".\"NAME\" = ? AND") + (foreign_tbl_name == null ? "" : " \"TBLS\".\"TBL_NAME\" = ? AND") + (parent_tbl_name == null ? "" : " \"T2\".\"TBL_NAME\" = ? AND") + (parent_db_name == null ? "" : " \"D2\".\"NAME\" = ?");
        if ((queryText = queryText.trim()).endsWith("WHERE")) {
            queryText = queryText.substring(0, queryText.length() - 5);
        }
        if (queryText.endsWith("AND")) {
            queryText = queryText.substring(0, queryText.length() - 3);
        }
        ArrayList<String> pms = new ArrayList<String>();
        if (foreign_db_name != null) {
            pms.add(foreign_db_name);
        }
        if (foreign_tbl_name != null) {
            pms.add(foreign_tbl_name);
        }
        if (parent_tbl_name != null) {
            pms.add(parent_tbl_name);
        }
        if (parent_db_name != null) {
            pms.add(parent_db_name);
        }
        if (!(sqlResult = MetastoreDirectSqlUtils.ensureList(this.executeWithArray(queryParams = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText), pms.toArray(), queryText))).isEmpty()) {
            for (Object[] line : sqlResult) {
                int enableValidateRely = MetastoreDirectSqlUtils.extractSqlInt(line[11]);
                boolean enable = (enableValidateRely & 4) != 0;
                boolean validate = (enableValidateRely & 2) != 0;
                boolean rely = (enableValidateRely & 1) != 0;
                SQLForeignKey currKey = new SQLForeignKey(MetastoreDirectSqlUtils.extractSqlString(line[0]), MetastoreDirectSqlUtils.extractSqlString(line[1]), MetastoreDirectSqlUtils.extractSqlString(line[2]), MetastoreDirectSqlUtils.extractSqlString(line[3]), MetastoreDirectSqlUtils.extractSqlString(line[4]), MetastoreDirectSqlUtils.extractSqlString(line[5]), MetastoreDirectSqlUtils.extractSqlInt(line[6]), MetastoreDirectSqlUtils.extractSqlInt(line[7]), MetastoreDirectSqlUtils.extractSqlInt(line[8]), MetastoreDirectSqlUtils.extractSqlString(line[9]), MetastoreDirectSqlUtils.extractSqlString(line[10]), enable, validate, rely);
                ret.add(currKey);
            }
        }
        return ret;
    }

    public List<SQLPrimaryKey> getPrimaryKeys(String db_name, String tbl_name) throws MetaException {
        Query queryParams;
        List<Object[]> sqlResult;
        ArrayList<SQLPrimaryKey> ret = new ArrayList<SQLPrimaryKey>();
        String queryText = "SELECT \"DBS\".\"NAME\", \"TBLS\".\"TBL_NAME\", \"COLUMNS_V2\".\"COLUMN_NAME\",\"KEY_CONSTRAINTS\".\"POSITION\", \"KEY_CONSTRAINTS\".\"CONSTRAINT_NAME\", \"KEY_CONSTRAINTS\".\"ENABLE_VALIDATE_RELY\"  FROM  \"TBLS\"  INNER  JOIN \"KEY_CONSTRAINTS\" ON \"TBLS\".\"TBL_ID\" = \"KEY_CONSTRAINTS\".\"PARENT_TBL_ID\"  INNER JOIN \"DBS\" ON \"TBLS\".\"DB_ID\" = \"DBS\".\"DB_ID\"  INNER JOIN \"COLUMNS_V2\" ON \"COLUMNS_V2\".\"CD_ID\" = \"KEY_CONSTRAINTS\".\"PARENT_CD_ID\" AND  \"COLUMNS_V2\".\"INTEGER_IDX\" = \"KEY_CONSTRAINTS\".\"PARENT_INTEGER_IDX\"  WHERE \"KEY_CONSTRAINTS\".\"CONSTRAINT_TYPE\" = 0 AND " + (db_name == null ? "" : "\"DBS\".\"NAME\" = ? AND") + (tbl_name == null ? "" : " \"TBLS\".\"TBL_NAME\" = ? ");
        if ((queryText = queryText.trim()).endsWith("WHERE")) {
            queryText = queryText.substring(0, queryText.length() - 5);
        }
        if (queryText.endsWith("AND")) {
            queryText = queryText.substring(0, queryText.length() - 3);
        }
        ArrayList<String> pms = new ArrayList<String>();
        if (db_name != null) {
            pms.add(db_name);
        }
        if (tbl_name != null) {
            pms.add(tbl_name);
        }
        if (!(sqlResult = MetastoreDirectSqlUtils.ensureList(this.executeWithArray(queryParams = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText), pms.toArray(), queryText))).isEmpty()) {
            for (Object[] line : sqlResult) {
                int enableValidateRely = MetastoreDirectSqlUtils.extractSqlInt(line[5]);
                boolean enable = (enableValidateRely & 4) != 0;
                boolean validate = (enableValidateRely & 2) != 0;
                boolean rely = (enableValidateRely & 1) != 0;
                SQLPrimaryKey currKey = new SQLPrimaryKey(MetastoreDirectSqlUtils.extractSqlString(line[0]), MetastoreDirectSqlUtils.extractSqlString(line[1]), MetastoreDirectSqlUtils.extractSqlString(line[2]), MetastoreDirectSqlUtils.extractSqlInt(line[3]), MetastoreDirectSqlUtils.extractSqlString(line[4]), enable, validate, rely);
                ret.add(currKey);
            }
        }
        return ret;
    }

    public void dropPartitionsViaSqlFilter(final String dbName, final String tblName, List<String> partNames) throws MetaException {
        if (partNames.isEmpty()) {
            return;
        }
        this.runBatched(partNames, new Batchable<String, Void>(){

            @Override
            public List<Void> run(List<String> input) throws MetaException {
                String filter = "\"PARTITIONS\".\"PART_NAME\" in (" + MetaStoreDirectSql.this.makeParams(input.size()) + ")";
                List partitionIds = MetaStoreDirectSql.this.getPartitionIdsViaSqlFilter(dbName, tblName, filter, input, Collections.emptyList(), null);
                if (partitionIds.isEmpty()) {
                    return Collections.emptyList();
                }
                MetaStoreDirectSql.this.dropPartitionsByPartitionIds(partitionIds);
                return Collections.emptyList();
            }
        });
    }

    private void dropPartitionsByPartitionIds(List<Long> partitionIdList) throws MetaException {
        String partitionIds = MetaStoreDirectSql.getIdListForIn(partitionIdList);
        String queryText = "SELECT \"SDS\".\"SD_ID\", \"SDS\".\"CD_ID\", \"SDS\".\"SERDE_ID\" from \"SDS\" INNER JOIN \"PARTITIONS\" ON \"PARTITIONS\".\"SD_ID\" = \"SDS\".\"SD_ID\" WHERE \"PARTITIONS\".\"PART_ID\" in (" + partitionIds + ")";
        Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        List<Object[]> sqlResult = MetastoreDirectSqlUtils.ensureList(this.executeWithArray(query, null, queryText));
        ArrayList<Object> sdIdList = new ArrayList<Object>(partitionIdList.size());
        ArrayList<Object> columnDescriptorIdList = new ArrayList<Object>(1);
        ArrayList<Object> serdeIdList = new ArrayList<Object>(partitionIdList.size());
        if (!sqlResult.isEmpty()) {
            for (Object[] fields : sqlResult) {
                sdIdList.add(MetastoreDirectSqlUtils.extractSqlLong(fields[0]));
                Long colId = MetastoreDirectSqlUtils.extractSqlLong(fields[1]);
                if (!columnDescriptorIdList.contains(colId)) {
                    columnDescriptorIdList.add(colId);
                }
                serdeIdList.add(MetastoreDirectSqlUtils.extractSqlLong(fields[2]));
            }
        }
        query.closeAll();
        try {
            queryText = "delete from \"PART_PRIVS\" where \"PART_ID\" in (" + partitionIds + ")";
            this.executeNoResult(queryText);
            Deadline.checkTimeout();
            queryText = "delete from \"PART_COL_PRIVS\" where \"PART_ID\" in (" + partitionIds + ")";
            this.executeNoResult(queryText);
            Deadline.checkTimeout();
            queryText = "delete from \"PART_COL_STATS\" where \"PART_ID\" in (" + partitionIds + ")";
            this.executeNoResult(queryText);
            Deadline.checkTimeout();
            queryText = "delete from \"PARTITION_PARAMS\" where \"PART_ID\" in (" + partitionIds + ")";
            this.executeNoResult(queryText);
            Deadline.checkTimeout();
            queryText = "delete from \"PARTITION_KEY_VALS\" where \"PART_ID\" in (" + partitionIds + ")";
            this.executeNoResult(queryText);
            Deadline.checkTimeout();
            queryText = "delete from \"PARTITIONS\" where \"PART_ID\" in (" + partitionIds + ")";
            this.executeNoResult(queryText);
            Deadline.checkTimeout();
        }
        catch (SQLException sqlException) {
            LOG.warn("SQL error executing query while dropping partition", (Throwable)sqlException);
            throw new MetaException("Encountered error while dropping partitions.");
        }
        this.dropStorageDescriptors(sdIdList);
        Deadline.checkTimeout();
        this.dropSerdes(serdeIdList);
        Deadline.checkTimeout();
        this.dropDanglingColumnDescriptors(columnDescriptorIdList);
    }

    private void dropStorageDescriptors(List<Object> storageDescriptorIdList) throws MetaException {
        String sdIds = MetaStoreDirectSql.getIdListForIn(storageDescriptorIdList);
        String queryText = "select \"SKEWED_VALUES\".\"STRING_LIST_ID_EID\" from \"SKEWED_VALUES\" WHERE \"SKEWED_VALUES\".\"SD_ID_OID\" in  (" + sdIds + ")";
        Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        List<Object[]> sqlResult = MetastoreDirectSqlUtils.ensureList(this.executeWithArray(query, null, queryText));
        ArrayList<Long> skewedStringListIdList = new ArrayList<Long>(0);
        if (!sqlResult.isEmpty()) {
            for (Object[] fields : sqlResult) {
                skewedStringListIdList.add(MetastoreDirectSqlUtils.extractSqlLong(fields[0]));
            }
        }
        query.closeAll();
        String skewedStringListIds = MetaStoreDirectSql.getIdListForIn(skewedStringListIdList);
        try {
            queryText = "delete from \"SD_PARAMS\" where \"SD_ID\" in (" + sdIds + ")";
            this.executeNoResult(queryText);
            Deadline.checkTimeout();
            queryText = "delete from \"SORT_COLS\" where \"SD_ID\" in (" + sdIds + ")";
            this.executeNoResult(queryText);
            Deadline.checkTimeout();
            queryText = "delete from \"BUCKETING_COLS\" where \"SD_ID\" in (" + sdIds + ")";
            this.executeNoResult(queryText);
            Deadline.checkTimeout();
            if (skewedStringListIdList.size() > 0) {
                queryText = "delete from \"SKEWED_COL_VALUE_LOC_MAP\" where \"SD_ID\" in (" + sdIds + ")";
                this.executeNoResult(queryText);
                Deadline.checkTimeout();
                queryText = "delete from \"SKEWED_VALUES\" where \"SD_ID_OID\" in (" + sdIds + ")";
                this.executeNoResult(queryText);
                Deadline.checkTimeout();
                queryText = "delete from \"SKEWED_STRING_LIST_VALUES\" where \"STRING_LIST_ID\" in (" + skewedStringListIds + ")";
                this.executeNoResult(queryText);
                Deadline.checkTimeout();
                queryText = "delete from \"SKEWED_STRING_LIST\" where \"STRING_LIST_ID\" in (" + skewedStringListIds + ")";
                this.executeNoResult(queryText);
                Deadline.checkTimeout();
            }
            queryText = "delete from \"SKEWED_COL_NAMES\" where \"SD_ID\" in (" + sdIds + ")";
            this.executeNoResult(queryText);
            Deadline.checkTimeout();
            queryText = "delete from \"SDS\" where \"SD_ID\" in (" + sdIds + ")";
            this.executeNoResult(queryText);
        }
        catch (SQLException sqlException) {
            LOG.warn("SQL error executing query while dropping storage descriptor.", (Throwable)sqlException);
            throw new MetaException("Encountered error while dropping storage descriptor.");
        }
    }

    private void dropSerdes(List<Object> serdeIdList) throws MetaException {
        String serdeIds = MetaStoreDirectSql.getIdListForIn(serdeIdList);
        try {
            String queryText = "delete from \"SERDE_PARAMS\" where \"SERDE_ID\" in (" + serdeIds + ")";
            this.executeNoResult(queryText);
            Deadline.checkTimeout();
            queryText = "delete from \"SERDES\" where \"SERDE_ID\" in (" + serdeIds + ")";
            this.executeNoResult(queryText);
        }
        catch (SQLException sqlException) {
            LOG.warn("SQL error executing query while dropping serde.", (Throwable)sqlException);
            throw new MetaException("Encountered error while dropping serde.");
        }
    }

    private void dropDanglingColumnDescriptors(List<Object> columnDescriptorIdList) throws MetaException {
        String colIds = MetaStoreDirectSql.getIdListForIn(columnDescriptorIdList);
        String queryText = "SELECT \"SDS\".\"CD_ID\", count(1) from \"SDS\" WHERE \"SDS\".\"CD_ID\" in (" + colIds + ") GROUP BY \"SDS\".\"CD_ID\"";
        Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        List<Object[]> sqlResult = MetastoreDirectSqlUtils.ensureList(this.executeWithArray(query, null, queryText));
        ArrayList<Long> danglingColumnDescriptorIdList = new ArrayList<Long>(columnDescriptorIdList.size());
        if (!sqlResult.isEmpty()) {
            for (Object[] fields : sqlResult) {
                if (MetastoreDirectSqlUtils.extractSqlInt(fields[1]) != 0) continue;
                danglingColumnDescriptorIdList.add(MetastoreDirectSqlUtils.extractSqlLong(fields[0]));
            }
        }
        query.closeAll();
        if (!danglingColumnDescriptorIdList.isEmpty()) {
            try {
                String danglingCDIds = MetaStoreDirectSql.getIdListForIn(danglingColumnDescriptorIdList);
                queryText = "delete from \"COLUMNS_V2\" where \"CD_ID\" in (" + danglingCDIds + ")";
                this.executeNoResult(queryText);
                Deadline.checkTimeout();
                queryText = "delete from \"CDS\" where \"CD_ID\" in (" + danglingCDIds + ")";
                this.executeNoResult(queryText);
            }
            catch (SQLException sqlException) {
                LOG.warn("SQL error executing query while dropping dangling col descriptions", (Throwable)sqlException);
                throw new MetaException("Encountered error while dropping col descriptions");
            }
        }
    }

    private static abstract class Batchable<I, R> {
        private List<Query> queries = null;

        private Batchable() {
        }

        public abstract List<R> run(List<I> var1) throws MetaException;

        public void addQueryAfterUse(Query query) {
            if (this.queries == null) {
                this.queries = new ArrayList<Query>(1);
            }
            this.queries.add(query);
        }

        protected void addQueryAfterUse(Batchable<?, ?> b) {
            if (b.queries == null) {
                return;
            }
            if (this.queries == null) {
                this.queries = new ArrayList<Query>(1);
            }
            this.queries.addAll(b.queries);
        }

        public void closeAllQueries() {
            for (Query q : this.queries) {
                try {
                    q.closeAll();
                }
                catch (Throwable t) {
                    LOG.error("Failed to close a query", t);
                }
            }
        }
    }

    private static class PartitionFilterGenerator
    extends ExpressionTree.TreeVisitor {
        private final Table table;
        private final ExpressionTree.FilterBuilder filterBuffer;
        private final List<Object> params;
        private final List<String> joins;
        private final boolean dbHasJoinCastBug;
        private final String defaultPartName;
        private final DB dbType;

        private PartitionFilterGenerator(Table table, List<Object> params, List<String> joins, boolean dbHasJoinCastBug, String defaultPartName, DB dbType) {
            this.table = table;
            this.params = params;
            this.joins = joins;
            this.dbHasJoinCastBug = dbHasJoinCastBug;
            this.filterBuffer = new ExpressionTree.FilterBuilder(false);
            this.defaultPartName = defaultPartName;
            this.dbType = dbType;
        }

        private static String generateSqlFilter(Table table, ExpressionTree tree, List<Object> params, List<String> joins, boolean dbHasJoinCastBug, String defaultPartName, DB dbType) throws MetaException {
            assert (table != null);
            if (tree == null) {
                return null;
            }
            if (tree.getRoot() == null) {
                return "";
            }
            PartitionFilterGenerator visitor = new PartitionFilterGenerator(table, params, joins, dbHasJoinCastBug, defaultPartName, dbType);
            tree.accept(visitor);
            if (visitor.filterBuffer.hasError()) {
                LOG.info("Unable to push down SQL filter: " + visitor.filterBuffer.getErrorMessage());
                return null;
            }
            for (int i = 0; i < joins.size(); ++i) {
                if (joins.get(i) != null) continue;
                joins.remove(i--);
            }
            return "(" + visitor.filterBuffer.getFilter() + ")";
        }

        @Override
        protected void beginTreeNode(ExpressionTree.TreeNode node) throws MetaException {
            this.filterBuffer.append(" (");
        }

        @Override
        protected void midTreeNode(ExpressionTree.TreeNode node) throws MetaException {
            this.filterBuffer.append(node.getAndOr() == ExpressionTree.LogicalOperator.AND ? " and " : " or ");
        }

        @Override
        protected void endTreeNode(ExpressionTree.TreeNode node) throws MetaException {
            this.filterBuffer.append(") ");
        }

        @Override
        protected boolean shouldStop() {
            return this.filterBuffer.hasError();
        }

        @Override
        public void visit(ExpressionTree.LeafNode node) throws MetaException {
            if (node.operator == ExpressionTree.Operator.LIKE) {
                this.filterBuffer.setError("LIKE is not supported for SQL filter pushdown");
                return;
            }
            int partColCount = this.table.getPartitionKeys().size();
            int partColIndex = node.getPartColIndexForFilter(this.table, this.filterBuffer);
            if (this.filterBuffer.hasError()) {
                return;
            }
            String colTypeStr = this.table.getPartitionKeys().get(partColIndex).getType();
            FilterType colType = FilterType.fromType(colTypeStr);
            if (colType == FilterType.Invalid) {
                this.filterBuffer.setError("Filter pushdown not supported for type " + colTypeStr);
                return;
            }
            FilterType valType = FilterType.fromClass(node.value);
            Object nodeValue = node.value;
            if (valType == FilterType.Invalid) {
                this.filterBuffer.setError("Filter pushdown not supported for value " + node.value.getClass());
                return;
            }
            if (colType == FilterType.Date && valType == FilterType.String) {
                try {
                    nodeValue = new Date(HiveMetaStore.PARTITION_DATE_FORMAT.get().parse((String)nodeValue).getTime());
                    valType = FilterType.Date;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (colType != valType) {
                this.filterBuffer.setError("Cannot push down filter for " + colTypeStr + " column and value " + nodeValue.getClass());
                return;
            }
            if (this.joins.isEmpty()) {
                for (int i = 0; i < partColCount; ++i) {
                    this.joins.add(null);
                }
            }
            if (this.joins.get(partColIndex) == null) {
                this.joins.set(partColIndex, "inner join \"PARTITION_KEY_VALS\" \"FILTER" + partColIndex + "\" on \"FILTER" + partColIndex + "\".\"PART_ID\" = \"PARTITIONS\".\"PART_ID\" and \"FILTER" + partColIndex + "\".\"INTEGER_IDX\" = " + partColIndex);
            }
            String tableValue = "\"FILTER" + partColIndex + "\".\"PART_KEY_VAL\"";
            if (node.isReverseOrder) {
                this.params.add(nodeValue);
            }
            String tableColumn = tableValue;
            if (colType != FilterType.String) {
                if (colType == FilterType.Integral) {
                    tableValue = "cast(" + tableValue + " as decimal(21,0))";
                } else if (colType == FilterType.Date) {
                    tableValue = this.dbType == DB.ORACLE ? "TO_DATE(" + tableValue + ", 'YYYY-MM-DD')" : "cast(" + tableValue + " as date)";
                }
                String tableValue0 = tableValue;
                tableValue = "(case when " + tableColumn + " <> ?";
                this.params.add(this.defaultPartName);
                if (this.dbHasJoinCastBug) {
                    tableValue = tableValue + " and \"TBLS\".\"TBL_NAME\" = ? and \"DBS\".\"NAME\" = ? and \"FILTER" + partColIndex + "\".\"PART_ID\" = \"PARTITIONS\".\"PART_ID\" and \"FILTER" + partColIndex + "\".\"INTEGER_IDX\" = " + partColIndex;
                    this.params.add(this.table.getTableName().toLowerCase());
                    this.params.add(this.table.getDbName().toLowerCase());
                }
                tableValue = tableValue + " then " + tableValue0 + " else null end)";
            }
            if (!node.isReverseOrder) {
                this.params.add(nodeValue);
            }
            this.filterBuffer.append(node.isReverseOrder ? "(? " + node.operator.getSqlOp() + " " + tableValue + ")" : "(" + tableValue + " " + node.operator.getSqlOp() + " ?)");
        }

        private static enum FilterType {
            Integral,
            String,
            Date,
            Invalid;


            static FilterType fromType(String colTypeStr) {
                if (colTypeStr.equals("string")) {
                    return String;
                }
                if (colTypeStr.equals("date")) {
                    return Date;
                }
                if (serdeConstants.IntegralTypes.contains(colTypeStr)) {
                    return Integral;
                }
                return Invalid;
            }

            public static FilterType fromClass(Object value) {
                if (value instanceof String) {
                    return String;
                }
                if (value instanceof Long) {
                    return Integral;
                }
                if (value instanceof Date) {
                    return Date;
                }
                return Invalid;
            }
        }
    }

    public static class SqlFilterForPushdown {
        private List<Object> params = new ArrayList<Object>();
        private List<String> joins = new ArrayList<String>();
        private String filter;
        private Table table;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface TableName {
    }

    private static enum DB {
        MYSQL,
        ORACLE,
        MSSQL,
        DERBY,
        POSTGRES,
        OTHER;

    }
}

