/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.messaging.DropIndexMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageFactory;
import org.apache.thrift.TException;
import org.codehaus.jackson.annotate.JsonProperty;

public class JSONDropIndexMessage
extends DropIndexMessage {
    @JsonProperty
    String server;
    @JsonProperty
    String servicePrincipal;
    @JsonProperty
    String db;
    @JsonProperty
    String indexObjJson;
    @JsonProperty
    Long timestamp;

    public JSONDropIndexMessage() {
    }

    public JSONDropIndexMessage(String server, String servicePrincipal, Index index, Long timestamp) {
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.db = index.getDbName();
        try {
            this.indexObjJson = JSONMessageFactory.createIndexObjJson(index);
        }
        catch (TException ex) {
            throw new IllegalArgumentException("Could not serialize Index object", ex);
        }
        this.timestamp = timestamp;
        this.checkValid();
    }

    @Override
    public String getDB() {
        return this.db;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getIndexObjJson() {
        return this.indexObjJson;
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString((Object)this);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not serialize: ", exception);
        }
    }
}

