/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreSchemaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStoreSchemaInfoFactory {
    public static final Logger LOG = LoggerFactory.getLogger(MetaStoreSchemaInfoFactory.class);

    public static IMetaStoreSchemaInfo get(Configuration conf) {
        String hiveHome = System.getenv("HIVE_HOME");
        if (hiveHome == null) {
            LOG.debug("HIVE_HOME is not set. Using current directory instead");
            hiveHome = ".";
        }
        return MetaStoreSchemaInfoFactory.get(conf, hiveHome, null);
    }

    public static IMetaStoreSchemaInfo get(Configuration conf, String hiveHome, String dbType) {
        String className = conf.get(HiveConf.ConfVars.METASTORE_SCHEMA_INFO_CLASS.varname, HiveConf.ConfVars.METASTORE_SCHEMA_INFO_CLASS.defaultStrVal);
        Class clasz = null;
        try {
            clasz = conf.getClassByName(className);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Unable to load class " + className, (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        Constructor constructor = null;
        try {
            constructor = clasz.getConstructor(String.class, Configuration.class, String.class);
            constructor.setAccessible(true);
            return (IMetaStoreSchemaInfo)constructor.newInstance(hiveHome, conf, dbType);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error("Unable to create instance of class " + className, (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }
}

