/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging;

import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.messaging.AddPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterIndexMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterTableMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateIndexMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateTableMessage;
import org.apache.hadoop.hive.metastore.messaging.DropDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.DropFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.DropIndexMessage;
import org.apache.hadoop.hive.metastore.messaging.DropPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.DropTableMessage;
import org.apache.hadoop.hive.metastore.messaging.InsertMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageDeserializer;
import org.apache.hadoop.util.ReflectionUtils;

public abstract class MessageFactory {
    public static final String ADD_PARTITION_EVENT = "ADD_PARTITION";
    public static final String ALTER_PARTITION_EVENT = "ALTER_PARTITION";
    public static final String DROP_PARTITION_EVENT = "DROP_PARTITION";
    public static final String CREATE_TABLE_EVENT = "CREATE_TABLE";
    public static final String ALTER_TABLE_EVENT = "ALTER_TABLE";
    public static final String DROP_TABLE_EVENT = "DROP_TABLE";
    public static final String CREATE_DATABASE_EVENT = "CREATE_DATABASE";
    public static final String ALTER_DATABASE_EVENT = "ALTER_DATABASE";
    public static final String DROP_DATABASE_EVENT = "DROP_DATABASE";
    public static final String INSERT_EVENT = "INSERT";
    public static final String CREATE_FUNCTION_EVENT = "CREATE_FUNCTION";
    public static final String DROP_FUNCTION_EVENT = "DROP_FUNCTION";
    public static final String CREATE_INDEX_EVENT = "CREATE_INDEX";
    public static final String DROP_INDEX_EVENT = "DROP_INDEX";
    public static final String ALTER_INDEX_EVENT = "ALTER_INDEX";
    private static MessageFactory instance = null;
    protected static final HiveConf hiveConf = new HiveConf();
    @Deprecated
    private static final String CONF_LABEL_HCAT_MESSAGE_FACTORY_IMPL_PREFIX = "hcatalog.message.factory.impl.";
    protected static final String MS_SERVER_URL;
    protected static final String MS_SERVICE_PRINCIPAL;

    public static MessageFactory getInstance() {
        if (instance == null) {
            instance = MessageFactory.getInstance(HiveConf.getVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_EVENT_MESSAGE_FACTORY));
        }
        return instance;
    }

    private static MessageFactory getInstance(String className) {
        try {
            MessageFactory factory = (MessageFactory)ReflectionUtils.newInstance((Class)JavaUtils.loadClass((String)className), (Configuration)hiveConf);
            factory.init();
            return factory;
        }
        catch (ClassNotFoundException classNotFound) {
            throw new IllegalStateException("Could not construct MessageFactory implementation: ", classNotFound);
        }
        catch (MetaException e) {
            throw new IllegalStateException((Throwable)((Object)e));
        }
    }

    public static MessageDeserializer getDeserializer(String format, String version) {
        return MessageFactory.getInstance(hiveConf.get(CONF_LABEL_HCAT_MESSAGE_FACTORY_IMPL_PREFIX + format, HiveConf.ConfVars.METASTORE_EVENT_MESSAGE_FACTORY.varname)).getDeserializer();
    }

    public void init() throws MetaException {
    }

    public abstract MessageDeserializer getDeserializer();

    public abstract String getVersion();

    public abstract String getMessageFormat();

    public abstract CreateDatabaseMessage buildCreateDatabaseMessage(Database var1);

    public abstract AlterDatabaseMessage buildAlterDatabaseMessage(Database var1, Database var2);

    public abstract DropDatabaseMessage buildDropDatabaseMessage(Database var1);

    public abstract CreateTableMessage buildCreateTableMessage(Table var1);

    public abstract AlterTableMessage buildAlterTableMessage(Table var1, Table var2);

    public abstract DropTableMessage buildDropTableMessage(Table var1);

    public abstract AddPartitionMessage buildAddPartitionMessage(Table var1, Iterator<Partition> var2);

    public abstract AlterPartitionMessage buildAlterPartitionMessage(Table var1, Partition var2, Partition var3);

    public abstract DropPartitionMessage buildDropPartitionMessage(Table var1, Iterator<Partition> var2);

    public abstract CreateFunctionMessage buildCreateFunctionMessage(Function var1);

    public abstract DropFunctionMessage buildDropFunctionMessage(Function var1);

    public abstract CreateIndexMessage buildCreateIndexMessage(Index var1);

    public abstract DropIndexMessage buildDropIndexMessage(Index var1);

    public abstract AlterIndexMessage buildAlterIndexMessage(Index var1, Index var2);

    public abstract InsertMessage buildInsertMessage(Table var1, Partition var2, boolean var3, List<String> var4);

    static {
        hiveConf.addResource("hive-site.xml");
        MS_SERVER_URL = hiveConf.get(HiveConf.ConfVars.METASTOREURIS.name(), "");
        MS_SERVICE_PRINCIPAL = hiveConf.get(HiveConf.ConfVars.METASTORE_KERBEROS_PRINCIPAL.name(), "");
    }
}

