/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.binarysortable.fast;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.serde2.binarysortable.BinarySortableUtils;
import org.apache.hadoop.hive.serde2.binarysortable.InputByteBuffer;
import org.apache.hadoop.hive.serde2.fast.DeserializeRead;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BinarySortableDeserializeRead
extends DeserializeRead {
    public static final Logger LOG = LoggerFactory.getLogger((String)BinarySortableDeserializeRead.class.getName());
    private boolean[] columnSortOrderIsDesc;
    byte[] columnNullMarker;
    byte[] columnNotNullMarker;
    private int start;
    private int end;
    private int fieldStart;
    private int bytesStart;
    private int internalBufferLen;
    private byte[] internalBuffer;
    private byte[] tempTimestampBytes;
    private byte[] tempDecimalBuffer;
    private InputByteBuffer inputByteBuffer = new InputByteBuffer();
    private Field root;
    private Deque<Field> stack;

    public static BinarySortableDeserializeRead with(TypeInfo[] typeInfos, boolean useExternalBuffer, Properties tbl) {
        boolean[] columnSortOrderIsDesc = new boolean[typeInfos.length];
        byte[] columnNullMarker = new byte[typeInfos.length];
        byte[] columnNotNullMarker = new byte[typeInfos.length];
        BinarySortableUtils.fillOrderArrays(tbl, columnSortOrderIsDesc, columnNullMarker, columnNotNullMarker);
        return new BinarySortableDeserializeRead(typeInfos, useExternalBuffer, columnSortOrderIsDesc, columnNullMarker, columnNotNullMarker);
    }

    public static BinarySortableDeserializeRead ascendingNullsFirst(TypeInfo[] typeInfos, boolean useExternalBuffer) {
        int count = typeInfos.length;
        boolean[] columnSortOrderIsDesc = new boolean[count];
        Arrays.fill(columnSortOrderIsDesc, false);
        byte[] columnNullMarker = new byte[count];
        byte[] columnNotNullMarker = new byte[count];
        for (int i = 0; i < count; ++i) {
            columnNullMarker[i] = 0;
            columnNotNullMarker[i] = 1;
        }
        return new BinarySortableDeserializeRead(typeInfos, useExternalBuffer, columnSortOrderIsDesc, columnNullMarker, columnNotNullMarker);
    }

    public BinarySortableDeserializeRead(TypeInfo[] typeInfos, boolean useExternalBuffer) {
        this(typeInfos, useExternalBuffer, null, null, null);
    }

    public BinarySortableDeserializeRead(TypeInfo[] typeInfos, boolean useExternalBuffer, boolean[] columnSortOrderIsDesc, byte[] columnNullMarker, byte[] columnNotNullMarker) {
        this(typeInfos, null, useExternalBuffer, columnSortOrderIsDesc, columnNullMarker, columnNotNullMarker);
    }

    public BinarySortableDeserializeRead(TypeInfo[] typeInfos, DataTypePhysicalVariation[] dataTypePhysicalVariations, boolean useExternalBuffer, boolean[] columnSortOrderIsDesc, byte[] columnNullMarker, byte[] columnNotNullMarker) {
        super(typeInfos, dataTypePhysicalVariations, useExternalBuffer);
        int count = typeInfos.length;
        this.root = new Field();
        this.root.category = ObjectInspector.Category.STRUCT;
        this.root.children = this.createFields(typeInfos);
        this.root.count = count;
        this.stack = new ArrayDeque<Field>();
        if (columnSortOrderIsDesc != null) {
            this.columnSortOrderIsDesc = columnSortOrderIsDesc;
        } else {
            this.columnSortOrderIsDesc = new boolean[count];
            Arrays.fill(this.columnSortOrderIsDesc, false);
        }
        if (columnNullMarker != null) {
            this.columnNullMarker = columnNullMarker;
            this.columnNotNullMarker = columnNotNullMarker;
        } else {
            this.columnNullMarker = new byte[count];
            this.columnNotNullMarker = new byte[count];
            for (int i = 0; i < count; ++i) {
                if (this.columnSortOrderIsDesc[i]) {
                    this.columnNullMarker[i] = 0;
                    this.columnNotNullMarker[i] = 1;
                    continue;
                }
                this.columnNullMarker[i] = 0;
                this.columnNotNullMarker[i] = 1;
            }
        }
        this.inputByteBuffer = new InputByteBuffer();
        this.internalBufferLen = -1;
    }

    private BinarySortableDeserializeRead() {
    }

    @Override
    public void set(byte[] bytes, int offset, int length) {
        this.start = offset;
        this.end = offset + length;
        this.inputByteBuffer.reset(bytes, this.start, this.end);
        this.root.index = -1;
        this.stack.clear();
        this.stack.push(this.root);
        this.clearIndex(this.root);
    }

    private void clearIndex(Field field) {
        field.index = -1;
        if (field.children == null) {
            return;
        }
        for (Field child : field.children) {
            this.clearIndex(child);
        }
    }

    @Override
    public String getDetailedReadPositionString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Reading inputByteBuffer of length ");
        sb.append(this.inputByteBuffer.getEnd());
        sb.append(" at start offset ");
        sb.append(this.start);
        sb.append(" for length ");
        sb.append(this.end - this.start);
        sb.append(" to read ");
        sb.append(this.root.count);
        sb.append(" fields with types ");
        sb.append(Arrays.toString(this.typeInfos));
        sb.append(".  ");
        if (this.root.index == -1) {
            sb.append("Before first field?");
        } else {
            sb.append("Read field #");
            sb.append(this.root.index);
            sb.append(" at field start position ");
            sb.append(this.fieldStart);
            sb.append(" current read offset ");
            sb.append(this.inputByteBuffer.tell());
        }
        sb.append(" column sort order ");
        sb.append(Arrays.toString(this.columnSortOrderIsDesc));
        sb.append(" column null marker ");
        sb.append(Arrays.toString(this.columnNullMarker));
        sb.append(" column non null marker ");
        sb.append(Arrays.toString(this.columnNotNullMarker));
        return sb.toString();
    }

    @Override
    public boolean readNextField() throws IOException {
        return this.readComplexField();
    }

    private boolean readPrimitive(Field field) throws IOException {
        int fieldIndex = this.root.index;
        field.start = this.inputByteBuffer.tell();
        switch (field.primitiveCategory) {
            case BOOLEAN: {
                this.currentBoolean = this.inputByteBuffer.read(this.columnSortOrderIsDesc[fieldIndex]) == 2;
                return true;
            }
            case BYTE: {
                this.currentByte = (byte)(this.inputByteBuffer.read(this.columnSortOrderIsDesc[fieldIndex]) ^ 0x80);
                return true;
            }
            case SHORT: {
                boolean invert = this.columnSortOrderIsDesc[fieldIndex];
                int v = this.inputByteBuffer.read(invert) ^ 0x80;
                v = (v << 8) + (this.inputByteBuffer.read(invert) & 0xFF);
                this.currentShort = (short)v;
                return true;
            }
            case INT: {
                boolean invert = this.columnSortOrderIsDesc[fieldIndex];
                int v = this.inputByteBuffer.read(invert) ^ 0x80;
                for (int i = 0; i < 3; ++i) {
                    v = (v << 8) + (this.inputByteBuffer.read(invert) & 0xFF);
                }
                this.currentInt = v;
                return true;
            }
            case LONG: {
                boolean invert = this.columnSortOrderIsDesc[fieldIndex];
                long v = this.inputByteBuffer.read(invert) ^ 0x80;
                for (int i = 0; i < 7; ++i) {
                    v = (v << 8) + (long)(this.inputByteBuffer.read(invert) & 0xFF);
                }
                this.currentLong = v;
                return true;
            }
            case DATE: {
                boolean invert = this.columnSortOrderIsDesc[fieldIndex];
                int v = this.inputByteBuffer.read(invert) ^ 0x80;
                for (int i = 0; i < 3; ++i) {
                    v = (v << 8) + (this.inputByteBuffer.read(invert) & 0xFF);
                }
                this.currentDateWritable.set(v);
                return true;
            }
            case TIMESTAMP: {
                if (this.tempTimestampBytes == null) {
                    this.tempTimestampBytes = new byte[11];
                }
                boolean invert = this.columnSortOrderIsDesc[fieldIndex];
                for (int i = 0; i < this.tempTimestampBytes.length; ++i) {
                    this.tempTimestampBytes[i] = this.inputByteBuffer.read(invert);
                }
                this.currentTimestampWritable.setBinarySortable(this.tempTimestampBytes, 0);
                return true;
            }
            case FLOAT: {
                boolean invert = this.columnSortOrderIsDesc[fieldIndex];
                int v = 0;
                for (int i = 0; i < 4; ++i) {
                    v = (v << 8) + (this.inputByteBuffer.read(invert) & 0xFF);
                }
                v = (v & Integer.MIN_VALUE) == 0 ? (v ^= 0xFFFFFFFF) : (v ^= Integer.MIN_VALUE);
                this.currentFloat = Float.intBitsToFloat(v);
                return true;
            }
            case DOUBLE: {
                boolean invert = this.columnSortOrderIsDesc[fieldIndex];
                long v = 0L;
                for (int i = 0; i < 8; ++i) {
                    v = (v << 8) + (long)(this.inputByteBuffer.read(invert) & 0xFF);
                }
                v = (v & Long.MIN_VALUE) == 0L ? (v ^= 0xFFFFFFFFFFFFFFFFL) : (v ^= Long.MIN_VALUE);
                this.currentDouble = Double.longBitsToDouble(v);
                return true;
            }
            case BINARY: 
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                byte b;
                this.bytesStart = this.inputByteBuffer.tell();
                boolean invert = this.columnSortOrderIsDesc[fieldIndex];
                int length = 0;
                while ((b = this.inputByteBuffer.read(invert)) != 0) {
                    if (b == 1) {
                        this.inputByteBuffer.read(invert);
                    }
                    ++length;
                }
                if (length == 0 || !invert && length == this.inputByteBuffer.tell() - this.bytesStart - 1) {
                    this.currentExternalBufferNeeded = false;
                    this.currentBytes = this.inputByteBuffer.getData();
                    this.currentBytesStart = this.bytesStart;
                    this.currentBytesLength = length;
                } else if (this.useExternalBuffer) {
                    this.currentExternalBufferNeeded = true;
                    this.currentExternalBufferNeededLen = length;
                } else {
                    this.currentExternalBufferNeeded = false;
                    if (this.internalBufferLen < length) {
                        this.internalBufferLen = length;
                        this.internalBuffer = new byte[this.internalBufferLen];
                    }
                    this.copyToBuffer(this.internalBuffer, 0, length);
                    this.currentBytes = this.internalBuffer;
                    this.currentBytesStart = 0;
                    this.currentBytesLength = length;
                }
                return true;
            }
            case INTERVAL_YEAR_MONTH: {
                boolean invert = this.columnSortOrderIsDesc[fieldIndex];
                int v = this.inputByteBuffer.read(invert) ^ 0x80;
                for (int i = 0; i < 3; ++i) {
                    v = (v << 8) + (this.inputByteBuffer.read(invert) & 0xFF);
                }
                this.currentHiveIntervalYearMonthWritable.set(v);
                return true;
            }
            case INTERVAL_DAY_TIME: {
                boolean invert = this.columnSortOrderIsDesc[fieldIndex];
                long totalSecs = this.inputByteBuffer.read(invert) ^ 0x80;
                for (int i = 0; i < 7; ++i) {
                    totalSecs = (totalSecs << 8) + (long)(this.inputByteBuffer.read(invert) & 0xFF);
                }
                int nanos = this.inputByteBuffer.read(invert) ^ 0x80;
                for (int i = 0; i < 3; ++i) {
                    nanos = (nanos << 8) + (this.inputByteBuffer.read(invert) & 0xFF);
                }
                this.currentHiveIntervalDayTimeWritable.set(totalSecs, nanos);
                return true;
            }
            case DECIMAL: {
                boolean decimalIsNull;
                boolean invert = this.columnSortOrderIsDesc[fieldIndex];
                int b = this.inputByteBuffer.read(invert) - 1;
                if (b != 1 && b != -1 && b != 0) {
                    throw new IOException("Unexpected byte value " + b + " in binary sortable format data (invert " + invert + ")");
                }
                boolean positive = b != -1;
                int factor = this.inputByteBuffer.read(invert) ^ 0x80;
                for (int i = 0; i < 3; ++i) {
                    factor = (factor << 8) + (this.inputByteBuffer.read(invert) & 0xFF);
                }
                if (!positive) {
                    factor = -factor;
                }
                int decimalStart = this.inputByteBuffer.tell();
                int length = 0;
                while (true) {
                    if ((b = (int)this.inputByteBuffer.read(positive ? invert : !invert)) == 1) {
                        throw new IOException("Expected -1 and found byte value " + b + " in binary sortable format data (invert " + invert + ")");
                    }
                    if (b == 0) break;
                    ++length;
                }
                if (this.tempDecimalBuffer == null || this.tempDecimalBuffer.length < length) {
                    this.tempDecimalBuffer = new byte[length];
                }
                this.inputByteBuffer.seek(decimalStart);
                for (int i = 0; i < length; ++i) {
                    this.tempDecimalBuffer[i] = this.inputByteBuffer.read(positive ? invert : !invert);
                }
                this.inputByteBuffer.read(positive ? invert : !invert);
                int scale = length - factor;
                this.currentHiveDecimalWritable.setFromDigitsOnlyBytesWithScale(!positive, this.tempDecimalBuffer, 0, length, scale);
                boolean bl = decimalIsNull = !this.currentHiveDecimalWritable.isSet();
                if (!decimalIsNull) {
                    int enforceScale;
                    DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)field.typeInfo;
                    int enforcePrecision = decimalTypeInfo.getPrecision();
                    boolean bl2 = decimalIsNull = !this.currentHiveDecimalWritable.mutateEnforcePrecisionScale(enforcePrecision, enforceScale = decimalTypeInfo.getScale());
                }
                return !decimalIsNull;
            }
        }
        throw new RuntimeException("Unexpected primitive type category " + (Object)((Object)field.primitiveCategory));
    }

    @Override
    public void skipNextField() throws IOException {
        Field current = this.stack.peek();
        ++current.index;
        if (this.root.index >= this.root.count) {
            return;
        }
        if (this.inputByteBuffer.isEof()) {
            return;
        }
        if (current.category == ObjectInspector.Category.UNION && current.index == 0) {
            this.currentInt = current.tag = (int)this.inputByteBuffer.read();
            return;
        }
        Field child = this.getChild(current);
        if (this.isNull()) {
            return;
        }
        if (child.category == ObjectInspector.Category.PRIMITIVE) {
            this.readPrimitive(child);
        } else {
            this.stack.push(child);
            switch (child.category) {
                case LIST: 
                case MAP: {
                    while (this.isNextComplexMultiValue()) {
                        this.skipNextField();
                    }
                    break;
                }
                case STRUCT: {
                    for (int i = 0; i < child.count; ++i) {
                        this.skipNextField();
                    }
                    this.finishComplexVariableFieldsType();
                    break;
                }
                case UNION: {
                    this.readComplexField();
                    this.skipNextField();
                    this.finishComplexVariableFieldsType();
                }
            }
        }
    }

    @Override
    public void copyToExternalBuffer(byte[] externalBuffer, int externalBufferStart) throws IOException {
        this.copyToBuffer(externalBuffer, externalBufferStart, this.currentExternalBufferNeededLen);
    }

    private void copyToBuffer(byte[] buffer, int bufferStart, int bufferLength) throws IOException {
        boolean invert = this.columnSortOrderIsDesc[this.root.index];
        this.inputByteBuffer.seek(this.bytesStart);
        for (int i = 0; i < bufferLength; ++i) {
            byte b = this.inputByteBuffer.read(invert);
            if (b == 1) {
                b = (byte)(this.inputByteBuffer.read(invert) - 1);
            }
            buffer[bufferStart + i] = b;
        }
        byte b = this.inputByteBuffer.read(invert);
        if (b != 0) {
            throw new RuntimeException("Expected 0 terminating byte");
        }
    }

    @Override
    public boolean isEndOfInputReached() {
        return this.inputByteBuffer.isEof();
    }

    private Field[] createFields(TypeInfo[] typeInfos) {
        Field[] children = new Field[typeInfos.length];
        for (int i = 0; i < typeInfos.length; ++i) {
            children[i] = this.createField(typeInfos[i]);
        }
        return children;
    }

    private Field createField(TypeInfo typeInfo) {
        ObjectInspector.Category category;
        Field field = new Field();
        field.category = category = typeInfo.getCategory();
        field.typeInfo = typeInfo;
        switch (category) {
            case PRIMITIVE: {
                field.primitiveCategory = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
                break;
            }
            case LIST: {
                field.children = new Field[1];
                field.children[0] = this.createField(((ListTypeInfo)typeInfo).getListElementTypeInfo());
                break;
            }
            case MAP: {
                field.children = new Field[2];
                field.children[0] = this.createField(((MapTypeInfo)typeInfo).getMapKeyTypeInfo());
                field.children[1] = this.createField(((MapTypeInfo)typeInfo).getMapValueTypeInfo());
                break;
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                ArrayList<TypeInfo> fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                field.count = fieldTypeInfos.size();
                field.children = this.createFields(fieldTypeInfos.toArray(new TypeInfo[fieldTypeInfos.size()]));
                break;
            }
            case UNION: {
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                List<TypeInfo> objectTypeInfos = unionTypeInfo.getAllUnionObjectTypeInfos();
                field.count = 2;
                field.children = this.createFields(objectTypeInfos.toArray(new TypeInfo[objectTypeInfos.size()]));
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return field;
    }

    private Field getChild(Field field) {
        switch (field.category) {
            case LIST: {
                return field.children[0];
            }
            case MAP: {
                return field.children[field.index % 2];
            }
            case STRUCT: {
                return field.children[field.index];
            }
            case UNION: {
                return field.children[field.tag];
            }
        }
        throw new RuntimeException();
    }

    private boolean isNull() throws IOException {
        return this.inputByteBuffer.read(this.columnSortOrderIsDesc[this.root.index]) == this.columnNullMarker[this.root.index];
    }

    @Override
    public boolean readComplexField() throws IOException {
        Field current = this.stack.peek();
        ++current.index;
        if (this.root.index >= this.root.count) {
            return false;
        }
        if (this.inputByteBuffer.isEof()) {
            return false;
        }
        if (current.category == ObjectInspector.Category.UNION && current.index == 0) {
            this.currentInt = current.tag = (int)this.inputByteBuffer.read(this.columnSortOrderIsDesc[this.root.index]);
            return true;
        }
        Field child = this.getChild(current);
        boolean isNull = this.isNull();
        if (isNull) {
            return false;
        }
        if (child.category == ObjectInspector.Category.PRIMITIVE) {
            isNull = !this.readPrimitive(child);
        } else {
            this.stack.push(child);
        }
        return !isNull;
    }

    @Override
    public boolean isNextComplexMultiValue() throws IOException {
        boolean isEnded;
        byte isNullByte = this.inputByteBuffer.read(this.columnSortOrderIsDesc[this.root.index]);
        switch (isNullByte) {
            case 0: {
                isEnded = true;
                break;
            }
            case 1: {
                isEnded = false;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        if (isEnded) {
            this.stack.pop();
            this.stack.peek();
        }
        return !isEnded;
    }

    @Override
    public void finishComplexVariableFieldsType() {
        this.stack.pop();
        if (this.stack.peek() == null) {
            throw new RuntimeException();
        }
        this.stack.peek();
    }

    private class Field {
        Field[] children;
        ObjectInspector.Category category;
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory;
        TypeInfo typeInfo;
        int index;
        int count;
        int start;
        int tag;

        private Field() {
        }
    }
}

