/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.sql.SQLException;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.operation.HiveCommandOperation;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.operation.SQLOperation;
import org.apache.hive.service.cli.session.HiveSession;

public abstract class ExecuteStatementOperation
extends Operation {
    protected String statement = null;

    public ExecuteStatementOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay, boolean runInBackground) {
        super(parentSession, confOverlay, OperationType.EXECUTE_STATEMENT, runInBackground);
        this.statement = statement;
    }

    public String getStatement() {
        return this.statement;
    }

    public static ExecuteStatementOperation newExecuteStatementOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay, boolean runAsync) throws HiveSQLException {
        String[] tokens = statement.trim().split("\\s+");
        CommandProcessor processor = null;
        try {
            processor = CommandProcessorFactory.getForHiveCommand((String[])tokens, (HiveConf)parentSession.getHiveConf());
        }
        catch (SQLException e) {
            throw new HiveSQLException(e.getMessage(), e.getSQLState(), e);
        }
        if (processor == null) {
            return new SQLOperation(parentSession, statement, confOverlay, runAsync);
        }
        return new HiveCommandOperation(parentSession, statement, processor, confOverlay);
    }
}

