/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.thrift;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.auth.HiveAuthUtils;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveServer2TransportMode;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.thrift.ThreadPoolExecutorWithOomHook;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.hive.service.server.ThreadFactoryWithGarbageCleanup;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.ServerContext;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TServerEventHandler;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;

public class ThriftBinaryCLIService
extends ThriftCLIService {
    private final Runnable oomHook;
    protected TServer server;

    public ThriftBinaryCLIService(CLIService cliService, Runnable oomHook) {
        super(cliService, ThriftBinaryCLIService.class.getSimpleName());
        this.oomHook = oomHook;
    }

    @Override
    protected HiveServer2TransportMode getTransportMode() {
        return HiveServer2TransportMode.binary;
    }

    @Override
    protected void initServer() {
        try {
            String threadPoolName = "HiveServer2-Handler-Pool";
            ThreadPoolExecutorWithOomHook executorService = new ThreadPoolExecutorWithOomHook(this.minWorkerThreads, this.maxWorkerThreads, this.workerKeepAliveTime, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new ThreadFactoryWithGarbageCleanup(threadPoolName), this.oomHook);
            this.hiveAuthFactory = new HiveAuthFactory(this.hiveConf);
            TTransportFactory transportFactory = this.hiveAuthFactory.getAuthTransFactory();
            TProcessorFactory processorFactory = this.hiveAuthFactory.getAuthProcFactory(this);
            TServerSocket serverSocket = null;
            ArrayList<String> sslVersionBlacklist = new ArrayList<String>();
            for (String sslVersion : this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SSL_PROTOCOL_BLACKLIST).split(",")) {
                sslVersionBlacklist.add(sslVersion);
            }
            if (!this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_USE_SSL)) {
                serverSocket = HiveAuthUtils.getServerSocket((String)this.hiveHost, (int)this.portNum);
            } else {
                String keyStorePath = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PATH).trim();
                if (keyStorePath.isEmpty()) {
                    throw new IllegalArgumentException(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PATH.varname + " Not configured for SSL connection");
                }
                String keyStorePassword = ShimLoader.getHadoopShims().getPassword((Configuration)this.hiveConf, HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PASSWORD.varname);
                String keyStoreType = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_TYPE).trim();
                String keyStoreAlgorithm = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYMANAGERFACTORY_ALGORITHM).trim();
                String includeCiphersuites = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SSL_BINARY_INCLUDE_CIPHERSUITES).trim();
                serverSocket = HiveAuthUtils.getServerSSLSocket((String)this.hiveHost, (int)this.portNum, (String)keyStorePath, (String)keyStorePassword, (String)keyStoreType, (String)keyStoreAlgorithm, sslVersionBlacklist, (String)includeCiphersuites);
            }
            int maxMessageSize = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_MAX_MESSAGE_SIZE);
            int requestTimeout = (int)this.hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_LOGIN_TIMEOUT, TimeUnit.SECONDS);
            int beBackoffSlotLength = (int)this.hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_LOGIN_BEBACKOFF_SLOT_LENGTH, TimeUnit.MILLISECONDS);
            TThreadPoolServer.Args sargs = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverSocket).processorFactory(processorFactory)).transportFactory(transportFactory)).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory())).inputProtocolFactory((TProtocolFactory)new TBinaryProtocol.Factory(true, true, (long)maxMessageSize, (long)maxMessageSize))).executorService((ExecutorService)executorService);
            this.server = new TThreadPoolServer(sargs);
            this.server.setServerEventHandler(new TServerEventHandler(){

                public ServerContext createContext(TProtocol input, TProtocol output) {
                    Metrics metrics = MetricsFactory.getInstance();
                    if (metrics != null) {
                        try {
                            metrics.incrementCounter("open_connections");
                            metrics.incrementCounter("cumulative_connection_count");
                        }
                        catch (Exception e) {
                            ThriftCLIService.LOG.warn("Error Reporting JDO operation to Metrics system", (Throwable)e);
                        }
                    }
                    return new ThriftCLIService.ThriftCLIServerContext();
                }

                public void deleteContext(ServerContext serverContext, TProtocol input, TProtocol output) {
                    ThriftCLIService.ThriftCLIServerContext context;
                    SessionHandle sessionHandle;
                    Metrics metrics = MetricsFactory.getInstance();
                    if (metrics != null) {
                        try {
                            metrics.decrementCounter("open_connections");
                        }
                        catch (Exception e) {
                            ThriftCLIService.LOG.warn("Error Reporting JDO operation to Metrics system", (Throwable)e);
                        }
                    }
                    if ((sessionHandle = (context = (ThriftCLIService.ThriftCLIServerContext)serverContext).getSessionHandle()) != null) {
                        ThriftCLIService.LOG.info("Session disconnected without closing properly. ");
                        try {
                            boolean close = ThriftBinaryCLIService.this.cliService.getSessionManager().getSession(sessionHandle).getHiveConf().getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_CLOSE_SESSION_ON_DISCONNECT);
                            ThriftCLIService.LOG.info((close ? "" : "Not ") + "Closing the session: " + sessionHandle);
                            if (close) {
                                ThriftBinaryCLIService.this.cliService.closeSession(sessionHandle);
                            }
                        }
                        catch (HiveSQLException e) {
                            ThriftCLIService.LOG.warn("Failed to close session: " + e, (Throwable)e);
                        }
                    }
                }

                public void preServe() {
                }

                public void processContext(ServerContext serverContext, TTransport input, TTransport output) {
                    ThriftBinaryCLIService.this.currentServerContext.set(serverContext);
                }
            });
            String msg = "Starting " + ThriftBinaryCLIService.class.getSimpleName() + " on port " + this.portNum + " with " + this.minWorkerThreads + "..." + this.maxWorkerThreads + " worker threads";
            LOG.info(msg);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to init thrift server", e);
        }
    }

    @Override
    public void run() {
        try {
            this.server.serve();
        }
        catch (Throwable t) {
            if (t instanceof InterruptedException) {
                LOG.info("Caught " + t.getClass().getSimpleName() + ". Shutting down.");
            } else {
                LOG.error("Exception caught by " + this.getClass().getSimpleName() + ". Exiting.", t);
            }
            System.exit(-1);
        }
    }

    @Override
    protected void stopServer() {
        this.server.stop();
        this.server = null;
        LOG.info("Thrift server has stopped");
    }
}

