// Autogenerated Jamon implementation
// /grid/0/jenkins/workspace/workspace/CDH-parallel-ubuntu20/SOURCES/hive/service/src/jamon/org/apache/hive/tmpl/QueryProfileTmpl.jamon

package org.apache.hive.tmpl;

// 24, 1
import java.util.*;
// 25, 1
import org.apache.hadoop.hive.ql.QueryDisplay;
// 26, 1
import org.apache.hadoop.hive.ql.QueryInfo;
// 27, 1
import org.apache.hadoop.hive.conf.HiveConf;

public class QueryProfileTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hive.tmpl.QueryProfileTmpl.Intf

{
  private final QueryInfo queryInfo;
  private final HiveConf hiveConf;
  // 29, 1
  
private boolean showGraph = false;
private boolean showStats = false;

  protected static org.apache.hive.tmpl.QueryProfileTmpl.ImplData __jamon_setOptionalArguments(org.apache.hive.tmpl.QueryProfileTmpl.ImplData p_implData)
  {
    return p_implData;
  }
  public QueryProfileTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hive.tmpl.QueryProfileTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    queryInfo = p_implData.getQueryInfo();
    hiveConf = p_implData.getHiveConf();
  }
  
  public void renderNoFlush(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 33, 1
    jamonWriter.write("<!--[if IE]>\n<!DOCTYPE html>\n<![endif]-->\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>HiveServer2</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n\n    <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/hive.css\" rel=\"stylesheet\">\n\n    <script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n    ");
    // 51, 5
    if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SHOW_GRAPH) &&
      hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_EXPLAIN_OUTPUT) )
    {
      // 52, 82
      jamonWriter.write("\n      ");
      // 53, 7
      showGraph = true; 
      // 54, 7
      if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SHOW_STATS) )
      {
        // 54, 83
        jamonWriter.write("\n        ");
        // 55, 9
        showStats = true; 
      }
      // 56, 13
      jamonWriter.write("\n    ");
    }
    // 57, 11
    jamonWriter.write("\n    ");
    // 58, 5
    if (showGraph )
    {
      // 58, 22
      jamonWriter.write("\n      <script type=\"text/javascript\" src=\"/static/js/vis.min.js\"></script>\n      <link href=\"/static/css/query-plan-graph.css\" rel=\"stylesheet\">\n      <script src=\"/static/js/query-plan-graph.js\"></script>\n    ");
    }
    // 62, 11
    jamonWriter.write("\n  </head>\n\n  <body>\n  <div class=\"navbar  navbar-fixed-top navbar-default\">\n      <div class=\"container\">\n          <div class=\"navbar-header\">\n              <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                  <span class=\"icon-bar\"></span>\n                  <span class=\"icon-bar\"></span>\n                  <span class=\"icon-bar\"></span>\n              </button>\n              <a class=\"navbar-brand\" href=\"/hiveserver2.jsp\"><img src=\"/static/hive_logo.jpeg\" alt=\"Hive Logo\"/></a>\n          </div>\n          <div class=\"collapse navbar-collapse\">\n              <ul class=\"nav navbar-nav\">\n                <li class=\"active\"><a href=\"/\">Home</a></li>\n                <li><a href=\"/logs/\">Local logs</a></li>\n                <li><a href=\"/jmx\">Metrics Dump</a></li>\n                <li><a href=\"/conf\">Hive Configuration</a></li>\n                <li><a href=\"/stacks\">Stack Trace</a></li>\n            </ul>\n          </div><!--/.nav-collapse -->\n        </div>\n      </div>\n    </div>\n\n\n    ");
    // 90, 5
    if (queryInfo == null )
    {
      // 90, 30
      jamonWriter.write("\n         <div class=\"jumbotron\">\n           <p>Query not found.  It may have been deleted, increase <i>hive.server2.webui.max.historic.queries</i>\n              to retain more historic query information.</p>\n         </div>\n    ");
    }
    // 95, 5
    else
    {
      // 95, 12
      jamonWriter.write("\n\n\n    <div class=\"container\">\n      <div class=\"row inner_header\">\n        <div class=\"page-header\">\n          <h1>Query Information: ");
      // 101, 34
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getQueryDisplay() == null ? "Unknown" : queryInfo.getQueryDisplay().getQueryString()), jamonWriter);
      // 101, 134
      jamonWriter.write("</h1>\n        </div>\n      </div>\n      <div class=\"row\">\n\n\n      <div class=\"tabbable\">\n          <ul class=\"nav nav-pills\">\n              <li class=\"active\"><a href=\"#tab_baseProfile\" data-toggle=\"tab\">Base Profile</a></li>\n              <li class=\"\"><a href=\"#tab_stages\" data-toggle=\"tab\">Stages</a></li>\n              <li class=\"\"><a href=\"#tab_queryPlan\" data-toggle=\"tab\">Query Plan</a></li>\n              <li class=\"\"><a href=\"#tab_perfLogging\" data-toggle=\"tab\">Performance Logging</a></li>\n          </ul>\n          <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n              <div class=\"tab-pane active\" id=\"tab_baseProfile\">\n                  ");
      // 116, 19
      {
        // 116, 19
        __jamon_innerUnit__baseProfile(jamonWriter, queryInfo );
      }
      // 116, 59
      jamonWriter.write("\n              </div>\n              <div class=\"tab-pane\" id=\"tab_stages\">\n                  ");
      // 119, 19
      {
        // 119, 19
        __jamon_innerUnit__stages(jamonWriter, queryInfo );
      }
      // 119, 54
      jamonWriter.write("\n              </div>\n              <div class=\"tab-pane\" id=\"tab_queryPlan\">\n                  ");
      // 122, 19
      {
        // 122, 19
        __jamon_innerUnit__queryPlan(jamonWriter, queryInfo );
      }
      // 122, 57
      jamonWriter.write("\n              </div>\n              <div class=\"tab-pane\" id=\"tab_perfLogging\">\n                  ");
      // 125, 19
      {
        // 125, 19
        __jamon_innerUnit__perfLogging(jamonWriter, queryInfo );
      }
      // 125, 59
      jamonWriter.write("\n              </div>\n          </div>\n      </div>\n\n   ");
    }
    // 130, 10
    jamonWriter.write("\n\n</div>\n</div>\n<script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n</body>\n</html>\n\n");
    // 283, 1
    if (showGraph )
    {
      // 283, 18
      jamonWriter.write("\n  <script type=\"text/javascript\">\n    // reload network to centralize graph upon switching to \"Query Plan\" tab\n    $('a[data-toggle=\"tab\"]').on('shown.bs.tab', function (e) {\n      if (e.target.toString().includes(\"queryPlan\") && typeof network !== 'undefined') {\n        network.fit();\n      }\n    });\n  </script>\n");
    }
    // 292, 7
    jamonWriter.write("\n\n\n</div>\n</div>\n</body>\n</html>\n");
  }
  
  
  // 140, 1
  private void __jamon_innerUnit__baseProfile(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final QueryInfo queryInfo)
    throws java.io.IOException
  {
    // 144, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <td>User Name</td>\n            <td>");
    // 147, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getUserName()), jamonWriter);
    // 147, 46
    jamonWriter.write("</td>\n        </tr>\n        <tr>\n            <td>Query String</td>\n            <td>");
    // 151, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getQueryDisplay() == null ? "Unknown" : queryInfo.getQueryDisplay().getQueryString()), jamonWriter);
    // 151, 117
    jamonWriter.write("</td>\n        </tr>\n        <tr>\n            <td>Id</td>\n            <td>");
    // 155, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getQueryDisplay() == null ? "Unknown" : queryInfo.getQueryDisplay().getQueryId()), jamonWriter);
    // 155, 113
    jamonWriter.write("</td>\n        </tr>\n        <tr>\n            <td>Execution Engine</td>\n            <td>");
    // 159, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getExecutionEngine()), jamonWriter);
    // 159, 53
    jamonWriter.write("\n        </tr>\n        <tr>\n            <td>State</td>\n            <td>");
    // 163, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getState()), jamonWriter);
    // 163, 43
    jamonWriter.write("</td>\n        </tr>\n        <tr>\n            <td>Opened Timestamp</td>\n            <td>");
    // 167, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(queryInfo.getBeginTime())), jamonWriter);
    // 167, 57
    jamonWriter.write("</td>\n        </tr>\n        <tr>\n            <td>Opened (s)</td>\n            <td>");
    // 171, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getElapsedTime()/1000), jamonWriter);
    // 171, 54
    jamonWriter.write("</td>\n        </tr>\n        <tr>\n            <td>Closed Timestamp</td>\n            <td>");
    // 175, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getEndTime() == null ? "Open" : new Date(queryInfo.getEndTime())), jamonWriter);
    // 175, 97
    jamonWriter.write("</td>\n        </tr>\n        ");
    // 177, 9
    if (queryInfo.getQueryDisplay() != null && queryInfo.getQueryDisplay().getErrorMessage() != null )
    {
      // 177, 109
      jamonWriter.write("\n            <tr>\n                <td>Error</td>\n                <td>");
      // 180, 21
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getQueryDisplay().getErrorMessage()), jamonWriter);
      // 180, 72
      jamonWriter.write("</td>\n            </tr>\n        ");
    }
    // 182, 15
    jamonWriter.write("\n        <tr>\n            <td>Latency (s)</td>\n            <td>");
    // 185, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getRuntime() == null ? "Not finished" : queryInfo.getRuntime()/1000), jamonWriter);
    // 185, 100
    jamonWriter.write("</td>\n        </tr>\n    </table>\n");
  }
  
  
  // 190, 1
  private void __jamon_innerUnit__stages(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final QueryInfo queryInfo)
    throws java.io.IOException
  {
    // 194, 4
    jamonWriter.write("<table class=\"table table-striped\">\n       <tr>\n           <th>Stage Id</th>\n           <th>Status</th>\n           <th>Begin Time</th>\n           <th>End Time</th>\n           <th>Elapsed Time (s)</th>\n           <th>Requires Lock</th>\n        </tr>\n\n       ");
    // 204, 8
    if (queryInfo.getQueryDisplay() != null && queryInfo.getQueryDisplay().getTaskDisplays() != null )
    {
      // 204, 108
      jamonWriter.write("\n           ");
      // 205, 12
      for (QueryDisplay.TaskDisplay taskDisplay : queryInfo.getQueryDisplay().getTaskDisplays() )
      {
        // 205, 105
        jamonWriter.write("\n               <tr>\n                   <td>");
        // 207, 24
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(taskDisplay.getTaskId() + ":" + taskDisplay.getTaskType()), jamonWriter);
        // 207, 87
        jamonWriter.write("</td>\n                   <td>");
        // 208, 24
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(taskDisplay.getStatus()), jamonWriter);
        // 208, 53
        jamonWriter.write("</td>\n                   <td>");
        // 209, 24
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(taskDisplay.getBeginTime() == null ? "" : new Date(taskDisplay.getBeginTime())), jamonWriter);
        // 209, 108
        jamonWriter.write("</td>\n                   <td>");
        // 210, 24
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(taskDisplay.getEndTime() == null ? "" : new Date(taskDisplay.getEndTime())), jamonWriter);
        // 210, 104
        jamonWriter.write("</td>\n                   <td>");
        // 211, 24
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(taskDisplay.getElapsedTime() == null ? "" : taskDisplay.getElapsedTime()/1000), jamonWriter);
        // 211, 107
        jamonWriter.write(" (s) </td>\n                   <td>");
        // 212, 24
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(taskDisplay.isRequireLock()), jamonWriter);
        // 212, 57
        jamonWriter.write("</td>\n               </tr>\n           ");
      }
      // 214, 19
      jamonWriter.write("\n       ");
    }
    // 215, 14
    jamonWriter.write("\n   </table>\n");
  }
  
  
  // 220, 1
  private void __jamon_innerUnit__queryPlan(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final QueryInfo queryInfo)
    throws java.io.IOException
  {
    // 224, 5
    jamonWriter.write("<div class=\"panel panel-default\">\n      <div class=\"panel-heading\">Explain plan</div>\n      <div class=\"panel-body\">\n        ");
    // 227, 9
    if (showGraph )
    {
      // 227, 26
      jamonWriter.write("\n          ");
      // 228, 11
      if (queryInfo.getQueryDisplay() != null &&
                queryInfo.getQueryDisplay().getExplainPlan() != null &&
                !queryInfo.getQueryDisplay().getExplainPlan().equals("UNKNOWN"))
      {
        // 230, 82
        jamonWriter.write("\n            <div id='plan-visualization'></div>\n            ");
        // 232, 13
        if (showStats )
        {
          // 232, 30
          jamonWriter.write("\n              <div class=\"row\">\n                <div class=\"col-md-6\">\n                  <pre id='stage-info'></pre>\n                </div>\n                <div class=\"col-md-6\">\n                  <pre id='statistics-info'><div id='statistics-info-head'></div><div id='statistics-info-body'></div></pre>\n                </div>\n              </div>\n            ");
        }
        // 241, 13
        else
        {
          // 241, 20
          jamonWriter.write("\n              <pre id='stage-info'></pre>\n            ");
        }
        // 243, 19
        jamonWriter.write("\n            <script type=\"text/javascript\">\n              var jsonPlan = ");
        // 245, 30
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getQueryDisplay().getExplainPlan()), jamonWriter);
        // 245, 80
        jamonWriter.write("\n              var jsonStatuses = {};\n              var jsonStatistics = {};\n              var jsonLogs = {};\n              ");
        // 249, 15
        if (queryInfo.getOperationLogLocation() != null )
        {
          // 249, 66
          jamonWriter.write("\n                jsonLogs[\"Operation Log - will be deleted after query completes\"] = \"");
          // 250, 86
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getOperationLogLocation()), jamonWriter);
          // 250, 127
          jamonWriter.write("\"\n              ");
        }
        // 251, 21
        jamonWriter.write("\n              ");
        // 252, 15
        if (queryInfo.getQueryDisplay().getFullLogLocation() != null )
        {
          // 252, 79
          jamonWriter.write("\n                jsonLogs[\"Full Log\"] = \"");
          // 253, 41
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getQueryDisplay().getFullLogLocation()), jamonWriter);
          // 253, 95
          jamonWriter.write("\"\n              ");
        }
        // 254, 21
        jamonWriter.write("\n              ");
        // 255, 15
        for (QueryDisplay.TaskDisplay taskDisplay : queryInfo.getQueryDisplay().getTaskDisplays() )
        {
          // 255, 108
          jamonWriter.write("\n                jsonStatuses[\"");
          // 256, 31
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(taskDisplay.getTaskId()), jamonWriter);
          // 256, 60
          jamonWriter.write("\"] = \"");
          // 256, 66
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(taskDisplay.getStatus()), jamonWriter);
          // 256, 95
          jamonWriter.write("\";\n                ");
          // 257, 17
          if (showStats && taskDisplay.getStatsJsonString() != null )
          {
            // 257, 78
            jamonWriter.write("\n                  jsonStatistics[\"");
            // 258, 35
            org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(taskDisplay.getTaskId()), jamonWriter);
            // 258, 64
            jamonWriter.write("\"] = ");
            // 258, 69
            org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(taskDisplay.getStatsJsonString()), jamonWriter);
            // 258, 107
            jamonWriter.write(";\n                ");
          }
          // 259, 23
          jamonWriter.write("\n              ");
        }
        // 260, 22
        jamonWriter.write("\n              const MAP_PROGRESS = '");
        // 261, 37
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(QueryDisplay.TaskDisplay.MAP_PROGRESS), jamonWriter);
        // 261, 80
        jamonWriter.write("';\n              const REDUCE_PROGRESS = '");
        // 262, 40
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(QueryDisplay.TaskDisplay.REDUCE_PROGRESS), jamonWriter);
        // 262, 86
        jamonWriter.write("';\n              network = visualizeJsonPlan('plan-visualization', 'stage-info', 'statistics-info', 'statistics-info-head',\n                'statistics-info-body', jsonPlan, jsonStatuses, jsonStatistics, jsonLogs);\n            </script>\n          ");
      }
      // 266, 11
      else
      {
        // 266, 18
        jamonWriter.write("\n            <pre>Query information not available. Query may have failed or plan size may exceed value of config hive.server2.webui.max.graph.size.</pre>\n          ");
      }
      // 268, 17
      jamonWriter.write("\n        ");
    }
    // 269, 9
    else
    {
      // 269, 16
      jamonWriter.write("\n          ");
      // 270, 11
      if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_EXPLAIN_OUTPUT) )
      {
        // 270, 91
        jamonWriter.write("\n            <pre>\n            ");
        // 272, 13
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getQueryDisplay() == null ? "Unknown" : queryInfo.getQueryDisplay().getExplainPlan()), jamonWriter);
        // 272, 113
        jamonWriter.write("\n            </pre>\n          ");
      }
      // 274, 11
      else
      {
        // 274, 18
        jamonWriter.write("\n            <pre>\n            Set configuration hive.server2.webui.explain.output to true to view future query plans\n            </pre>\n          ");
      }
      // 278, 17
      jamonWriter.write("\n        ");
    }
    // 279, 15
    jamonWriter.write("\n      </div>\n    </div>\n");
  }
  
  
  // 295, 1
  private void __jamon_innerUnit__perfLogging(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final QueryInfo queryInfo)
    throws java.io.IOException
  {
    // 299, 5
    jamonWriter.write("<section>\n      <h3>Compile-time metadata operations</h3>\n        <table class=\"table table-striped\">\n          <tr>\n             <th>Call Name</th>\n             <th>Time (ms)</th>\n          </tr>\n\n          ");
    // 307, 11
    if (queryInfo.getQueryDisplay() != null && queryInfo.getQueryDisplay().getHmsTimings(QueryDisplay.Phase.COMPILATION) != null )
    {
      // 307, 139
      jamonWriter.write("\n             ");
      // 308, 14
      for (Map.Entry<String, Long> time : queryInfo.getQueryDisplay().getHmsTimings(QueryDisplay.Phase.COMPILATION).entrySet() )
      {
        // 308, 138
        jamonWriter.write("\n                 <tr>\n                     <td>");
        // 310, 26
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(time.getKey()), jamonWriter);
        // 310, 45
        jamonWriter.write("</td>\n                     <td>");
        // 311, 26
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(time.getValue()), jamonWriter);
        // 311, 47
        jamonWriter.write("</td>\n                 </tr>\n             ");
      }
      // 313, 21
      jamonWriter.write("\n         ");
    }
    // 314, 16
    jamonWriter.write("\n        </table>\n      </section>\n\n    <section>\n      <h3>Execution-time metadata operations</h3>\n        <table class=\"table table-striped\">\n          <tr>\n             <th>Call Name</th>\n             <th>Time (ms)</th>\n          </tr>\n\n          ");
    // 326, 11
    if (queryInfo.getQueryDisplay() != null && queryInfo.getQueryDisplay().getHmsTimings(QueryDisplay.Phase.EXECUTION) != null )
    {
      // 326, 137
      jamonWriter.write("\n             ");
      // 327, 14
      for (Map.Entry<String, Long> time : queryInfo.getQueryDisplay().getHmsTimings(QueryDisplay.Phase.EXECUTION).entrySet() )
      {
        // 327, 136
        jamonWriter.write("\n                 <tr>\n                     <td>");
        // 329, 26
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(time.getKey()), jamonWriter);
        // 329, 45
        jamonWriter.write("</td>\n                     <td>");
        // 330, 26
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(time.getValue()), jamonWriter);
        // 330, 47
        jamonWriter.write("</td>\n                 </tr>\n             ");
      }
      // 332, 21
      jamonWriter.write("\n         ");
    }
    // 333, 16
    jamonWriter.write("\n        </table>\n      </section>\n\n    <section>\n      <h3>Compile-Time Perf-Logger</h3>\n        <table class=\"table table-striped\">\n          <tr>\n             <th>Compile-time Call Name</th>\n             <th>Time (ms)</th>\n          </tr>\n\n          ");
    // 345, 11
    if (queryInfo.getQueryDisplay() != null && queryInfo.getQueryDisplay().getPerfLogTimes(QueryDisplay.Phase.COMPILATION) != null )
    {
      // 345, 141
      jamonWriter.write("\n             ");
      // 346, 14
      for (Map.Entry<String, Long> time : queryInfo.getQueryDisplay().getPerfLogTimes(QueryDisplay.Phase.COMPILATION).entrySet()  )
      {
        // 346, 141
        jamonWriter.write("\n                 <tr>\n                     <td>");
        // 348, 26
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(time.getKey()), jamonWriter);
        // 348, 45
        jamonWriter.write("</td>\n                     <td>");
        // 349, 26
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(time.getValue()), jamonWriter);
        // 349, 47
        jamonWriter.write("</td>\n                 </tr>\n             ");
      }
      // 351, 21
      jamonWriter.write("\n         ");
    }
    // 352, 16
    jamonWriter.write("\n        </table>\n      </section>\n\n    <section>\n      <h3>Execution-Time Perf-Logger</h3>\n        <table class=\"table table-striped\">\n          <tr>\n             <th>Execution-time Call Name</th>\n             <th>Time (ms)</th>\n          </tr>\n\n          ");
    // 364, 11
    if (queryInfo.getQueryDisplay() != null && queryInfo.getQueryDisplay().getPerfLogTimes(QueryDisplay.Phase.EXECUTION) != null )
    {
      // 364, 139
      jamonWriter.write("\n             ");
      // 365, 14
      for (Map.Entry<String, Long> time : queryInfo.getQueryDisplay().getPerfLogTimes(QueryDisplay.Phase.EXECUTION).entrySet()  )
      {
        // 365, 139
        jamonWriter.write("\n                 <tr>\n                     <td>");
        // 367, 26
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(time.getKey()), jamonWriter);
        // 367, 45
        jamonWriter.write("</td>\n                     <td>");
        // 368, 26
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(time.getValue()), jamonWriter);
        // 368, 47
        jamonWriter.write("</td>\n                 </tr>\n             ");
      }
      // 370, 21
      jamonWriter.write("\n         ");
    }
    // 371, 16
    jamonWriter.write("\n        </table>\n      </section>\n");
  }
  
  
}
