/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import javax.security.sasl.AuthenticationException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.ServiceUtils;
import org.apache.hive.service.auth.PasswdAuthenticationProvider;
import org.apache.hive.service.auth.ldap.ChainFilterFactory;
import org.apache.hive.service.auth.ldap.CustomQueryFilterFactory;
import org.apache.hive.service.auth.ldap.DirSearch;
import org.apache.hive.service.auth.ldap.DirSearchFactory;
import org.apache.hive.service.auth.ldap.Filter;
import org.apache.hive.service.auth.ldap.FilterFactory;
import org.apache.hive.service.auth.ldap.GroupFilterFactory;
import org.apache.hive.service.auth.ldap.LdapSearchFactory;
import org.apache.hive.service.auth.ldap.LdapUtils;
import org.apache.hive.service.auth.ldap.UserFilterFactory;
import org.apache.hive.service.auth.ldap.UserSearchFilterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapAuthenticationProviderImpl
implements PasswdAuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LdapAuthenticationProviderImpl.class);
    private static final List<FilterFactory> FILTER_FACTORIES = ImmutableList.of((Object)new CustomQueryFilterFactory(), (Object)new ChainFilterFactory(new UserSearchFilterFactory(), new UserFilterFactory(), new GroupFilterFactory()));
    private final HiveConf conf;
    private final Filter filter;
    private final DirSearchFactory searchFactory;

    public LdapAuthenticationProviderImpl(HiveConf conf) {
        this(conf, new LdapSearchFactory());
    }

    @VisibleForTesting
    LdapAuthenticationProviderImpl(HiveConf conf, DirSearchFactory searchFactory) {
        this.conf = conf;
        this.searchFactory = searchFactory;
        this.filter = LdapAuthenticationProviderImpl.resolveFilter(conf);
    }

    @Override
    public void Authenticate(String user, String password) throws AuthenticationException {
        boolean usedBind;
        DirSearch search = null;
        String bindUser = this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BIND_USER);
        String bindPassword = null;
        try {
            char[] rawPassword = this.conf.getPassword(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BIND_PASSWORD.toString());
            if (rawPassword != null) {
                bindPassword = new String(rawPassword);
            }
        }
        catch (IOException e) {
            bindPassword = null;
        }
        boolean bl = usedBind = bindUser != null && bindPassword != null;
        if (!usedBind) {
            bindUser = user;
            bindPassword = password;
        }
        try {
            search = this.createDirSearch(bindUser, bindPassword);
            this.applyFilter(search, user);
            if (usedBind) {
                this.createDirSearch(search.findUserDn(user), password);
            }
        }
        catch (NamingException e) {
            try {
                throw new AuthenticationException("Unable to find the user in the LDAP tree. " + e.getMessage());
            }
            catch (Throwable throwable) {
                ServiceUtils.cleanup(LOG, search);
                throw throwable;
            }
        }
        ServiceUtils.cleanup(LOG, search);
    }

    private DirSearch createDirSearch(String user, String password) throws AuthenticationException {
        if (StringUtils.isBlank((String)user)) {
            throw new AuthenticationException("Error validating LDAP user: a null or blank user name has been provided");
        }
        if (StringUtils.isBlank((String)password) || password.getBytes()[0] == 0) {
            throw new AuthenticationException("Error validating LDAP user: a null or blank password has been provided");
        }
        List<String> principals = LdapUtils.createCandidatePrincipals(this.conf, user);
        Iterator<String> iterator = principals.iterator();
        while (iterator.hasNext()) {
            String principal = iterator.next();
            try {
                return this.searchFactory.getInstance(this.conf, principal, password);
            }
            catch (AuthenticationException ex) {
                if (iterator.hasNext()) continue;
                throw ex;
            }
        }
        throw new AuthenticationException(String.format("No candidate principals for %s was found.", user));
    }

    private static Filter resolveFilter(HiveConf conf) {
        for (FilterFactory filterProvider : FILTER_FACTORIES) {
            Filter filter = filterProvider.getInstance(conf);
            if (filter == null) continue;
            return filter;
        }
        return null;
    }

    private void applyFilter(DirSearch client, String user) throws AuthenticationException {
        if (this.filter != null) {
            if (LdapUtils.hasDomain(user)) {
                this.filter.apply(client, LdapUtils.extractUserName(user));
            } else {
                this.filter.apply(client, user);
            }
        }
    }
}

