/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.thrift;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.ByteStreams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import javax.ws.rs.core.NewCookie;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.CookieSigner;
import org.apache.hive.service.auth.AuthenticationProviderFactory;
import org.apache.hive.service.auth.HiveAuthConstants;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.auth.HttpAuthUtils;
import org.apache.hive.service.auth.HttpAuthenticationException;
import org.apache.hive.service.auth.PasswdAuthenticationProvider;
import org.apache.hive.service.auth.PlainSaslHelper;
import org.apache.hive.service.auth.ldap.HttpEmptyAuthenticationException;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.session.SessionManager;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServlet;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftHttpServlet
extends TServlet {
    private static final long serialVersionUID = 1L;
    public static final Logger LOG = LoggerFactory.getLogger((String)ThriftHttpServlet.class.getName());
    private final String authType;
    private final UserGroupInformation serviceUGI;
    private final UserGroupInformation httpUGI;
    private HiveConf hiveConf = new HiveConf();
    private CookieSigner signer;
    public static final String AUTH_COOKIE = "hive.server2.auth";
    private static final SecureRandom RAN = new SecureRandom();
    private boolean isCookieAuthEnabled;
    private String cookieDomain;
    private String cookiePath;
    private int cookieMaxAge;
    private boolean isCookieSecure;
    private boolean isHttpOnlyCookie;
    private final HiveAuthFactory hiveAuthFactory;
    private static final String HIVE_DELEGATION_TOKEN_HEADER = "X-Hive-Delegation-Token";
    private static final String X_FORWARDED_FOR = "X-Forwarded-For";

    public ThriftHttpServlet(TProcessor processor, TProtocolFactory protocolFactory, String authType, UserGroupInformation serviceUGI, UserGroupInformation httpUGI, HiveAuthFactory hiveAuthFactory) {
        super(processor, protocolFactory);
        this.authType = authType;
        this.serviceUGI = serviceUGI;
        this.httpUGI = httpUGI;
        this.hiveAuthFactory = hiveAuthFactory;
        this.isCookieAuthEnabled = this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_COOKIE_AUTH_ENABLED);
        if (this.isCookieAuthEnabled) {
            String secret = Long.toString(RAN.nextLong());
            LOG.debug("Using the random number as the secret for cookie generation " + secret);
            this.signer = new CookieSigner(secret.getBytes());
            this.cookieMaxAge = (int)this.hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_COOKIE_MAX_AGE, TimeUnit.SECONDS);
            this.cookieDomain = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_COOKIE_DOMAIN);
            this.cookiePath = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_COOKIE_PATH);
            this.isCookieSecure = this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_USE_SSL);
            this.isHttpOnlyCookie = this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_COOKIE_IS_HTTPONLY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String clientUserName = null;
        boolean requireNewCookie = false;
        try {
            boolean continueProcessing;
            if (this.hiveConf.getBoolean(HiveConf.ConfVars.HIVE_SERVER2_XSRF_FILTER_ENABLED.varname, false) && !(continueProcessing = Utils.doXsrfFilter((ServletRequest)request, (ServletResponse)response, null, null))) {
                LOG.warn("Request did not have valid XSRF header, rejecting.");
                return;
            }
            String clientIpAddress = request.getRemoteAddr();
            LOG.debug("Client IP Address: " + clientIpAddress);
            if (this.isCookieAuthEnabled) {
                clientUserName = this.validateCookie(request);
                boolean bl = requireNewCookie = clientUserName == null;
                if (requireNewCookie) {
                    LOG.info("Could not validate cookie sent, will try to generate a new cookie");
                }
            }
            SessionManager.setIpAddress(clientIpAddress);
            String forwarded_for = request.getHeader(X_FORWARDED_FOR);
            if (forwarded_for != null) {
                LOG.debug("{}:{}", (Object)X_FORWARDED_FOR, (Object)forwarded_for);
                List<String> forwardedAddresses = Arrays.asList(forwarded_for.split(","));
                SessionManager.setForwardedAddresses(forwardedAddresses);
            } else {
                SessionManager.setForwardedAddresses(Collections.emptyList());
            }
            if (clientUserName == null) {
                String trustedDomain = HiveConf.getVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_TRUSTED_DOMAIN).trim();
                boolean useXff = HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_TRUSTED_DOMAIN_USE_XFF_HEADER);
                if (useXff && !trustedDomain.isEmpty() && SessionManager.getForwardedAddresses() != null && !SessionManager.getForwardedAddresses().isEmpty()) {
                    clientIpAddress = SessionManager.getForwardedAddresses().get(0);
                    LOG.info("Trusted domain authN is enabled. clientIp from X-Forwarded-For header: {}", (Object)clientIpAddress);
                }
                String remoteHostName = InetAddress.getByName(clientIpAddress).getCanonicalHostName();
                if (!trustedDomain.isEmpty() && PlainSaslHelper.isHostFromTrustedDomain(remoteHostName, trustedDomain)) {
                    LOG.info("No authentication performed because the connecting host " + remoteHostName + " is from the trusted domain " + trustedDomain);
                    clientUserName = this.doPasswdAuth(request, HiveAuthConstants.AuthTypes.NOSASL.getAuthName());
                } else {
                    String delegationToken;
                    clientUserName = this.isKerberosAuthMode(this.authType) ? ((delegationToken = request.getHeader(HIVE_DELEGATION_TOKEN_HEADER)) != null && !delegationToken.isEmpty() ? this.doTokenAuth(request) : this.doKerberosAuth(request)) : this.doPasswdAuth(request, this.authType);
                }
            }
            assert (clientUserName != null);
            LOG.debug("Client username: " + clientUserName);
            SessionManager.setUserName(clientUserName);
            String doAsQueryParam = ThriftHttpServlet.getDoAsQueryParam(request.getQueryString());
            if (doAsQueryParam != null) {
                SessionManager.setProxyUserName(doAsQueryParam);
            }
            if (requireNewCookie && !this.authType.equalsIgnoreCase(HiveAuthConstants.AuthTypes.NOSASL.toString())) {
                String cookieToken = HttpAuthUtils.createCookieToken(clientUserName);
                Cookie hs2Cookie = this.createCookie(this.signer.signCookie(cookieToken));
                if (this.isHttpOnlyCookie) {
                    response.setHeader("SET-COOKIE", ThriftHttpServlet.getHttpOnlyCookieHeader(hs2Cookie));
                } else {
                    response.addCookie(hs2Cookie);
                }
                LOG.info("Cookie added for clientUserName " + clientUserName);
            }
            super.doPost(request, response);
        }
        catch (HttpAuthenticationException e) {
            if (!(e instanceof HttpEmptyAuthenticationException)) {
                LOG.error("Error: ", (Throwable)e);
            }
            if (request.getContentLength() < 0) {
                try {
                    ByteStreams.skipFully((InputStream)request.getInputStream(), (long)Integer.MAX_VALUE);
                }
                catch (EOFException ex) {
                    LOG.info(ex.getMessage());
                }
            }
            response.setStatus(401);
            if (this.isKerberosAuthMode(this.authType)) {
                response.addHeader("WWW-Authenticate", "Negotiate");
            }
            response.getWriter().println("Authentication Error: " + e.getMessage());
        }
        finally {
            SessionManager.clearUserName();
            SessionManager.clearIpAddress();
            SessionManager.clearProxyUserName();
            SessionManager.clearForwardedAddresses();
        }
    }

    private String getClientNameFromCookie(Cookie[] cookies) {
        for (Cookie currCookie : cookies) {
            String currName = currCookie.getName();
            if (!currName.equals(AUTH_COOKIE)) continue;
            String currValue = currCookie.getValue();
            try {
                currValue = this.signer.verifyAndExtract(currValue);
            }
            catch (IllegalArgumentException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invalid cookie", (Throwable)e);
                }
                currValue = null;
            }
            if (currValue == null) continue;
            String userName = HttpAuthUtils.getUserNameFromCookieToken(currValue);
            if (userName == null) {
                LOG.warn("Invalid cookie token " + currValue);
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Validated the cookie for user " + userName);
            }
            return userName;
        }
        return null;
    }

    private String toCookieStr(Cookie[] cookies) {
        StringBuilder cookieStr = new StringBuilder();
        for (Cookie c : cookies) {
            cookieStr.append(c.getName()).append('=').append(c.getValue()).append(" ;\n");
        }
        return cookieStr.toString();
    }

    private String validateCookie(HttpServletRequest request) throws UnsupportedEncodingException {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No valid cookies associated with the request " + request);
            }
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received cookies: " + this.toCookieStr(cookies));
        }
        return this.getClientNameFromCookie(cookies);
    }

    private Cookie createCookie(String str) throws UnsupportedEncodingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cookie name = hive.server2.auth value = " + str);
        }
        Cookie cookie = new Cookie(AUTH_COOKIE, str);
        cookie.setMaxAge(this.cookieMaxAge);
        if (this.cookieDomain != null) {
            cookie.setDomain(this.cookieDomain);
        }
        if (this.cookiePath != null) {
            cookie.setPath(this.cookiePath);
        }
        cookie.setSecure(this.isCookieSecure);
        return cookie;
    }

    private static String getHttpOnlyCookieHeader(Cookie cookie) {
        NewCookie newCookie = new NewCookie(cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getVersion(), cookie.getComment(), cookie.getMaxAge(), cookie.getSecure());
        return newCookie + "; HttpOnly";
    }

    private String doPasswdAuth(HttpServletRequest request, String authType) throws HttpAuthenticationException {
        String userName = this.getUsername(request, authType);
        if (!authType.equalsIgnoreCase(HiveAuthConstants.AuthTypes.NOSASL.toString())) {
            try {
                AuthenticationProviderFactory.AuthMethods authMethod = AuthenticationProviderFactory.AuthMethods.getValidAuthMethod(authType);
                PasswdAuthenticationProvider provider = AuthenticationProviderFactory.getAuthenticationProvider(authMethod, this.hiveConf);
                provider.Authenticate(userName, this.getPassword(request, authType));
            }
            catch (Exception e) {
                throw new HttpAuthenticationException(e);
            }
        }
        return userName;
    }

    private String doTokenAuth(HttpServletRequest request) throws HttpAuthenticationException {
        String tokenStr = request.getHeader(HIVE_DELEGATION_TOKEN_HEADER);
        try {
            return this.hiveAuthFactory.verifyDelegationToken(tokenStr);
        }
        catch (HiveSQLException e) {
            throw new HttpAuthenticationException(e);
        }
    }

    @VisibleForTesting
    String doKerberosAuth(HttpServletRequest request) throws HttpAuthenticationException {
        this.getAuthHeader(request, this.authType);
        if (this.httpUGI != null) {
            try {
                return (String)this.httpUGI.doAs((PrivilegedExceptionAction)new HttpKerberosServerAction(request, this.httpUGI));
            }
            catch (Exception e) {
                LOG.info("Failed to authenticate with HTTP/_HOST kerberos principal, trying with hive/_HOST kerberos principal");
            }
        }
        try {
            return (String)this.serviceUGI.doAs((PrivilegedExceptionAction)new HttpKerberosServerAction(request, this.serviceUGI));
        }
        catch (Exception e) {
            LOG.error("Failed to authenticate with hive/_HOST kerberos principal");
            throw new HttpAuthenticationException(e);
        }
    }

    private String getUsername(HttpServletRequest request, String authType) throws HttpAuthenticationException {
        String[] creds = this.getAuthHeaderTokens(request, authType);
        if (creds[0] == null || creds[0].isEmpty()) {
            throw new HttpAuthenticationException("Authorization header received from the client does not contain username.");
        }
        return creds[0];
    }

    private String getPassword(HttpServletRequest request, String authType) throws HttpAuthenticationException {
        String[] creds = this.getAuthHeaderTokens(request, authType);
        if (creds[1] == null || creds[1].isEmpty()) {
            throw new HttpAuthenticationException("Authorization header received from the client does not contain username.");
        }
        return creds[1];
    }

    private String[] getAuthHeaderTokens(HttpServletRequest request, String authType) throws HttpAuthenticationException {
        String authHeaderBase64 = this.getAuthHeader(request, authType);
        String authHeaderString = StringUtils.newStringUtf8((byte[])Base64.decodeBase64((byte[])authHeaderBase64.getBytes()));
        String[] creds = authHeaderString.split(":");
        return creds;
    }

    private String getAuthHeader(HttpServletRequest request, String authType) throws HttpAuthenticationException {
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null || authHeader.isEmpty()) {
            throw new HttpEmptyAuthenticationException("Authorization header received from the client is empty.");
        }
        int beginIndex = this.isKerberosAuthMode(authType) ? "Negotiate ".length() : "Basic ".length();
        String authHeaderBase64String = authHeader.substring(beginIndex);
        if (authHeaderBase64String.isEmpty()) {
            throw new HttpAuthenticationException("Authorization header received from the client does not contain any data.");
        }
        return authHeaderBase64String;
    }

    private boolean isKerberosAuthMode(String authType) {
        return authType.equalsIgnoreCase(HiveAuthConstants.AuthTypes.KERBEROS.toString());
    }

    private static String getDoAsQueryParam(String queryString) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("URL query string:" + queryString);
        }
        if (queryString == null) {
            return null;
        }
        Hashtable params = HttpUtils.parseQueryString((String)queryString);
        Set keySet = params.keySet();
        for (String key : keySet) {
            if (!key.equalsIgnoreCase("doAs")) continue;
            return ((String[])params.get(key))[0];
        }
        return null;
    }

    class HttpKerberosServerAction
    implements PrivilegedExceptionAction<String> {
        HttpServletRequest request;
        UserGroupInformation serviceUGI;

        HttpKerberosServerAction(HttpServletRequest request, UserGroupInformation serviceUGI) {
            this.request = request;
            this.serviceUGI = serviceUGI;
        }

        @Override
        public String run() throws HttpAuthenticationException {
            GSSManager manager = GSSManager.getInstance();
            GSSContext gssContext = null;
            String serverPrincipal = this.getPrincipalWithoutRealm(this.serviceUGI.getUserName());
            try {
                Oid kerberosMechOid = new Oid("1.2.840.113554.1.2.2");
                Oid spnegoMechOid = new Oid("1.3.6.1.5.5.2");
                Oid krb5PrincipalOid = new Oid("1.2.840.113554.1.2.2.1");
                GSSName serverName = manager.createName(serverPrincipal, krb5PrincipalOid);
                GSSCredential serverCreds = manager.createCredential(serverName, 0, new Oid[]{kerberosMechOid, spnegoMechOid}, 2);
                gssContext = manager.createContext(serverCreds);
                String serviceTicketBase64 = ThriftHttpServlet.this.getAuthHeader(this.request, ThriftHttpServlet.this.authType);
                byte[] inToken = Base64.decodeBase64((byte[])serviceTicketBase64.getBytes());
                gssContext.acceptSecContext(inToken, 0, inToken.length);
                if (!gssContext.isEstablished()) {
                    throw new HttpAuthenticationException("Kerberos authentication failed: unable to establish context with the service ticket provided by the client.");
                }
                String string = this.getPrincipalWithoutRealmAndHost(gssContext.getSrcName().toString());
                return string;
            }
            catch (GSSException e) {
                throw new HttpAuthenticationException("Kerberos authentication failed: ", e);
            }
            finally {
                if (gssContext != null) {
                    try {
                        gssContext.dispose();
                    }
                    catch (GSSException gSSException) {}
                }
            }
        }

        private String getPrincipalWithoutRealm(String fullPrincipal) throws HttpAuthenticationException {
            HadoopShims.KerberosNameShim fullKerberosName;
            try {
                fullKerberosName = ShimLoader.getHadoopShims().getKerberosNameShim(fullPrincipal);
            }
            catch (IOException e) {
                throw new HttpAuthenticationException(e);
            }
            String serviceName = fullKerberosName.getServiceName();
            String hostName = fullKerberosName.getHostName();
            String principalWithoutRealm = serviceName;
            if (hostName != null) {
                principalWithoutRealm = serviceName + "/" + hostName;
            }
            return principalWithoutRealm;
        }

        private String getPrincipalWithoutRealmAndHost(String fullPrincipal) throws HttpAuthenticationException {
            try {
                HadoopShims.KerberosNameShim fullKerberosName = ShimLoader.getHadoopShims().getKerberosNameShim(fullPrincipal);
                return fullKerberosName.getShortName();
            }
            catch (IOException e) {
                throw new HttpAuthenticationException(e);
            }
        }
    }
}

