/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.session;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.common.metrics.common.MetricsVariable;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.hooks.HookUtils;
import org.apache.hive.service.CompositeService;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.HiveSessionHook;
import org.apache.hive.service.cli.session.HiveSessionHookContextImpl;
import org.apache.hive.service.cli.session.HiveSessionImpl;
import org.apache.hive.service.cli.session.HiveSessionImplwithUGI;
import org.apache.hive.service.cli.session.HiveSessionProxy;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.hive.service.server.HiveServer2;
import org.apache.hive.service.server.ThreadFactoryWithGarbageCleanup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager
extends CompositeService {
    private static final String INACTIVE_ERROR_MESSAGE = "Cannot open sessions on an inactive HS2 instance, or the HS2 server leader is not ready; please use service discovery to connect the server leader again";
    private static final String FAIL_CLOSE_ERROR_MESSAGE = "Cannot close the session opened during the HA state change time";
    public static final String HIVERCFILE = ".hiverc";
    private static final Logger LOG = LoggerFactory.getLogger(CompositeService.class);
    private HiveConf hiveConf;
    private final Object sessionAddLock = new Object();
    private boolean allowSessions;
    private final Map<SessionHandle, HiveSession> handleToSession = new ConcurrentHashMap<SessionHandle, HiveSession>();
    private final Map<String, LongAdder> connectionsCount = new ConcurrentHashMap<String, LongAdder>();
    private int userLimit;
    private int ipAddressLimit;
    private int userIpAddressLimit;
    private final OperationManager operationManager = new OperationManager();
    private ThreadPoolExecutor backgroundOperationPool;
    private boolean isOperationLogEnabled;
    private File operationLogRootDir;
    private long checkInterval;
    private long sessionTimeout;
    private boolean checkOperation;
    private TezSessionMetricsHelper tezSessionMetricsHelper = new TezSessionMetricsHelper();
    private volatile boolean shutdown;
    private final HiveServer2 hiveServer2;
    private String sessionImplWithUGIclassName;
    private String sessionImplclassName;
    private static final Integer[] PERCENTILE_SET = new Integer[]{50, 60, 70, 80, 90, 95, 96, 97, 98, 99};
    private final Object timeoutCheckerLock = new Object();
    private static ThreadLocal<String> threadLocalIpAddress = new ThreadLocal();
    private static ThreadLocal<List<String>> threadLocalForwardedAddresses = new ThreadLocal();
    private static ThreadLocal<String> threadLocalUserName = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return null;
        }
    };
    private static ThreadLocal<String> threadLocalProxyUserName = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return null;
        }
    };

    public SessionManager(HiveServer2 hiveServer2, boolean allowSessions) {
        super(SessionManager.class.getSimpleName());
        this.hiveServer2 = hiveServer2;
        this.allowSessions = allowSessions;
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        this.hiveConf = hiveConf;
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_ENABLED)) {
            this.initOperationLogRootDir();
        }
        this.createBackgroundOperationPool();
        this.addService(this.operationManager);
        this.initSessionImplClassName();
        Metrics metrics = MetricsFactory.getInstance();
        if (metrics != null) {
            this.registerOpenSesssionMetrics(metrics);
            this.registerActiveSesssionMetrics(metrics);
            this.registerTezSessionMetrics(metrics);
        }
        this.userLimit = hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_USER);
        this.ipAddressLimit = hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_IPADDRESS);
        this.userIpAddressLimit = hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_USER_IPADDRESS);
        LOG.info("Connections limit are user: {} ipaddress: {} user-ipaddress: {}", new Object[]{this.userLimit, this.ipAddressLimit, this.userIpAddressLimit});
        super.init(hiveConf);
    }

    private void registerOpenSesssionMetrics(Metrics metrics) {
        MetricsVariable<Integer> openSessionCnt = new MetricsVariable<Integer>(){

            public Integer getValue() {
                return SessionManager.this.getSessions().size();
            }
        };
        MetricsVariable<Integer> openSessionTime = new MetricsVariable<Integer>(){

            public Integer getValue() {
                long sum = 0L;
                long currentTime = System.currentTimeMillis();
                for (HiveSession s : SessionManager.this.getSessions()) {
                    sum += currentTime - s.getCreationTime();
                }
                return (long)((int)sum) != sum ? -1 : (int)sum;
            }
        };
        metrics.addGauge("hs2_open_sessions", (MetricsVariable)openSessionCnt);
        metrics.addRatio("hs2_avg_open_session_time", (MetricsVariable)openSessionTime, (MetricsVariable)openSessionCnt);
    }

    private void registerActiveSesssionMetrics(Metrics metrics) {
        MetricsVariable<Integer> activeSessionCnt = new MetricsVariable<Integer>(){

            public Integer getValue() {
                Iterable filtered = Iterables.filter(SessionManager.this.getSessions(), (Predicate)new Predicate<HiveSession>(){

                    public boolean apply(HiveSession hiveSession) {
                        return hiveSession.getNoOperationTime() == 0L;
                    }
                });
                return Iterables.size((Iterable)filtered);
            }
        };
        MetricsVariable<Integer> activeSessionTime = new MetricsVariable<Integer>(){

            public Integer getValue() {
                long sum = 0L;
                long currentTime = System.currentTimeMillis();
                for (HiveSession s : SessionManager.this.getSessions()) {
                    if (s.getNoOperationTime() != 0L) continue;
                    sum += currentTime - s.getLastAccessTime();
                }
                return (long)((int)sum) != sum ? -1 : (int)sum;
            }
        };
        metrics.addGauge("hs2_active_sessions", (MetricsVariable)activeSessionCnt);
        metrics.addRatio("hs2_avg_active_session_time", (MetricsVariable)activeSessionTime, (MetricsVariable)activeSessionCnt);
    }

    private void registerTezSessionMetrics(Metrics metrics) {
        MetricsVariable<Integer> waitingTezSessionCnt = new MetricsVariable<Integer>(){

            public Integer getValue() {
                SessionManager.this.tezSessionMetricsHelper.checkRefresh(() -> SessionManager.this.getSessions());
                return SessionManager.this.tezSessionMetricsHelper.getWaitingTezSessionCount();
            }
        };
        for (final Integer percentileVal : PERCENTILE_SET) {
            String percentileMetricName = "waiting_tez_session_time_pctile_" + percentileVal.toString();
            MetricsVariable<Double> percentileMetric = new MetricsVariable<Double>(){

                public Double getValue() {
                    SessionManager.this.tezSessionMetricsHelper.checkRefresh(() -> SessionManager.this.getSessions());
                    return SessionManager.this.tezSessionMetricsHelper.getPercentile(percentileVal);
                }
            };
            metrics.addGauge(percentileMetricName, (MetricsVariable)percentileMetric);
        }
        metrics.addGauge("waiting_tez_session", (MetricsVariable)waitingTezSessionCnt);
    }

    private void initSessionImplClassName() {
        this.sessionImplclassName = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SESSION_IMPL_CLASSNAME);
        this.sessionImplWithUGIclassName = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SESSION_IMPL_WITH_UGI_CLASSNAME);
    }

    private void createBackgroundOperationPool() {
        int poolSize = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_THREADS);
        LOG.info("HiveServer2: Background operation thread pool size: " + poolSize);
        int poolQueueSize = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_WAIT_QUEUE_SIZE);
        LOG.info("HiveServer2: Background operation thread wait queue size: " + poolQueueSize);
        long keepAliveTime = HiveConf.getTimeVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_KEEPALIVE_TIME, (TimeUnit)TimeUnit.SECONDS);
        LOG.info("HiveServer2: Background operation thread keepalive time: " + keepAliveTime + " seconds");
        String threadPoolName = "HiveServer2-Background-Pool";
        final LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(poolQueueSize);
        this.backgroundOperationPool = new ThreadPoolExecutor(poolSize, poolSize, keepAliveTime, TimeUnit.SECONDS, queue, new ThreadFactoryWithGarbageCleanup(threadPoolName));
        this.backgroundOperationPool.allowCoreThreadTimeOut(true);
        this.checkInterval = HiveConf.getTimeVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_SESSION_CHECK_INTERVAL, (TimeUnit)TimeUnit.MILLISECONDS);
        this.sessionTimeout = HiveConf.getTimeVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_IDLE_SESSION_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
        this.checkOperation = HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_IDLE_SESSION_CHECK_OPERATION);
        Metrics m = MetricsFactory.getInstance();
        if (m != null) {
            m.addGauge("exec_async_queue_size", new MetricsVariable(){

                public Object getValue() {
                    return queue.size();
                }
            });
            m.addGauge("exec_async_pool_size", new MetricsVariable(){

                public Object getValue() {
                    return SessionManager.this.backgroundOperationPool.getPoolSize();
                }
            });
        }
    }

    private void initOperationLogRootDir() {
        this.operationLogRootDir = new File(this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_LOG_LOCATION));
        this.isOperationLogEnabled = true;
        if (this.operationLogRootDir.exists() && !this.operationLogRootDir.isDirectory()) {
            LOG.warn("The operation log root directory exists, but it is not a directory: " + this.operationLogRootDir.getAbsolutePath());
            this.isOperationLogEnabled = false;
        }
        if (!this.operationLogRootDir.exists() && !this.operationLogRootDir.mkdirs()) {
            LOG.warn("Unable to create operation log root directory: " + this.operationLogRootDir.getAbsolutePath());
            this.isOperationLogEnabled = false;
        }
        if (this.isOperationLogEnabled) {
            LOG.info("Operation log root directory is created: " + this.operationLogRootDir.getAbsolutePath());
            try {
                FileUtils.forceDeleteOnExit((File)this.operationLogRootDir);
            }
            catch (IOException e) {
                LOG.warn("Failed to schedule cleanup HS2 operation logging root dir: " + this.operationLogRootDir.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void start() {
        super.start();
        if (this.checkInterval > 0L) {
            this.startTimeoutChecker();
        }
    }

    private void startTimeoutChecker() {
        final long interval = Math.max(this.checkInterval, 3000L);
        Runnable timeoutChecker = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.sleepFor(interval);
                while (!SessionManager.this.shutdown) {
                    long current = System.currentTimeMillis();
                    for (HiveSession session : new ArrayList(SessionManager.this.handleToSession.values())) {
                        if (SessionManager.this.shutdown) break;
                        if (!(SessionManager.this.sessionTimeout <= 0L || session.getLastAccessTime() + SessionManager.this.sessionTimeout > current || SessionManager.this.checkOperation && session.getNoOperationTime() <= SessionManager.this.sessionTimeout)) {
                            SessionHandle handle = session.getSessionHandle();
                            LOG.warn("Session " + handle + " is Timed-out (last access : " + new Date(session.getLastAccessTime()) + ") and will be closed");
                            try {
                                SessionManager.this.closeSession(handle);
                                continue;
                            }
                            catch (HiveSQLException e) {
                                LOG.warn("Exception is thrown closing session " + handle, (Throwable)e);
                                continue;
                            }
                            finally {
                                Metrics metrics = MetricsFactory.getInstance();
                                if (metrics != null) {
                                    metrics.incrementCounter("hs2_abandoned_sessions");
                                }
                                continue;
                            }
                        }
                        session.closeExpiredOperations();
                    }
                    this.sleepFor(interval);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void sleepFor(long interval2) {
                Object object = SessionManager.this.timeoutCheckerLock;
                synchronized (object) {
                    try {
                        SessionManager.this.timeoutCheckerLock.wait(interval2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        };
        this.backgroundOperationPool.execute(timeoutChecker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownTimeoutChecker() {
        this.shutdown = true;
        Object object = this.timeoutCheckerLock;
        synchronized (object) {
            this.timeoutCheckerLock.notify();
        }
    }

    @Override
    public synchronized void stop() {
        super.stop();
        this.shutdownTimeoutChecker();
        if (this.backgroundOperationPool != null) {
            this.backgroundOperationPool.shutdown();
            long timeout = this.hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_SHUTDOWN_TIMEOUT, TimeUnit.SECONDS);
            try {
                this.backgroundOperationPool.awaitTermination(timeout, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.warn("HIVE_SERVER2_ASYNC_EXEC_SHUTDOWN_TIMEOUT = " + timeout + " seconds has been exceeded. RUNNING background operations will be shut down", (Throwable)e);
            }
            this.backgroundOperationPool = null;
        }
        this.cleanupLoggingRootDir();
    }

    private void cleanupLoggingRootDir() {
        if (this.isOperationLogEnabled) {
            try {
                FileUtils.forceDelete((File)this.operationLogRootDir);
            }
            catch (Exception e) {
                LOG.warn("Failed to cleanup root dir of HS2 logging: " + this.operationLogRootDir.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    public SessionHandle openSession(TProtocolVersion protocol, String username, String password, String ipAddress, Map<String, String> sessionConf) throws HiveSQLException {
        return this.openSession(protocol, username, password, ipAddress, sessionConf, false, null);
    }

    public SessionHandle openSession(TProtocolVersion protocol, String username, String password, String ipAddress, Map<String, String> sessionConf, boolean withImpersonation, String delegationToken) throws HiveSQLException {
        return this.createSession(null, protocol, username, password, ipAddress, sessionConf, withImpersonation, delegationToken).getSessionHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HiveSession createSession(SessionHandle sessionHandle, TProtocolVersion protocol, String username, String password, String ipAddress, Map<String, String> sessionConf, boolean withImpersonation, String delegationToken) throws HiveSQLException {
        HiveSession session;
        Object object = this.sessionAddLock;
        synchronized (object) {
            if (!this.allowSessions) {
                throw new HiveSQLException(INACTIVE_ERROR_MESSAGE);
            }
        }
        List<String> forwardedAddresses = SessionManager.getForwardedAddresses();
        this.incrementConnections(username, ipAddress, forwardedAddresses);
        if (withImpersonation) {
            HiveSessionImplwithUGI hiveSessionUgi;
            if (this.sessionImplWithUGIclassName == null) {
                hiveSessionUgi = new HiveSessionImplwithUGI(sessionHandle, protocol, username, password, this.hiveConf, ipAddress, delegationToken, forwardedAddresses);
            } else {
                try {
                    Class<?> clazz = Class.forName(this.sessionImplWithUGIclassName);
                    Constructor<?> constructor = clazz.getConstructor(SessionHandle.class, TProtocolVersion.class, String.class, String.class, HiveConf.class, String.class, String.class, List.class);
                    hiveSessionUgi = (HiveSessionImplwithUGI)constructor.newInstance(sessionHandle, protocol, username, password, this.hiveConf, ipAddress, delegationToken, forwardedAddresses);
                }
                catch (Exception e) {
                    throw new HiveSQLException("Cannot initialize session class:" + this.sessionImplWithUGIclassName);
                }
            }
            session = HiveSessionProxy.getProxy(hiveSessionUgi, hiveSessionUgi.getSessionUgi());
            hiveSessionUgi.setProxySession(session);
        } else if (this.sessionImplclassName == null) {
            session = new HiveSessionImpl(sessionHandle, protocol, username, password, this.hiveConf, ipAddress, forwardedAddresses);
        } else {
            try {
                Class<?> clazz = Class.forName(this.sessionImplclassName);
                Constructor<?> constructor = clazz.getConstructor(SessionHandle.class, TProtocolVersion.class, String.class, String.class, HiveConf.class, String.class, List.class);
                session = (HiveSession)constructor.newInstance(sessionHandle, protocol, username, password, this.hiveConf, ipAddress, forwardedAddresses);
            }
            catch (Exception e) {
                throw new HiveSQLException("Cannot initialize session class:" + this.sessionImplclassName, e);
            }
        }
        session.setSessionManager(this);
        session.setOperationManager(this.operationManager);
        try {
            session.open(sessionConf);
        }
        catch (Exception e) {
            LOG.warn("Failed to open session", (Throwable)e);
            try {
                session.close();
            }
            catch (Throwable t) {
                LOG.warn("Error closing session", t);
            }
            session = null;
            throw new HiveSQLException("Failed to open new session: " + e.getMessage(), e);
        }
        if (this.isOperationLogEnabled) {
            session.setOperationLogSessionDir(this.operationLogRootDir);
        }
        try {
            this.executeSessionHooks(session);
        }
        catch (Exception e) {
            LOG.warn("Failed to execute session hooks", (Throwable)e);
            try {
                session.close();
            }
            catch (Throwable t) {
                LOG.warn("Error closing session", t);
            }
            session = null;
            throw new HiveSQLException("Failed to execute session hooks: " + e.getMessage(), e);
        }
        boolean isAdded = false;
        Object t = this.sessionAddLock;
        synchronized (t) {
            if (this.allowSessions) {
                this.handleToSession.put(session.getSessionHandle(), session);
                isAdded = true;
            }
        }
        if (!isAdded) {
            try {
                this.closeSessionInternal(session);
            }
            catch (Exception e) {
                LOG.warn("Failed to close the session opened during an HA state change; ignoring", (Throwable)e);
            }
            throw new HiveSQLException(FAIL_CLOSE_ERROR_MESSAGE);
        }
        LOG.info("Session opened, " + session.getSessionHandle() + ", current sessions:" + this.getOpenSessionCount());
        return session;
    }

    private void incrementConnections(String username, String ipAddress, List<String> forwardedAddresses) throws HiveSQLException {
        String clientIpAddress = this.getOriginClientIpAddress(ipAddress, forwardedAddresses);
        String violation = this.anyViolations(username, clientIpAddress);
        if (violation == null) {
            if (this.trackConnectionsPerUser(username)) {
                this.connectionsCount.computeIfAbsent(username, k -> new LongAdder()).increment();
            }
            if (this.trackConnectionsPerIpAddress(clientIpAddress)) {
                this.connectionsCount.computeIfAbsent(clientIpAddress, k -> new LongAdder()).increment();
            }
            if (this.trackConnectionsPerUserIpAddress(username, clientIpAddress)) {
                this.connectionsCount.computeIfAbsent(username + ":" + clientIpAddress, k -> new LongAdder()).increment();
            }
        } else {
            LOG.error(violation);
            throw new HiveSQLException(violation);
        }
    }

    private String getOriginClientIpAddress(String ipAddress, List<String> forwardedAddresses) {
        if (forwardedAddresses == null || forwardedAddresses.isEmpty()) {
            return ipAddress;
        }
        return forwardedAddresses.get(0);
    }

    private void decrementConnections(HiveSession session) {
        String username = session.getUserName();
        String clientIpAddress = this.getOriginClientIpAddress(session.getIpAddress(), session.getForwardedAddresses());
        if (this.trackConnectionsPerUser(username)) {
            this.connectionsCount.computeIfPresent(username, (k, v) -> v).decrement();
        }
        if (this.trackConnectionsPerIpAddress(clientIpAddress)) {
            this.connectionsCount.computeIfPresent(clientIpAddress, (k, v) -> v).decrement();
        }
        if (this.trackConnectionsPerUserIpAddress(username, clientIpAddress)) {
            this.connectionsCount.computeIfPresent(username + ":" + clientIpAddress, (k, v) -> v).decrement();
        }
    }

    private String anyViolations(String username, String ipAddress) {
        if (this.trackConnectionsPerUser(username) && !this.withinLimits(username, this.userLimit)) {
            return "Connection limit per user reached (user: " + username + " limit: " + this.userLimit + ")";
        }
        if (this.trackConnectionsPerIpAddress(ipAddress) && !this.withinLimits(ipAddress, this.ipAddressLimit)) {
            return "Connection limit per ipaddress reached (ipaddress: " + ipAddress + " limit: " + this.ipAddressLimit + ")";
        }
        if (this.trackConnectionsPerUserIpAddress(username, ipAddress) && !this.withinLimits(username + ":" + ipAddress, this.userIpAddressLimit)) {
            return "Connection limit per user:ipaddress reached (user:ipaddress: " + username + ":" + ipAddress + " limit: " + this.userIpAddressLimit + ")";
        }
        return null;
    }

    private boolean trackConnectionsPerUserIpAddress(String username, String ipAddress) {
        return this.userIpAddressLimit > 0 && username != null && !username.isEmpty() && ipAddress != null && !ipAddress.isEmpty();
    }

    private boolean trackConnectionsPerIpAddress(String ipAddress) {
        return this.ipAddressLimit > 0 && ipAddress != null && !ipAddress.isEmpty();
    }

    private boolean trackConnectionsPerUser(String username) {
        return this.userLimit > 0 && username != null && !username.isEmpty();
    }

    private boolean withinLimits(String track, int limit) {
        int connectionCount;
        return !this.connectionsCount.containsKey(track) || (connectionCount = this.connectionsCount.get(track).intValue()) < limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(SessionHandle sessionHandle) throws HiveSQLException {
        HiveSession session;
        Object object = this.sessionAddLock;
        synchronized (object) {
            session = this.handleToSession.remove(sessionHandle);
            if (session == null) {
                throw new HiveSQLException("Session does not exist: " + sessionHandle);
            }
            LOG.info("Session closed, " + sessionHandle + ", current sessions:" + this.getOpenSessionCount());
        }
        this.closeSessionInternal(session);
    }

    private void closeSessionInternal(HiveSession session) throws HiveSQLException {
        try {
            session.close();
            this.decrementConnections(session);
        }
        catch (Throwable throwable) {
            this.decrementConnections(session);
            if (this.hiveServer2 != null && this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_SUPPORT_DYNAMIC_SERVICE_DISCOVERY) && this.hiveServer2.isDeregisteredWithZooKeeper() && this.getOpenSessionCount() == 0) {
                LOG.info("This instance of HiveServer2 has been removed from the list of server instances available for dynamic service discovery. The last client session has ended - will shutdown now.");
                Thread shutdownThread = new Thread(){

                    @Override
                    public void run() {
                        SessionManager.this.hiveServer2.stop();
                    }
                };
                shutdownThread.start();
            }
            throw throwable;
        }
        if (this.hiveServer2 != null && this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_SUPPORT_DYNAMIC_SERVICE_DISCOVERY) && this.hiveServer2.isDeregisteredWithZooKeeper() && this.getOpenSessionCount() == 0) {
            LOG.info("This instance of HiveServer2 has been removed from the list of server instances available for dynamic service discovery. The last client session has ended - will shutdown now.");
            Thread shutdownThread = new /* invalid duplicate definition of identical inner class */;
            shutdownThread.start();
        }
    }

    public HiveSession getSession(SessionHandle sessionHandle) throws HiveSQLException {
        HiveSession session = this.handleToSession.get(sessionHandle);
        if (session == null) {
            throw new HiveSQLException("Invalid SessionHandle: " + sessionHandle);
        }
        return session;
    }

    public OperationManager getOperationManager() {
        return this.operationManager;
    }

    public static void setIpAddress(String ipAddress) {
        threadLocalIpAddress.set(ipAddress);
    }

    public static void clearIpAddress() {
        threadLocalIpAddress.remove();
    }

    public static String getIpAddress() {
        return threadLocalIpAddress.get();
    }

    public static void setForwardedAddresses(List<String> ipAddress) {
        threadLocalForwardedAddresses.set(ipAddress);
    }

    public static void clearForwardedAddresses() {
        threadLocalForwardedAddresses.remove();
    }

    public static List<String> getForwardedAddresses() {
        return threadLocalForwardedAddresses.get();
    }

    public static void setUserName(String userName) {
        threadLocalUserName.set(userName);
    }

    public static void clearUserName() {
        threadLocalUserName.remove();
    }

    public static String getUserName() {
        return threadLocalUserName.get();
    }

    public static void setProxyUserName(String userName) {
        LOG.debug("setting proxy user name based on query param to: " + userName);
        threadLocalProxyUserName.set(userName);
    }

    public static String getProxyUserName() {
        return threadLocalProxyUserName.get();
    }

    public static void clearProxyUserName() {
        threadLocalProxyUserName.remove();
    }

    private void executeSessionHooks(HiveSession session) throws Exception {
        List sessionHooks = HookUtils.readHooksFromConf((HiveConf)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_SESSION_HOOK);
        for (HiveSessionHook sessionHook : sessionHooks) {
            sessionHook.run(new HiveSessionHookContextImpl(session));
        }
    }

    public Future<?> submitBackgroundOperation(Runnable r) {
        return this.backgroundOperationPool.submit(r);
    }

    public Collection<Operation> getOperations() {
        return this.operationManager.getOperations();
    }

    public Collection<HiveSession> getSessions() {
        return Collections.unmodifiableCollection(this.handleToSession.values());
    }

    public int getOpenSessionCount() {
        return this.handleToSession.size();
    }

    public String getHiveServer2HostName() throws Exception {
        if (this.hiveServer2 == null) {
            return null;
        }
        return this.hiveServer2.getServerHost();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allowSessions(boolean b) {
        Object object = this.sessionAddLock;
        synchronized (object) {
            this.allowSessions = b;
        }
    }

    private static class TezSessionMetricsHelper {
        private static final long CALC_REUSE_DURATION_MSEC = 2000L;
        private volatile long lastRefreshTime;
        private ArrayList<Double> vals = new ArrayList();

        private TezSessionMetricsHelper() {
        }

        private boolean shouldRefresh() {
            return System.currentTimeMillis() - this.lastRefreshTime > 2000L;
        }

        public void checkRefresh(Supplier<Collection<HiveSession>> sessionsFunc) {
            if (this.shouldRefresh()) {
                this.refresh(sessionsFunc.get());
            }
        }

        public int getWaitingTezSessionCount() {
            return this.vals.size();
        }

        public Double getPercentile(Integer percentile) {
            return TezSessionMetricsHelper.getPercentile(this.vals, percentile.intValue());
        }

        private static Double getPercentile(ArrayList<Double> vals, double percentile) {
            int size = vals.size();
            if (size == 0) {
                return 0.0;
            }
            int index = (int)(percentile / 100.0 * (double)vals.size());
            index = Math.min(index, vals.size() - 1);
            return vals.get(index);
        }

        private synchronized void refresh(Collection<HiveSession> sessions) {
            if (!this.shouldRefresh()) {
                return;
            }
            this.vals.clear();
            long currentTime = System.currentTimeMillis();
            for (HiveSession session : sessions) {
                long waitingSince = session.getSessionState().getWaitingTezSession();
                if (waitingSince == 0L) continue;
                this.vals.add(Double.valueOf(currentTime - waitingSince));
            }
            Collections.sort(this.vals);
            this.lastRefreshTime = System.currentTimeMillis();
        }
    }
}

